/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.programme.bfb.BalanceDesign;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class BalanceLabyrinthe
extends BalanceDesign {
    Random random = new Random();
    static final Rectangle trueRect = new Rectangle();
    private final int nbCases;
    private Rectangle[][] horizontalWalls;
    private Rectangle[][] verticalWalls;
    private boolean[][] visited;
    static final double percSizeWall = 0.1;
    static final double percSizeCible = 0.25;
    double taille;
    double cellSize;
    double wallSize;
    double x0;
    double y0;
    int arriveeX;
    int arriveeY;
    Rectangle cible;
    double cx;
    double cy;
    long lastUpdate = 0L;

    BalanceLabyrinthe(BiofeedbackAnimation animation) {
        this.controller = animation.controller;
        this.nbCases = Main.progEnCours.currentPageProgram.taille;
        this.createMaze();
    }

    private void createMaze() {
        int j;
        int i;
        this.horizontalWalls = new Rectangle[this.nbCases][this.nbCases + 1];
        this.verticalWalls = new Rectangle[this.nbCases + 1][this.nbCases];
        this.visited = new boolean[this.nbCases][this.nbCases];
        for (i = 0; i < this.nbCases; ++i) {
            for (j = 0; j <= this.nbCases; ++j) {
                this.horizontalWalls[i][j] = trueRect;
            }
        }
        for (i = 0; i <= this.nbCases; ++i) {
            for (j = 0; j < this.nbCases; ++j) {
                this.verticalWalls[i][j] = trueRect;
            }
        }
        this.arriveeX = this.random.nextInt(2) * (this.nbCases - 1);
        this.arriveeY = this.random.nextInt(2) * (this.nbCases - 1);
        this.cx = (double)this.nbCases - 0.5 - (double)this.arriveeX;
        this.cy = (double)this.nbCases - 0.5 - (double)this.arriveeY;
        this.iterateMaze(this.arriveeX, this.arriveeY);
        this.visited = new boolean[this.nbCases][this.nbCases];
    }

    private void iterateMaze(int x, int y) {
        this.visited[x][y] = true;
        ArrayList directions = new ArrayList();
        Collections.addAll(directions, Direction.values());
        Collections.shuffle(directions);
        for (Direction direction : directions) {
            int newX = x + direction.dx;
            int newY = y + direction.dy;
            if (newX < 0 || newX >= this.nbCases || newY < 0 || newY >= this.nbCases || this.visited[newX][newY]) continue;
            if (direction == Direction.NORTH) {
                this.horizontalWalls[x][y] = null;
            } else if (direction == Direction.SOUTH) {
                this.horizontalWalls[x][y + 1] = null;
            } else if (direction == Direction.EAST) {
                this.verticalWalls[x + 1][y] = null;
            } else if (direction == Direction.WEST) {
                this.verticalWalls[x][y] = null;
            }
            this.iterateMaze(newX, newY);
        }
    }

    @Override
    void init() {
        this.updateSizeBalance();
        this.updateBalance();
    }

    @Override
    void fin() {
        int nb = this.controller.balanceAnchor.getChildren().size() - 2;
        for (int i = 0; i < nb; ++i) {
            ((Rectangle)this.controller.balanceAnchor.getChildren().get(i)).setFill((Paint)Color.RED);
        }
    }

    @Override
    synchronized void updateSizeBalance() {
        int j;
        int i;
        super.updateSizeBalance();
        this.taille = Math.min(this.width, this.height) * 0.85;
        this.cellSize = this.taille / (double)this.nbCases;
        this.wallSize = this.cellSize * 0.1;
        this.x0 = this.width / 2.0 - this.cellSize * (double)this.nbCases / 2.0;
        this.y0 = this.height / 2.0 - this.cellSize * (double)this.nbCases / 2.0;
        this.controller.balanceAnchor.getChildren().clear();
        for (i = 0; i < this.nbCases; ++i) {
            for (j = 0; j <= this.nbCases; ++j) {
                if (this.horizontalWalls[i][j] == null) continue;
                this.horizontalWalls[i][j] = new Rectangle(this.x0 + (double)i * this.cellSize, this.y0 + (double)j * this.cellSize, this.cellSize + this.wallSize, this.wallSize);
                this.horizontalWalls[i][j].setFill((Paint)Color.BLACK);
                this.horizontalWalls[i][j].setArcWidth(this.wallSize);
                this.horizontalWalls[i][j].setArcHeight(this.wallSize);
                this.controller.balanceAnchor.getChildren().add((Object)this.horizontalWalls[i][j]);
            }
        }
        for (i = 0; i <= this.nbCases; ++i) {
            for (j = 0; j < this.nbCases; ++j) {
                if (this.verticalWalls[i][j] == null) continue;
                this.verticalWalls[i][j] = new Rectangle(this.x0 + (double)i * this.cellSize, this.y0 + (double)j * this.cellSize, this.wallSize, this.cellSize + this.wallSize);
                this.verticalWalls[i][j].setFill((Paint)Color.BLACK);
                this.verticalWalls[i][j].setArcWidth(this.wallSize);
                this.verticalWalls[i][j].setArcHeight(this.wallSize);
                this.controller.balanceAnchor.getChildren().add((Object)this.verticalWalls[i][j]);
            }
        }
        Rectangle arrivee = new Rectangle(this.x0 + (double)this.arriveeX * this.cellSize + 2.0 * this.wallSize, this.y0 + (double)this.arriveeY * this.cellSize + 2.0 * this.wallSize, this.cellSize - 3.0 * this.wallSize, this.cellSize - 3.0 * this.wallSize);
        arrivee.setFill((Paint)new ImagePattern(Computer.getImage("maze/arrivee.png", "no-image.png", false)));
        this.controller.balanceAnchor.getChildren().add((Object)arrivee);
        ImagePattern ip = new ImagePattern(Computer.getImage("maze/abeille.gif", "no-image.png", false));
        this.cible = FxUtils.creationObjet((Pane)this.controller.balanceAnchor, ip, this.cellSize * 0.25 * 2.0);
        this.lastUpdate = 0L;
        this.updateBalance();
    }

    @Override
    public synchronized void updateBalance() {
        int casex = Math.max(Math.min((int)this.cx, this.nbCases - 1), 0);
        int casey = Math.max(Math.min((int)this.cy, this.nbCases - 1), 0);
        if (casex == this.arriveeX && casey == this.arriveeY) {
            this.updateScore(this.nbCases * this.nbCases);
            this.createMaze();
            this.updateSizeBalance();
        } else {
            if (!this.visited[casex][casey]) {
                this.visited[casex][casey] = true;
                this.updateScore(1);
            }
            long now = System.currentTimeMillis();
            if (this.lastUpdate != 0L) {
                double vx = (Biostim.getVoie(9) - 50.0) / 50.0;
                double vy = (Biostim.getVoie(10) - 50.0) / 50.0;
                double delta = (double)((now - this.lastUpdate) * (long)Main.progEnCours.currentPageProgram.vitesse) / 1000.0;
                if (Math.abs(vx) * delta > 0.125) {
                    vx = Math.signum(vx) * 0.25 / 2.0 / delta;
                }
                if (Math.abs(vy) * delta > 0.125) {
                    vy = Math.signum(vy) * 0.25 / 2.0 / delta;
                }
                Pos initPos = new Pos(this.cx, this.cy);
                Pos pos = new Pos(this.cx + vx * delta, this.cy);
                this.updateX(pos, initPos, casex);
                this.updateY(pos, initPos, casey);
                initPos.backTo(pos);
                pos.y -= vy * delta;
                this.updateX(pos, initPos, casex);
                this.updateY(pos, initPos, casey);
                if (Math.abs(pos.x - this.cx) > 0.25 || Math.abs(pos.y - this.cy) > 0.25) {
                    Utils.debugLine("x : %.2f -> %.2f ; y : %.2f -> %.2f", this.cx, pos.x, this.cy, pos.y);
                }
                this.cx = pos.x;
                this.cy = pos.y;
            }
            this.lastUpdate = now;
            this.cible.setLayoutX(this.x0 + this.cx * this.cellSize - this.cellSize * 0.25);
            this.cible.setLayoutY(this.y0 + this.cy * this.cellSize - this.cellSize * 0.25);
        }
    }

    private void updateX(Pos pos, Pos initPos, int casex) {
        Rectangle tmp = new Rectangle(this.x0 + pos.x * this.cellSize - this.cellSize * 0.25, this.y0 + pos.y * this.cellSize - this.cellSize * 0.25, this.cible.getWidth(), this.cible.getHeight());
        if (this.intersectVertical(tmp, casex)) {
            pos.backTo(initPos);
        } else if (this.intersectVertical(tmp, casex + 1)) {
            pos.backTo(initPos);
        }
    }

    private void updateY(Pos pos, Pos initPos, int casey) {
        Rectangle tmp = new Rectangle(this.x0 + pos.x * this.cellSize - this.cellSize * 0.25, this.y0 + pos.y * this.cellSize - this.cellSize * 0.25, this.cible.getWidth(), this.cible.getHeight());
        if (this.intersectHorizontal(tmp, casey)) {
            pos.backTo(initPos);
        } else if (this.intersectHorizontal(tmp, casey + 1)) {
            pos.backTo(initPos);
        }
    }

    private boolean intersectVertical(Rectangle rect, int x) {
        for (int y = 0; y < this.nbCases; ++y) {
            if (this.verticalWalls[x][y] == null || !this.verticalWalls[x][y].intersects(rect.getBoundsInLocal())) continue;
            return true;
        }
        return false;
    }

    private boolean intersectHorizontal(Rectangle rect, int y) {
        for (int x = 0; x < this.nbCases; ++x) {
            if (this.horizontalWalls[x][y] == null || !this.horizontalWalls[x][y].intersects(rect.getBoundsInLocal())) continue;
            return true;
        }
        return false;
    }

    private static enum Direction {
        NORTH(0, -1),
        SOUTH(0, 1),
        EAST(1, 0),
        WEST(-1, 0);

        private final int dx;
        private final int dy;

        private Direction(int dx, int dy) {
            this.dx = dx;
            this.dy = dy;
        }
    }

    private static class Pos {
        double x;
        double y;

        public Pos(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public void backTo(Pos pos) {
            this.x = pos.x;
            this.y = pos.y;
        }
    }
}

