/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.ProgEnCours;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.programme.MenuBasController;
import com.mazet.biostim.view.programme.bfb.AnimationAPA;
import com.mazet.biostim.view.programme.bfb.AnimationBalance;
import com.mazet.biostim.view.programme.bfb.AnimationRevoir;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.MenuHautBFBController;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Profil;
import com.mazet.biostim.zdata.ProfilConcatSimple;
import java.util.Objects;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public class BiofeedbackController
extends Controller {
    @FXML
    MenuHautBFBController menuHautBFBController;
    @FXML
    private MenuBasController menuBasController;
    @FXML
    protected AnchorPane fullAnchor;
    @FXML
    protected HBox animationAnchor;
    @FXML
    protected AnchorPane histoAnchor;
    @FXML
    protected AnchorPane gameAnchor;
    @FXML
    protected AnchorPane voie2Anchor;
    @FXML
    protected AnchorPane balanceAnchor;
    @FXML
    protected Region sidePanel;
    @FXML
    protected ScrollPane pausePane;
    @FXML
    protected Button dotButton;
    @FXML
    private VBox dotPane;
    @FXML
    CheckBox checkAnimation;
    @FXML
    CheckBox checkTendance;
    @FXML
    CheckBox checkPanel;
    @FXML
    CheckBox checkHistorique;
    @FXML
    CheckBox checkVoie2;
    @FXML
    CheckBox checkBalance;
    @FXML
    CheckBox checkModeAveugle;
    @FXML
    private CheckBox autoTarage;
    @FXML
    private HBox hboxEpaisseur;
    @FXML
    protected Label epaisseur;
    @FXML
    TextField event1;
    @FXML
    private TextField event2;
    @FXML
    private CheckBox aleatoire;
    @FXML
    private GridPane dataBFB;
    @FXML
    private Label lvoie1;
    @FXML
    private Label base1;
    @FXML
    private Label min1;
    @FXML
    private Label max1;
    @FXML
    private Slider slider1;
    private final Label lvoie2 = new Label();
    private final Label base2 = new Label();
    private final Label min2 = new Label();
    private final Label max2 = new Label();
    private final Slider slider2 = new Slider();
    boolean finish = false;
    private boolean pause = false;
    public Profil profil;
    public int nbVoie = 1;
    int cvoie1;
    int cvoie2;
    boolean voiesSeparees;
    double dureeMilli;
    private double lastUpdate = 0.0;
    private double lastSeconde = 0.0;
    private double lastSlowUpdate = 0.0;
    private int startCounter = 0;
    private long initTime;
    private long startTime;
    private long debutPause = 0L;
    double dureePage = 9999.0;
    private double dureeRafr;
    private double maxUpdate = 0.0;
    private int slowUpdate = 0;
    private int nbUpdate = 0;
    boolean needUpdateProfil = true;
    boolean profilChanged = false;
    double niveauVoie1Aff;
    double niveauVoie2Aff;
    public double niveauVoie1Reel;
    public double niveauVoie2Reel;
    public double profilLevel;
    private double niveauVoie1Prof;
    int isInProfile;
    int motifStimEnCours = 0;
    private boolean debutContraction;
    private boolean finContraction;
    private int lastPente = 0;
    private double lastProfilLevel = 0.0;
    private AnimationTimer timer;
    private static MidiChannel mChannel;
    private int midiNote;
    public BiofeedbackAnimation biofeedbackAnimation;
    private static final int SAMPLING_FREQUENCY_IN_HZ = 8000;
    private static final int NUMBER_OF_FADE_SAMPLES = 80;
    private static final int FREQ = 350;
    private static final int DURATION = 60;
    private static byte[] buf;
    private static SourceDataLine sdl;
    private int delayBip = 500;
    private static final int ssRepos = 0;
    private static final int ssContract = 1;
    private static final int ssSeuilMini = 2;
    private static final int ssSeuilDecl = 3;
    static final int ssStim = 4;
    int stateStimAssistee = 0;
    private double stateStart;
    long closeDate = 0L;

    @Override
    public void setMain() {
        try {
            this.initTime = System.currentTimeMillis();
            this.selectAnimation();
            this.menuBasController.initLogo();
            FxUtils.adjustHboxReglageStyle(this.hboxEpaisseur, "00%", 1.2, null);
            this.profil = Main.progEnCours.currentPageProgram.getProfil();
            this.cvoie1 = Main.progEnCours.currentProgram.getVoieBFB1();
            this.cvoie2 = Main.progEnCours.currentProgram.getVoieBFB2();
            if (this.cvoie2 != -1) {
                this.nbVoie = 2;
            }
            boolean bl = this.voiesSeparees = Main.getConfig().voiesSeparees && this.nbVoie == 2;
            if (this.cvoie1 == 8 || this.cvoie2 == 8) {
                SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.debutAcquisition);
                if (Main.progEnCours.getPageDureeRestante() != null) {
                    if (Main.progEnCours.getPageDureeRestante() > 600) {
                        Main.progEnCours.setPageDureeRestante(600);
                    }
                } else {
                    int progDuree = Main.progEnCours.getProgDureeRestante();
                    if (progDuree > 600) {
                        Main.progEnCours.setProgDureeRestante(600);
                        Main.progEnCours.currentProgram.setDuree(Main.progEnCours.currentProgram.getDuree() - (progDuree - 600));
                    }
                }
            }
            if (!Main.getConfig().autoTarage && Main.progEnCours.getAffMax(this.cvoie1) <= Main.progEnCours.getBase(this.cvoie1)) {
                Main.progEnCours.setBase(this.cvoie1, 0.0);
                Main.progEnCours.setAffMax(this.cvoie1, 100.0);
            }
            if (this.nbVoie == 2 && !Main.getConfig().autoTarage && Main.progEnCours.getAffMax(this.cvoie2) <= Main.progEnCours.getBase(this.cvoie2)) {
                Main.progEnCours.setBase(this.cvoie2, 0.0);
                Main.progEnCours.setAffMax(this.cvoie2, 100.0);
            }
            this.menuHautBFBController.init(this);
            this.menuBasController.afficheDureeRestante();
            this.menuHautBFBController.dureeProg.setText(Main.progEnCours.getProgDureeRestanteString());
            if (Main.progEnCours.currentPageProgram.getDuree() != null) {
                this.dureePage = Main.progEnCours.currentPageProgram.getDuree().intValue();
            }
            this.dureePage = Math.min((double)Main.progEnCours.getProgDureeRestante(), this.dureePage);
            this.menuBasController.getLabelSuivant().setOnMouseClicked(event -> this.suivantAction());
            this.menuBasController.getLabelPrecedent().setOnMouseClicked(event -> this.precedentAction());
            this.menuBasController.getLabelStop().setOnMouseClicked(event -> this.stopAction());
            this.menuBasController.getLabelPause().setOnMouseClicked(event -> this.pauseAction());
            this.autoTarage.setSelected(Main.getConfig().autoTarage);
            this.setEpaisseur(Main.progEnCours.epaisseurProfil);
            this.event1.setText(Main.getConfig().event1);
            this.event2.setText(Main.getConfig().event2);
            this.aleatoire.setSelected(Main.progEnCours.aleatoire);
            this.lvoie1.setText(Biostim.shortNomOfVoie(this.cvoie1) + " ");
            this.slider1.valueProperty().addListener((obs, oldVal, newVal) -> {
                if (!this.needUpdateProfil) {
                    Main.progEnCours.setAffMin(this.cvoie1, (double)newVal.floatValue() * Main.progEnCours.getBase(this.cvoie1) / 100.0);
                    this.needUpdateProfil = true;
                }
            });
            if (this.nbVoie == 2) {
                Label setzero2 = new Label("\u27940");
                setzero2.getStyleClass().add((Object)"link");
                setzero2.setOnMouseClicked(e -> this.setZero2());
                this.dataBFB.add((Node)setzero2, 2, 1);
                this.lvoie2.setText(Biostim.shortNomOfVoie(this.cvoie2) + " ");
                this.lvoie2.getStyleClass().add((Object)"bold");
                this.dataBFB.add((Node)this.lvoie2, 2, 0);
                this.dataBFB.add((Node)this.base2, 2, 2);
                this.dataBFB.add((Node)this.max2, 2, 4);
                this.dataBFB.add((Node)this.min2, 2, 5);
                this.slider2.setOrientation(Orientation.VERTICAL);
                this.slider2.setMaxHeight(120.0);
                this.dataBFB.add((Node)this.slider2, 2, 6, 1, 2);
                this.slider2.valueProperty().addListener((obs, oldVal, newVal) -> {
                    if (!this.needUpdateProfil) {
                        Main.progEnCours.setAffMin(this.cvoie2, (double)newVal.floatValue() * Main.progEnCours.getBase(this.cvoie2) / 100.0);
                        this.needUpdateProfil = true;
                    }
                });
            }
            this.initSon();
            Platform.runLater(() -> {
                if (!this.finish) {
                    if (Main.progEnCours.revoir == null) {
                        Main.progEnCours.revoir = new AnimationRevoir(this);
                    } else {
                        Main.progEnCours.revoir.updateController(this);
                    }
                    this.biofeedbackAnimation.init(this);
                    boolean bl = this.started = Main.getConfig().autoStart || Main.progEnCours.getMinPower() != 9999;
                    if (!this.started) {
                        this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "restartButton"});
                    }
                    if (this.started && Main.getConfig().decomptePageBFB) {
                        this.started = false;
                        FxUtils.lanceDecompte(this, this.gameAnchor);
                    }
                    this.mainLoop();
                }
            });
            if (Version.isSAV()) {
                this.addBoutonsSAV();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void addBoutonsSAV() {
        Button cal200 = new Button("Calibre 200");
        cal200.setOnMouseClicked(e -> this.setCalibre(200));
        AnchorPane.setRightAnchor((Node)cal200, (Double)0.0);
        AnchorPane.setTopAnchor((Node)cal200, (Double)0.0);
        Button cal600 = new Button("Calibre 600");
        cal600.setOnMouseClicked(e -> this.setCalibre(600));
        AnchorPane.setRightAnchor((Node)cal600, (Double)0.0);
        AnchorPane.setTopAnchor((Node)cal600, (Double)30.0);
        VBox vbox = new VBox(10.0, new Node[]{cal200, cal600});
        vbox.setMinWidth(150.0);
        this.menuHautBFBController.menuHautHbox.getChildren().add(3, (Object)vbox);
    }

    private void selectAnimation() {
        if (Main.progEnCours.currentPageProgram.getType() == 11) {
            Main.progEnCours.typeAnimation = 98;
            this.biofeedbackAnimation = new AnimationAPA(this);
            return;
        }
        if (Main.progEnCours.currentPageProgram.getType() == 13) {
            Main.progEnCours.typeAnimation = 97;
            this.biofeedbackAnimation = new AnimationBalance(this);
            return;
        }
        if (Main.progEnCours.currentProgram.getChoixAnim_BFB() == 0) {
            Main.progEnCours.typeAnimation = Main.getConfig().getAnimationParDefaut();
        } else {
            Main.progEnCours.typeAnimation = Main.progEnCours.currentProgram.getChoixAnim_BFB() - 1;
            if (Main.progEnCours.currentProgram.choixForce) {
                Main.getConfig().setAnimationParDefaut(Main.progEnCours.typeAnimation);
            }
        }
        if (Main.progEnCours.typeAnimation >= AnimationStyle.selectedAnimations.size() + Main.getConfig().customAnimationList.size()) {
            Main.progEnCours.typeAnimation = 0;
        }
        if (Main.progEnCours.typeAnimation < AnimationStyle.selectedAnimations.size()) {
            AnimationStyle animationStyle = AnimationStyle.selectedAnimations.get(Main.progEnCours.typeAnimation);
            if (Main.progEnCours.currentPageProgram.getType() == 10 && animationStyle.type != 0 && animationStyle.type != 4) {
                animationStyle = AnimationStyle.staticAnimationList.get(0);
            }
            this.biofeedbackAnimation = animationStyle.getBiofeedBackAnimation(this);
            Main.progEnCours.typeAnimation = AnimationStyle.staticAnimationList.indexOf(AnimationStyle.selectedAnimations.get(Main.progEnCours.typeAnimation));
        } else {
            this.biofeedbackAnimation = Main.getConfig().customAnimationList.get(Main.progEnCours.typeAnimation - AnimationStyle.selectedAnimations.size()).getBiofeedBackAnimation(this);
            Main.progEnCours.typeAnimation = 99;
        }
        Utils.debugInfo("animation : %s (num %d ; %s%s ; default %b ; parallax %b)", Main.progEnCours.typeAnimation == 99 ? "custom" : AnimationStyle.staticAnimationList.get((int)Main.progEnCours.typeAnimation).name, Main.progEnCours.typeAnimation, Main.progEnCours.currentProgram.isDefilement() ? "defilement" : "fixe", Main.progEnCours.currentProgram.ghost ? " reactif" : "", Main.progEnCours.currentProgram.getChoixAnim_BFB() == 0, !Main.getConfig().noParallax);
    }

    private void mainLoop() {
        this.timer = new AnimationTimer(this){
            final /* synthetic */ BiofeedbackController this$0;
            {
                BiofeedbackController biofeedbackController = this$0;
                Objects.requireNonNull(biofeedbackController);
                this.this$0 = biofeedbackController;
            }

            public void handle(long unused) {
                try {
                    long now = System.currentTimeMillis();
                    if (this.this$0.startCounter < 5) {
                        ++this.this$0.startCounter;
                    }
                    if (this.this$0.startCounter == 5) {
                        this.this$0.startTime = now;
                        this.this$0.lastSeconde = 0.0;
                        ++this.this$0.startCounter;
                        Utils.debugInfo("temps de demarrage : %.1fs", (double)(now - this.this$0.initTime) / 1000.0);
                    }
                    if (this.this$0.startCounter > 5 && !this.this$0.pause && !this.this$0.finish) {
                        if (!this.this$0.started) {
                            this.this$0.startTime = now;
                        }
                        this.this$0.dureeMilli = (double)(now - this.this$0.startTime) / 1000.0;
                        if (Main.progEnCours.getProgDureeRestante() <= 0) {
                            this.this$0.progTermine();
                        } else if (Main.progEnCours.getPageDureeRestante() != null && Main.progEnCours.getPageDureeRestante() <= 0) {
                            if (Main.progEnCours.currentPageProgram.getNext() != 0) {
                                this.this$0.suivantAction();
                            } else {
                                this.this$0.progTermine();
                            }
                        } else {
                            if (this.this$0.dureeMilli - this.this$0.lastSeconde >= 1.0) {
                                Computer.keepAwake();
                                Main.progEnCours.decrProgDureeRestante();
                                this.this$0.menuHautBFBController.dureeProg.setText(Main.progEnCours.getProgDureeRestanteString());
                                Main.progEnCours.decrPageDureeRestante();
                                this.this$0.menuBasController.afficheDureeRestante();
                                this.this$0.lastSeconde += 1.0;
                            }
                            this.this$0.dureeRafr = this.this$0.dureeMilli - this.this$0.lastUpdate;
                            if (this.this$0.started) {
                                this.this$0.lastUpdate = this.this$0.dureeMilli;
                                ++this.this$0.nbUpdate;
                                if (this.this$0.dureeRafr > this.this$0.maxUpdate) {
                                    this.this$0.maxUpdate = this.this$0.dureeRafr;
                                }
                                if (this.this$0.dureeRafr > 0.1) {
                                    ++this.this$0.slowUpdate;
                                }
                                this.this$0.updateGenerique();
                                Main.progEnCours.historique.ajouteValeur(this.this$0.dureeMilli + Main.progEnCours.revoir.startPageTime, this.this$0);
                            } else {
                                this.this$0.updateGenerique();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.this$0.stopAction();
                }
            }
        };
        this.timer.start();
    }

    private void sound() {
        try {
            if (buf == null) {
                int i;
                buf = new byte[480];
                for (i = 0; i < buf.length; ++i) {
                    double angle = (double)(i * 2) * Math.PI * 350.0 / 8000.0;
                    BiofeedbackController.buf[i] = (byte)(Math.sin(angle) * 100.0);
                }
                for (i = 0; i < 80 && i < buf.length / 2; ++i) {
                    BiofeedbackController.buf[i] = (byte)(buf[i] * i / 80);
                    BiofeedbackController.buf[BiofeedbackController.buf.length - 1 - i] = (byte)(buf[buf.length - 1 - i] * i / 80);
                }
            }
            if (sdl == null) {
                AudioFormat af = new AudioFormat(8000.0f, 8, 1, true, false);
                sdl = AudioSystem.getSourceDataLine(af);
                sdl.open(af);
                sdl.start();
            }
            sdl.drain();
            sdl.write(buf, 0, buf.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSon() {
        if (Main.getConfig().getBfbSonore() == 1) {
            try {
                if (mChannel == null) {
                    Synthesizer midiSynth = MidiSystem.getSynthesizer();
                    midiSynth.open();
                    Instrument[] instr = midiSynth.getDefaultSoundbank().getInstruments();
                    MidiChannel[] mChannels = midiSynth.getChannels();
                    mChannel = mChannels[0];
                    mChannel.programChange(instr[82].getPatch().getProgram());
                }
                this.midiNote = 0;
            }
            catch (Exception e) {
                Utils.debugInfo("impossible d'initialiser le son : " + String.valueOf(e));
            }
        } else if (Main.getConfig().getBfbSonore() == 2) {
            new Thread(() -> {
                while (!this.finish) {
                    if (!this.pause) {
                        this.sound();
                    }
                    Utils.sleep(this.delayBip);
                }
            }).start();
        }
        Computer.loadSong(Main.getConfig().getSonDebutBfb());
        Computer.loadSong(Main.getConfig().getSonFinBfb());
    }

    private void stopSon() {
        if (Main.getConfig().getBfbSonore() == 1 && mChannel != null) {
            mChannel.noteOff(this.midiNote);
        }
        if (Main.getConfig().getBfbSonore() == 2 && sdl != null) {
            sdl.drain();
        }
    }

    private void changeFreq(int niveau) {
        if (Main.getConfig().getBfbSonore() == 1 && mChannel != null) {
            int note = 50 + niveau / 5;
            if (note != this.midiNote) {
                mChannel.noteOff(this.midiNote);
                this.midiNote = note;
                mChannel.noteOn(this.midiNote, 600);
            }
        } else if (Main.getConfig().getBfbSonore() == 2) {
            this.delayBip = (int)(1100.0 - Math.sqrt(10000.0 * (double)niveau));
        }
    }

    private void updateGenerique() {
        if (this.needUpdateProfil) {
            this.updateProfil();
        }
        this.profilLevel = this.profil.getVal(this.dureeMilli);
        this.manageStim();
        this.getNiveaux();
        if (this.autoTarage.isSelected()) {
            this.ajusteTarage();
        }
        this.biofeedbackAnimation.updateSpecifique();
        if (this.started) {
            this.manageReussite();
            if (Main.progEnCours.currentPageProgram.isBfbAssiste()) {
                this.manageStimAssistee();
            }
        }
    }

    private void updateProfil() {
        double limMin2;
        this.menuHautBFBController.updateInfo();
        double limMin1 = Main.progEnCours.getBase(this.cvoie1);
        if (limMin1 > 0.0) {
            this.slider1.setValue(100.0 * Main.progEnCours.getAffMin(this.cvoie1) / limMin1);
        }
        if (this.nbVoie == 2 && (limMin2 = Main.progEnCours.getBase(this.cvoie2)) > 0.0) {
            this.slider2.setValue(100.0 * Main.progEnCours.getAffMin(this.cvoie2) / limMin2);
        }
        this.biofeedbackAnimation.updateProfil();
        this.needUpdateProfil = false;
        this.profilChanged = false;
    }

    private void getNiveaux() {
        ProgEnCours pec = Main.progEnCours;
        this.niveauVoie1Reel = this.stateStimAssistee == 4 || this.motifStimEnCours != 0 ? pec.getBase(this.cvoie1) + ((double)pec.epaisseurProfil / 2.0 + this.profilLevel * (double)(100 - pec.epaisseurProfil) / 100.0) / 100.0 * (pec.getAffMax(this.cvoie1) - pec.getBase(this.cvoie1)) : Biostim.getVoie(this.cvoie1);
        Main.progEnCours.updatePower(this.niveauVoie1Reel, this.profilLevel, this.dureeMilli, this.stateStimAssistee != 4 && this.motifStimEnCours == 0);
        this.niveauVoie1Aff = this.biofeedbackAnimation.niv1AffOfReel(this.niveauVoie1Reel);
        this.changeFreq((int)this.niveauVoie1Aff);
        boolean slowUpdate = false;
        if (this.dureeMilli - this.lastSlowUpdate > 0.5) {
            this.lastSlowUpdate = this.dureeMilli;
            slowUpdate = true;
        }
        if (slowUpdate || !this.started) {
            this.updateDataBFB();
            this.menuHautBFBController.valVoie1.setText(String.format("%s: %s", Biostim.shortNomOfVoie(this.cvoie1), pec.relativeValue(this.cvoie1, this.niveauVoie1Reel)));
        }
        if (this.nbVoie == 2) {
            if (this.stateStimAssistee != 4 && this.motifStimEnCours == 0) {
                this.niveauVoie2Reel = Biostim.getVoie(this.cvoie2);
                this.niveauVoie2Aff = this.biofeedbackAnimation.niv2AffOfReel(this.niveauVoie2Reel);
            }
            Main.progEnCours.updatePower2(this.niveauVoie2Reel);
            if (slowUpdate || !this.started) {
                this.menuHautBFBController.valVoie2.setText(String.format("%s: %s", Biostim.shortNomOfVoie(this.cvoie2), pec.relativeValue(this.cvoie2, this.niveauVoie2Reel)));
            }
        }
        double niv1sature = this.niveauVoie1Reel < Main.progEnCours.getAffMin(this.cvoie1) ? Main.progEnCours.getAffMin(this.cvoie1) : Math.min(this.niveauVoie1Reel, Main.progEnCours.getAffMax(this.cvoie1));
        this.niveauVoie1Prof = 100.0 * (niv1sature - Main.progEnCours.getBase(this.cvoie1)) / (Main.progEnCours.getAffMax(this.cvoie1) - Main.progEnCours.getBase(this.cvoie1)) * 100.0 / (double)(100 - Main.progEnCours.epaisseurProfil);
        this.isInProfile = this.niveauVoie1Prof < this.profilLevel - 1.0 ? -1 : (this.niveauVoie1Prof > this.profilLevel + (double)Main.progEnCours.epaisseurProfil + 1.0 ? 1 : 0);
    }

    private void ajusteTarage() {
        if (this.niveauVoie1Reel > Main.progEnCours.getAffMax(this.cvoie1)) {
            Main.progEnCours.setAffMax(this.cvoie1, this.niveauVoie1Reel);
            this.needUpdateProfil = true;
        }
        if (this.nbVoie == 2 && this.niveauVoie2Reel > Main.progEnCours.getAffMax(this.cvoie2)) {
            Main.progEnCours.setAffMax(this.cvoie2, this.niveauVoie2Reel);
            this.needUpdateProfil = true;
        }
        if (this.niveauVoie1Reel < Main.progEnCours.getBase(this.cvoie1)) {
            Main.progEnCours.setBase(this.cvoie1, this.niveauVoie1Reel);
            this.needUpdateProfil = true;
        }
        if (this.nbVoie == 2 && this.niveauVoie2Reel < Main.progEnCours.getBase(this.cvoie2)) {
            Main.progEnCours.setBase(this.cvoie2, this.niveauVoie2Reel);
            this.needUpdateProfil = true;
        }
    }

    private void manageReussite() {
        if (this.profil.typeProfil() == 2) {
            if (this.profilLevel == 0.0 && this.isInProfile <= 0 || this.profilLevel > 0.0 && this.isInProfile >= 0) {
                if (!this.biofeedbackAnimation.hasObjects()) {
                    Main.progEnCours.points += this.dureeRafr;
                }
                Main.progEnCours.incDansProfil();
            } else {
                Main.progEnCours.incHorsProfil();
            }
        }
        if (this.profil.typeProfil() == 2) {
            if (Main.getConfig().typeScore == 1) {
                this.menuHautBFBController.reussite.setText(Main.progEnCours.getPourcentageReussite() + "%");
            } else if (Main.getConfig().typeScore == 2) {
                this.menuHautBFBController.reussite.setText(String.format("%.0f", Main.progEnCours.points));
            }
        } else if (Main.progEnCours.currentPageProgram.getType() == 10) {
            this.menuHautBFBController.reussite.setText(String.format("%.0f", Main.progEnCours.points));
        }
        this.debutContraction = this.lastPente <= 0 && this.profilLevel > this.lastProfilLevel;
        boolean bl = this.finContraction = this.lastPente >= 0 && this.profilLevel < this.lastProfilLevel;
        if (this.debutContraction) {
            Computer.playSong(Main.getConfig().getSonDebutBfb());
        }
        if (this.finContraction) {
            Computer.playSong(Main.getConfig().getSonFinBfb());
        }
        this.lastPente = Double.compare(this.profilLevel, this.lastProfilLevel);
        this.lastProfilLevel = this.profilLevel;
    }

    void manageStim() {
        ProfilConcatSimple.Motif motifStim = this.profil.getStimMotif(this.dureeMilli);
        ProfilConcatSimple.Motif motifStimNext = this.profil.getStimMotifNext(this.dureeMilli);
        double dateFin = this.profil.dateFinStim(this.dureeMilli);
        if (motifStim != null) {
            if (this.motifStimEnCours != 1 && motifStim == motifStimNext) {
                int oldmotifStim = this.motifStimEnCours;
                this.startStim(motifStim);
                if (oldmotifStim == 0) {
                    this.biofeedbackAnimation.nouvellesCourbes();
                }
            } else if (motifStim != motifStimNext && (this.profilLevel == 0.0 || this.dureeMilli + 0.3 > dateFin) && this.motifStimEnCours == 1) {
                this.stopStim();
                this.motifStimEnCours = 2;
            }
        } else if (this.motifStimEnCours == 1) {
            this.stopStim();
            this.biofeedbackAnimation.nouvellesCourbes();
        } else if (this.motifStimEnCours != 0) {
            this.motifStimEnCours = 0;
        }
    }

    private void startStim(ProfilConcatSimple.Motif motif) {
        Main.progEnCours.currentPageProgram.csFreq = motif.freq;
        Main.progEnCours.currentPageProgram.csLargeur = motif.largeur;
        this.deltaStim(0);
        this.menuHautBFBController.eclair.getStyleClass().setAll((Object[])new String[]{"eclair"});
        this.menuHautBFBController.freq.setText(String.format("%dHz / %dus", motif.freq, motif.largeur));
        this.motifStimEnCours = 1;
        UsbBiostim.initStimInnervee(1, (int)(motif.dureePlateau * 10.0 + 10.0), (int)(motif.repos * 10.0), 5L, 5L, (int)(motif.dureePlateau * 10.0 + 10.0), (int)(motif.repos * 10.0), 5L, 5L, 0, motif.freq, motif.largeur, motif.freq, motif.largeur, 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false);
        UsbBiostim.amplitudeVoie(0, Main.progEnCours.getStimAmplitudeA());
    }

    private void stopStim() {
        this.menuHautBFBController.eclair.getStyleClass().setAll((Object[])new String[]{"eclairgris"});
        if (this.motifStimEnCours == 1) {
            UsbBiostim.activateGenerateur(1, false);
        }
        this.motifStimEnCours = 0;
    }

    private void manageStimAssistee() {
        Pageprogramme pp = Main.progEnCours.currentPageProgram;
        if (this.debutContraction) {
            this.stateStimAssistee = 1;
        } else if (this.finContraction) {
            this.stopStimAssistee();
        } else if (this.stateStimAssistee != 4) {
            if ((this.stateStimAssistee == 1 || this.stateStimAssistee == 2 || this.stateStimAssistee == 3) && this.niveauVoie1Prof > (double)(pp.dynHaut * Main.progEnCours.seuilBFBAssiste) / 100.0) {
                this.stateStimAssistee = 3;
                this.stateStart = this.dureeMilli;
            }
            if (this.stateStimAssistee == 1 && this.niveauVoie1Prof > (double)(pp.dynHaut * Main.progEnCours.seuilBFBAssiste) / 100.0 / 3.0) {
                this.stateStimAssistee = 2;
                this.stateStart = this.dureeMilli;
            }
            if (pp.relachement && this.stateStimAssistee == 3 && this.dureeMilli - this.stateStart > 1.0) {
                this.startStimAssistee();
            }
            if (pp.insuffisant && this.stateStimAssistee == 2 && this.dureeMilli - this.stateStart > 1.0) {
                this.startStimAssistee();
            }
        }
    }

    private void startStimAssistee() {
        this.stateStimAssistee = 4;
        this.menuHautBFBController.eclair.getStyleClass().setAll((Object[])new String[]{"eclair"});
        this.biofeedbackAnimation.nouvellesCourbes();
        UsbBiostim.initStimInnervee(1, 1000L, 0L, 10L, 0L, 1000L, 0L, 10L, 0L, Main.progEnCours.currentPageProgram.getBf(), Main.progEnCours.currentPageProgram.getFreq(), Main.progEnCours.currentPageProgram.getLargeur(), Main.progEnCours.currentPageProgram.getFreq2(), Main.progEnCours.currentPageProgram.getLargeur2(), Main.progEnCours.currentPageProgram.getAttente2Impulsion(), Main.progEnCours.currentPageProgram.getLargeurL2(), Main.progEnCours.currentPageProgram.getFreqF2(), Main.progEnCours.currentPageProgram.getDissymetrique(), Main.progEnCours.currentPageProgram.getHauteTension(), Main.progEnCours.currentPageProgram.getImpulsionMono(), Main.progEnCours.currentPageProgram.getPolarite(), Main.progEnCours.currentPageProgram.getLargeurL3(), Main.progEnCours.currentPageProgram.getFreqF3(), Main.progEnCours.currentPageProgram.getReposActif(), Main.progEnCours.currentPageProgram.getReposActif2());
        UsbBiostim.amplitudeVoie(0, Main.progEnCours.getStimAmplitudeA());
    }

    private void stopStimAssistee() {
        int initState = this.stateStimAssistee;
        this.stateStimAssistee = 0;
        if (initState == 4) {
            this.menuHautBFBController.eclair.getStyleClass().setAll((Object[])new String[]{"eclairgris"});
            this.biofeedbackAnimation.nouvellesCourbes();
            UsbBiostim.activateGenerateur(1, false);
        }
    }

    private void stopBiofeedBack() {
        try {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = null;
            if (this.cvoie1 == 8 || this.cvoie2 == 8) {
                SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.finAcquisition);
            }
            Main.progEnCours.commentaire = this.menuHautBFBController.commentaire.getText();
            Main.progEnCours.fpsBFB = (int)((double)this.nbUpdate / this.dureeMilli);
            if (!this.finish && this.nbUpdate > 100) {
                Utils.debugInfo("fin de BFB : %d fps ; max %dms ; %d slow / %d", Main.progEnCours.fpsBFB, (int)(this.maxUpdate * 1000.0), this.slowUpdate, this.nbUpdate);
            }
            this.finish = true;
            Main.getConfig().setAutoTarage(this.autoTarage.isSelected() && Main.getConfig().isActivated);
            Main.getConfig().event1 = this.event1.getText();
            Main.getConfig().event2 = this.event2.getText();
            Main.getConfig().epaisseurProfil = Main.progEnCours.epaisseurProfil;
            if (this.checkHistorique.isVisible()) {
                Main.getConfig().afficheHistorique = this.checkHistorique.isSelected();
            }
            if (this.checkTendance.isVisible()) {
                Main.getConfig().afficheTendance = this.checkTendance.isSelected();
            }
            if (this.checkPanel.isVisible()) {
                Main.getConfig().afficheSidePanel = this.checkPanel.isSelected();
            }
            Main.getConfig().saveConfig();
            this.stopStimAssistee();
            this.stopStim();
            this.stopSon();
            this.gameAnchor.getChildren().removeAll((Object[])new Node[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void progTermine() {
        try {
            if (!this.finish) {
                Computer.playSong(Main.getConfig().getSonFinProgramme());
                this.stopBiofeedBack();
                if (this.biofeedbackAnimation instanceof AnimationBalance) {
                    this.biofeedbackAnimation.balanceDesign.fin();
                } else {
                    this.showHistory(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopAction() {
        try {
            this.stopBiofeedBack();
            Platform.runLater(Main.progEnCours::finProgramme);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pauseAction() {
        if (!this.started) {
            this.started = true;
            this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "pauseButton"});
        } else if (!this.finish) {
            boolean bl = this.pause = !this.pause;
            if (this.pause) {
                if (this.cvoie1 == 8 || this.cvoie2 == 8) {
                    SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.finAcquisition);
                }
                this.debutPause = System.currentTimeMillis();
                this.stopSon();
                this.stopStim();
                this.stopStimAssistee();
                this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "restartButton"});
                if (!(this.biofeedbackAnimation instanceof AnimationBalance)) {
                    this.showHistory(false);
                }
            } else {
                if (this.cvoie1 == 8 || this.cvoie2 == 8) {
                    SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.debutAcquisition);
                }
                this.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "pauseButton"});
                this.startTime += System.currentTimeMillis() - this.debutPause;
                if (!(this.biofeedbackAnimation instanceof AnimationBalance)) {
                    this.menuHautBFBController.commentRegion.setVisible(false);
                    this.biofeedbackAnimation.onResume();
                }
            }
        }
    }

    @Override
    public void aPlusAction() {
        this.menuHautBFBController.action = "stim+";
        this.menuHautBFBController.reglageEnCours();
    }

    @Override
    public void aMoinsAction() {
        this.menuHautBFBController.action = "stim-";
        this.menuHautBFBController.reglageEnCours();
    }

    private void showHistory(boolean fin) {
        this.menuHautBFBController.commentRegion.setVisible(true);
        Main.progEnCours.revoir.dessineHistorique(fin);
        FxUtils.setVisibility((Node)this.pausePane, true);
        FxUtils.setVisibility((Node)this.animationAnchor, false);
    }

    private void precedentAction() {
        try {
            if (Main.progEnCours.getProgDureeRestante() > 0 && (Main.progEnCours.getPageDureeRestante() == null || Main.progEnCours.getPageDureeRestante() > 0)) {
                Utils.debugInfo("sortie de page par appui sur precedent");
            }
            this.stopBiofeedBack();
            Main.progEnCours.gotoLastPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void suivantAction() {
        try {
            if (Main.progEnCours.getProgDureeRestante() > 0 && (Main.progEnCours.getPageDureeRestante() == null || Main.progEnCours.getPageDureeRestante() > 0)) {
                Utils.debugInfo("sortie de page par appui sur suivant");
            }
            this.stopBiofeedBack();
            Main.progEnCours.gotoNextPage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void openDot() {
        this.dotPane.setVisible(true);
        this.postCloseDot();
    }

    private synchronized void postCloseDot() {
        this.closeDate = System.currentTimeMillis() + 20000L;
        new Thread(() -> {
            long now;
            while ((now = System.currentTimeMillis()) < this.closeDate) {
                Utils.sleep(this.closeDate - now);
            }
            if (this.closeDate != 0L) {
                this.closeDot();
            }
        }).start();
    }

    private void delayCloseDot() {
        this.closeDate = System.currentTimeMillis() + 20000L;
    }

    @FXML
    private synchronized void closeDot() {
        this.closeDate = 0L;
        Platform.runLater(() -> this.dotPane.setVisible(false));
    }

    @FXML
    private void changeZoneAffichee() {
        this.delayCloseDot();
        this.biofeedbackAnimation.updateSize(true);
    }

    @FXML
    private void changeModeAveugle() {
        this.delayCloseDot();
        this.biofeedbackAnimation.changeModeAveugle();
    }

    @FXML
    public void fxMousePressed(MouseEvent event) {
        this.menuHautBFBController.mousePressed(event);
    }

    @FXML
    private void fxMouseReleased() {
        this.menuHautBFBController.mouseReleased();
    }

    @FXML
    void setZero1() {
        if (this.cvoie1 == 14) {
            SondeBT.setRefGonio();
            return;
        }
        if (this.niveauVoie1Reel >= Main.progEnCours.getAffMax(this.cvoie1) - 2.0) {
            return;
        }
        Main.progEnCours.setBase(this.cvoie1, this.niveauVoie1Reel);
        this.needUpdateProfil = true;
    }

    @FXML
    void setZero2() {
        if (this.cvoie2 == 14) {
            SondeBT.setRefGonio();
            return;
        }
        if (this.niveauVoie2Reel >= Main.progEnCours.getAffMax(this.cvoie2) - 2.0) {
            return;
        }
        Main.progEnCours.setBase(this.cvoie2, this.niveauVoie2Reel);
        this.needUpdateProfil = true;
    }

    private void updateDataBFB() {
        this.base1.setText(Integer.toString((int)Main.progEnCours.getBase(this.cvoie1)));
        this.min1.setText(Main.progEnCours.relativeValue(this.cvoie1, Main.progEnCours.getMinPower()));
        this.max1.setText(Main.progEnCours.relativeValue(this.cvoie1, Main.progEnCours.getMaxPower()));
        if (this.nbVoie == 2) {
            this.base2.setText(Integer.toString((int)Main.progEnCours.getBase(this.cvoie2)));
            this.min2.setText(Main.progEnCours.relativeValue(this.cvoie2, Main.progEnCours.getMinPower2()));
            this.max2.setText(Main.progEnCours.relativeValue(this.cvoie2, Main.progEnCours.getMaxPower2()));
        }
    }

    void setEpaisseur(int e) {
        if (e > 30) {
            e = 30;
        }
        if (e < 5) {
            e = 5;
        }
        Main.progEnCours.epaisseurProfil = e;
        this.epaisseur.setText(e + "%");
    }

    void deltaSeuil(int delta) {
        Main.progEnCours.seuilBFBAssiste += delta;
        if (Main.progEnCours.seuilBFBAssiste > 100) {
            Main.progEnCours.seuilBFBAssiste = 100;
        }
        if (Main.progEnCours.seuilBFBAssiste < 20) {
            Main.progEnCours.seuilBFBAssiste = 20;
        }
    }

    void deltaStim(int delta) {
        if (this.stateStimAssistee == 4 || this.motifStimEnCours == 1 || delta <= 0) {
            Main.progEnCours.setStimAmplitudeA(Main.progEnCours.getStimAmplitudeA() + (double)delta * UsbBiostim.deltaStim);
            double ampli = Main.progEnCours.getStimAmplitudeA();
            this.menuHautBFBController.nivStim.setText(String.format("%.1f mA", ampli));
            UsbBiostim.amplitudeVoie(0, ampli);
        }
    }

    @Override
    public void updateAffichageStim() {
        this.deltaStim(0);
    }

    @FXML
    private void addEvent(MouseEvent event) {
        Button source = (Button)event.getSource();
        String type = source.getUserData().toString().equals("1") ? this.event1.getText() : this.event2.getText();
        this.biofeedbackAnimation.addEvent(type, this.dureeMilli);
    }

    public void aleatoireChange() {
        Main.progEnCours.aleatoire = this.aleatoire.isSelected();
    }

    @Override
    public void setCalibre(int cal) {
        Main.progEnCours.setAffMax(this.cvoie1, cal);
        if (this.nbVoie >= 2) {
            Main.progEnCours.setAffMax(this.cvoie2, cal);
        }
        this.needUpdateProfil = true;
    }

    static {
        buf = null;
        sdl = null;
    }
}

