/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.ProgEnCours;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.zdata.Csv;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Patient;
import com.mazet.biostim.zdata.Profil;
import com.mazet.biostim.zdata.ProfilConcat;
import com.mazet.biostim.zdata.ProfilConcatSimple;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import org.json.JSONArray;
import org.json.JSONObject;

public class Programme {
    public static final int typeStim = 1;
    public static final int typeBFB = 2;
    public static final int typeBilan = 4;
    public static final int typeAPA = 8;
    public static final int typeBal = 16;
    private int id;
    private int parentId;
    private String nom;
    private String categorie;
    private String lienHtml;
    private int duree;
    private ArrayList<Pageprogramme> listPage;
    public int choixBFB = 0;
    public Integer tarage2 = null;
    public boolean aidePlacementSondePression = false;
    private int voieBFB1 = -1;
    private int voieBFB2 = -1;
    private boolean defilement = true;
    public boolean voie1EnHaut = true;
    public boolean ghost = false;
    private transient boolean custom = false;
    public transient boolean choixForce = false;
    public transient Pageprogramme page0;
    private static ArrayList<Integer> listFav;
    private static Csv sheet;

    public Programme() {
    }

    public Programme(int id, String nom, String categorie, String lienHtml, int duree, ArrayList<Pageprogramme> listPage) {
        this.id = id;
        this.nom = nom;
        this.categorie = categorie;
        this.lienHtml = lienHtml;
        this.duree = duree;
        this.listPage = listPage;
    }

    public Programme(int id, String nom, String categorie, int duree, int type) {
        this.id = id;
        this.nom = TransientConfig.translate(nom);
        this.categorie = categorie;
        this.duree = duree;
        this.listPage = new ArrayList<Pageprogramme>(Collections.singletonList(new Pageprogramme(type)));
    }

    public Programme(int id, String nom, String categorie, int duree, Pageprogramme page) {
        this.id = id;
        this.nom = TransientConfig.translate(nom);
        this.categorie = categorie;
        this.duree = duree;
        this.listPage = new ArrayList<Pageprogramme>(Collections.singletonList(page));
    }

    public boolean forceNoTarage() {
        return this.id == 42 || this.parentId == 42 || this.categorie.equals("SAV");
    }

    public static Programme getProgById(int id) {
        for (Programme prog : Programme.getAllProgrammes()) {
            if (prog.getId() != id) continue;
            return prog;
        }
        return null;
    }

    public static ArrayList<Programme> excelProgList() {
        ArrayList<Programme> listProg = new ArrayList<Programme>();
        int nbStimAppareil = Main.getConfig().nbVoiesStimDispo;
        try {
            if (sheet == null) {
                sheet = new Csv("/programmes.csv");
            }
            for (int row = 1; row < sheet.nbRows(); ++row) {
                Programme temp = new Programme();
                ArrayList<Pageprogramme> tempPage = new ArrayList<Pageprogramme>();
                temp.setListPage(tempPage);
                temp.setCustom(false);
                temp.setId(sheet.getInt(row, 0));
                String nom = sheet.get(row, 1);
                temp.setCategorie(sheet.get(row, 2));
                temp.setNom(temp.categorie.equals("SAV") ? nom : TransientConfig.translate(nom));
                temp.setLienHtml(sheet.get(row, 3));
                temp.duree = Utils.intOfTime(sheet.get(row, 4));
                int col = 5;
                while (!sheet.get(row, col).isEmpty()) {
                    Pageprogramme pp = new Pageprogramme(sheet.get(row, col), temp, row, col);
                    tempPage.add(pp);
                    if (pp.getType() == 1 && (pp.getImaxA() < 1 || pp.getImaxB() < 1)) {
                        Utils.debugInfo("prog stim trop energetique : " + temp.getNom());
                    }
                    ++col;
                }
                if (Main.getConfig().isActivated) {
                    if (temp.id == 56) {
                        motif1 = new ProfilConcatSimple.Motif(1, 4.0, 50, 350, 10.0);
                        motif2 = new ProfilConcatSimple.Motif(1, 0.5, 4.0, 0.0);
                        motif3 = new ProfilConcatSimple.Motif(10.0);
                        pageprogramme = new Pageprogramme(new ArrayList<ProfilConcatSimple.Motif>(Arrays.asList(motif1, motif2, motif3)));
                        temp = new Programme(temp.id, temp.nom, temp.categorie, temp.lienHtml, temp.duree, new ArrayList<Pageprogramme>(Collections.singletonList(pageprogramme)));
                    } else if (temp.id == 58) {
                        motif1 = new ProfilConcatSimple.Motif(1, 3.0, 50, 350, 2.0);
                        motif2 = new ProfilConcatSimple.Motif(1, 0.5, 11.0, 0.0);
                        motif3 = new ProfilConcatSimple.Motif(10.0);
                        pageprogramme = new Pageprogramme(new ArrayList<ProfilConcatSimple.Motif>(Arrays.asList(motif1, motif2, motif3)));
                        temp = new Programme(temp.id, temp.nom, temp.categorie, temp.lienHtml, temp.duree, new ArrayList<Pageprogramme>(Collections.singletonList(pageprogramme)));
                    }
                }
                listProg.add(temp);
            }
            if (Main.getConfig().isActivated && nbStimAppareil > 0) {
                ProfilConcatSimple.Motif glazer1 = new ProfilConcatSimple.Motif(60.0);
                ProfilConcatSimple.Motif glazer2 = new ProfilConcatSimple.Motif(5, 1, 1.0, 10.0);
                ProfilConcatSimple.Motif glazer3 = new ProfilConcatSimple.Motif(5, 0.5, 10.0, 10.0);
                ProfilConcatSimple.Motif glazer4 = new ProfilConcatSimple.Motif(1, 0.5, 60.0, 10.0);
                listProg.add(new Programme(34, "glazer", "bilans", 350, new Pageprogramme(new ArrayList<ProfilConcatSimple.Motif>(Arrays.asList(glazer1, glazer2, glazer3, glazer4, glazer1)))));
            }
            listProg.add(new Programme(200, "cible", "Balance", 300, new Pageprogramme(0, 5, 2)));
            listProg.add(new Programme(201, "cibleAleatoire", "Balance", 300, new Pageprogramme(0, 5, 0)));
            listProg.add(new Programme(202, "labyrinthe5", "Balance", 300, new Pageprogramme(1, 5, 5)));
            listProg.add(new Programme(203, "labyrinthe7", "Balance", 300, new Pageprogramme(1, 7, 5)));
            if (Main.getConfig().isActivated && (nbStimAppareil > 0 || Main.getConfig().biopodDispo)) {
                listProg.add(new Programme(107, "concat_simple", "Batir", 900, 12));
                listProg.add(new Programme(102, "dessine", "Batir", 900, 6));
                listProg.add(new Programme(106, "catch", "Batir", 900, 10));
                listProg.add(new Programme(103, "concat", "Batir", 900, 5));
                listProg.add(new Programme(105, "aleatoire", "Batir", 900, 9));
                listProg.add(new Programme(104, "combine", "Batir", 900, 8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Programme p2 : listProg) {
            for (Pageprogramme pp : p2.listPage) {
                if (Main.getConfig().isTypeProgAutorise(pp.getType())) continue;
                pp.makeStatic(listProg, p2);
            }
        }
        if (Main.getConfig().distributeur.equals("menfis")) {
            listProg.removeIf(p -> p.categorie.equals("Batir") || p.categorie.equals("Anorectal") || p.categorie.equals("bilans") || p.categorie.equals("Stim_Motrice"));
        }
        return Programme.cleanList(listProg);
    }

    public static ArrayList<Programme> cleanList(ArrayList<Programme> input) {
        ArrayList<Programme> res = new ArrayList<Programme>();
        int nbPressionAppareil = Main.getConfig().nbVoiesPressionDispo;
        int nbStimAppareil = Main.getConfig().nbVoiesStimDispo;
        for (Programme p : input) {
            boolean isok;
            int type = p.getType();
            boolean bl = isok = !p.getCategorie().equals("SAV");
            if ((type == 8 || type == 16) && SondeBT.connectionBiomoov < 3) {
                isok = false;
            }
            if (p.voieBFB2 == 1 && nbStimAppareil < 2) {
                p.voieBFB2 = 16;
            }
            if (Biostim.isBTinvisible(p.getVoieBFB1()) || Biostim.isBTinvisible(p.getVoieBFB2())) {
                isok = false;
            }
            if (p.voieBFB2 == 3 && nbPressionAppareil < 2) {
                isok = false;
            }
            if (p.voieBFB1 == 2 && nbPressionAppareil < 1) {
                isok = false;
            }
            if (p.voieBFB2 == 2 && nbPressionAppareil < 1) {
                isok = false;
            }
            if (!(p.voieBFB1 != 0 && p.voieBFB1 != -1 || nbStimAppareil >= 1 || Main.getConfig().biopodDispo)) {
                isok = false;
            }
            if (p.voieBFB2 == 1 && nbStimAppareil < 2) {
                isok = false;
            }
            if (p.getNbVoiesStim() > nbStimAppareil) {
                isok = false;
            }
            if (nbStimAppareil == 0 && p.isConcatSimple()) {
                isok = false;
            }
            if (p.getId() == 51 && nbPressionAppareil == 0) {
                isok = false;
            }
            if (!isok && !Version.isSAV()) continue;
            res.add(p);
        }
        return res;
    }

    public static ArrayList<String> getListCategorie() {
        ArrayList<String> listCategorie = new ArrayList<String>();
        for (Programme prog : Programme.excelProgList()) {
            if (listCategorie.contains(prog.getCategorie())) continue;
            listCategorie.add(prog.getCategorie());
        }
        if (!Main.getConfig().optionBatir()) {
            listCategorie.remove("Batir");
        }
        if (!Main.getConfig().optionStimMotrice()) {
            listCategorie.remove("Stim_Motrice");
        }
        if (SondeBT.connectionBiomoov < 3) {
            listCategorie.remove("Balance");
        }
        return listCategorie;
    }

    public static ArrayList<Programme> getCustomProgrammes(String categorie, boolean showFavoris, boolean getall) {
        ArrayList<Programme> res = new ArrayList<Programme>();
        try {
            ArrayList<Programme> listTemp = new ArrayList<Programme>();
            String contents = new String(Files.readAllBytes(Paths.get(Main.getConfig().getProgCustom(), new String[0])));
            JSONObject obj = new JSONObject(contents);
            JSONArray arr = obj.getJSONArray("programmes");
            for (int i = 0; i < arr.length(); ++i) {
                Programme temps = Utils.fromJson(arr.getJSONObject(i).toString(), Programme.class);
                temps.setCustom(true);
                if (!getall && (!showFavoris || !temps.isFavoris()) && (showFavoris || !temps.getCategorie().equals(categorie))) continue;
                listTemp.add(temps);
            }
            for (Programme p : listTemp) {
                if (p.listPage.contains(null) || p.listPage.isEmpty()) continue;
                boolean isOK = true;
                for (Pageprogramme pp : p.listPage) {
                    isOK &= Main.getConfig().isTypeProgAutorise(pp.getType());
                }
                if (!isOK) continue;
                res.add(p);
            }
        }
        catch (Exception e) {
            Utils.debugInfo("erreur progCustom : %s", e);
        }
        return res;
    }

    public static ArrayList<Programme> getStaticProgrammes(String categorie, boolean showFavoris) {
        ArrayList<Programme> listProg = new ArrayList<Programme>();
        for (Programme temps : Programme.excelProgList()) {
            if ((!showFavoris || !temps.isFavoris()) && (showFavoris || !temps.getCategorie().equals(categorie))) continue;
            listProg.add(temps);
        }
        return listProg;
    }

    public static ArrayList<Programme> getAllProgrammes() {
        ArrayList<Programme> listProg = Programme.getCustomProgrammes("", false, true);
        listProg.addAll(Programme.excelProgList());
        return listProg;
    }

    public static ArrayList<Programme> getProgrammesCombinables(boolean withStim) {
        ArrayList<Programme> progsOk = new ArrayList<Programme>();
        for (Programme prog : Programme.getAllProgrammes()) {
            int type = prog.getFirstPage().getType();
            if (prog.getId() != 44 && (prog.getListPage().size() != 1 || (type != 1 || !withStim) && type != 4 && type != 5 && type != 12 && type != 6 && type != 7 || type != 1 && prog.getId() <= 107 && (!prog.getCategorie().equals("Uro_Biofeedback") || prog.getId() < 32 || prog.getFirstPage().getProfil().typeProfil() != 2))) continue;
            progsOk.add(prog);
        }
        return progsOk;
    }

    public static ArrayList<Programme> getProgrammesConcat() {
        ArrayList<Programme> progsOk = new ArrayList<Programme>();
        for (Programme prog : Programme.getAllProgrammes()) {
            Pageprogramme page = prog.getFirstPage();
            int type = page.getType();
            if (prog.getListPage().size() != 1 || !(type == 4 || type == 5 && page.progs.size() == 1 || type == 12 && page.motifs.size() == 1 || type == 6) && type != 7 || prog.getId() <= 107 && (!prog.getCategorie().equals("Uro_Biofeedback") || prog.getId() < 35) || prog.getFirstPage().getProfil().typeProfil() != 2) continue;
            progsOk.add(prog);
        }
        return progsOk;
    }

    public void copyParams(Programme progACopier) {
        this.voieBFB1 = progACopier.voieBFB1;
        this.voieBFB2 = progACopier.voieBFB2;
        this.duree = progACopier.duree;
        this.choixBFB = progACopier.choixBFB;
        this.defilement = progACopier.defilement;
        this.ghost = progACopier.ghost;
        this.aidePlacementSondePression = progACopier.aidePlacementSondePression;
        int deltaPages = progACopier.listPage.size() - this.listPage.size();
        if (this.listPage.get(0).getType() != 8) {
            for (int i = 0; i < this.listPage.size(); ++i) {
                this.listPage.get(i).copyParams(progACopier.listPage.get(deltaPages + i));
            }
        } else if (progACopier.page0 != null) {
            this.listPage.clear();
            this.listPage.add(progACopier.page0);
        }
    }

    public int getType() {
        int res = 0;
        block10: for (Pageprogramme pageProg : this.getListPage()) {
            switch (pageProg.getType()) {
                case 1: {
                    res |= 1;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    res |= 2;
                    break;
                }
                case 7: {
                    res |= 2;
                    if (!pageProg.isBfbAssiste()) break;
                    res |= 1;
                    break;
                }
                case 12: {
                    res |= 2;
                    for (ProfilConcatSimple.Motif motif : pageProg.motifs) {
                        if (motif.nbPic != -1) continue;
                        res |= 1;
                    }
                    continue block10;
                }
                case 8: {
                    Iterator<Object> iterator = pageProg.progs.iterator();
                    while (iterator.hasNext()) {
                        int pr = (Integer)iterator.next();
                        Programme p = Programme.getProgById(pr);
                        if (p == null) continue;
                        res |= p.getType();
                    }
                    continue block10;
                }
                case -2: 
                case -1: {
                    return 4;
                }
                case 11: {
                    return 8;
                }
                case 13: {
                    return 16;
                }
            }
        }
        return res;
    }

    public int getVoieStim2() {
        for (Pageprogramme pageProg : this.getListPage()) {
            if (pageProg.getType() != 1 || pageProg.getNbVoie() != 2) continue;
            return 1;
        }
        return -1;
    }

    public int getStimFreq() {
        for (Pageprogramme pageProg : this.getListPage()) {
            if (pageProg.getType() != 1 && (pageProg.getType() != 7 || !pageProg.isBfbAssiste())) continue;
            return pageProg.getFreq();
        }
        return 0;
    }

    public int getStimLarg() {
        for (Pageprogramme pageProg : this.getListPage()) {
            if (pageProg.getType() != 1 && (pageProg.getType() != 7 || !pageProg.isBfbAssiste())) continue;
            return pageProg.getLargeur();
        }
        return 0;
    }

    private int getNbVoiesStim() {
        int res = 0;
        for (Pageprogramme pageProg : this.getListPage()) {
            if (pageProg.getType() != 1) continue;
            res = Math.max(res, pageProg.getNbVoie());
        }
        return res;
    }

    public int getPourcentTravail() {
        for (int i = this.getListPage().size() - 1; i >= 0; --i) {
            Pageprogramme pageProg = this.getListPage().get(i);
            switch (pageProg.getType()) {
                case 1: {
                    double travail = pageProg.getTtravail();
                    return (int)(100.0 * travail / (travail + pageProg.getTrepos()));
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: {
                    Profil p = pageProg.getProfil();
                    double dureeTravail = 0.0;
                    for (i = 1; i < p.val.size(); ++i) {
                        if (!(p.val.get(i - 1) > 0.001) && !(p.val.get(i) > 0.001)) continue;
                        dureeTravail += p.temps.get(i) - p.temps.get(i - 1);
                    }
                    return (int)(100.0 * dureeTravail / p.temps.get(p.temps.size() - 1));
                }
                case 10: {
                    return -2;
                }
                case 11: {
                    return -3;
                }
                case 13: {
                    return -4;
                }
            }
        }
        Thread.dumpStack();
        return -1;
    }

    public boolean containBFB() {
        for (Pageprogramme pageProg : this.getListPage()) {
            if (pageProg.getType() < 4 || pageProg.getType() == 13) continue;
            return true;
        }
        return false;
    }

    public boolean containStim() {
        for (Pageprogramme pageProg : this.getListPage()) {
            if (!pageProg.containStim()) continue;
            return true;
        }
        return false;
    }

    private boolean containSimpleStim() {
        for (Pageprogramme pageProg : this.getListPage()) {
            if (pageProg.getType() != 1 || pageProg.getNbVoie() != 1) continue;
            return true;
        }
        return false;
    }

    private boolean isConcatSimple() {
        return this.getFirstPage().getType() == 12;
    }

    public boolean isFavoris() {
        if (listFav == null) {
            listFav = new ArrayList();
            try {
                String contents = new String(Files.readAllBytes(Paths.get(Main.getConfig().getProgFav(), new String[0])));
                JSONArray arr = new JSONObject(contents).getJSONArray("programmes");
                for (int i = 0; i < arr.length(); ++i) {
                    listFav.add(arr.getInt(i));
                }
            }
            catch (Exception e) {
                Utils.debugInfo("le fichier progfav n'existe pas");
            }
        }
        return listFav.contains(this.id);
    }

    public void toggleFavoris() {
        try {
            int pos = listFav.indexOf(this.id);
            if (pos == -1) {
                listFav.add(this.id);
            } else {
                listFav.remove(pos);
            }
            JSONObject obj = new JSONObject();
            obj.put("programmes", (Object)new JSONArray(listFav));
            FileWriter file = new FileWriter(Main.getConfig().getProgFav());
            file.write(obj.toString(2));
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addProgrammePerso() {
        this.id = 1000;
        try {
            JSONArray arr;
            File f = new File(Main.getConfig().getProgCustom());
            JSONObject res = new JSONObject();
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            if (!f.exists()) {
                arr = new JSONArray();
            } else {
                String contents = new String(Files.readAllBytes(f.toPath()));
                JSONObject obj = new JSONObject(contents);
                arr = obj.getJSONArray("programmes");
            }
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject programme = arr.getJSONObject(i);
                items.add(programme);
                if (programme.getInt("id") < this.id) continue;
                this.id = programme.getInt("id") + 1;
            }
            items.add(this.toJSON());
            res.put("programmes", (Object)new JSONArray(items));
            FileWriter file = new FileWriter(f);
            file.write(res.toString(2));
            file.close();
            this.savePng();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    JSONObject toJSON() {
        return new JSONObject(Utils.toJson(this));
    }

    public Programme copy() {
        return Utils.fromJson(Utils.toJson(this), Programme.class);
    }

    public void updateProgrammePerso() {
        try {
            String contents = new String(Files.readAllBytes(Paths.get(Main.getConfig().getProgCustom(), new String[0])));
            JSONObject obj = new JSONObject(contents);
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            JSONArray arr = obj.getJSONArray("programmes");
            obj.remove("programmes");
            for (int i = 0; i < arr.length(); ++i) {
                if (arr.getJSONObject(i).getInt("id") == this.getId()) {
                    items.add(this.toJSON());
                    continue;
                }
                items.add(arr.getJSONObject(i));
            }
            obj.put("programmes", (Object)new JSONArray(items));
            FileWriter file = new FileWriter(Main.getConfig().getProgCustom());
            file.write(obj.toString(2));
            file.close();
            this.savePng();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteProgrammePerso() {
        try {
            String contents = new String(Files.readAllBytes(Paths.get(Main.getConfig().getProgCustom(), new String[0])));
            JSONObject obj = new JSONObject(contents);
            ArrayList<JSONObject> items = new ArrayList<JSONObject>();
            JSONArray arr = obj.getJSONArray("programmes");
            obj.remove("programmes");
            for (int i = 0; i < arr.length(); ++i) {
                if (arr.getJSONObject(i).getInt("id") == this.getId()) continue;
                items.add(arr.getJSONObject(i));
            }
            obj.put("programmes", (Object)new JSONArray(items));
            FileWriter file = new FileWriter(Main.getConfig().getProgCustom());
            file.write(obj.toString(2));
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void supprimeTarrage() {
        int nb = 0;
        for (Pageprogramme pp : this.listPage) {
            if (pp.getType() != 2 && !pp.isTarage) continue;
            ++nb;
        }
        if (nb > 0) {
            this.listPage.subList(0, nb).clear();
        }
        for (Pageprogramme pp : this.listPage) {
            int next = pp.getNext();
            if (next == 0) continue;
            pp.setNext(next - nb);
        }
    }

    public void ajouteTarage() {
        if (this.forceNoTarage()) {
            return;
        }
        boolean addedP = false;
        int nb = 0;
        if (this.containBFB()) {
            if (this.needTarage(this.voieBFB1)) {
                this.ajouteTarage(this.voieBFB1, nb);
                ++nb;
                boolean bl = addedP = this.voieBFB1 == 2;
            }
            if (this.needTarage(this.voieBFB2) && this.tarage2 == null) {
                this.ajouteTarage(this.voieBFB2, nb);
                ++nb;
                addedP |= this.voieBFB2 == 2;
            }
        }
        if (!(this.getListPage().size() != 1 || this.voieBFB1 != 8 && this.voieBFB2 != 8 || this.getListPage().get(0).getType() != -2 && this.getListPage().get(0).getType() != -1 || !this.needTarage(8))) {
            this.ajouteTarage(8, nb);
            ++nb;
        }
        if (!addedP && Main.getConfig().stimBFB && this.containSimpleStim() && this.needTarage(2)) {
            this.ajouteTarage(2, nb);
            ++nb;
        }
        for (int i = nb; i < this.listPage.size(); ++i) {
            Pageprogramme p = this.listPage.get(i);
            int next = p.getNext();
            if (next == 0) continue;
            p.setNext(next + nb);
        }
    }

    private boolean needTarage(int voie) {
        if (voie == -1 || voie == 9 || voie == 10 || voie == 11) {
            return false;
        }
        if (Main.getConfig().typePageTarage == 2 || voie == 14) {
            return true;
        }
        if (voie == 8) {
            if (Main.getCurrentPatient() != null && Main.getCurrentPatient().id.equals(TransientConfig.patientBlueback) && System.currentTimeMillis() / 1000L < TransientConfig.dateTarageBlueback + 3600L) {
                return !SondeBT.bluebackCalibre;
            }
            return true;
        }
        if (Main.getConfig().typePageTarage == 0) {
            return false;
        }
        Patient p = Main.getCurrentPatient();
        if (p == null) {
            return true;
        }
        return TransientConfig.getTarageMax(voie) == 0;
    }

    private void ajouteTarage(int voie, int nb) {
        this.listPage.add(nb, new Pageprogramme(2, voie, Main.getConfig().dureeTarage, nb + 2));
    }

    public void ajouteReglagesStim(ProgEnCours progEnCours) {
        ArrayList<Pageprogramme> list = new ArrayList<Pageprogramme>();
        for (int i = this.getListPage().size() - 1; i >= 0; --i) {
            list.add(this.getListPage().get(i));
        }
        for (Pageprogramme pp : list) {
            if (pp.getType() == 1 || pp.getType() == 7 && pp.isBfbAssiste() && this.voieBFB1 == 0) {
                this.ajouteReglageStim(pp, pp.getFreq(), pp.getLargeur(), progEnCours);
                continue;
            }
            if (pp.getType() != 12) continue;
            for (ProfilConcatSimple.Motif motif : pp.motifs) {
                if (motif.nbPic != -1) continue;
                this.ajouteReglageStim(pp, motif.freq, motif.largeur, progEnCours);
            }
        }
    }

    private void ajouteReglageStim(Pageprogramme stim, int freq, int largeur, ProgEnCours progEnCours) {
        String freqlarg = freq + "/" + largeur;
        Double old = progEnCours.stimAmplitudeA.put(freqlarg, 0.0);
        if (old != null) {
            return;
        }
        Pageprogramme reglage = new Pageprogramme(1, stim.getNbVoie(), Main.getConfig().dureeReglageStim, 2);
        reglage.isTarage = true;
        reglage.setInfo("Reglage_de_la_stimulation");
        reglage.setTtravail(Main.getConfig().dureeReglageStim - 1);
        reglage.setTrepos(2.0);
        reglage.setTmontee(1.0);
        reglage.setTdescente(1.0);
        reglage.setTtravail2(Main.getConfig().dureeReglageStim - 1);
        reglage.setTrepos2(2.0);
        reglage.setTmontee2(1.0);
        reglage.setTdescente2(1.0);
        reglage.setFreq(freq);
        reglage.setLargeur(largeur);
        reglage.setBf(stim.getBf());
        reglage.setFreq2(stim.getFreq2());
        reglage.setLargeur2(stim.getLargeur2());
        reglage.setAttente2Impulsion(stim.getAttente2Impulsion());
        reglage.setLargeurL2(stim.getLargeurL2());
        reglage.setFreqF2(stim.getFreqF2());
        reglage.setDissymetrique(stim.getDissymetrique());
        reglage.setHauteTension(stim.getHauteTension());
        reglage.setImpulsionMono(stim.getImpulsionMono());
        reglage.setPolarite(stim.getPolarite());
        this.listPage.add(0, reglage);
        for (int i = 1; i < this.listPage.size(); ++i) {
            Pageprogramme p = this.listPage.get(i);
            int next = p.getNext();
            if (next == 0) continue;
            p.setNext(next + 1);
        }
    }

    public int countBFBPages() {
        int nb = 0;
        for (Pageprogramme pp : this.listPage) {
            if (pp.getType() < 4) continue;
            ++nb;
        }
        return nb;
    }

    public Profil getFirstProfil() {
        for (Pageprogramme pp : this.listPage) {
            if (pp.getType() < 4) continue;
            return pp.getProfil();
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setId(int id) {
        this.id = id;
        this.parentId = id;
    }

    public String getLienHtml() {
        return this.lienHtml;
    }

    private void setLienHtml(String lienHtml) {
        this.lienHtml = lienHtml;
    }

    public int getDuree() {
        return this.duree;
    }

    public void setDuree(int duree) {
        this.duree = duree;
        if (this.duree < 5) {
            this.duree = 5;
        }
        if (this.duree > Main.getConfig().maxDureeProgramme) {
            this.duree = Main.getConfig().maxDureeProgramme;
        }
    }

    public String getCategorie() {
        return this.categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public void setChoixAnim_BFB(int choix) {
        this.choixBFB = choix;
        this.choixForce = true;
    }

    public int getChoixAnim_BFB() {
        return this.choixBFB;
    }

    public void setDefilement(boolean defilement) {
        this.defilement = defilement;
    }

    public boolean isDefilement() {
        return this.defilement;
    }

    public String getPrefix() {
        if (this.isCustom()) {
            int i = this.nom.indexOf(":");
            if (i != -1) {
                return this.nom.substring(0, i + 1);
            }
        } else {
            switch (this.id) {
                case 101: {
                    return TransientConfig.translate("dynamique") + ":";
                }
                case 102: {
                    return TransientConfig.translate("dessine") + ":";
                }
                case 103: 
                case 107: {
                    return TransientConfig.translate("concat") + ":";
                }
                case 104: {
                    return TransientConfig.translate("combine") + ":";
                }
                case 105: {
                    return TransientConfig.translate("aleatoire") + ":";
                }
                case 106: {
                    return TransientConfig.translate("catch") + ":";
                }
            }
        }
        return TransientConfig.translate("prefixeCustomProg");
    }

    public String getNom() {
        String res;
        if (this.nom.contains("(")) {
            return this.nom;
        }
        ArrayList<Integer> freq = new ArrayList<Integer>();
        ArrayList<String> descLongues = new ArrayList<String>();
        ArrayList<Object> descCourtes = new ArrayList<Object>();
        ArrayList<Pageprogramme> sansTarrage = new ArrayList<Pageprogramme>();
        for (Pageprogramme pp : this.listPage) {
            if (pp.getType() == 2) continue;
            sansTarrage.add(pp);
        }
        if (this.id < 100 && sansTarrage.size() == 1 && ((Pageprogramme)sansTarrage.get(0)).getType() == 7 && ((Pageprogramme)sansTarrage.get((int)0)).dynTravail > 0) {
            return String.format("%s %d%%", this.nom, ((Pageprogramme)sansTarrage.get((int)0)).dynHaut);
        }
        for (Pageprogramme pp : sansTarrage) {
            if (pp.getType() != 1 || freq.contains(pp.getFreq())) continue;
            freq.add(pp.getFreq());
            if (pp.getFreqF2() != 0) {
                int min = Math.min(pp.getFreq(), pp.getFreqF2());
                int max = Math.max(pp.getFreq(), pp.getFreqF2());
                String s = String.format("%d ~ %d Hz", min, max);
                descCourtes.add(s);
                descLongues.add(s);
                continue;
            }
            if (pp.getBf() != 0) {
                String s = String.format("%d Hz, BF %d Hz", pp.getFreq(), pp.getBf());
                descCourtes.add(s);
                descLongues.add(s);
                continue;
            }
            descCourtes.add(pp.getFreq() + " Hz");
            descLongues.add(String.format("%d Hz %d \u00b5s", pp.getFreq(), pp.getLargeur()));
        }
        if (descLongues.isEmpty()) {
            return this.nom;
        }
        String string = res = this.nom.contains("\n") ? this.nom + " (" : this.nom + "\n(";
        if (descLongues.size() == 1) {
            return String.format("%s%s)", res, descLongues.get(0));
        }
        return String.format("%s%s)", res, String.join((CharSequence)" / ", descCourtes));
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public boolean isCustom() {
        return this.custom;
    }

    private void setCustom(boolean custom) {
        this.custom = custom;
    }

    public ArrayList<Pageprogramme> getListPage() {
        return this.listPage;
    }

    public Pageprogramme getFirstPage() {
        if (this.listPage.isEmpty()) {
            return null;
        }
        return this.listPage.get(0);
    }

    private void setListPage(ArrayList<Pageprogramme> listPage) {
        this.listPage = listPage;
    }

    public int getVoieBFB1() {
        return this.voieBFB1;
    }

    public void setVoieBFB1(int voieBFB1) {
        this.voieBFB1 = voieBFB1;
    }

    public int getVoieBFB2() {
        return this.voieBFB2;
    }

    public void setVoieBFB2(int voieBFB2) {
        this.voieBFB2 = voieBFB2;
    }

    public void savePng() {
        try {
            ArrayList<Pageprogramme> pages = new ArrayList<Pageprogramme>();
            for (Pageprogramme pp : this.listPage) {
                if (pp.getType() == 8) {
                    ArrayList<Programme> allProgs = Programme.getAllProgrammes();
                    for (int i = 0; i < pp.progs.size(); ++i) {
                        int pid = pp.progs.get(i);
                        for (Programme p : allProgs) {
                            if (pid != p.getId()) continue;
                            for (Pageprogramme ppp : p.getListPage()) {
                                if (ppp.getType() < 4) continue;
                                pages.add(ppp);
                            }
                        }
                    }
                    continue;
                }
                if (pp.getType() < 4 || pp.getType() == 9 || pp.getType() == 10 || pp.getType() == 11 || pp.getType() == 13 || this.id >= 101 && this.id <= 107) continue;
                pages.add(pp);
            }
            String name = "appData/profils/" + this.id + ".png";
            File file = Computer.newBiostimFile(name);
            switch (pages.size()) {
                case 0: {
                    file.delete();
                    break;
                }
                case 1: {
                    Utils.debugInfo("creation du profil " + name);
                    ((Pageprogramme)pages.get(0)).getProfil().savePNG(file);
                    break;
                }
                default: {
                    Utils.debugInfo("creation du multiprofil " + name);
                    ArrayList<Integer> repet = new ArrayList<Integer>();
                    for (Pageprogramme ignored : pages) {
                        repet.add(1);
                    }
                    new ProfilConcat(pages, repet, 0.0, true, false).savePNG(file);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean pngExist() {
        return new File(Computer.absolutePath + "appData/profils/" + this.id + ".png").exists();
    }

    public static void resetPng() {
        Computer.newBiostimFile("appData/profils/").mkdirs();
        for (Programme prog : Programme.getAllProgrammes()) {
            prog.savePng();
        }
    }

    public static ListCell<Programme> cellFactory() {
        return new ListCell<Programme>(){

            public void updateItem(Programme item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    this.setText(item.getNom());
                    File file = new File(Computer.absolutePath + "appData/profils/" + item.getId() + ".png");
                    if (file.exists()) {
                        Image image = new Image(file.toURI().toASCIIString());
                        this.setGraphic((Node)new HBox(new Node[]{new ImageView(image), new Label("  ")}));
                    } else {
                        Label lab = new Label("  STIM  ");
                        lab.setMinWidth(100.0);
                        lab.setMaxWidth(100.0);
                        this.setGraphic((Node)new HBox(new Node[]{lab, new Label("  ")}));
                    }
                }
            }
        };
    }

    public static ListCell<Programme> simpleCellFactory() {
        return new ListCell<Programme>(){

            public void updateItem(Programme item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null && !empty) {
                    this.setText(item.getNom());
                }
            }
        };
    }
}

