/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.zdata.Programme;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import sun.net.ftp.FtpClient;

public abstract class BioPodBrut {
    static String filename = "";
    static FileWriter fos = null;

    public static void init(Programme prog) {
        try {
            BioPodBrut.close();
            filename = "biopod_" + Main.getConfig().numero_serie + "_" + Utils.fileDateFormat.format(new Date()) + ".txt";
            fos = new FileWriter(Main.getConfig().getSauvegarde_auto() + "/" + filename);
            fos.write(String.format("Biostim %s / Prog %d : %s%n", Main.getConfig().numero_serie, prog.getId(), prog.getNom()));
            SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.startBioPodRaw);
            Utils.debugLine("ouverture fichier %s", filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.stopBioPodRaw);
        if (!filename.isEmpty() && fos != null) {
            try {
                fos.close();
                String name = filename;
                new Thread(() -> BioPodBrut.ftpUpload(name)).start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        filename = "";
        fos = null;
    }

    public static void addData(String data) {
        try {
            if (fos != null) {
                fos.write(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ftpUpload(String filename) {
        try (FtpClient ftp = FtpClient.create("ftp.cluster005.hosting.ovh.net");){
            ftp.login("mazetsanzn-etienne", "Etienne2021".toCharArray());
            ftp.setBinaryType();
            try (InputStream is = Files.newInputStream(Paths.get(Main.getConfig().getSauvegarde_auto() + "/" + filename, new String[0]), new OpenOption[0]);){
                ftp.putFile("/test_biopod/" + filename, is);
                Utils.debugInfo("fichier %s envoy\u00e9", filename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.debugLine("ftp KO", new Object[0]);
        }
    }
}

