/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.BioPodBrut;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.configuration.BalanceConfig;
import com.mazet.biostim.view.configuration.BiopodTest;
import com.mazet.biostim.view.main.listViewController;
import com.mazet.biostim.view.programme.ProgListController;
import com.mazet.biostim.view.programme.TarageController;
import com.mazet.biostim.view.programme.bfb.AnimationAPA;
import com.mazet.biostim.view.programme.bfb.AnimationBalance;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javafx.application.Platform;

public abstract class SondeBT {
    public static int sondeBT = 0;
    public static int batterySonde = -1;
    public static int levelSonde1 = 0;
    public static int levelSonde2 = 0;
    public static int batteryBioPod = -1;
    public static double biopodA;
    public static double biopodB;
    public static RawDataBioPod rawBiopodA;
    public static RawDataBioPod rawBiopodB;
    public static int batteryBiomoov;
    public static double balanceX;
    public static double balanceY;
    public static double balanceV;
    public static double biomoovGonioX;
    public static double biomoovGonioY;
    public static double biomoovGonioZ;
    public static double biomoovGonio;
    public static int batteryBlueback;
    public static int levelBlueback;
    public static boolean bluebackCalibre;
    public static int innerupBatt;
    public static int connectionSonde;
    public static int connectionBiomoov;
    public static int connectionBioPod;
    public static int connectionBlueback;
    public static int connectionInnerUp;
    private static int dataReceivedSonde;
    private static int dataReceivedBiomoov;
    private static int dataReceivedBioPod;
    private static InputStream is;
    private static OutputStream os;
    private static String trameTemp;
    private static long lastReceptBiomoov;
    private static double refGonioX;
    private static double refGonioY;
    private static double refGonioZ;

    public static void start() {
        if (connectionSonde == 0) {
            if (SondeBT.isOsCompatible()) {
                Utils.debugInfo("D\u00e9marrage du service BLEconnect");
                connectionSonde = 1;
                SondeBT.setConnectionBiomoov(1);
                connectionBioPod = 1;
                connectionBlueback = 1;
                connectionInnerUp = 1;
                new Thread(SondeBT::read).start();
                new Thread(SondeBT::monitor).start();
                new Thread(SondeBT::lanceExe).start();
            } else {
                Utils.popupAlert(TransientConfig.translate("BT_impossible_OS"));
            }
        }
    }

    public static boolean isOsCompatible() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("windows 10") || os.contains("windows 11") || os.contains("mac os x");
    }

    public static void stop() {
        if (connectionSonde != 0) {
            Utils.debugInfo("Stop service BLEconnect");
            is = null;
            if (os != null) {
                try {
                    SondeBT.commandeBLEConnect(ActionBLEConnect.kill);
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                os = null;
            }
            SondeBT.osKill();
        }
        connectionSonde = 0;
        SondeBT.setConnectionBiomoov(0);
        connectionBioPod = 0;
        connectionBlueback = 0;
        connectionInnerUp = 0;
        batterySonde = -1;
        batteryBiomoov = -1;
        batteryBlueback = -1;
        batteryBioPod = -1;
        bluebackCalibre = false;
        sondeBT = 0;
        Main.menu.changeBTStatus();
        if (Main.currentController instanceof listViewController) {
            Platform.runLater(Main.menu::goToHome);
        }
        boolean isAPAOrBalance = false;
        if (Main.currentController instanceof BiofeedbackController) {
            BiofeedbackAnimation animation = ((BiofeedbackController)Main.currentController).biofeedbackAnimation;
            boolean bl = isAPAOrBalance = animation instanceof AnimationAPA || animation instanceof AnimationBalance;
        }
        if (Main.progEnCours != null && (Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB1()) || Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB2()) || isAPAOrBalance)) {
            Main.telecommandeStop();
        } else if (Main.currentController instanceof BalanceConfig) {
            Platform.runLater(() -> Main.menu.goToHome());
        }
    }

    private static void lanceExe() {
        try {
            Main.menu.changeBTStatus();
            SondeBT.osKill();
            String cmd = "";
            for (Map.Entry<Integer, String> ble : Main.getConfig().lastAddrBLE.entrySet()) {
                cmd = cmd + " " + ble.getValue();
            }
            Process p = Runtime.getRuntime().exec(SondeBT.osExe() + cmd);
            Utils.copyToOut(p.getErrorStream());
            is = p.getInputStream();
            os = p.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.popupAlert(TransientConfig.translate("noBleConnect", SondeBT.osExe()));
            SondeBT.stop();
        }
    }

    private static void osKill() {
        try {
            String cmd = Computer.isMac() ? "killall -9 MacBle" : "taskkill /F /IM BLEconnect.exe";
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String osExe() {
        if (Computer.isMac()) {
            return "./MacBle";
        }
        return Computer.absolutePath + "appData/BLEconnect.exe";
    }

    private static void monitor() {
        int countdownActivite = 600;
        while (connectionSonde != 0) {
            try {
                if (Main.progEnCours != null && (Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB1()) || Biostim.isVoieBT(Main.progEnCours.currentProgram.getVoieBFB2()) || connectionBiomoov != 0) || Main.currentController instanceof BiopodTest) {
                    countdownActivite = 600;
                } else if (--countdownActivite < 0) {
                    Utils.debugInfo("deconnexion de la sonde BT pour inactivit\u00e9 prolong\u00e9e");
                    SondeBT.stop();
                }
                SondeBT.checkDevice(connectionSonde, --dataReceivedSonde, "Sonde BT");
                SondeBT.checkDevice(connectionBiomoov, --dataReceivedBiomoov, "Biomoov");
                SondeBT.checkDevice(connectionBioPod, --dataReceivedBioPod, "BioPod");
                Utils.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkDevice(int connection, int dataReceived, String name) {
        if (connection >= 2 && dataReceived < 0) {
            if (connection == 2) {
                Utils.popupAlert(TransientConfig.translate("BT_sonde_appairee"));
            }
            Utils.debugInfo("deconnexion %s (aucune donn\u00e9e re\u00e7ue)", name);
            SondeBT.stop();
        }
    }

    private static void read() {
        trameTemp = "";
        while (connectionSonde != 0) {
            try {
                if (is != null) {
                    byte[] bread = new byte[256];
                    int nb = is.read(bread);
                    if (nb == -1) {
                        SondeBT.stop();
                        return;
                    }
                    char[] cread = new char[nb];
                    for (int i = 0; i < nb; ++i) {
                        cread[i] = bread[i] >= 0 ? (char)bread[i] : (char)(bread[i] + 256);
                    }
                    trameTemp = trameTemp + new String(cread);
                    SondeBT.decodeBuffer();
                    continue;
                }
                Utils.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
                Utils.debugInfo("perte de COM avec BLEconnect : " + e);
                SondeBT.stop();
            }
        }
    }

    private static void decodeBuffer() {
        boolean continu = true;
        while (continu) {
            continu = false;
            int posDeb = trameTemp.indexOf(60);
            if (posDeb >= 0) {
                int posFin = (trameTemp = trameTemp.substring(posDeb)).indexOf(62);
                if (posFin < 0) continue;
                String trame = trameTemp.substring(1, posFin);
                boolean crcOK = true;
                if (trame.charAt(0) != '@') {
                    int crc = Integer.parseInt(trameTemp.substring(posFin - 4, posFin), 16);
                    boolean bl = crcOK = crc == SondeBT.calculate_crc(trameTemp.substring(1, posFin - 4));
                }
                if (crcOK) {
                    SondeBT.decodeTrame(trame);
                } else {
                    Utils.debugInfo("CRC incorrect, trame ignor\u00e9e : %s", trame);
                }
                trameTemp = trameTemp.substring(posFin + 1);
                continu = true;
                continue;
            }
            trameTemp = "";
        }
    }

    private static int calculate_crc(String trame) {
        byte[] buffer = trame.getBytes();
        int crc = 65535;
        for (byte b : buffer) {
            crc = (crc >>> 8 | crc << 8) & 0xFFFF;
            crc ^= b & 0xFF;
            crc ^= (crc & 0xFF) >> 4;
            crc ^= crc << 12 & 0xFFFF;
            crc ^= (crc & 0xFF) << 5 & 0xFFFF;
        }
        return crc &= 0xFFFF;
    }

    private static void decodeTrame(String trame) {
        try {
            if (trame.charAt(0) == '@') {
                if (!trame.contains("Device trouve") || connectionSonde < 2 && connectionBiomoov < 2 && connectionBioPod < 2 && batteryBlueback == -1 && connectionInnerUp < 2) {
                    System.out.format("    BLEconnect : %s%n", trame.substring(1));
                }
                return;
            }
            String[] decoupe = trame.split(";");
            block14 : switch (decoupe[0]) {
                case "C": {
                    int type = Integer.parseInt(decoupe[1]);
                    switch (type) {
                        case 1: 
                        case 2: {
                            sondeBT = type;
                            SondeBT.dataReceivedSonde();
                            break;
                        }
                        case 3: {
                            SondeBT.dataReceivedBiomoov();
                            break;
                        }
                        case 4: {
                            if (connectionBlueback == 1) {
                                connectionBlueback = 2;
                                if (Main.currentController instanceof listViewController) {
                                    Platform.runLater(Main.menu::goToHome);
                                }
                            }
                            batteryBlueback = Integer.parseInt(decoupe[3]);
                            Utils.debugInfo("Connexion Blueback OK. Bat = %d", batteryBlueback);
                            bluebackCalibre = false;
                            Main.menu.changeBTStatus();
                            if (Integer.parseInt(decoupe[4]) == 0) break;
                            SondeBT.bluebackEnCharge();
                            break;
                        }
                        case 5: {
                            SondeBT.dataReceivedBioPod();
                            break;
                        }
                        case 6: {
                            if (connectionInnerUp == 1) {
                                connectionInnerUp = 2;
                            }
                            innerupBatt = 50;
                            Utils.debugInfo("Connexion Inner Up OK");
                            Main.menu.changeBTStatus();
                        }
                    }
                    Main.getConfig().setLastAddrBLE(type, decoupe[2]);
                    break;
                }
                case "S": {
                    SondeBT.setBatterySonde(decoupe[1]);
                    levelSonde1 = Integer.parseInt(decoupe[2]);
                    if (levelSonde1 > 30000) {
                        levelSonde1 = 0;
                    }
                    levelSonde2 = Integer.parseInt(decoupe[3]);
                    if (connectionSonde == 2) {
                        Utils.debugInfo("Connexion sonde OK. Bat = %d", batterySonde);
                    }
                    SondeBT.dataReceivedSonde();
                    break;
                }
                case "B": {
                    SondeBT.decodeTrameBiomoov(decoupe);
                    break;
                }
                case "P0": {
                    SondeBT.setBatteryBioPod(decoupe[1]);
                    break;
                }
                case "P1": {
                    SondeBT.decodeTrameBioPod(decoupe);
                    break;
                }
                case "P2": {
                    biopodB = (double)Integer.parseInt(decoupe[1]) / 10.0 / 10.0;
                    break;
                }
                case "R1": {
                    BioPodBrut.addData(decoupe[1]);
                    SondeBT.rawBiopodA.decodeRawBioPod(decoupe);
                    break;
                }
                case "R2": {
                    SondeBT.rawBiopodB.decodeRawBioPod(decoupe);
                    break;
                }
                case "K": {
                    SondeBT.decodeTrameBlueback(trame, decoupe);
                    break;
                }
                case "V": {
                    SondeBT.bluebackEnCharge();
                    break;
                }
                case "Z": {
                    Utils.debugInfo("trame erreur BLEConnect : " + trame);
                    switch (decoupe[1]) {
                        default: {
                            Utils.popupAlert(TransientConfig.translate("BT_impossible_HW"));
                            break block14;
                        }
                        case "2": {
                            Utils.popupAlert(TransientConfig.translate("activer_BT"));
                            break block14;
                        }
                        case "1": {
                            Utils.popupAlert(TransientConfig.translate("BT_impossible_OS"));
                            break block14;
                        }
                        case "4": 
                    }
                    Utils.popupAlert(TransientConfig.translate("BT_Mac_interdit"));
                    break;
                }
                default: {
                    Utils.debugInfo("trame BLEconnect inconnue : " + trame);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void bluebackEnCharge() {
        Utils.popupAlert(TransientConfig.translate("blueback_en_charge"));
        SondeBT.stop();
    }

    public static void commandeBLEConnect(ActionBLEConnect actionBLEConnect) {
        try {
            if (actionBLEConnect == ActionBLEConnect.startBioPodRaw) {
                rawBiopodA = new RawDataBioPod();
            }
            if (actionBLEConnect == ActionBLEConnect.startBioPodRaw2) {
                rawBiopodB = new RawDataBioPod();
            }
            os.write(actionBLEConnect.ordinal() + 97);
            os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void decodeTrameBlueback(String trame, String[] decoupe) {
        switch (decoupe[1]) {
            case "MC": {
                levelBlueback = Integer.parseInt(decoupe[2]);
                if (Integer.parseInt(decoupe[3]) == 0) break;
                SondeBT.bluebackDecollee();
                break;
            }
            case "EC": {
                int pb = Integer.parseInt(decoupe[2]);
                Utils.debugInfo("trame re\u00e7ue : %s", trame);
                if ((pb & 1) != 0) {
                    SondeBT.bluebackDecollee();
                    break;
                }
                if (Main.currentController instanceof TarageController) {
                    ((TarageController)Main.currentController).retourCalibBlueback(pb);
                    break;
                }
                Utils.debugInfo("retour calib recu hors page de tarage => non trait\u00e9");
                break;
            }
            default: {
                Utils.debugInfo("trame re\u00e7ue : %s", trame);
            }
        }
    }

    private static void bluebackDecollee() {
        Main.telecommandeStop();
        Utils.popupAlert(TransientConfig.translate("blueback_decollee"));
        SondeBT.stop();
    }

    private static void setBatterySonde(String strBatt) {
        int new_batt = Integer.parseInt(strBatt);
        if (new_batt != batterySonde) {
            batterySonde = new_batt;
            Platform.runLater(() -> Main.menu.updateBattSonde());
        }
    }

    private static void setBatteryBiomoov(String strBatt) {
        int new_batt = Integer.parseInt(strBatt);
        if (new_batt != batteryBiomoov) {
            batteryBiomoov = new_batt;
            Platform.runLater(() -> Main.menu.updateBattBiomoov());
        }
    }

    private static void setBatteryBioPod(String strBatt) {
        int new_batt = Integer.parseInt(strBatt);
        if (new_batt != batteryBioPod) {
            batteryBioPod = new_batt;
            Platform.runLater(() -> Main.menu.updateBattBioPod());
        }
    }

    private static void dataReceivedSonde() {
        dataReceivedSonde = Main.getConfig().timeOutBT;
        if (connectionSonde == 1 || connectionSonde == 2) {
            ++connectionSonde;
            Main.menu.changeBTStatus();
        }
    }

    private static void setConnectionBiomoov(int connectionBiomoov) {
        if (SondeBT.connectionBiomoov != connectionBiomoov) {
            if (connectionBiomoov == 3 != (SondeBT.connectionBiomoov == 3) && (Main.currentController instanceof listViewController || Main.currentController instanceof ProgListController && Main.getCategorie().equals("Balance"))) {
                Platform.runLater(() -> Main.menu.goToHome());
            }
            SondeBT.connectionBiomoov = connectionBiomoov;
        }
    }

    private static void decodeTrameBiomoov(String[] decoupe) {
        SondeBT.setBatteryBiomoov(decoupe[1]);
        if (connectionBiomoov == 2) {
            Utils.debugInfo("Connexion biomoov OK. Bat = %d", batteryBiomoov);
        }
        SondeBT.dataReceivedBiomoov();
        ArrayList<Integer> matrix = new ArrayList<Integer>();
        for (int i = 2; i < 11; ++i) {
            matrix.add(Integer.parseInt(decoupe[i]));
        }
        int balx = (Integer)matrix.get(6) * 1000 / 16384;
        int baly = (Integer)matrix.get(7) * 1000 / 16384;
        biomoovGonioX = (double)((Integer)matrix.get(0)).intValue() / 16384.0;
        biomoovGonioY = (double)((Integer)matrix.get(3)).intValue() / 16384.0;
        biomoovGonioZ = (double)((Integer)matrix.get(6)).intValue() / 16384.0;
        long now = System.currentTimeMillis();
        if (lastReceptBiomoov != 0L && now - lastReceptBiomoov > 10L) {
            double dx = (double)balx - balanceX;
            double dy = (double)baly - balanceY;
            balanceV = 10.0 * Math.sqrt(dx * dx + dy * dy) / (double)(now - lastReceptBiomoov);
            balanceX = balx;
            balanceY = baly;
        }
        lastReceptBiomoov = now;
        double scalaire = biomoovGonioX * refGonioX + biomoovGonioY * refGonioY + biomoovGonioZ * refGonioZ;
        double biomoov2 = biomoovGonioX * biomoovGonioX + biomoovGonioY * biomoovGonioY + biomoovGonioZ * biomoovGonioZ;
        double ref2 = refGonioX * refGonioX + refGonioY * refGonioY + refGonioZ * refGonioZ;
        biomoovGonio = Math.acos(scalaire /= Math.sqrt(biomoov2 * ref2)) * 180.0 / Math.PI;
    }

    public static void setRefGonio() {
        refGonioX = biomoovGonioX;
        refGonioY = biomoovGonioY;
        refGonioZ = biomoovGonioZ;
    }

    private static void dataReceivedBiomoov() {
        dataReceivedBiomoov = Main.getConfig().timeOutBT;
        if (connectionBiomoov < 3) {
            SondeBT.setConnectionBiomoov(connectionBiomoov + 1);
            Main.menu.changeBTStatus();
        }
    }

    private static void dataReceivedBioPod() {
        dataReceivedBioPod = Main.getConfig().timeOutBT;
        if (connectionBioPod < 3) {
            ++connectionBioPod;
            Main.menu.changeBTStatus();
        }
    }

    private static void decodeTrameBioPod(String[] decoupe) {
        if (connectionBioPod == 2) {
            Utils.debugInfo("Connexion biopod OK");
        }
        SondeBT.dataReceivedBioPod();
        biopodA = (double)Integer.parseInt(decoupe[1]) / 10.0 / 10.0;
    }

    static {
        rawBiopodA = new RawDataBioPod();
        rawBiopodB = new RawDataBioPod();
        batteryBiomoov = -1;
        balanceV = 0.0;
        biomoovGonio = 0.0;
        batteryBlueback = -1;
        levelBlueback = 0;
        bluebackCalibre = false;
        innerupBatt = -1;
        connectionSonde = 0;
        connectionBiomoov = 0;
        connectionBioPod = 0;
        connectionBlueback = 0;
        connectionInnerUp = 0;
        is = null;
        os = null;
        trameTemp = "";
        lastReceptBiomoov = 0L;
        refGonioX = 0.0;
        refGonioY = 0.0;
        refGonioZ = 1.0;
    }

    public static class RawDataBioPod {
        public static boolean octetTournant = true;
        private int stopTampon = 0;
        private int sizeTampon = 0;
        private final double[] tampon = new double[16384];
        private long lastCompteurRaw = 0L;
        private static final long tailleWindowsMesurePerte = 250L;
        int nbTotalOK = 0;
        long firstCompteur;
        int nbOK = 0;
        int nbCoupure = 1;
        int nbTrame;
        long currentWindow = 0L;

        private synchronized void decodeRawBioPod(String[] decoupe) {
            try {
                if (octetTournant) {
                    long compteur = RawDataBioPod.intAtPos(decoupe[1], decoupe[1].length() - 8);
                    if (this.nbTotalOK == 0) {
                        this.firstCompteur = compteur;
                        this.lastCompteurRaw = compteur - 1L;
                    }
                    ++this.nbTotalOK;
                    long window = compteur / 250L;
                    if (window != this.currentWindow) {
                        Main.currentController.updateAffPertes((float)(250L - (long)this.nbOK) / 250.0f, this.nbTotalOK / this.nbCoupure);
                        this.currentWindow = window;
                        this.nbOK = 0;
                    }
                    ++this.nbTrame;
                    if (compteur != this.lastCompteurRaw + 1L) {
                        ++this.nbCoupure;
                        Utils.debugLine("%d trames ok, %d trame(s) perdue(s) (%d + 1 != %d) %d octets", this.nbTrame, compteur - this.lastCompteurRaw - 1L, this.lastCompteurRaw, compteur, decoupe[1].length() / 2);
                        this.stopTampon = 0;
                        this.sizeTampon = 0;
                        this.nbTrame = 0;
                    } else {
                        ++this.nbOK;
                    }
                    this.lastCompteurRaw = compteur;
                }
                int fin = decoupe[1].length() - (octetTournant ? 8 : 0);
                for (int i = 0; i < fin; i += 8) {
                    float val = Float.intBitsToFloat(RawDataBioPod.intAtPos(decoupe[1], i));
                    if (BiopodTest.enregEnCours != null) {
                        BiopodTest.enregEnCours.write(String.format("%f\r\n", Float.valueOf(val)));
                    }
                    this.tampon[this.stopTampon % 16384] = val;
                    this.stopTampon = (this.stopTampon + 1) % 16384;
                    ++this.sizeTampon;
                }
                if (this.sizeTampon > 16384) {
                    this.sizeTampon = 16384;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static int intAtPos(String trame, int pos) {
            return (Integer.parseInt(trame.substring(pos + 0, pos + 2), 16) << 0) + (Integer.parseInt(trame.substring(pos + 2, pos + 4), 16) << 8) + (Integer.parseInt(trame.substring(pos + 4, pos + 6), 16) << 16) + (Integer.parseInt(trame.substring(pos + 6, pos + 8), 16) << 24);
        }

        public synchronized boolean getTamponRaw(double[] tab, int size) {
            if (this.sizeTampon < size) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                tab[i] = this.tampon[(this.stopTampon + 16384 - size + i) % 16384];
            }
            return true;
        }
    }

    public static enum ActionBLEConnect {
        debutCalibration,
        finCalibration,
        debutAcquisition,
        finAcquisition,
        forceCalibPatient,
        forceDecalibPatient,
        readCalibration,
        kill,
        startBBUsb,
        stopBBUsb,
        startInnerUpUsb,
        stopInnerUpUsb,
        startInnerUpAcquisition,
        startBioPodRaw,
        stopBioPodRaw,
        startBioPodRaw2,
        stopBioPodRaw2;

    }
}

