/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.view.Controller;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.shape.Circle;

public class BalanceConfig
extends Controller {
    @FXML
    AnchorPane cibleAnchor;
    @FXML
    RadioButton switch2axes;
    @FXML
    RadioButton switchAxeGD;
    @FXML
    RadioButton switchAxeAA;
    AnimationTimer timer;
    private double widthBalance;
    private double heightBalance;
    private static final double tailleCible = 0.1;
    private static final int nbNiveaux = 4;
    private Circle position;
    private double rayonMax;

    @Override
    public void setMain() {
        switch (Main.getConfig().typeBalance) {
            case 0: {
                this.switch2axes.setSelected(true);
                break;
            }
            case 1: {
                this.switchAxeGD.setSelected(true);
                break;
            }
            case 2: {
                this.switchAxeAA.setSelected(true);
            }
        }
        this.switch2axes.selectedProperty().addListener((a, b, c) -> this.updateTypeBalance());
        this.switchAxeGD.selectedProperty().addListener((a, b, c) -> this.updateTypeBalance());
        this.switchAxeAA.selectedProperty().addListener((a, b, c) -> this.updateTypeBalance());
        this.initBalance();
    }

    @Override
    public void exitAction() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private void initBalance() {
        this.widthBalance = this.cibleAnchor.getWidth();
        this.heightBalance = this.cibleAnchor.getHeight();
        if (this.widthBalance < 10.0 || this.heightBalance < 10.0) {
            Platform.runLater(this::initBalance);
        } else {
            try {
                this.rayonMax = Math.min(this.widthBalance, this.heightBalance) / 2.0 * 0.85;
                for (int i = 4; i > 0; --i) {
                    Circle c = new Circle();
                    c.setCenterX(this.widthBalance / 2.0);
                    c.setCenterY(this.heightBalance / 2.0);
                    c.setRadius(this.rayonMax * (double)i / 4.0);
                    c.getStyleClass().add((Object)"cibleBalance");
                    this.cibleAnchor.getChildren().add((Object)c);
                }
                this.position = new Circle();
                this.position.setRadius(0.1 * this.rayonMax);
                this.cibleAnchor.getChildren().add((Object)this.position);
                this.updateBalance();
                this.launchUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void launchUpdate() {
        this.timer = new AnimationTimer(){

            public void handle(long unused) {
                BalanceConfig.this.updateBalance();
            }
        };
        this.timer.start();
    }

    public void updateBalance() {
        this.position.setCenterX(this.widthBalance / 2.0 + (Biostim.getVoie(9) - 50.0) / 50.0 * this.rayonMax);
        this.position.setCenterY(this.heightBalance / 2.0 - (Biostim.getVoie(10) - 50.0) / 50.0 * this.rayonMax);
    }

    public void setRight() {
        double gd;
        Main.getConfig().inversionAxesBalance = Math.abs(SondeBT.balanceX) < Math.abs(SondeBT.balanceY);
        double d = gd = Main.getConfig().inversionAxesBalance ? SondeBT.balanceY : SondeBT.balanceX;
        gd = gd > 0.0 ? (gd += 1.0) : (gd -= 1.0);
        Main.getConfig().coefBalanceGD = (int)gd;
        Main.getConfig().saveConfig();
    }

    public void setFront() {
        double aa;
        Main.getConfig().inversionAxesBalance = Math.abs(SondeBT.balanceX) > Math.abs(SondeBT.balanceY);
        double d = aa = Main.getConfig().inversionAxesBalance ? SondeBT.balanceX : SondeBT.balanceY;
        aa = aa > 0.0 ? (aa += 1.0) : (aa -= 1.0);
        Main.getConfig().coefBalanceAA = (int)aa;
        Main.getConfig().saveConfig();
    }

    public void updateTypeBalance() {
        if (this.switch2axes.isSelected()) {
            Main.getConfig().typeBalance = 0;
        }
        if (this.switchAxeGD.isSelected()) {
            Main.getConfig().typeBalance = 1;
        }
        if (this.switchAxeAA.isSelected()) {
            Main.getConfig().typeBalance = 2;
        }
        Main.getConfig().saveConfig();
    }
}

