/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSkin;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.ProfilConcatSimple;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;

public class AnimationDefilement
extends BiofeedbackAnimationSkin {
    private ScrollPane scrollPane;
    private double dureeEcran = 20.0;
    private double nbPixelParSeconde;
    double positionCurseur;
    ArrayList<Region> parallax = new ArrayList();
    private double debutProfil = 0.0;
    private double debutCourbe;
    double finObjet = 0.05;
    private final ArrayList<String> motifsColors = new ArrayList();
    private int posCatch = 0;
    private int cycleCatch = 0;
    private final ArrayList<Node> nodesAEffacer = new ArrayList();
    private final ArrayList<Double> nodeValidite = new ArrayList();
    private final ArrayList<Integer> nodeType = new ArrayList();
    private final ArrayList<Double> nodeLevelObj = new ArrayList();
    private final ArrayList<Rectangle> nodesDisparition = new ArrayList();
    private final ArrayList<Double> nodesDateDisparition = new ArrayList();
    private final ArrayList<Double> nodesDisparitionInitY = new ArrayList();

    public AnimationDefilement(AnimationStyle animationStyle, BiofeedbackController controller) {
        this.animationStyle = animationStyle;
        controller.checkVoie2.setSelected(false);
        FxUtils.setVisibility((Node)controller.checkVoie2, false);
        controller.checkHistorique.setSelected(false);
        FxUtils.setVisibility((Node)controller.checkHistorique, false);
    }

    @Override
    public void initGame() {
        super.initGame();
        try {
            this.setPositionCurseur();
            this.scrollPane = new ScrollPane();
            this.scrollPane.setPrefViewportWidth(this.widthGame);
            this.scrollPane.setPrefWidth(this.widthGame);
            this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            this.createContent();
            this.controller.gameAnchor.getChildren().add((Object)this.scrollPane);
            this.scrollPane.setContent((Node)this.gameRoot);
            if (Main.getConfig().isActivated) {
                this.gameRoot.setOnMouseClicked(this::clicEcran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createContent() {
        try {
            this.dureeEcran = this.dureeEcran * 10.0 / (double)Main.getConfig().getVitesseDefilement();
            this.nbPixelParSeconde = this.widthGame / this.dureeEcran;
            double totalWidthGame = this.controller.dureePage * this.nbPixelParSeconde + this.widthGame;
            this.gameRoot.setPrefSize(totalWidthGame, this.anchorHeight);
            this.initLines();
            this.setOrUpdateBackground(totalWidthGame);
            boolean inverseCurseur = this.controller.voiesSeparees && !Main.progEnCours.currentProgram.voie1EnHaut;
            this.curseur1 = this.animationStyle.getShapeCurseur(inverseCurseur ? 2 : 1, this);
            if (this.curseur1 != null) {
                this.gameRoot.getChildren().add((Object)this.curseur1);
            }
            if (this.controller.nbVoie == 2) {
                this.curseur2 = this.animationStyle.getShapeCurseur(inverseCurseur ? 1 : 2, this);
                if (this.curseur2 != null) {
                    this.gameRoot.getChildren().add((Object)this.curseur2);
                }
            }
            this.nouvellesCourbes();
            if (this.controller.voiesSeparees) {
                this.courbeSeparation = new Polyline();
                this.courbeSeparation.getStyleClass().add((Object)"courbeSeparation");
                this.courbeSeparation.getPoints().addAll((Object[])new Double[]{0.0, this.anchorHeight / 2.0, totalWidthGame, this.anchorHeight / 2.0});
                this.gameRoot.getChildren().add((Object)this.courbeSeparation);
            }
            this.scrollPane.setHmax(this.controller.dureePage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        this.scrollPane.setPrefViewportWidth(this.widthGame);
        this.scrollPane.setPrefWidth(this.widthGame);
        this.nbPixelParSeconde = this.widthGame / this.dureeEcran;
        double totalWidthGame = this.controller.dureePage * this.nbPixelParSeconde + this.widthGame;
        this.gameRoot.setPrefSize(totalWidthGame, this.anchorHeight);
        this.setOrUpdateBackground(totalWidthGame);
        if (this.courbeSeparation != null) {
            this.courbeSeparation.getPoints().setAll((Object[])new Double[]{0.0, this.anchorHeight / 2.0, totalWidthGame, this.anchorHeight / 2.0});
        }
        if (this.marqueurVoie1.getPoints().size() > 2) {
            this.marqueurVoie1.getPoints().set(2, (Object)totalWidthGame);
        }
        if (this.marqueurVoie2.getPoints().size() > 2) {
            this.marqueurVoie2.getPoints().set(2, (Object)totalWidthGame);
        }
        this.animationStyle.updateShapeCurseur(this.curseur1, 1, this);
        this.animationStyle.updateShapeCurseur(this.curseur2, 2, this);
        this.controller.needUpdateProfil = true;
    }

    private void setOrUpdateBackground(double totalWidthGame) {
        if (this.animationStyle.nbBackgrounds == 0 || Main.getConfig().noParallax) {
            this.animationStyle.setBackground(this.gameRoot, this.controller.voiesSeparees, (int)this.anchorHeight, this.positionCurseur * this.widthGame, this.nbPixelParSeconde * 5.0);
        } else if (this.parallax.isEmpty()) {
            for (int i = 0; i < this.animationStyle.nbBackgrounds; ++i) {
                Region bg = new Region();
                bg.setPrefSize(totalWidthGame, this.anchorHeight);
                bg.setBackground(this.animationStyle.getBackground(i));
                this.parallax.add(bg);
                this.gameRoot.getChildren().add(i, (Object)bg);
            }
        } else {
            for (Region bg : this.parallax) {
                bg.setPrefSize(totalWidthGame, this.anchorHeight);
            }
        }
    }

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        try {
            this.scrollPane.setHvalue(this.controller.dureeMilli);
            int nb = this.parallax.size();
            for (int i = 0; i < nb; ++i) {
                this.parallax.get(i).setTranslateX(this.nbPixelParSeconde * this.controller.dureeMilli * (double)(nb - i) / (double)(nb + 1) - 1.0);
            }
            this.effaceNodes();
            if (this.curseur1 != null) {
                this.gereCollision();
                this.gereAnimationDisparition();
            }
            this.manageNewObjets();
            double posX = this.pixOfTime(this.controller.dureeMilli);
            double posY1 = this.pixOfNiv1(this.controller.niveauVoie1Aff);
            double posY2 = this.pixOfNiv2(this.controller.niveauVoie2Aff);
            if (this.controller.started) {
                this.courbe1.getPoints().addAll((Object[])new Double[]{posX, posY1});
                if (this.controller.nbVoie == 2) {
                    this.courbe2.getPoints().addAll((Object[])new Double[]{posX, posY2});
                }
            }
            if (this.debutCourbe < this.controller.dureeMilli - this.dureeEcran * this.positionCurseur) {
                this.nouvellesCourbes();
                this.courbe1.getPoints().addAll((Object[])new Double[]{posX, posY1});
                if (this.controller.nbVoie == 2) {
                    this.courbe2.getPoints().addAll((Object[])new Double[]{posX, posY2});
                }
            }
            if (this.curseur2 != null) {
                this.curseur2.setTranslateX(posX - FxUtils.getCursorWidth(this.curseur2, 2, this) / 2.0);
                this.curseur2.setTranslateY(posY2 - FxUtils.getCursorHeight(this.curseur2, 2, this) / 2.0);
                this.curseur2.toFront();
            }
            if (this.curseur1 != null) {
                this.curseur1.setTranslateX(posX - FxUtils.getCursorWidth(this.curseur1, 1, this) / 2.0);
                this.curseur1.setTranslateY(posY1 - FxUtils.getCursorHeight(this.curseur1, 1, this) / 2.0);
                this.curseur1.toFront();
            }
            this.marqueurPresent.getPoints().setAll((Object[])new Double[]{posX, this.anchorHeight * 0.04, posX, this.anchorHeight * 0.96});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateProfil() {
        this.controller.biofeedbackAnimation.setMarqueurBFBAssiste();
        if (this.controller.profilChanged) {
            this.finObjet = this.controller.dureeMilli + 1.0;
        }
        int i = 0;
        while (i < this.nodesAEffacer.size()) {
            double valy;
            Rectangle r;
            Node n = this.nodesAEffacer.get(i);
            if (this.nodeType.get(i) == 1 || this.nodeType.get(i) == 5 || this.nodeType.get(i) == 0 && this.controller.profilChanged) {
                this.gameRoot.getChildren().remove((Object)n);
                this.nodesAEffacer.remove(i);
                this.nodeValidite.remove(i);
                this.nodeType.remove(i);
                this.nodeLevelObj.remove(i);
                continue;
            }
            double d = this.pixOfTime(this.nodeValidite.get(i));
            if (this.nodeType.get(i) == 0) {
                r = (Rectangle)n;
                valy = this.nodeLevelObj.get(i);
                if (valy == -1.0) {
                    valy = this.controller.profil.getVal(this.nodeValidite.get(i));
                }
                FxUtils.resizeObj(r, this.getSizeObj(), d);
                r.setY(this.pixOfObjet(valy, r.getHeight()));
            } else if (this.nodeType.get(i) == 6) {
                r = (Rectangle)n;
                valy = this.nodeLevelObj.get(i);
                if (valy == -1.0) {
                    valy = this.controller.profil.getVal(this.nodeValidite.get(i));
                }
                FxUtils.resizeObj(r, this.getSizeObj() * 2.0, d);
                r.setY(this.pixOfObjet(valy, r.getHeight()));
            } else if (this.nodeType.get(i) == 2) {
                Polyline p = (Polyline)n;
                p.getPoints().setAll((Object[])new Double[]{d, this.anchorHeight * 0.96, d, this.anchorHeight * 0.04});
            } else if (this.nodeType.get(i) == 3) {
                Label l = (Label)n;
                l.setLayoutX(d - l.getWidth() / 2.0);
                l.setLayoutY(this.anchorHeight - l.getHeight());
            } else if (this.nodeType.get(i) == 4) {
                r = (Rectangle)n;
                FxUtils.resizeObj(r, this.getSizeObj() * 2.0, d);
            }
            ++i;
        }
        for (Node node : this.nodesDisparition) {
            this.gameRoot.getChildren().remove((Object)node);
        }
        this.nodesDisparition.clear();
        this.nodesDateDisparition.clear();
        this.nodesDisparitionInitY.clear();
        double debutPage = this.controller.dureeMilli - this.dureeEcran * this.positionCurseur;
        this.debutProfil = debutPage - debutPage % this.controller.profil.getDuree();
        if (this.debutProfil < 0.0) {
            this.debutProfil = 0.0;
        }
        this.dessineProfil();
        this.courbe1.getPoints().clear();
        if (this.controller.nbVoie == 2) {
            this.courbe2.getPoints().clear();
        }
        ArrayList<Integer> temps = Main.progEnCours.historique.temps;
        ArrayList<Double> voie1 = Main.progEnCours.historique.niveauVoie1;
        ArrayList<Double> voie2 = Main.progEnCours.historique.niveauVoie2;
        double tempsDebut = (Main.progEnCours.revoir.startPageTime + Math.max(0.0, debutPage)) * 100.0;
        for (int j = 0; j < temps.size(); ++j) {
            if (!((double)temps.get(j).intValue() > tempsDebut)) continue;
            double posX = this.pixOfTime((double)temps.get(j).intValue() / 100.0 - Main.progEnCours.revoir.startPageTime);
            double posY1 = this.pixOfNiv1(this.niv1AffOfReel(voie1.get(j)));
            if (!this.controller.started) continue;
            this.courbe1.getPoints().addAll((Object[])new Double[]{posX, posY1});
            if (this.controller.nbVoie != 2) continue;
            double posY2 = this.pixOfNiv2(this.niv2AffOfReel(voie2.get(j)));
            this.courbe2.getPoints().addAll((Object[])new Double[]{posX, posY2});
        }
    }

    private void dessineProfil() {
        this.updateLevelZero();
        if (this.controller.profil.typeProfil() == 2) {
            double posY;
            double posX;
            ProfilConcatSimple.Motif motif = this.controller.profil.getStimMotif(0);
            Polyline profil = this.newProfilLine(motif);
            int nbPassage = (int)(2.0 + (this.dureeEcran / this.controller.profil.getDuree() + 0.5));
            double tDebut = this.debutProfil;
            for (int i = 0; i < nbPassage; ++i) {
                for (int indice = 0; indice < this.controller.profil.size() && tDebut + this.controller.profil.temps.get(indice) < this.controller.dureePage; ++indice) {
                    ProfilConcatSimple.Motif newMotif = this.controller.profil.getStimMotif(indice);
                    if (motif != newMotif) {
                        boolean stimPasStim;
                        boolean bl = stimPasStim = motif.nbPic == -1 != (newMotif.nbPic == -1);
                        if (!(stimPasStim || motif.nbPic != -1 || motif.freq == newMotif.freq && motif.largeur == newMotif.largeur)) {
                            stimPasStim = true;
                        }
                        if (stimPasStim) {
                            motif = newMotif;
                            profil = this.newProfilLine(motif);
                        }
                    }
                    posX = this.pixOfTime(this.controller.profil.temps.get(indice) + tDebut);
                    posY = this.pixOfProfil(this.controller.profil.val.get(indice) * 100.0);
                    profil.getPoints().addAll((Object[])new Double[]{posX, posY});
                }
                tDebut += this.controller.profil.getDuree();
            }
            if (tDebut >= this.controller.dureePage) {
                posX = this.pixOfTime(this.controller.dureePage);
                posY = this.pixOfProfil(this.controller.profil.getVal(this.controller.dureePage));
                profil.getPoints().addAll((Object[])new Double[]{posX, posY});
            }
        }
    }

    private String getMotifColor(ProfilConcatSimple.Motif motif) {
        String str = motif.freq + "/" + motif.largeur;
        int pos = this.motifsColors.indexOf(str);
        if (pos == -1) {
            pos = this.motifsColors.size();
            this.motifsColors.add(str);
        }
        switch (pos % 3) {
            case 0: {
                return "rubanRouge";
            }
            case 1: {
                return "rubanOrange";
            }
        }
        return "rubanViolet";
    }

    private Polyline newProfilLine(ProfilConcatSimple.Motif motif) {
        Polyline profil = new Polyline();
        double profilWidth = 0.92 * this.anchorHeight * (double)Main.progEnCours.epaisseurProfil / 100.0 * (100.0 - this.profToAff(0.0)) / 100.0;
        if (this.controller.voiesSeparees) {
            profilWidth = profilWidth * 5.0 / 11.0;
        }
        profil.setStrokeWidth(profilWidth);
        profil.getStyleClass().add((Object)(motif != null && motif.nbPic == -1 ? this.getMotifColor(motif) : this.animationStyle.getRubanStyle()));
        this.gameRoot.getChildren().add(this.parallax.size(), (Object)profil);
        this.addNode((Node)profil, this.debutProfil + this.controller.profil.getDuree(), 1);
        return profil;
    }

    private void manageNewObjets() {
        double max_objet = Math.min(this.controller.dureeMilli + this.dureeEcran * (1.0 - this.positionCurseur) + 0.5, this.controller.dureePage);
        if (Main.progEnCours.currentPageProgram.getType() == 10 && !Main.progEnCours.currentPageProgram.dessineT.isEmpty()) {
            while (true) {
                double d;
                double pos = (Main.progEnCours.currentPageProgram.dessineT.get(this.posCatch) + (double)this.cycleCatch) * (double)Main.progEnCours.currentPageProgram.dureeTravail;
                if (d < max_objet) {
                    Integer pinceau = Main.progEnCours.currentPageProgram.progs.get(this.posCatch);
                    ImagePattern[] imgs = pinceau == null ? (this.animationStyle.patternObjets != null ? this.animationStyle.patternObjets : new ImagePattern[]{AnimationStyle.simpleEtoile}) : new ImagePattern[]{Config.listImagesCatch.get(Config.decodePosObj(pinceau))};
                    this.afficheObjet(imgs, pos, Main.progEnCours.currentPageProgram.dessineY.get(this.posCatch) * 100.0, this.anchorHeight / 10.0, 6);
                    ++this.posCatch;
                    if (this.posCatch < Main.progEnCours.currentPageProgram.dessineT.size()) continue;
                    this.posCatch = 0;
                    ++this.cycleCatch;
                    continue;
                }
                break;
            }
        } else if (this.animationStyle.patternObjets != null && this.controller.profil.typeProfil() == 2) {
            while (this.finObjet < max_objet) {
                if (this.controller.profil.isStim(this.finObjet)) {
                    do {
                        this.finObjet += 0.1;
                    } while (this.finObjet < max_objet && this.controller.profil.isStim(this.finObjet));
                    continue;
                }
                double prof = this.controller.profil.getVal(this.finObjet);
                this.afficheObjet(this.animationStyle.patternObjets, this.finObjet, -1.0, this.getSizeObj(), 0);
                double initFin = this.finObjet;
                while (this.finObjet < initFin + 0.99 && prof == this.controller.profil.getVal(this.finObjet)) {
                    this.finObjet += 0.08;
                }
                this.finObjet += 0.08;
            }
        }
    }

    private void gereCollision() {
        try {
            Bounds bound = this.curseur1.getBoundsInParent();
            for (int i = 0; i < this.nodesAEffacer.size(); ++i) {
                Node node = this.nodesAEffacer.get(i);
                if (this.nodeType.get(i) != 0 && this.nodeType.get(i) != 6 && this.nodeType.get(i) != 4 || !node.getBoundsInParent().intersects(bound)) continue;
                if (Main.getConfig().noParallax) {
                    this.gameRoot.getChildren().remove((Object)node);
                } else {
                    this.nodesDisparition.add((Rectangle)node);
                    this.nodesDateDisparition.add(this.controller.dureeMilli);
                    this.nodesDisparitionInitY.add(((Rectangle)node).getY());
                }
                this.nodesAEffacer.remove(i);
                this.nodeValidite.remove(i);
                this.nodeType.remove(i);
                this.nodeLevelObj.remove(i);
                Main.progEnCours.points += 1.0;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void gereAnimationDisparition() {
        for (int i = 0; i < this.nodesDisparition.size(); ++i) {
            Rectangle node = this.nodesDisparition.get(i);
            double dt = this.controller.dureeMilli - this.nodesDateDisparition.get(i);
            double y = this.nodesDisparitionInitY.get(i) - dt * 1000.0 + dt * dt * 1000.0;
            if (y > this.anchorHeight + node.getHeight()) {
                this.gameRoot.getChildren().remove((Object)node);
                this.nodesDisparition.remove(i);
                this.nodesDateDisparition.remove(i);
                this.nodesDisparitionInitY.remove(i);
                continue;
            }
            node.setY(y);
            node.setRotate(dt * 600.0);
        }
    }

    @Override
    void nouvellesCourbes() {
        this.debutCourbe = this.controller.dureeMilli;
        if (this.controller.nbVoie == 2) {
            if (this.courbe2 != null) {
                this.addNode((Node)this.courbe2, this.controller.dureeMilli, 5);
            }
            this.courbe2 = new Polyline();
            this.courbe2.getStyleClass().add((Object)"courbeVoie");
            this.courbe2.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.7);
            this.courbe2.setStyle("-fx-stroke:" + this.animationStyle.getCouleurVoie2());
            this.courbe2.setVisible(!this.controller.checkModeAveugle.isSelected());
            this.gameRoot.getChildren().add((Object)this.courbe2);
        }
        if (this.courbe1 != null) {
            this.addNode((Node)this.courbe1, this.controller.dureeMilli, 5);
        }
        this.courbe1 = new Polyline();
        this.courbe1.getStyleClass().add((Object)"courbeVoie");
        double widthRatio = this.controller.stateStimAssistee == 4 || this.controller.motifStimEnCours != 0 ? 1.4 : 1.0;
        this.courbe1.setStrokeWidth((double)Main.getConfig().epaisseurVoie * widthRatio);
        this.courbe1.setStyle("-fx-stroke:" + this.animationStyle.getCouleurVoie1());
        this.courbe1.setVisible(!this.controller.checkModeAveugle.isSelected());
        this.gameRoot.getChildren().add((Object)this.courbe1);
    }

    @Override
    void addNode(Node n, double dateVal, int type) {
        this.nodesAEffacer.add(n);
        this.nodeValidite.add(dateVal);
        this.nodeType.add(type);
        this.nodeLevelObj.add(0.0);
    }

    @Override
    void addNodeObj(Node n, double dateVal, double level, int type) {
        this.nodesAEffacer.add(n);
        this.nodeValidite.add(dateVal);
        this.nodeType.add(type);
        this.nodeLevelObj.add(level);
    }

    private void effaceNodes() {
        try {
            int i = 0;
            while (i < this.nodesAEffacer.size()) {
                if (this.nodeValidite.get(i) < this.controller.dureeMilli - this.dureeEcran * this.positionCurseur - 2.0) {
                    if (this.nodeType.get(i) == 1) {
                        this.debutProfil += this.controller.profil.getDuree();
                        this.dessineProfil();
                    }
                    this.gameRoot.getChildren().remove((Object)this.nodesAEffacer.get(i));
                    this.nodesAEffacer.remove(i);
                    this.nodeValidite.remove(i);
                    this.nodeType.remove(i);
                    this.nodeLevelObj.remove(i);
                    continue;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addEvent(String s_event, double time) {
        super.addEvent(s_event, time);
        double labelX = this.pixOfTime(time);
        Polyline p = new Polyline(new double[]{labelX, this.anchorHeight * 0.96, labelX, this.anchorHeight * 0.04});
        Label event = new Label(s_event);
        event.getStyleClass().add((Object)"event");
        this.gameRoot.getChildren().addAll((Object[])new Node[]{p, event});
        this.addNode((Node)p, time, 2);
        this.addNode((Node)event, time, 3);
        BiofeedbackAnimation.postPositionneEvent(event, labelX, this.anchorHeight);
    }

    @Override
    void setPositionCurseur() {
        this.positionCurseur = Main.progEnCours.currentProgram.ghost ? (this.dureeEcran - 1.0) / this.dureeEcran : (this.controller.profil.typeProfil() != 2 && Main.progEnCours.currentPageProgram.getType() != 10 ? 0.8 : 0.3);
    }

    @Override
    double getLargeurComplete() {
        return this.controller.dureePage * this.nbPixelParSeconde + this.widthGame;
    }

    @Override
    double pixOfTime(double temps) {
        return this.nbPixelParSeconde * temps + this.widthGame * this.positionCurseur;
    }

    @Override
    double timeOfPix(double pix) {
        return (pix - this.widthGame * this.positionCurseur) / this.nbPixelParSeconde;
    }
}

