/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Pdf;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import com.mazet.biostim.zdata.Patient;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Polyline;

public class AnimationRevoir {
    private BiofeedbackController controller;
    private Pane animRoot;
    private double profDur;
    private int nbPoints;
    double startPageTime = 0.0;
    public static final double deltaMoy = 0.1;
    private double dureeAffichage;
    private double totalWidthGame;
    private double nbPixelParSeconde = 100.0;
    private static final double hauteurScroll = 20.0;
    private static final double positionCursor = 0.7;
    double paneHeight;
    double paneWidth;
    private Button printButton;
    private ProgressIndicator waiting;
    private CheckBox moyenne;
    private boolean isMoyenne;
    private final Polyline marqueurSouris = new Polyline();
    private final Label labelSouris = new Label();
    private final Polyline marqueurStart = new Polyline();
    private Double marqueurStartTime = null;

    AnimationRevoir(BiofeedbackController controller) {
        this.controller = controller;
        controller.pausePane.setOnScroll(this::deplaceScroll);
        controller.pausePane.hvalueProperty().addListener(e -> this.scrollChanged());
        this.profDur = controller.profil.getDuree();
        this.nbPoints = (int)(this.profDur / 0.1);
        controller.pausePane.setOnMouseMoved(this::moveMouse);
        controller.pausePane.setOnMouseClicked(this::setMarqueurSouris);
        controller.pausePane.setOnMouseExited(e -> {
            this.marqueurSouris.setVisible(false);
            this.labelSouris.setVisible(false);
        });
        this.labelSouris.getStyleClass().add((Object)"timing");
    }

    void updateController(BiofeedbackController controller) {
        this.startPageTime += this.controller.dureePage;
        this.controller = controller;
        Main.progEnCours.historique.resetCumul();
        this.profDur = controller.profil.getDuree();
        this.nbPoints = (int)(this.profDur / 0.1);
        double decalage = this.startPageTime % this.profDur;
        if (decalage > 0.5) {
            this.startPageTime += this.profDur - decalage;
        }
    }

    void dessineHistorique(boolean fin) {
        this.paneHeight = this.controller.animationAnchor.getHeight();
        this.paneWidth = this.controller.animationAnchor.getWidth();
        this.profDur = this.controller.profil.getDuree();
        this.nbPoints = (int)(this.profDur / 0.1);
        this.isMoyenne = !fin || !(this.startPageTime + this.controller.dureeMilli > this.profDur * 1.1);
        this.changeMoyenne();
    }

    private void moveMouse(MouseEvent e) {
        double post = this.controller.pausePane.getHvalue() + (e.getX() - 0.7 * this.controller.pausePane.getWidth()) / this.nbPixelParSeconde;
        post = post < 0.0 ? 0.0 : Math.min(post, this.dureeAffichage);
        double posx = this.pixOfTime(post);
        this.marqueurSouris.getPoints().clear();
        this.marqueurSouris.getPoints().addAll((Object[])new Double[]{posx, this.pixTop()});
        this.marqueurSouris.getPoints().addAll((Object[])new Double[]{posx, this.pixBottom()});
        this.marqueurSouris.setVisible(true);
        this.labelSouris.setText(String.format("%.1f", this.marqueurStartTime == null ? post : post - this.marqueurStartTime));
        this.labelSouris.setLayoutX(posx - this.labelSouris.getHeight() / 2.0);
        this.labelSouris.setLayoutY(this.controller.pausePane.getHeight() - 20.0 - this.labelSouris.getHeight());
        this.labelSouris.setVisible(true);
    }

    private void setMarqueurSouris(MouseEvent e) {
        double post = this.controller.pausePane.getHvalue() + (e.getX() - 0.7 * this.controller.pausePane.getWidth()) / this.nbPixelParSeconde;
        post = post < 0.0 ? 0.0 : Math.min(post, this.dureeAffichage);
        double posx = this.pixOfTime(post);
        if (this.marqueurStart.isVisible() && post == this.marqueurStartTime) {
            this.marqueurStart.setVisible(false);
            this.marqueurStartTime = null;
        } else {
            this.marqueurStartTime = post;
            this.marqueurStart.getPoints().clear();
            this.marqueurStart.getPoints().addAll((Object[])new Double[]{posx, this.pixTop()});
            this.marqueurStart.getPoints().addAll((Object[])new Double[]{posx, this.pixBottom()});
            this.marqueurStart.setVisible(true);
        }
    }

    private void changeMoyenne() {
        this.isMoyenne = !this.isMoyenne;
        this.dureeAffichage = this.isMoyenne ? this.profDur : this.controller.dureePage;
        this.createHistory();
        this.controller.pausePane.setHmax(this.dureeAffichage);
        if (this.isMoyenne) {
            this.controller.pausePane.setHvalue(0.7 * this.paneWidth / this.nbPixelParSeconde);
        } else {
            this.controller.pausePane.setHvalue(this.controller.dureeMilli);
        }
        this.deplaceScroll(null);
    }

    private void createHistory() {
        String styleVoie1 = "-fx-stroke:" + this.controller.biofeedbackAnimation.getCouleurVoie1();
        String styleVoie2 = "-fx-stroke:" + this.controller.biofeedbackAnimation.getCouleurVoie2();
        String styleVoieMvt = "-fx-stroke: black";
        this.animRoot = new Pane();
        this.controller.pausePane.setContent((Node)this.animRoot);
        try {
            this.nbPixelParSeconde = this.paneWidth * (double)Main.getConfig().getVitesseDefilement() / 200.0;
            this.totalWidthGame = this.dureeAffichage * this.nbPixelParSeconde + this.paneWidth;
            this.animRoot.setPrefSize(this.totalWidthGame, this.paneHeight - 20.0);
            this.animRoot.setBackground(FxUtils.getBackGroundQuadrille(Main.getConfig().voiesSeparees && this.controller.nbVoie == 2, 0, (int)(this.paneHeight - 20.0), this.paneWidth * 0.7, this.nbPixelParSeconde * 5.0));
            if (this.controller.profil.typeProfil() == 2) {
                this.animRoot.getChildren().add((Object)this.getProfilLine(this.profDur));
            }
            Polyline courbeVoie1 = new Polyline();
            courbeVoie1.getStyleClass().add((Object)"courbeVoie");
            courbeVoie1.setStrokeWidth((double)Main.getConfig().epaisseurVoie);
            courbeVoie1.setStyle(styleVoie1);
            this.animRoot.getChildren().add((Object)courbeVoie1);
            Polyline courbeVoie2 = new Polyline();
            courbeVoie2.getStyleClass().add((Object)"courbeVoie");
            courbeVoie2.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.7);
            courbeVoie2.setStyle(styleVoie2);
            this.animRoot.getChildren().add((Object)courbeVoie2);
            Polyline courbeMvt = new Polyline();
            double maxMvt = 1.0;
            if (Main.progEnCours.historique.hasBalance) {
                courbeMvt.getStyleClass().add((Object)"courbeVoie");
                courbeMvt.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.7);
                courbeMvt.setStyle(styleVoieMvt);
                courbeMvt.getStrokeDashArray().addAll((Object[])new Double[]{20.0, 10.0, 5.0, 10.0});
                this.animRoot.getChildren().add((Object)courbeMvt);
                for (double n : Main.progEnCours.historique.mvt) {
                    if (!(n > maxMvt)) continue;
                    maxMvt = n;
                }
            }
            if (!this.isMoyenne) {
                double time;
                int i;
                for (i = 0; i < Main.progEnCours.historique.temps.size(); ++i) {
                    time = (float)Main.progEnCours.historique.temps.get(i).intValue() / 100.0f;
                    if (!(time >= this.startPageTime)) continue;
                    double posX = this.pixOfTime((time - this.startPageTime) % this.dureeAffichage);
                    double posY = this.pixOfNiv1(Main.progEnCours.historique.niveauVoie1.get(i));
                    courbeVoie1.getPoints().addAll((Object[])new Double[]{posX, posY});
                    if (this.controller.nbVoie == 2) {
                        posY = this.pixOfNiv2(Main.progEnCours.historique.niveauVoie2.get(i));
                        courbeVoie2.getPoints().addAll((Object[])new Double[]{posX, posY});
                    }
                    if (!Main.progEnCours.historique.hasBalance) continue;
                    posY = this.pixOfNivMvt(Main.progEnCours.historique.mvt.get(i) / maxMvt);
                    courbeMvt.getPoints().addAll((Object[])new Double[]{posX, posY});
                }
                for (i = 0; i < Main.progEnCours.historique.tempsEvt.size(); ++i) {
                    time = (float)Main.progEnCours.historique.tempsEvt.get(i).intValue() / 100.0f;
                    if (!(time >= this.startPageTime)) continue;
                    double labelX = this.pixOfTime(time - this.startPageTime);
                    double labelY = this.paneHeight - 20.0;
                    Polyline p = new Polyline(new double[]{labelX, labelY * 0.96, labelX, labelY * 0.04});
                    Label event = new Label(Main.progEnCours.historique.events.get(i));
                    event.getStyleClass().add((Object)"event");
                    this.animRoot.getChildren().addAll((Object[])new Node[]{p, event});
                    BiofeedbackAnimation.postPositionneEvent(event, labelX, labelY);
                }
            } else {
                int i;
                double[] moyenne1 = new double[this.nbPoints];
                double[] moyenne2 = new double[this.nbPoints];
                double[] moyenneMvt = new double[this.nbPoints];
                int[] nbVal = new int[this.nbPoints];
                int lastPosMoy = -1;
                for (i = 0; i < Main.progEnCours.historique.temps.size(); ++i) {
                    double time = (float)Main.progEnCours.historique.temps.get(i).intValue() / 100.0f;
                    if (!(time >= this.startPageTime)) continue;
                    int pos = (int)((time - this.startPageTime) / this.profDur * (double)this.nbPoints) % this.nbPoints;
                    if (pos != lastPosMoy) {
                        int n = pos;
                        moyenne1[n] = moyenne1[n] + Main.progEnCours.historique.niveauVoie1.get(i);
                        if (this.controller.nbVoie == 2) {
                            int n2 = pos;
                            moyenne2[n2] = moyenne2[n2] + Main.progEnCours.historique.niveauVoie2.get(i);
                        }
                        if (Main.progEnCours.historique.hasBalance) {
                            int n3 = pos;
                            moyenneMvt[n3] = moyenneMvt[n3] + Main.progEnCours.historique.mvt.get(i);
                        }
                        int n4 = pos;
                        nbVal[n4] = nbVal[n4] + 1;
                    }
                    lastPosMoy = pos;
                }
                for (i = 1; i < this.nbPoints; ++i) {
                    if (nbVal[i] <= 0) continue;
                    double posX = this.pixOfTime(((double)i + 0.5) * this.dureeAffichage / (double)this.nbPoints);
                    double posY = this.pixOfNiv1(moyenne1[i] / (double)nbVal[i]);
                    courbeVoie1.getPoints().addAll((Object[])new Double[]{posX, posY});
                    if (this.controller.nbVoie == 2) {
                        posY = this.pixOfNiv2(moyenne2[i] / (double)nbVal[i]);
                        courbeVoie2.getPoints().addAll((Object[])new Double[]{posX, posY});
                    }
                    if (!Main.progEnCours.historique.hasBalance) continue;
                    posY = this.pixOfNivMvt(moyenneMvt[i] / (double)nbVal[i] / maxMvt);
                    courbeMvt.getPoints().addAll((Object[])new Double[]{posX, posY});
                }
            }
            if (this.controller.voiesSeparees) {
                Polyline poly = new Polyline();
                poly.getStyleClass().add((Object)"courbeSeparation");
                poly.getPoints().addAll((Object[])new Double[]{0.0, (this.paneHeight - 20.0) / 2.0});
                poly.getPoints().addAll((Object[])new Double[]{this.totalWidthGame, (this.paneHeight - 20.0) / 2.0});
                this.animRoot.getChildren().add((Object)poly);
            }
            FxUtils.addLabelTemps(this.animRoot, this.dureeAffichage, this.pixOfTime(0.0), this.nbPixelParSeconde, this.paneHeight - 20.0);
            this.addPrintButton();
            this.marqueurStart.getStyleClass().add((Object)"courbeZeroSouris");
            this.marqueurStart.setVisible(false);
            this.marqueurStartTime = null;
            this.marqueurSouris.setVisible(false);
            this.labelSouris.setVisible(false);
            this.animRoot.getChildren().addAll((Object[])new Node[]{this.marqueurSouris, this.labelSouris, this.marqueurStart});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Polyline getProfilLine(double profDur) {
        double posY;
        double posX;
        Polyline ruban = new Polyline();
        double profilWidth = 0.92 * this.paneHeight * (double)Main.progEnCours.epaisseurProfil / 100.0 * (100.0 - this.profToAff(0.0)) / 100.0;
        if (this.controller.voiesSeparees) {
            profilWidth = profilWidth * 5.0 / 11.0;
        }
        ruban.setStrokeWidth(profilWidth);
        ruban.getStyleClass().add((Object)"rubanBleu");
        for (double time = 0.0; time < this.dureeAffichage; time += profDur) {
            for (int indice = 0; indice <= this.controller.profil.size() - 1 && time + this.controller.profil.temps.get(indice) < this.dureeAffichage - 0.01; ++indice) {
                posX = this.pixOfTime(this.controller.profil.temps.get(indice) + time);
                posY = this.pixOfProfil(this.controller.profil.val.get(indice) * 100.0);
                ruban.getPoints().addAll((Object[])new Double[]{posX, posY});
            }
        }
        posX = this.pixOfTime(this.dureeAffichage);
        posY = this.pixOfProfil(this.controller.profil.getVal(this.dureeAffichage));
        ruban.getPoints().addAll((Object[])new Double[]{posX, posY});
        return ruban;
    }

    private void addPrintButton() {
        this.printButton = new Button();
        this.printButton.getStyleClass().add((Object)"printHistBFB");
        this.printButton.setLayoutY(100.0);
        this.animRoot.getChildren().add((Object)this.printButton);
        this.printButton.setOnMouseClicked(e -> this.printHistory(this.animRoot));
        this.waiting = new ProgressIndicator();
        this.waiting.getStyleClass().add((Object)"waiting");
        this.waiting.setLayoutY(this.paneHeight / 2.0 - 200.0);
        this.waiting.setVisible(false);
        this.animRoot.getChildren().add((Object)this.waiting);
        this.moyenne = new CheckBox(TransientConfig.translate("Moyenne"));
        this.moyenne.setSelected(this.isMoyenne);
        this.moyenne.setLayoutY(70.0);
        this.animRoot.getChildren().add((Object)this.moyenne);
        this.moyenne.selectedProperty().addListener(e -> this.changeMoyenne());
    }

    private void deplaceScroll(ScrollEvent e) {
        double posScroll = this.controller.pausePane.getHvalue();
        if (e != null) {
            posScroll -= e.getDeltaY() / 20.0;
        }
        if (posScroll < 0.0) {
            posScroll = 0.0;
        }
        if (posScroll > this.dureeAffichage) {
            posScroll = this.dureeAffichage;
        }
        this.controller.pausePane.setHvalue(posScroll);
    }

    private void scrollChanged() {
        double posScroll = this.controller.pausePane.getHvalue();
        double pixStart = posScroll / this.dureeAffichage * (this.totalWidthGame - this.paneWidth);
        this.printButton.setLayoutX(30.0 + pixStart);
        this.moyenne.setLayoutX(10.0 + pixStart);
        this.waiting.setLayoutX(pixStart + this.paneWidth / 2.0 - 200.0);
    }

    private void printHistory(Pane animRoot) {
        Patient patient = Main.getCurrentPatient();
        String titre = LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
        String soustitre = Main.progEnCours.currentProgram.getNom() + ", Max : " + Main.progEnCours.getMaxPower();
        if (Main.progEnCours.hasPourcentageReussite()) {
            soustitre = soustitre + ", " + TransientConfig.translate("Reussite") + " : " + Main.progEnCours.getPourcentageReussite() + "%";
        }
        if (patient != null) {
            titre = patient.getNameAndId() + ", " + titre;
        }
        this.printButton.setVisible(false);
        this.moyenne.setVisible(false);
        Pdf.createHistPDF(animRoot, this.isMoyenne, this.waiting, (int)(0.7 * this.paneWidth) - 10, (int)(0.30000000000000004 * this.paneWidth) - 10, titre, soustitre, null, (int)Main.progEnCours.getAffMax(this.controller.cvoie1), this.controller.cvoie2 == -1 ? 0 : (int)Main.progEnCours.getAffMax(this.controller.cvoie2));
        this.printButton.setVisible(true);
        this.moyenne.setVisible(true);
    }

    private double pixOfTime(double temps) {
        return this.nbPixelParSeconde * temps + this.paneWidth * 0.7;
    }

    private double profToAff(double niv) {
        double zeroProf = 100.0 * (Main.progEnCours.getBase(this.controller.cvoie1) - Main.progEnCours.getAffMin(this.controller.cvoie1)) / (Main.progEnCours.getAffMax(this.controller.cvoie1) - Main.progEnCours.getAffMin(this.controller.cvoie1));
        return zeroProf + (100.0 - zeroProf) * niv / 100.0;
    }

    private double pixOfProfil(double niv) {
        niv = (double)Main.progEnCours.epaisseurProfil / 2.0 + niv * (double)(100 - Main.progEnCours.epaisseurProfil) / 100.0;
        niv = this.profToAff(niv);
        if (this.controller.voiesSeparees) {
            niv = Main.progEnCours.currentProgram.voie1EnHaut ? (600.0 + niv * 5.0) / 11.0 : niv * 5.0 / 11.0;
        }
        return (this.paneHeight - 20.0) * (0.96 - 0.92 * niv / 100.0);
    }

    private double pixOfNiv1(double niv) {
        double nivrel = (niv - Main.progEnCours.getAffMin(this.controller.cvoie1)) / (Main.progEnCours.getAffMax(this.controller.cvoie1) - Main.progEnCours.getAffMin(this.controller.cvoie1));
        if (nivrel > 1.0) {
            nivrel = 1.0;
        }
        if (nivrel < 0.0) {
            nivrel = 0.0;
        }
        if (this.controller.voiesSeparees) {
            nivrel = Main.progEnCours.currentProgram.voie1EnHaut ? (6.0 + nivrel * 5.0) / 11.0 : nivrel * 5.0 / 11.0;
        }
        return (this.paneHeight - 20.0) * (0.96 - 0.92 * nivrel);
    }

    private double pixOfNiv2(double niv) {
        double nivrel = (niv - Main.progEnCours.getAffMin(this.controller.cvoie2)) / (Main.progEnCours.getAffMax(this.controller.cvoie2) - Main.progEnCours.getAffMin(this.controller.cvoie2));
        if (nivrel > 1.0) {
            nivrel = 1.0;
        }
        if (nivrel < 0.0) {
            nivrel = 0.0;
        }
        if (this.controller.voiesSeparees) {
            nivrel = Main.progEnCours.currentProgram.voie1EnHaut ? nivrel * 5.0 / 11.0 : (6.0 + nivrel * 5.0) / 11.0;
        }
        return (this.paneHeight - 20.0) * (0.96 - 0.92 * nivrel);
    }

    private double pixOfNivMvt(double niv) {
        if (this.controller.voiesSeparees) {
            niv = niv * 5.0 / 11.0;
        }
        return (this.paneHeight - 20.0) * (0.96 - 0.92 * niv);
    }

    private double pixTop() {
        return (this.paneHeight - 20.0) * 0.96;
    }

    private double pixBottom() {
        return (this.paneHeight - 20.0) * 0.04;
    }
}

