/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bilan;

import com.mazet.biostim.Main;
import com.mazet.biostim.graph.LineChartWithMarkers;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.view.programme.bilan.BilanController;
import com.mazet.biostim.view.programme.bilan.EtapeBilan;
import com.mazet.biostim.view.programme.bilan.ProgBilan;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;

public class PressionAnaleController
extends EtapeBilan {
    @FXML
    Label title;
    @FXML
    Label commentaire;
    @FXML
    Label pressionField;
    @FXML
    LineChartWithMarkers<Number, Number> graphique;
    @FXML
    NumberAxis xAxis;
    @FXML
    NumberAxis yAxis;
    @FXML
    AnchorPane partGraph2;
    @FXML
    LineChartWithMarkers<Number, Number> graphique2;
    @FXML
    NumberAxis xAxis2;
    @FXML
    NumberAxis yAxis2;
    private double levelMin;
    private double levelMax;
    private XYChart.Data<Number, Number> horizontalRangeMarker1;
    private XYChart.Series<Number, Number> series1;
    private XYChart.Data<Number, Number> horizontalRangeMarker2;
    private XYChart.Series<Number, Number> series2;
    private boolean isRetour = false;
    private int startRetour;

    @Override
    void init(ProgBilan progBilan, int posAffichee) {
        super.init(progBilan, posAffichee);
        this.title.setText(posAffichee + ". " + this.title.getText());
        this.series1 = new XYChart.Series();
        this.graphique.getData().add(this.series1);
        this.xAxis.setTickUnit(60.0);
        this.series2 = new XYChart.Series();
        this.graphique2.getData().add(this.series2);
    }

    @Override
    void enter() {
        super.enter();
        this.isRetour = false;
        this.series1.getData().clear();
        this.series2.getData().clear();
        this.pressionField.setText("");
        this.endIndex = Integer.MAX_VALUE;
        this.levelMin = 5000.0;
        this.levelMax = 0.0;
    }

    @Override
    boolean update(int currentIndex) {
        try {
            double pression = Biostim.getVoie(this.progBilan.voie1);
            if (!this.isRetour) {
                if (pression < this.levelMin) {
                    this.levelMin = pression;
                    this.updateMinMax();
                }
                if (pression > this.levelMax) {
                    this.levelMax = pression;
                    this.endIndex = Integer.MAX_VALUE;
                    this.updateMinMax();
                }
                this.addDataToSerie1(currentIndex, pression);
                if (this.levelMax > 30.0 && pression < this.levelMax * 0.5 && this.endIndex == Integer.MAX_VALUE) {
                    this.bilan.pressionAnale = this.levelMax;
                    this.pressionField.setText(TransientConfig.translate("pression_anale", this.levelMax));
                    this.endIndex = currentIndex + 300;
                }
                if (this.endIndex < currentIndex) {
                    this.isRetour = true;
                    this.startRetour = currentIndex + 1;
                    this.endIndex = Integer.MAX_VALUE;
                    this.commentaire.setText(TransientConfig.translate("placer_sonde"));
                    this.setMainVbox();
                    this.updateMinMax2();
                }
                return false;
            }
            if (pression > this.levelMax) {
                this.levelMax = pression;
                this.updateMinMax2();
            }
            this.addDataToSerie2(currentIndex, pression);
            if (pression >= this.bilan.pressionAnale * 0.9 && pression <= this.bilan.pressionAnale * 1.1) {
                if (this.endIndex == Integer.MAX_VALUE) {
                    this.commentaire.getStyleClass().setAll((Object[])new String[]{"labelConfiguration", "green"});
                    this.endIndex = currentIndex + 300;
                }
            } else {
                this.commentaire.getStyleClass().setAll((Object[])new String[]{"labelConfiguration", "red"});
                this.endIndex = Integer.MAX_VALUE;
            }
            return this.endIndex < currentIndex;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    void setMainVbox() {
        if (this.isRetour) {
            this.commentaire.setText(TransientConfig.translate("placer_sonde"));
            this.mainVbox.getChildren().setAll((Object[])new Node[]{this.partText, this.partGraph2});
            String color = Main.getConfig().couleurVoie1;
            String style = String.format("-fx-stroke: %s;  -fx-background-color: %s;", color, color);
            for (Node n : this.partGraph2.lookupAll(".default-color0")) {
                n.setStyle(style);
            }
        } else {
            this.commentaire.setText(TransientConfig.translate("inserer_sonde"));
            this.mainVbox.getChildren().setAll((Object[])new Node[]{this.partText, this.partGraph});
        }
        this.commentaire.getStyleClass().setAll((Object[])new String[]{"labelConfiguration"});
    }

    @Override
    void setMainHbox() {
        super.setMainHbox();
        this.commentaire.setText("");
    }

    private void updateMinMax() {
        this.levelMax = Math.min(this.levelMax, Biostim.getMaxVoie(this.progBilan.voie1));
        this.levelMin = Math.max(this.levelMin, 0.0);
        this.yAxis.setUpperBound(10.0 * Math.ceil(this.levelMax * 0.12));
        this.yAxis.setTickUnit(BilanController.getTickUnit(this.yAxis.getUpperBound()));
        if (this.horizontalRangeMarker1 != null) {
            this.graphique.removeHorizontalRangeMarker(this.horizontalRangeMarker1);
        }
        this.horizontalRangeMarker1 = new XYChart.Data((Object)this.levelMin, (Object)this.levelMax);
        this.graphique.addHorizontalRangeMarker(this.horizontalRangeMarker1);
    }

    private void addDataToSerie1(int currentIndex, Double data) {
        this.series1.getData().add((Object)new XYChart.Data((Object)currentIndex, (Object)data));
        while ((Integer)((Number)((XYChart.Data)this.series1.getData().get(0)).getXValue()) < currentIndex - this.duree * 60) {
            this.series1.getData().remove(0);
        }
        int start = Math.max(0, currentIndex - this.duree * 60);
        this.xAxis.setLowerBound((double)start);
        this.xAxis.setUpperBound((double)(start + this.duree * 60 - 1));
    }

    private void updateMinMax2() {
        this.levelMax = Math.min(this.levelMax, Biostim.getMaxVoie(this.progBilan.voie1));
        this.levelMin = Math.max(this.levelMin, 0.0);
        this.yAxis2.setUpperBound(10.0 * Math.ceil(this.levelMax * 0.12));
        this.yAxis2.setTickUnit(BilanController.getTickUnit(this.yAxis2.getUpperBound()));
        if (this.horizontalRangeMarker2 != null) {
            this.graphique2.removeHorizontalRangeMarker(this.horizontalRangeMarker2);
        }
        this.horizontalRangeMarker2 = new XYChart.Data((Object)(this.bilan.pressionAnale * 0.9), (Object)(this.bilan.pressionAnale * 1.1));
        this.graphique2.addHorizontalRangeMarker(this.horizontalRangeMarker2);
    }

    private void addDataToSerie2(int currentIndex, Double data) {
        this.series2.getData().add((Object)new XYChart.Data((Object)currentIndex, (Object)data));
        while ((Integer)((Number)((XYChart.Data)this.series2.getData().get(0)).getXValue()) < currentIndex - this.duree * 60) {
            this.series2.getData().remove(0);
        }
        int start = Math.max(this.startRetour, currentIndex - this.duree * 60);
        this.xAxis2.setLowerBound((double)start);
        this.xAxis2.setUpperBound((double)(start + this.duree * 60 - 1));
    }

    double remplirHistorique(double startTime) {
        Main.progEnCours.historique.addEvent(this.title.getText().substring(3), startTime);
        for (XYChart.Data data1 : this.series1.getData()) {
            double index = ((Number)data1.getXValue()).doubleValue();
            if (Main.progEnCours.currentProgram.getVoieBFB2() != -1) {
                Main.progEnCours.historique.ajouteValeur(startTime + index / 60.0, ((Number)data1.getYValue()).doubleValue(), 0.0);
                continue;
            }
            Main.progEnCours.historique.ajouteValeur(startTime + index / 60.0, ((Number)data1.getYValue()).doubleValue());
        }
        return this.duree;
    }

    @Override
    boolean etapeFaite() {
        return false;
    }
}

