/*
 * Decompiled with CFR 0.152.
 */
package jssc;

import java.io.IOException;
import jssc.SerialPort;

public class SerialPortException
extends IOException {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_PORT_ALREADY_OPENED = "Port already opened";
    public static final String TYPE_PORT_NOT_OPENED = "Port not opened";
    public static final String TYPE_CANT_SET_MASK = "Can't set mask";
    public static final String TYPE_LISTENER_ALREADY_ADDED = "Event listener already added";
    public static final String TYPE_LISTENER_THREAD_INTERRUPTED = "Event listener thread interrupted";
    public static final String TYPE_CANT_REMOVE_LISTENER = "Can't remove event listener";
    public static final String TYPE_PORT_BUSY = "Port busy";
    public static final String TYPE_PORT_NOT_FOUND = "Port not found";
    public static final String TYPE_PERMISSION_DENIED = "Permission denied";
    public static final String TYPE_INCORRECT_SERIAL_PORT = "Incorrect serial port";
    public static final String TYPE_NATIVE_EXCEPTION = "Native exception occurred: %s";
    private SerialPort port;
    private String methodName;
    private String exceptionType;
    @Deprecated
    private String portName;

    public SerialPortException(SerialPort port, String methodName, String exceptionType) {
        super("Port name - " + port.getPortName() + "; Method name - " + methodName + "; Exception type - " + exceptionType + ".");
        this.port = port;
        this.methodName = methodName;
        this.exceptionType = exceptionType;
    }

    @Deprecated
    public SerialPortException(String portName, String methodName, String exceptionType) {
        super("Port name - " + portName + "; Method name - " + methodName + "; Exception type - " + exceptionType + ".");
        this.portName = portName;
        this.methodName = methodName;
        this.exceptionType = exceptionType;
    }

    public static SerialPortException wrapNativeException(Exception ex, SerialPort port, String methodName) {
        return new SerialPortException(port, methodName, String.format(TYPE_NATIVE_EXCEPTION, ex.getLocalizedMessage()));
    }

    @Deprecated
    public String getPortName() {
        return this.port != null ? this.port.getPortName() : this.portName;
    }

    public SerialPort getPort() {
        return this.port;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }
}

