/*
 * Decompiled with CFR 0.152.
 */
package jwave;

import jwave.Transform;
import jwave.TransformBuilder;
import jwave.transforms.DiscreteFourierTransform;
import jwave.transforms.wavelets.Wavelet;
import jwave.transforms.wavelets.WaveletBuilder;

public class JWave {
    public static void main(String[] stringArray) {
        if (stringArray.length < 3 || stringArray.length > 5) {
            System.err.println("example usage: JWave [transformType] {waveletType}");
            System.err.println("");
            System.err.println("Transform names: 'Discrete Fourier Transform' 'Fast Wavelet Transform' 'Wavelet Packet Transform'");
            System.err.println("Wavelet names: 'Haar', 'Haar orthogonal', 'Daubechies 2' .. 'Daubechies 20', 'Symlet 2' .. 'Symlet 20', 'Coiflet 1' .. 'Coiflet 5', 'Legendre 1' .. 'Legendre 3',  ... 'BiOrthogonal 1/1' have a look for more in the 'transform.wavelets' package!");
            return;
        }
        String string = stringArray[3] + " " + stringArray[4];
        String string2 = stringArray[0] + " " + stringArray[1] + " " + stringArray[2];
        Transform transform = TransformBuilder.create(string2, string);
        Wavelet wavelet = transform.getWavelet();
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        if (transform.getBasicTransform() instanceof DiscreteFourierTransform) {
            System.out.print(TransformBuilder.identify(transform));
        } else {
            System.out.print(TransformBuilder.identify(transform) + " using " + WaveletBuilder.identify(wavelet));
        }
        System.out.println("");
        System.out.println("time domain:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.printf("%7.4f", dArray[i]);
        }
        System.out.println("");
        double[] dArray2 = transform.forward(dArray);
        if (transform.getBasicTransform() instanceof DiscreteFourierTransform) {
            System.out.println("frequency domain:");
        } else {
            System.out.println("Hilbert domain:");
        }
        for (int i = 0; i < dArray.length; ++i) {
            System.out.printf("%7.4f", dArray2[i]);
        }
        System.out.println("");
        double[] dArray3 = transform.reverse(dArray2);
        System.out.println("reconstruction:");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.printf("%7.4f", dArray3[i]);
        }
        System.out.println("");
    }
}

