/*
 * Decompiled with CFR 0.152.
 */
package jwave;

import jwave.Transform;
import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;
import jwave.transforms.DiscreteFourierTransform;
import jwave.transforms.FastWaveletTransform;
import jwave.transforms.WaveletPacketTransform;
import jwave.transforms.wavelets.Wavelet;
import jwave.transforms.wavelets.WaveletBuilder;

public class TransformBuilder {
    public static Transform create(String string, Wavelet wavelet) {
        BasicTransform basicTransform = null;
        try {
            switch (string) {
                case "Discrete Fourier Transform": {
                    basicTransform = new DiscreteFourierTransform();
                    break;
                }
                case "Fast Wavelet Transform": {
                    basicTransform = new FastWaveletTransform(wavelet);
                    break;
                }
                case "Wavelet Packet Transform": {
                    basicTransform = new WaveletPacketTransform(wavelet);
                    break;
                }
                default: {
                    throw new JWaveFailure("TransformBuilder::create - unknown type of transform for given string!");
                }
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            jWaveException.printStackTrace();
        }
        return new Transform(basicTransform);
    }

    public static Transform create(String string, String string2) {
        return TransformBuilder.create(string, WaveletBuilder.create(string2));
    }

    public static String identify(Transform transform) {
        BasicTransform basicTransform = transform.getBasicTransform();
        return basicTransform.getName();
    }
}

