/*
 * Decompiled with CFR 0.152.
 */
package jwave.compressions;

import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;

public abstract class Compressor {
    protected double _threshold = 1.0;
    protected double _magnitude = 0.0;

    public Compressor() {
        this._threshold = 1.0;
    }

    public Compressor(double d) {
        try {
            if (d <= 0.0) {
                throw new JWaveFailure("Compressor - given threshold should be larger than zero!");
            }
        }
        catch (JWaveException jWaveException) {
            jWaveException.showMessage();
            System.out.println("Compressor - setting threshold to default value: 1.0");
            d = 1.0;
        }
        this._threshold = d;
    }

    protected double[] compress(double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.abs(dArray[i]) >= d * this._threshold ? dArray[i] : 0.0;
        }
        return dArray2;
    }

    protected double[][] compress(double[][] dArray, double d) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = Math.abs(dArray[i][j]) >= d * this._threshold ? dArray[i][j] : 0.0;
            }
        }
        return dArray2;
    }

    protected double[][][] compress(double[][][] dArray, double d) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        double[][][] dArray2 = new double[n][n2][n3];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    dArray2[i][j][k] = Math.abs(dArray[i][j][k]) >= d * this._threshold ? dArray[i][j][k] : 0.0;
                }
            }
        }
        return dArray2;
    }

    public double getThreshold() {
        return this._threshold;
    }

    public double getMagnitude() {
        return this._magnitude;
    }

    public abstract double[] compress(double[] var1);

    public abstract double[][] compress(double[][] var1);

    public abstract double[][][] compress(double[][][] var1);
}

