/*
 * Decompiled with CFR 0.152.
 */
package jwave.compressions;

import jwave.compressions.Compressor;

public class CompressorMagnitude
extends Compressor {
    public CompressorMagnitude() {
        this._magnitude = 0.0;
        this._threshold = 1.0;
    }

    public CompressorMagnitude(double d) {
        super(d);
        this._magnitude = 0.0;
    }

    @Override
    public double[] compress(double[] dArray) {
        this._magnitude = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this._magnitude += Math.abs(dArray[i]);
        }
        this._magnitude /= (double)n;
        return this.compress(dArray, this._magnitude);
    }

    @Override
    public double[][] compress(double[][] dArray) {
        this._magnitude = 0.0;
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this._magnitude += Math.abs(dArray[i][j]);
            }
        }
        this._magnitude /= (double)n * (double)n2;
        return this.compress(dArray, this._magnitude);
    }

    @Override
    public double[][][] compress(double[][][] dArray) {
        this._magnitude = 0.0;
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    this._magnitude += Math.abs(dArray[i][j][k]);
                }
            }
        }
        this._magnitude /= (double)n * (double)n2 * (double)n3;
        return this.compress(dArray, this._magnitude);
    }
}

