/*
 * Decompiled with CFR 0.152.
 */
package jwave.compressions;

import jwave.compressions.Compressor;

public class CompressorPeaksAverage
extends Compressor {
    protected double _peakMinimum = 0.0;
    protected double _peakMaximum = 0.0;

    public CompressorPeaksAverage() {
        this._magnitude = 0.0;
    }

    public CompressorPeaksAverage(double d) {
        super(d);
        this._magnitude = 0.0;
    }

    @Override
    public double[] compress(double[] dArray) {
        for (double d : dArray) {
            double d2 = Math.abs(d);
            if (d2 <= this._peakMinimum) {
                this._peakMinimum = d2;
            }
            if (!(d2 >= this._peakMaximum)) continue;
            this._peakMaximum = d2;
        }
        this._magnitude = 0.5 * (this._peakMaximum - this._peakMinimum);
        return this.compress(dArray, this._magnitude);
    }

    @Override
    public double[][] compress(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = Math.abs(dArray[i][j]);
                if (d <= this._peakMinimum) {
                    this._peakMinimum = d;
                }
                if (!(d >= this._peakMaximum)) continue;
                this._peakMaximum = d;
            }
        }
        this._magnitude = 0.5 * (this._peakMaximum - this._peakMinimum);
        return this.compress(dArray, this._magnitude);
    }

    @Override
    public double[][][] compress(double[][][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double d = Math.abs(dArray[i][j][k]);
                    if (d <= this._peakMinimum) {
                        this._peakMinimum = d;
                    }
                    if (!(d >= this._peakMaximum)) continue;
                    this._peakMaximum = d;
                }
            }
        }
        this._magnitude = 0.5 * (this._peakMaximum - this._peakMinimum);
        return this.compress(dArray, this._magnitude);
    }
}

