/*
 * Decompiled with CFR 0.152.
 */
package jwave.datatypes.natives;

public class Complex {
    private double _r;
    private double _j;

    public Complex() {
        this._r = 0.0;
        this._j = 0.0;
    }

    public Complex(Complex complex) {
        this._r = complex._r;
        this._j = complex._j;
    }

    public Complex(double d, double d2) {
        this._r = d;
        this._j = d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this._r);
        if (this._j >= 0.0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
        }
        return stringBuffer.append(this._j).append('j').toString();
    }

    public double getReal() {
        return this._r;
    }

    public double getImag() {
        return this._j;
    }

    public void setReal(double d) {
        this._r = d;
    }

    public void setImag(double d) {
        this._j = d;
    }

    public void addReal(double d) {
        this._r += d;
    }

    public void addImag(double d) {
        this._j += d;
    }

    public void mulReal(double d) {
        this._r *= d;
    }

    public void mulImag(double d) {
        this._j *= d;
    }

    public double getMag() {
        return Math.sqrt(this._r * this._r + this._j * this._j);
    }

    public double getPhi() {
        if (this._r == 0.0 && this._j == 0.0) {
            return 0.0;
        }
        double d = Math.toDegrees(Math.atan(Math.abs(this._j / this._r)));
        if (this._r >= 0.0 && this._j >= 0.0) {
            return d;
        }
        if (this._r <= 0.0 && this._j >= 0.0) {
            return 180.0 - d;
        }
        if (this._r <= 0.0 && this._j <= 0.0) {
            return d + 180.0;
        }
        if (this._r >= 0.0 && this._j <= 0.0) {
            return 360.0 - d;
        }
        return Math.toDegrees(Math.atan(Math.abs(this._j / this._r)));
    }

    public double[] toArr() {
        double[] dArray = new double[]{this._r, this._j};
        return dArray;
    }

    public Complex conjugate() {
        return new Complex(this._r, -this._j);
    }

    public Complex add(Complex complex) {
        return new Complex(this._r + complex._r, this._j + complex._j);
    }

    public Complex sub(Complex complex) {
        return new Complex(this._r - complex._r, this._j - complex._j);
    }

    public Complex mul(Complex complex) {
        return new Complex(this._r * complex._r - this._j * complex._j, this._r * complex._j + this._j * complex._r);
    }

    public Complex mul(double d) {
        return new Complex(this._r * d, this._j * d);
    }

    public Complex div(Complex complex) {
        return this.mul(complex.conjugate()).div(complex._r * complex._r + complex._j * complex._j);
    }

    public Complex div(double d) {
        return this.mul(1.0 / d);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this._j);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this._r);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Complex complex = (Complex)object;
        if (Double.doubleToLongBits(this._j) != Double.doubleToLongBits(complex._j)) {
            return false;
        }
        return Double.doubleToLongBits(this._r) == Double.doubleToLongBits(complex._r);
    }

    public void show() {
        if (this._j < 0.0) {
            System.out.println(this.getReal() + " - j" + Math.abs(this.getImag()));
        } else {
            System.out.println(this.getReal() + " + j" + this.getImag());
        }
    }

    public void show(String string) {
        if (this._j < 0.0) {
            System.out.println(string + ": " + this.getReal() + " - j" + Math.abs(this.getImag()));
        } else {
            System.out.println(string + ": " + this.getReal() + " + j" + this.getImag());
        }
    }

    public void showMag() {
        System.out.println(this.getMag());
    }

    public void showPhi() {
        System.out.println(this.getPhi());
    }
}

