/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.exceptions.JWaveException;
import jwave.tools.MathToolKit;
import jwave.transforms.BasicTransform;

public class AncientEgyptianDecomposition
extends BasicTransform {
    protected BasicTransform _basicTransform;
    private int _initialWaveletSpaceSize;

    public AncientEgyptianDecomposition(BasicTransform basicTransform) {
        this._basicTransform = basicTransform;
        this._initialWaveletSpaceSize = 0;
    }

    public AncientEgyptianDecomposition(BasicTransform basicTransform, int n) {
        this._basicTransform = basicTransform;
        this._initialWaveletSpaceSize = n;
    }

    @Override
    public double[] forward(double[] dArray) throws JWaveException {
        double[] dArray2 = new double[dArray.length];
        int[] nArray = null;
        nArray = MathToolKit.decompose(dArray.length);
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = (int)MathToolKit.scalb(1.0, n2);
            double[] dArray3 = new double[n3];
            for (int j = 0; j < dArray3.length; ++j) {
                dArray3[j] = dArray[j + n];
            }
            double[] dArray4 = this._basicTransform.forward(dArray3);
            for (int j = 0; j < dArray4.length; ++j) {
                dArray2[j + n] = dArray4[j];
            }
            n += dArray4.length;
        }
        return dArray2;
    }

    @Override
    public double[] reverse(double[] dArray) throws JWaveException {
        double[] dArray2 = new double[dArray.length];
        int[] nArray = null;
        try {
            nArray = MathToolKit.decompose(dArray.length);
        }
        catch (JWaveException jWaveException) {
            jWaveException.printStackTrace();
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            int n3 = (int)MathToolKit.scalb(1.0, n2);
            double[] dArray3 = new double[n3];
            for (int j = 0; j < dArray3.length; ++j) {
                dArray3[j] = dArray[j + n];
            }
            double[] dArray4 = this._basicTransform.reverse(dArray3);
            for (int j = 0; j < dArray4.length; ++j) {
                dArray2[j + n] = dArray4[j];
            }
            n += dArray3.length;
        }
        return dArray2;
    }
}

