/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;
import jwave.transforms.wavelets.Wavelet;

public abstract class WaveletTransform
extends BasicTransform {
    protected Wavelet _wavelet;

    protected WaveletTransform(Wavelet wavelet) {
        this._wavelet = wavelet;
    }

    @Override
    public Wavelet getWavelet() {
        return this._wavelet;
    }

    @Override
    public double[] forward(double[] dArray) throws JWaveException {
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("WaveletTransform#forward - given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n = this.calcExponent(dArray.length);
        return this.forward(dArray, n);
    }

    @Override
    public double[] reverse(double[] dArray) throws JWaveException {
        if (!this.isBinary(dArray.length)) {
            throw new JWaveFailure("WaveletTransform#reverse - given array length is not 2^p | p E N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int n = this.calcExponent(dArray.length);
        return this.reverse(dArray, n);
    }

    @Override
    public double[][] decompose(double[] dArray) throws JWaveException {
        int n = dArray.length;
        int n2 = this.calcExponent(n);
        double[][] dArray2 = new double[n2 + 1][n];
        for (int i = 0; i <= n2; ++i) {
            System.arraycopy(this.forward(dArray, i), 0, dArray2[i], 0, n);
        }
        return dArray2;
    }

    @Override
    public double[] recompose(double[][] dArray, int n) throws JWaveException {
        if (n < 0 || n >= dArray.length) {
            throw new JWaveFailure("WaveletTransform#recompose - given level is out of range");
        }
        return this.reverse(dArray[n], n);
    }
}

