/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets;

import java.util.Arrays;

public abstract class Wavelet {
    protected String _name = null;
    protected int _motherWavelength = 0;
    protected int _transformWavelength = 0;
    protected double[] _scalingDeCom = null;
    protected double[] _waveletDeCom = null;
    protected double[] _scalingReCon = null;
    protected double[] _waveletReCon = null;

    protected void _buildOrthonormalSpace() {
        int n;
        this._waveletDeCom = new double[this._motherWavelength];
        for (n = 0; n < this._motherWavelength; ++n) {
            this._waveletDeCom[n] = n % 2 == 0 ? this._scalingDeCom[this._motherWavelength - 1 - n] : -this._scalingDeCom[this._motherWavelength - 1 - n];
        }
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (n = 0; n < this._motherWavelength; ++n) {
            this._scalingReCon[n] = this._scalingDeCom[n];
            this._waveletReCon[n] = this._waveletDeCom[n];
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this.getName();
    }

    public int getMotherWavelength() {
        return this._motherWavelength;
    }

    public int getTransformWavelength() {
        return this._transformWavelength;
    }

    public final double[] getScalingDeComposition() {
        return Arrays.copyOf(this._scalingDeCom, this._scalingDeCom.length);
    }

    public final double[] getWaveletDeComposition() {
        return Arrays.copyOf(this._waveletDeCom, this._waveletDeCom.length);
    }

    public final double[] getScalingReConstruction() {
        return Arrays.copyOf(this._scalingReCon, this._scalingReCon.length);
    }

    public final double[] getWaveletReConstruction() {
        return Arrays.copyOf(this._waveletReCon, this._waveletReCon.length);
    }

    public double[] forward(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = dArray2.length >> 1;
        for (int i = 0; i < n2; ++i) {
            dArray2[i + n2] = 0.0;
            dArray2[i] = 0.0;
            for (int j = 0; j < this._motherWavelength; ++j) {
                int n3;
                for (n3 = (i << 1) + j; n3 >= dArray2.length; n3 -= dArray2.length) {
                }
                int n4 = i;
                dArray2[n4] = dArray2[n4] + dArray[n3] * this._scalingDeCom[j];
                int n5 = i + n2;
                dArray2[n5] = dArray2[n5] + dArray[n3] * this._waveletDeCom[j];
            }
        }
        return dArray2;
    }

    public double[] reverse(double[] dArray, int n) {
        int n2;
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = 0.0;
        }
        n2 = dArray2.length >> 1;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int n3;
                for (n3 = (i << 1) + j; n3 >= dArray2.length; n3 -= dArray2.length) {
                }
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + (dArray[i] * this._scalingReCon[j] + dArray[i + n2] * this._waveletReCon[j]);
            }
        }
        return dArray2;
    }
}

