/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.biorthogonal;

import jwave.transforms.wavelets.Wavelet;

public class BiOrthogonal
extends Wavelet {
    protected void _buildBiOrthonormalSpace() {
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (int i = 0; i < this._motherWavelength; ++i) {
            if (i % 2 == 0) {
                this._scalingReCon[i] = -this._waveletDeCom[i];
                this._waveletReCon[i] = -this._scalingDeCom[i];
                continue;
            }
            this._scalingReCon[i] = this._waveletDeCom[i];
            this._waveletReCon[i] = this._scalingDeCom[i];
        }
    }

    @Override
    public double[] forward(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        int n2 = dArray2.length >> 1;
        for (int i = 0; i < n2; ++i) {
            dArray2[i + n2] = 0.0;
            dArray2[i] = 0.0;
            for (int j = 0; j < this._motherWavelength; ++j) {
                int n3;
                for (n3 = (i << 1) + j; n3 >= dArray2.length; n3 -= dArray2.length) {
                }
                int n4 = i;
                dArray2[n4] = dArray2[n4] + dArray[n3] * this._scalingDeCom[j];
                int n5 = i + n2;
                dArray2[n5] = dArray2[n5] + dArray[n3] * this._waveletDeCom[j];
            }
        }
        return dArray2;
    }

    @Override
    public double[] reverse(double[] dArray, int n) {
        int n2;
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            dArray2[n2] = 0.0;
        }
        n2 = dArray2.length >> 1;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int n3;
                for (n3 = (i << 1) + j; n3 >= dArray2.length; n3 -= dArray2.length) {
                }
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + (dArray[i] * this._scalingReCon[j] + dArray[i + n2] * this._waveletReCon[j]);
            }
        }
        return dArray2;
    }
}

