/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.daubechies;

import jwave.transforms.wavelets.Wavelet;

public class Daubechies2
extends Wavelet {
    public Daubechies2() {
        this._name = "Daubechies 2";
        this._transformWavelength = 2;
        this._motherWavelength = 4;
        double d = Math.sqrt(3.0);
        this._scalingDeCom = new double[this._motherWavelength];
        this._scalingDeCom[0] = (1.0 + d) / 4.0;
        this._scalingDeCom[1] = (3.0 + d) / 4.0;
        this._scalingDeCom[2] = (3.0 - d) / 4.0;
        this._scalingDeCom[3] = (1.0 - d) / 4.0;
        double d2 = Math.sqrt(2.0);
        int n = 0;
        while (n < this._motherWavelength) {
            int n2 = n++;
            this._scalingDeCom[n2] = this._scalingDeCom[n2] / d2;
        }
        this._buildOrthonormalSpace();
    }
}

