/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.daubechies;

import jwave.transforms.wavelets.Wavelet;

public class Daubechies3
extends Wavelet {
    public Daubechies3() {
        this._name = "Daubechies 3";
        this._transformWavelength = 2;
        this._motherWavelength = 6;
        this._scalingDeCom = new double[this._motherWavelength];
        double d = Math.sqrt(10.0);
        double d2 = Math.sqrt(5.0 + 2.0 * d);
        this._scalingDeCom[0] = (1.0 + 1.0 * d + 1.0 * d2) / 16.0;
        this._scalingDeCom[1] = (5.0 + 1.0 * d + 3.0 * d2) / 16.0;
        this._scalingDeCom[2] = (10.0 - 2.0 * d + 2.0 * d2) / 16.0;
        this._scalingDeCom[3] = (10.0 - 2.0 * d - 2.0 * d2) / 16.0;
        this._scalingDeCom[4] = (5.0 + 1.0 * d - 3.0 * d2) / 16.0;
        this._scalingDeCom[5] = (1.0 + 1.0 * d - 1.0 * d2) / 16.0;
        double d3 = Math.sqrt(2.0);
        int n = 0;
        while (n < this._motherWavelength) {
            int n2 = n++;
            this._scalingDeCom[n2] = this._scalingDeCom[n2] / d3;
        }
        this._buildOrthonormalSpace();
    }
}

