/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.commons.actions.AbstractITextConfigurationEvent;
import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.producer.ProducerBuilder;
import com.itextpdf.text.actions.data.IText5ProductData;
import com.itextpdf.text.actions.events.IText5ProductEvent;
import com.itextpdf.text.pdf.statistics.NumberOfPagesStatisticsEvent;
import com.itextpdf.text.pdf.statistics.SizeOfPdfStatisticsEvent;
import java.util.ArrayList;

final class UnifiedVersionUtil {
    private static final UnifiedVersionEvent UNIFIED_VERSION_EVENT = new UnifiedVersionEvent();

    private UnifiedVersionUtil() {
    }

    static void onEventUsage() {
        IText5ProductEvent processPdfUnifiedEvent = IText5ProductEvent.createProcessPdfEvent();
        EventManager.getInstance().onEvent((IEvent)processPdfUnifiedEvent);
        EventManager.getInstance().onEvent((IEvent)new ConfirmEvent((AbstractProductProcessITextEvent)processPdfUnifiedEvent));
    }

    static void onEventStatistic(long amountOfBytes, int numberOfPages) {
        EventManager.getInstance().onEvent((IEvent)new SizeOfPdfStatisticsEvent(amountOfBytes, IText5ProductData.getInstance()));
        EventManager.getInstance().onEvent((IEvent)new NumberOfPagesStatisticsEvent(numberOfPages, IText5ProductData.getInstance()));
    }

    static String getProducer(String oldProducer) {
        IText5ProductEvent processPdfUnifiedEvent = IText5ProductEvent.createProcessPdfEvent();
        ArrayList<IText5ProductEvent> unifiedEvents = new ArrayList<IText5ProductEvent>();
        unifiedEvents.add(processPdfUnifiedEvent);
        return ProducerBuilder.modifyProducer(unifiedEvents, (String)oldProducer);
    }

    static boolean isAGPLVersion() {
        return UNIFIED_VERSION_EVENT.isAGPLVersion();
    }

    private static class UnifiedVersionEvent
    extends AbstractITextConfigurationEvent {
        private UnifiedVersionEvent() {
        }

        protected void doAction() {
            throw new IllegalStateException("Configuration events for util internal purposes are not expected to be sent");
        }

        boolean isAGPLVersion() {
            return this.getActiveProcessor(IText5ProductData.getInstance().getProductName()) == null;
        }
    }
}

