/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.actions.data.ProductData;
import com.itextpdf.text.pdf.statistics.NumberOfPagesStatisticsAggregator;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOfPagesStatisticsEvent
extends AbstractStatisticsEvent {
    private static final String NUMBER_OF_PAGES_STATISTICS = "numberOfPages";
    private final int numberOfPages;

    public NumberOfPagesStatisticsEvent(int numberOfPages, ProductData productData) {
        super(productData);
        if (numberOfPages < 0) {
            throw new IllegalStateException("Number of pages can not be negative.");
        }
        this.numberOfPages = numberOfPages;
    }

    public AbstractStatisticsAggregator createStatisticsAggregatorFromName(String statisticsName) {
        if (NUMBER_OF_PAGES_STATISTICS.equals(statisticsName)) {
            return new NumberOfPagesStatisticsAggregator();
        }
        return super.createStatisticsAggregatorFromName(statisticsName);
    }

    public List<String> getStatisticsNames() {
        return Collections.singletonList(NUMBER_OF_PAGES_STATISTICS);
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }
}

