/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim;

import com.mazet.biostim.ProgEnCours;
import com.mazet.biostim.comm.RS232;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.Skin;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.utils.Version;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.configuration.ConfigurationMainViewCtrl;
import com.mazet.biostim.view.main.MenuController;
import com.mazet.biostim.view.planche.Planche;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.Patient;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class Main
extends Application {
    private static Config config;
    public static Main main;
    private static String configFile;
    private static boolean firstStop;
    public static Stage primaryStage;
    public static Scene sceneMain;
    public static BorderPane mainLayout;
    private static Pane menuView;
    public static MenuController menu;
    public static String debugFileName;
    static Patient currentPatient;
    public static Patient tempPatient;
    private static String categorie;
    public static ProgEnCours progEnCours;
    public static Controller currentController;
    private static ServerSocket serverSocket;

    public static void main(String[] args) {
        if (args.length > 0) {
            configFile = args[0];
        }
        Main.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        try {
            Utils.debugInfo("D\u00e9marrage");
            main = this;
            config = Config.getConfigFromJson(configFile);
            if (Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().toLowerCase().endsWith(".jar")) {
                Utils.deleteOldFiles(config.getSauvegarde_auto(), "debug");
                String date = Utils.fileDateFormat.format(new Date());
                debugFileName = config.getSauvegarde_auto() + "/debug_" + date + ".txt";
                Utils.debugInfo("redirecting output to " + debugFileName);
                try {
                    PrintStream out = new PrintStream(Files.newOutputStream(Paths.get(debugFileName, new String[0]), new OpenOption[0]));
                    System.setOut(out);
                    System.setErr(out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            TransientConfig.choixLangue();
            Utils.debugInfo("numero de version : %s / %d%nsave path : %s%ncwd : %s%njar : %s%n%s %s %s bit (%s)%nos : %s (%s %s)", Version.versionSoft, Version.numVersionSoft, Computer.absolutePath, new File(".").getAbsolutePath(), Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), System.getProperty("java.runtime.name"), System.getProperty("java.version"), System.getProperty("sun.arch.data.model"), System.getProperty("java.vendor"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"));
            if (Main.config.verifLancementsMultiples) {
                this.verifLancementsMultiples();
            }
            new Thread(AnimationStyle::initAnimationList).start();
            Planche.initPlanches();
            Main.primaryStage = primaryStage;
            this.showMainView();
            Main.showMenuView();
            menu.goToHome();
            new Thread(Biostim::simulation).start();
            new Thread(() -> {
                try {
                    String bootTime = Computer.getBootTime();
                    String proc = Computer.getProcName();
                    Runtime runtime = Runtime.getRuntime();
                    Utils.debugInfo("version %s%nprotocole v%d : activation %s (bt %d)%ncode FTDI %06d (%s)%s%n%s %s %s bit (%s)%nos : %s (%s %s)%nProc : %s%n%d proc, mem free %d Mo / total %d Mo / max %d Mo%nBoot time : %s%n", MenuController.logoName, Main.config.versionProtocole, Main.config.isActivated, Main.config.optionBluetooth, Security.getHardKey(), Security.getBiostimPort(), Main.config.versionProtocole != 0 ? String.format(" / id Biostim %06d", Main.config.idBiostim) : String.format(" / activation %06d / bt %06d", Main.config.activationKey, Main.config.btKey), System.getProperty("java.runtime.name"), System.getProperty("java.version"), System.getProperty("sun.arch.data.model"), System.getProperty("java.vendor"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), proc, runtime.availableProcessors(), runtime.freeMemory() / 1024L / 1024L, runtime.totalMemory() / 1024L / 1024L, runtime.maxMemory() / 1024L / 1024L, bootTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            RS232.init();
            new Thread(() -> {
                Security.verifStart();
                ConfigurationMainViewCtrl.verifNewVersion();
                ConfigurationMainViewCtrl.verifOneTimeBackupAndAptitude();
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void stop() {
        if (firstStop) {
            Utils.debugInfo("On quitte le programme");
            if (UsbBiostim.nbComErrors > 0) {
                Utils.debugInfo("!!!!!!!!!! %d erreur(s) de COM !!!!!!!!!!", UsbBiostim.nbComErrors);
                if (UsbBiostim.nbComErrors > 5) {
                    CloudManager.sendJdd("%d erreurs de COM", UsbBiostim.nbComErrors);
                }
            }
            firstStop = false;
            try {
                currentController.exitAction();
                primaryStage.close();
                AnchorPane pane = new AnchorPane();
                URL imageUrl = ((Object)((Object)this)).getClass().getResource("/img/logo.png");
                pane.setStyle("-fx-background-image: url('" + imageUrl.toExternalForm() + "'); -fx-background-size: 400 auto; -fx-background-repeat: no-repeat; -fx-background-position: center; -fx-background-color: white;");
                Scene scene = new Scene((Parent)pane, 600.0, 400.0);
                Stage stage = new Stage();
                stage.setScene(scene);
                stage.setTitle("Backup Biostim");
                stage.show();
                new Timer().schedule(new TimerTask(this){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public void run() {
                        SondeBT.stop();
                        config.createBackup(config.getSauvegarde_auto(), true);
                        Utils.debugInfo("Backup OK");
                        Utils.debugInfo("Exit");
                        Platform.exit();
                        System.exit(0);
                    }
                }, 50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showMainView() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setResources(TransientConfig.langue);
        loader.setLocation(Main.class.getResource("/com/mazet/biostim/view/main/MainView.fxml"));
        mainLayout = (BorderPane)loader.load();
        Font.loadFont((String)Main.class.getResource("/font/Inter_24pt-Regular.ttf").toExternalForm(), (double)24.0);
        Font.loadFont((String)Main.class.getResource("/font/Inter_24pt-Bold.ttf").toExternalForm(), (double)24.0);
        Main.setCSS();
        Platform.runLater(() -> primaryStage.getIcons().add((Object)new Image(Main.class.getResource("/img/icone.png").toExternalForm())));
        primaryStage.setTitle("BioStim");
        sceneMain = new Scene((Parent)mainLayout);
        primaryStage.setScene(sceneMain);
        primaryStage.show();
        primaryStage.setFullScreenExitHint("");
        if (!Version.isSAV()) {
            primaryStage.setFullScreen(true);
        }
        System.out.format("resolution : %.0f*%.0f / echelle %.2f%n", primaryStage.getWidth(), primaryStage.getHeight(), primaryStage.getOutputScaleX());
    }

    public static void setCSS() {
        URL skin_distri;
        Main.setMainStyle();
        URL skin = Skin.getCss();
        if (skin != null) {
            mainLayout.getStylesheets().add((Object)skin.toExternalForm());
        }
        if (!Main.config.distributeur.isEmpty() && (skin_distri = Main.class.getResource("/style/style_distri_" + Main.config.distributeur + ".css")) != null) {
            mainLayout.getStylesheets().add((Object)skin_distri.toExternalForm());
        }
        mainLayout.setStyle(String.format("-fx-font-size: %d", (int)(Font.getDefault().getSize() * (0.55 + (double)Main.config.tailleChar * 0.15))));
        if (menu != null) {
            menu.updateMenuWidth();
        }
    }

    public static void setMainStyle() {
        mainLayout.getStylesheets().removeIf(s -> s.contains("main-style"));
        try {
            String style = Utils.readFileInJar("/style/style_home.css");
            style = style.replace("{SKIN_PATH}", Skin.getImgPath());
            String imageUrl = Main.class.getResource("/img/logo.png").toExternalForm();
            imageUrl = imageUrl.substring(0, imageUrl.length() - 8);
            style = style.replace("/img/", imageUrl);
            File tempCssFile = File.createTempFile("main-style", ".css");
            tempCssFile.deleteOnExit();
            Files.writeString(tempCssFile.toPath(), (CharSequence)style, StandardCharsets.UTF_8, new OpenOption[0]);
            mainLayout.getStylesheets().setAll((Object[])new String[]{tempCssFile.toURI().toString()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addDynamicCSS(String style) {
        mainLayout.getStylesheets().removeIf(s -> s.contains("dynamic-style"));
        try {
            File tempCssFile = File.createTempFile("dynamic-style", ".css");
            tempCssFile.deleteOnExit();
            Files.writeString(tempCssFile.toPath(), (CharSequence)style, StandardCharsets.UTF_8, new OpenOption[0]);
            mainLayout.getStylesheets().add((Object)tempCssFile.toURI().toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void showMenuView() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(TransientConfig.langue);
            loader.setLocation(Main.class.getResource("/com/mazet/biostim/view/main/MenuView.fxml"));
            menuView = (Pane)loader.load();
            if (loader.getController() instanceof MenuController) {
                menu = (MenuController)loader.getController();
                menu.setMain();
            }
            mainLayout.setLeft((Node)menuView);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void changeCenterView(String folder, String view, ToggleButton button) {
        Main.changeCenterView(folder + "/" + view + "View.fxml", button);
    }

    public static void changeCenterView(String view, ToggleButton button) {
        try {
            currentController.exitAction();
            mainLayout.setLeft((Node)menuView);
            menu.changeVignette();
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(TransientConfig.langue);
            loader.setLocation(Main.class.getResource("/com/mazet/biostim/view/" + view));
            mainLayout.setCenter((Node)loader.load());
            currentController = (Controller)loader.getController();
            currentController.setMain();
            for (ToggleButton but : Main.menu.toggleButtons) {
                but.setSelected(but == button);
            }
        }
        catch (Exception e) {
            Utils.popupAlert("Erreur lors de l affichage des pages : " + String.valueOf(e));
            e.printStackTrace();
        }
    }

    public static Patient getCurrentPatient() {
        return currentPatient;
    }

    public static void setCurrentPatient(Patient currentPatient) {
        Main.currentPatient = currentPatient;
    }

    public static String getCategorie() {
        return categorie;
    }

    public static void setCategorie(String categorie) {
        Main.categorie = categorie;
    }

    public static Config getConfig() {
        return config;
    }

    public static void reinitConfig() {
        config = new Config();
        config.saveConfig();
    }

    public static void telecommandeStop() {
        Platform.runLater(() -> currentController.stopAction());
    }

    public static void telecommandePause() {
        Platform.runLater(() -> currentController.pauseAction());
    }

    public static void telecommandeAMoins() {
        Platform.runLater(() -> currentController.aMoinsAction());
    }

    public static void telecommandeAPlus() {
        Platform.runLater(() -> currentController.aPlusAction());
    }

    public static void telecommandeBMoins() {
        Platform.runLater(() -> currentController.bMoinsAction());
    }

    public static void telecommandeBPlus() {
        Platform.runLater(() -> currentController.bPlusAction());
    }

    private void verifLancementsMultiples() {
        try {
            try {
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(true);
                serverSocket.bind(new InetSocketAddress("127.0.0.1", 61976));
            }
            catch (Exception e) {
                try {
                    Utils.debugInfo("deja un biostim ouvert, on le reveille (%s)", e);
                    new Socket("127.0.0.1", 61976);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                System.exit(0);
            }
            new Thread(() -> {
                try {
                    while (true) {
                        serverSocket.accept().close();
                        Utils.debugInfo("connection recue (lancement d'un autre biostim) : reprise du focus");
                        Platform.runLater(() -> {
                            primaryStage.setFullScreen(true);
                            primaryStage.toFront();
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        firstStop = true;
        debugFileName = null;
        progEnCours = null;
        currentController = new Controller();
    }
}

