/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.UsbBiopod;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.configuration.BiopodTest;

public class RawDataBioPod {
    char voie;
    private int stopTampon = 0;
    private int sizeTampon = 0;
    private final double[] tampon = new double[16384];
    private long lastCompteurRaw = 0L;
    private static final long tailleWindowsMesurePerte = 250L;
    int nbTotalOK = 0;
    long firstCompteur;
    int nbOK = 0;
    int nbCoupure = 1;
    int nbTrame;
    long currentWindow = 0L;

    RawDataBioPod(char voie) {
        this.voie = voie;
    }

    synchronized void decodeBTRawBioPod(String[] decoupe) {
        try {
            long compteur = RawDataBioPod.intAtPos(decoupe[1], decoupe[1].length() - 8);
            if (compteur <= this.lastCompteurRaw && compteur > this.lastCompteurRaw - 10L) {
                return;
            }
            this.checkCompteurTournant(compteur);
            int fin = decoupe[1].length() - 8;
            for (int i = 0; i < fin; i += 8) {
                float val = Float.intBitsToFloat(RawDataBioPod.intAtPos(decoupe[1], i));
                if (BiopodTest.enregEnCours != null) {
                    BiopodTest.enregEnCours.write(String.format("%f\r\n", Float.valueOf(val)));
                }
                this.tampon[this.stopTampon % 16384] = val;
                this.stopTampon = (this.stopTampon + 1) % 16384;
                ++this.sizeTampon;
            }
            if (this.sizeTampon > 16384) {
                this.sizeTampon = 16384;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void decodeUsbRawBioPod(int[] trame) {
        try {
            int compteur = UsbBiopod.readIntInTab(trame, trame.length - 4);
            this.checkCompteurTournant(compteur);
            int fin = trame.length - 4;
            for (int i = 4; i < fin; i += 4) {
                float val = Float.intBitsToFloat(UsbBiopod.readIntInTab(trame, i));
                if (BiopodTest.enregEnCours != null) {
                    BiopodTest.enregEnCours.write(String.format("%f\r\n", Float.valueOf(val)));
                }
                this.tampon[this.stopTampon % 16384] = val;
                this.stopTampon = (this.stopTampon + 1) % 16384;
                ++this.sizeTampon;
            }
            if (this.sizeTampon > 16384) {
                this.sizeTampon = 16384;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void checkCompteurTournant(long compteur) {
        if (this.nbTotalOK == 0) {
            this.firstCompteur = compteur;
            this.lastCompteurRaw = compteur - 1L;
        }
        ++this.nbTotalOK;
        long window = compteur / 250L;
        if (window != this.currentWindow) {
            Main.currentController.updateAffPertes((float)(250L - (long)this.nbOK) / 250.0f, this.nbTotalOK / this.nbCoupure);
            this.currentWindow = window;
            this.nbOK = 0;
        }
        ++this.nbTrame;
        if (compteur != this.lastCompteurRaw + 1L) {
            ++this.nbCoupure;
            Utils.debugLine("voie %s : %5d trames ok, %2d trame(s) perdue(s) (%d + 1 != %d)", Character.valueOf(this.voie), this.nbTrame, compteur - this.lastCompteurRaw - 1L, this.lastCompteurRaw, compteur);
            this.stopTampon = 0;
            this.sizeTampon = 0;
            this.nbTrame = 0;
        } else {
            ++this.nbOK;
        }
        this.lastCompteurRaw = compteur;
    }

    public static int intAtPos(String trame, int pos) {
        return (Integer.parseInt(trame.substring(pos + 0, pos + 2), 16) << 0) + (Integer.parseInt(trame.substring(pos + 2, pos + 4), 16) << 8) + (Integer.parseInt(trame.substring(pos + 4, pos + 6), 16) << 16) + (Integer.parseInt(trame.substring(pos + 6, pos + 8), 16) << 24);
    }

    public synchronized boolean getTamponRaw(double[] tab, int size) {
        if (this.sizeTampon < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            tab[i] = this.tampon[(this.stopTampon + 16384 - size + i) % 16384];
        }
        return true;
    }
}

