/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.comm;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.mazet.biostim.Main;
import com.mazet.biostim.comm.RS232;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.Security;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.configuration.Autotest;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;

public abstract class UsbBiostim {
    public static SerialPort serialPort = null;
    public static long openDate;
    public static int connexionBioStim;
    public static boolean isL1;
    private static int etatPoire;
    private static String trameTemp;
    private static boolean activationGenerateur;
    private static int nbStartStim;
    public static double deltaStim;
    public static double voieBfbABrut;
    public static double voieBfbBBrut;
    public static double voiePressionBrut;
    public static double voiePression2Brut;
    private static int gainVoieA;
    private static int gainVoieB;
    private static long invalidTimeA;
    private static long invalidTimeB;
    private static final long dureeInvalidCalibre = 250L;
    private static final long dureeInvalidStim = 2000L;
    private static boolean maintien;
    private static long disableSecuStim;
    private static long disableIncrStim;
    private static long disableIncrStim2;
    static boolean receptionTrameG;
    static boolean aucunEnvoie;
    public static int nbComErrors;
    private static final ArrayList<String> messagesEnAttente;
    private static final ArrayList<Boolean> typeMsgEnAttente;
    static boolean attenteReponse;
    private static final ReentrantLock mutexInit;
    private static double prevValStim;

    static boolean searchBiostim() {
        return connexionBioStim == 0;
    }

    static void initConnexion(SerialPort portName) {
        if (mutexInit.tryLock()) {
            try {
                connexionBioStim = 1;
                serialPort = portName;
                Utils.debugInfo("Trying Biostim Port " + serialPort.getSystemPortName());
                openDate = System.currentTimeMillis();
                serialPort.setBaudRate(19200);
                serialPort.setNumDataBits(8);
                serialPort.setNumStopBits(1);
                serialPort.setParity(2);
                serialPort.setFlowControl(0);
                serialPort.addDataListener(new SerialPortDataListener(){

                    public int getListeningEvents() {
                        return 1;
                    }

                    public void serialEvent(SerialPortEvent event) {
                        UsbBiostim.rs232SerialEvent(event);
                    }
                });
                if (!serialPort.openPort()) {
                    return;
                }
                messagesEnAttente.clear();
                typeMsgEnAttente.clear();
                serialPort.clearDTR();
                Utils.sleep(200L);
                serialPort.setDTR();
                Utils.sleep(300L);
                isL1 = false;
                UsbBiostim.sendMessageSync("&l0;1");
                Utils.sleep(300L);
                serialPort.setDTR();
                Utils.sleep(300L);
                serialPort.clearDTR();
                Utils.sleep(300L);
                serialPort.setDTR();
                Utils.sleep(300L);
                isL1 = true;
                UsbBiostim.sendMessageSync("&l1;1");
                Utils.sleep(500L);
                UsbBiostim.sendMessageAsync("&i", true);
                UsbBiostim.initBioStim();
                UsbBiostim.initTarrage();
                receptionTrameG = false;
                double timeWithoutComm = 0.0;
                while (connexionBioStim > 1) {
                    if (receptionTrameG) {
                        receptionTrameG = false;
                        timeWithoutComm = 0.0;
                    } else {
                        timeWithoutComm += 0.3;
                    }
                    if (timeWithoutComm > 3.0) {
                        Utils.debugInfo("3s sans donnee BioStim sur %s (ports : %s)", serialPort.getSystemPortName(), RS232.getPortsListNames());
                        return;
                    }
                    if (aucunEnvoie) {
                        attenteReponse = false;
                        UsbBiostim.nextMessageAsync();
                    }
                    aucunEnvoie = true;
                    Utils.sleep(300L);
                }
            }
            catch (Exception e) {
                Utils.debugLine(e, 1, "%s", e);
            }
            finally {
                UsbBiostim.closeConnexion();
                mutexInit.unlock();
            }
        }
    }

    static void closeConnexion() {
        if (serialPort != null) {
            if (connexionBioStim == 2 && Main.progEnCours != null) {
                Main.telecommandeStop();
                Platform.runLater(() -> CloudManager.sendJdd("Perte de Com Biostim en cours de programme", new Object[0]));
            }
            Utils.debugInfo("Close connexion Biostim");
            try {
                if (serialPort.isOpen()) {
                    serialPort.clearDTR();
                }
                serialPort.removeDataListener();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                serialPort.closePort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Utils.sleep(500L);
            serialPort = null;
        }
        if (connexionBioStim != 0) {
            connexionBioStim = 0;
            Main.menu.changeHomeStatus();
        }
    }

    public static void initStimInnervee(int nbVoie, long tTravail, long tRepos, long tMontee, long tDescente, long tTravail2, long tRepos2, long tMontee2, long tDescente2, int bFrequence, int frequenceMotif, int lImpulsion, int frequenceMotif2, int lImpulsion2, int delai2Impulsion, int largeurL2, int frequenceL2, int dissymetrique, int hauteTension, int impMonophasique, int polarite, int largeurL3, int frequenceF3, boolean reposActif, boolean reposActif2) {
        try {
            disableSecuStim = System.currentTimeMillis() + (long)Main.getConfig().ignoreSecu;
            Object initStimulation = "&a1;";
            initStimulation = (String)initStimulation + tTravail + ";";
            initStimulation = (String)initStimulation + tRepos + ";";
            initStimulation = (String)initStimulation + tMontee + ";";
            initStimulation = (String)initStimulation + tDescente + ";";
            initStimulation = (String)initStimulation + bFrequence + ";";
            initStimulation = (String)initStimulation + frequenceMotif + ";";
            initStimulation = (String)initStimulation + lImpulsion + ";";
            initStimulation = (String)initStimulation + delai2Impulsion + ";";
            initStimulation = (String)initStimulation + largeurL2 + ";";
            initStimulation = (String)initStimulation + frequenceL2 + ";";
            initStimulation = (String)initStimulation + dissymetrique + ";";
            initStimulation = (String)initStimulation + hauteTension + ";";
            initStimulation = (String)initStimulation + impMonophasique + ";";
            initStimulation = (String)initStimulation + polarite + ";";
            initStimulation = (String)initStimulation + largeurL3 + ";";
            initStimulation = (String)initStimulation + frequenceF3;
            if (Main.getConfig().versionProtocole == 1) {
                initStimulation = (String)initStimulation + ";" + (reposActif ? 1 : 0);
            }
            UsbBiostim.sendMessageAsync((String)initStimulation, true);
            if (nbVoie > 1 || Main.getConfig().versionProtocole == 1 && Main.getConfig().nbVoiesStim() > 1) {
                Object initStimulation2 = "&a2;";
                initStimulation2 = (String)initStimulation2 + tTravail2 + ";";
                initStimulation2 = (String)initStimulation2 + tRepos2 + ";";
                initStimulation2 = (String)initStimulation2 + tMontee2 + ";";
                initStimulation2 = (String)initStimulation2 + tDescente2 + ";";
                initStimulation2 = (String)initStimulation2 + bFrequence + ";";
                initStimulation2 = (String)initStimulation2 + frequenceMotif2 + ";";
                initStimulation2 = (String)initStimulation2 + lImpulsion2 + ";";
                initStimulation2 = (String)initStimulation2 + delai2Impulsion + ";";
                initStimulation2 = (String)initStimulation2 + largeurL2 + ";";
                initStimulation2 = (String)initStimulation2 + frequenceL2 + ";";
                initStimulation2 = (String)initStimulation2 + dissymetrique + ";";
                initStimulation2 = (String)initStimulation2 + hauteTension + ";";
                initStimulation2 = (String)initStimulation2 + impMonophasique + ";";
                initStimulation2 = (String)initStimulation2 + polarite + ";";
                initStimulation2 = (String)initStimulation2 + largeurL3 + ";";
                initStimulation2 = (String)initStimulation2 + frequenceF3;
                if (Main.getConfig().versionProtocole == 1) {
                    initStimulation2 = (String)initStimulation2 + ";" + (reposActif2 ? 1 : 0);
                }
                UsbBiostim.sendMessageAsync((String)initStimulation2, true);
            }
            UsbBiostim.activateGenerateur(nbVoie, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void activateGenerateur(int nbVoie, boolean actif) {
        block11: {
            try {
                String strActif;
                nbStartStim = 0;
                String string = strActif = actif ? "1" : "0";
                if (Main.getConfig().versionProtocole == 0) {
                    UsbBiostim.sendMessageAsync("&k", true);
                    if (!actif) {
                        UsbBiostim.amplitudeVoie(0, 0.0);
                        if (nbVoie > 1) {
                            UsbBiostim.amplitudeVoie(1, 0.0);
                        }
                    }
                    UsbBiostim.sendMessageAsync("&j0;" + strActif, true);
                    if (nbVoie > 1) {
                        UsbBiostim.sendMessageAsync("&j1;" + strActif, true);
                    }
                    UsbBiostim.sendMessageAsync("&k", true);
                } else {
                    UsbBiostim.sendMessageAsync("&k0", true);
                    if (!actif) {
                        UsbBiostim.amplitudeVoie(0, 0.0);
                        UsbBiostim.amplitudeVoie(1, 0.0);
                    }
                    UsbBiostim.sendMessageAsync("&j" + (Main.getConfig().nbVoiesStim() == 1 ? 1 : 3) + ";" + strActif, true);
                    if (actif) {
                        UsbBiostim.amplitudeVoie(0, 0.0);
                        UsbBiostim.amplitudeVoie(1, 0.0);
                    }
                    UsbBiostim.sendMessageAsync("&k1", true);
                }
                if (actif) break block11;
                try {
                    voieBfbABrut = Biostim.voieBfbA = Main.progEnCours.getBase(0);
                    voieBfbBBrut = Biostim.voieBfbB = Main.progEnCours.getBase(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                invalidTimeA = invalidTimeB = System.currentTimeMillis() + 2000L;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void amplitudeVoie(int numVoie, double valPourcent) {
        if (Main.progEnCours != null && valPourcent > prevValStim + 0.1) {
            int freq;
            int deltams = 20;
            int n = freq = numVoie == 0 ? Main.progEnCours.currentPageProgram.getFreq() : Main.progEnCours.currentPageProgram.getFreq2();
            if (freq < 60) {
                deltams = Math.min(200, 1200 / freq);
            }
            if (numVoie == 0) {
                disableIncrStim = System.currentTimeMillis() + (long)deltams;
            } else {
                disableIncrStim2 = System.currentTimeMillis() + (long)deltams;
            }
            prevValStim = valPourcent;
        }
        try {
            int val = Main.getConfig().versionProtocole != 0 ? (int)(valPourcent * 2.0) : (int)(valPourcent * 255.0 / 100.0);
            Object ampVoie = "&d";
            ampVoie = (String)ampVoie + numVoie + ";";
            ampVoie = (String)ampVoie + val;
            UsbBiostim.sendMessageAsync((String)ampVoie, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void activerChienGarde() {
        String message = "&y";
        while (true) {
            UsbBiostim.sendMessageAsync(message, false);
            Utils.sleep(700L);
        }
    }

    static void initTarrage() {
        try {
            if (Main.getConfig().versionProtocole != 0) {
                UsbBiostim.paramBfb(0, 1);
                UsbBiostim.paramBfb(1, 1);
            } else {
                UsbBiostim.paramBfb(0, 7);
                UsbBiostim.paramBfb(1, 7);
                UsbBiostim.paramBfb(2, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void paramBfb(int voie, int gain) {
        try {
            if (voie == 0) {
                gainVoieA = gain;
            } else if (voie == 1) {
                gainVoieB = gain;
            }
            Object message = "&f";
            message = (String)message + (voie + 1) + ";" + gain;
            if (Main.getConfig().versionProtocole == 0) {
                message = (String)message + ";0";
            }
            UsbBiostim.sendMessageAsync((String)message, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void selectCalibre(int voie, double max) {
        int gain;
        if (voie > 1) {
            return;
        }
        if (Main.getConfig().versionProtocole == 0) {
            for (gain = 7; gain > 0 && max > 0.95 * (double)UsbBiostim.getGainReel(gain); --gain) {
            }
        } else {
            gain = 1;
            if (max > 0.9 * (double)UsbBiostim.getGainReel(1)) {
                gain = 0;
            }
        }
        if (voie == 0 && gain != UsbBiostim.getGainVoieA()) {
            UsbBiostim.paramBfb(voie, gain);
            invalidTimeA = System.currentTimeMillis() + 250L;
        } else if (voie == 1 && gain != UsbBiostim.getGainVoieB()) {
            UsbBiostim.paramBfb(voie, gain);
            invalidTimeB = System.currentTimeMillis() + 250L;
        }
    }

    public static void initBioStim() {
        String initBioStim = Main.getConfig().versionProtocole == 0 ? "&e1;32;1;1;1;1;1;0;0;0;0;0;0;" : "&e1";
        UsbBiostim.sendMessageAsync(initBioStim, true);
    }

    public static synchronized void sendMessageAsync(String message, Boolean expectReponse) {
        try {
            if (connexionBioStim >= 2) {
                if (!attenteReponse && messagesEnAttente.isEmpty()) {
                    UsbBiostim.sendMessageSync(message);
                    attenteReponse = expectReponse;
                } else {
                    messagesEnAttente.add(message);
                    typeMsgEnAttente.add(expectReponse);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static synchronized void nextMessageAsync() {
        try {
            boolean first = true;
            while (!attenteReponse && !messagesEnAttente.isEmpty()) {
                if (!first) {
                    Utils.sleep(20L);
                }
                first = false;
                UsbBiostim.sendMessageSync(messagesEnAttente.getFirst());
                attenteReponse = typeMsgEnAttente.getFirst();
                messagesEnAttente.removeFirst();
                typeMsgEnAttente.removeFirst();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendMessageSync(String message) {
        try {
            aucunEnvoie = false;
            if (message.startsWith("&d") && !message.endsWith(";0")) {
                Utils.debugInfo("niveau voie %s : %s", message.charAt(2) == '0' ? "A" : "B", message.substring(4));
            }
            if (message.charAt(1) == 'j') {
                activationGenerateur = message.charAt(4) == '1';
            }
            byte[] temp = message.getBytes();
            byte[] msg = new byte[temp.length + 2];
            System.arraycopy(temp, 0, msg, 0, temp.length);
            msg[temp.length] = 13;
            msg[temp.length + 1] = UsbBiostim.calculCRC(message);
            serialPort.writeBytes(msg, msg.length);
        }
        catch (Exception e) {
            Utils.debugInfo("Erreur envoi message : " + String.valueOf(e));
        }
    }

    private static byte calculCRC(String temps) {
        int crc = 0;
        for (int i = 0; i < temps.length(); ++i) {
            crc += temps.charAt(i);
        }
        return (byte)(crc %= 256);
    }

    private static void decodeTrame(String trame, boolean partiel) {
        block38: {
            block37: {
                if (connexionBioStim < 2 && (trame.length() <= 2 || trame.charAt(0) != '&' || trame.charAt(1) != 'l')) {
                    Utils.debugInfo("bruit dans la com au d\u00e9marrage");
                    return;
                }
                if (trame.charAt(0) != '&' || trame.length() <= 2) break block37;
                block0 : switch (trame.charAt(1)) {
                    case 'a': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'k': {
                        if (!partiel || trame.length() == 4) {
                            attenteReponse = false;
                            if (partiel) {
                                trameTemp = "";
                                break;
                            }
                        }
                        break block38;
                    }
                    case 'y': {
                        if (!partiel || trame.length() == 4) {
                            attenteReponse = false;
                            if (partiel) {
                                trameTemp = "";
                                break;
                            }
                        }
                        break block38;
                    }
                    case 'l': {
                        attenteReponse = false;
                        if (trame.length() == 4 && trame.charAt(2) == '\r') {
                            Main.telecommandeStop();
                            Utils.debugInfo("--------------- Connexion Megastim OK ---------------");
                            connexionBioStim = 2;
                            deltaStim = 0.4;
                            if (partiel) {
                                trameTemp = "";
                            }
                            Security.checkKeyV0();
                            Main.getConfig().setVersionProtocole(0);
                            Main.getConfig().setCavaliers(0);
                            Main.getConfig().setIdBiostim(Security.getHardKey());
                            Main.getConfig().setNumero_serie(99000000 + Main.getConfig().idBiostim);
                        } else if (trame.length() == 5) {
                            Main.telecommandeStop();
                            if (isL1) {
                                Utils.debugInfo("--------------- Connexion Biostim OK --------------- ");
                            }
                            connexionBioStim = 2;
                            Main.getConfig().setVersionProtocole(trame.charAt(2) - 48);
                            deltaStim = 0.5;
                            if (partiel) {
                                trameTemp = "";
                            }
                        }
                        Utils.debugInfo("Reponse &l (connexion) " + trame.length() + " : version protocole " + Main.getConfig().versionProtocole);
                        Main.menu.changeHomeStatus();
                    }
                    case 'm': {
                        UsbBiostim.decodeTrameTelecommande(trame, partiel);
                        break;
                    }
                    case '0': {
                        attenteReponse = false;
                        switch (trame.charAt(2)) {
                            case '0': {
                                Utils.debugInfo("Mauvais checksum");
                                break block0;
                            }
                            case '1': {
                                Utils.debugInfo("Format des donn\u00e9es incompatible");
                                break block0;
                            }
                            case '2': {
                                Utils.debugInfo("Valeur inad\u00e9quate");
                                break block0;
                            }
                            case '3': {
                                Utils.debugInfo("Probl\u00e8me d'alimentation");
                                break block0;
                            }
                            case '4': {
                                Utils.debugInfo("Contexte inad\u00e9quat - Commande interdite \u00e0 ce stade");
                                break block0;
                            }
                            case '5': {
                                Utils.debugInfo("Commande inconnue");
                                break block0;
                            }
                            case '6': {
                                Utils.debugInfo("Impossibilit\u00e9 de passer en stim, l'arr\u00eat d'urgence est actif");
                                break block0;
                            }
                        }
                        Utils.debugInfo("Erreur incompr\u00e9hensible " + trame);
                        break;
                    }
                    default: {
                        switch (Main.getConfig().versionProtocole) {
                            case 0: {
                                UsbBiostim.decodeTrameV0(trame, partiel);
                                break block0;
                            }
                        }
                        UsbBiostim.decodeTrameV1(trame, partiel);
                        break;
                    }
                }
                break block38;
            }
            if (trame.length() == 2 && trame.charAt(0) == '\r' && trame.charAt(1) == '\u0000' || trame.length() == 1 && (trame.charAt(0) == '\r' || trame.charAt(0) == '\u0000')) {
                if (partiel) {
                    trameTemp = "";
                }
            } else if (trame.charAt(0) != '&') {
                if (connexionBioStim == 2) {
                    ++nbComErrors;
                    Object msg = " Erreur Message Inconnu sans & (" + trame.length() + ") ->";
                    for (int i = 0; i < trame.length(); ++i) {
                        msg = String.format("%s %03d", msg, trame.charAt(i) & 0xFF);
                    }
                    Utils.debugInfo((String)msg);
                }
                if (partiel) {
                    trameTemp = "";
                }
            }
        }
    }

    private static void decodeTrameV1(String trame, boolean partiel) {
        switch (trame.charAt(1)) {
            case 'g': {
                if (partiel || trame.length() <= 10) break;
                receptionTrameG = true;
                int nbVal = (trame.charAt(2) - 3) / 2;
                if ((trame.charAt(3) & '\u0001') != 0) {
                    UsbBiostim.securiteVoieA();
                }
                if ((trame.charAt(3) & 2) != 0) {
                    UsbBiostim.securiteVoieB();
                }
                if (nbVal > 0) {
                    UsbBiostim.setVoieBfbABrut((trame.charAt(4) & 0xFF) * 256 + (trame.charAt(5) & 0xFF));
                }
                if (nbVal > 1) {
                    UsbBiostim.setVoieBfbBBrut((trame.charAt(6) & 0xFF) * 256 + (trame.charAt(7) & 0xFF));
                }
                if (nbVal > 2) {
                    UsbBiostim.setVoiePressionBrut((double)(trame.charAt(8) & 0xFF) * 25.6 + (double)(trame.charAt(9) & 0xFF) * 0.1);
                }
                if (nbVal <= 3) break;
                UsbBiostim.setVoiePression2Brut((double)(trame.charAt(10) & 0xFF) * 25.6 + (double)(trame.charAt(11) & 0xFF) * 0.1);
                break;
            }
            case 'i': {
                if (partiel) break;
                attenteReponse = false;
                int posVersion = trame.indexOf(59, 2);
                int posSerie = trame.indexOf(59, posVersion + 1);
                int posId = trame.indexOf(59, posSerie + 1);
                int posCavalier = trame.indexOf(59, posId + 1);
                if (posVersion != -1 && posSerie != -1 && posId != -1 && posCavalier != -1) {
                    Main.getConfig().setVersion_biostim(trame.substring(2, posVersion));
                    Main.getConfig().setIdBiostim(Integer.parseInt(trame.substring(posSerie + 1, posId)));
                    Main.getConfig().setNumero_serie(Integer.parseInt(trame.substring(posVersion + 1, posSerie)));
                    Main.getConfig().setCavaliers(Integer.parseInt(trame.substring(posId + 1, posCavalier)));
                    int etat = trame.charAt(posCavalier + 1) - 48;
                    UsbBiostim.manageArretUrgence(etat);
                    Main.getConfig().setMem_interne(Integer.parseInt(trame.substring(posCavalier + 3, trame.length() - 3)));
                    Utils.debugInfo("Reponse &i\n    numero de version: " + Main.getConfig().version_biostim + "\n    num serie: " + Main.getConfig().numero_serie + "\n    id biostim: " + Main.getConfig().idBiostim + "\n    cavaliers: " + Main.getConfig().posCavaliers + "\n    etat systeme: " + etat + "\n    mem interne: " + Main.getConfig().mem_interne);
                    new Thread(CloudManager::checkLatestVersionAndActivation).start();
                    break;
                }
                Utils.debugInfo("Reponse &i incoherente : trame non interpr\u00e9t\u00e9e");
                break;
            }
            case 'j': {
                if (partiel && trame.length() != 4) break;
                attenteReponse = false;
                if (partiel) {
                    trameTemp = "";
                }
                if (activationGenerateur) {
                    nbStartStim += 2;
                    Utils.debugInfo("Reponse &j (activation generateur)");
                    break;
                }
                Utils.debugInfo("Reponse &j (arret generateur)");
                break;
            }
            case 'r': {
                Utils.debugInfo("Arr\u00eat d'urgence");
                Main.telecommandeStop();
                if (trame.length() <= 2) break;
                UsbBiostim.manageArretUrgence(trame.charAt(2) - 48);
                break;
            }
            case 'q': {
                boolean isOK;
                if (partiel && trame.length() != 4) break;
                Utils.debugInfo("Reponse &q (code " + trame.charAt(2) + ")");
                attenteReponse = false;
                if (partiel) {
                    trameTemp = "";
                }
                boolean bl = isOK = trame.charAt(2) == '0';
                if (isOK) {
                    Utils.popupAlert("commande OK");
                    break;
                }
                Utils.popupAlert("erreur dans la commande");
                break;
            }
            default: {
                attenteReponse = false;
                if (connexionBioStim != 2) break;
                ++nbComErrors;
                Object msg = " Erreur Message Inconnu v1 (" + trame.length() + ") ->";
                for (int i = 0; i < trame.length(); ++i) {
                    msg = String.format("%s %03d", msg, trame.charAt(i) & 0xFF);
                }
                Utils.debugInfo((String)msg);
            }
        }
    }

    private static void manageArretUrgence(int etat) {
        if (etatPoire != etat) {
            if (etat == 1) {
                Utils.popupAlert(TransientConfig.translate("poire_debranchee"));
            } else if (etat == 2) {
                Utils.popupAlert(TransientConfig.translate("arret_urgence_alerte"));
            }
            etatPoire = etat;
            Main.menu.changeHomeStatus();
        }
    }

    private static void decodeTrameV0(String trame, boolean partiel) {
        switch (trame.charAt(1)) {
            case 'g': {
                if (partiel || trame.length() <= 10) break;
                receptionTrameG = true;
                UsbBiostim.setVoieBfbABrut(trame.charAt(5) & 0xFF);
                UsbBiostim.setVoieBfbBBrut(trame.charAt(6) & 0xFF);
                UsbBiostim.setVoiePressionBrut((double)(trame.charAt(7) & 0xFF) / 2.55);
                if ((trame.charAt(10) & '\u0001') != 0) {
                    UsbBiostim.securiteVoieA();
                }
                if ((trame.charAt(10) & 2) == 0) break;
                UsbBiostim.securiteVoieB();
                break;
            }
            case 'i': {
                if (partiel || trame.length() <= 6) break;
                attenteReponse = false;
                String version = trame.substring(2, 7);
                Utils.debugInfo("Reponse &i (numero de version : " + version + ")");
                Main.getConfig().setVersion_biostim(version);
                new Thread(CloudManager::checkLatestVersionAndActivation).start();
                break;
            }
            case 'j': {
                if (partiel && trame.length() != 4) break;
                attenteReponse = false;
                if (partiel) {
                    trameTemp = "";
                }
                if (activationGenerateur) {
                    ++nbStartStim;
                    Utils.debugInfo("Reponse &j (activation generateur)");
                    break;
                }
                Utils.debugInfo("Reponse &j (arret generateur)");
                break;
            }
            case 'r': {
                Utils.debugInfo("Arr\u00eat d'urgence");
                Platform.runLater(() -> {
                    try {
                        Main.main.stop();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                break;
            }
            default: {
                attenteReponse = false;
                if (connexionBioStim != 2) break;
                ++nbComErrors;
                Object msg = " Erreur Message Inconnu v0 (" + trame.length() + ", " + trame.charAt(1) + ") ->";
                for (int i = 0; i < trame.length(); ++i) {
                    msg = String.format("%s %03d", msg, trame.charAt(i) & 0xFF);
                }
                Utils.debugInfo((String)msg);
            }
        }
    }

    private static void decodeTrameTelecommande(String trame, boolean partiel) {
        if (trame.length() == 7) {
            if (partiel) {
                trameTemp = "";
            }
            Utils.debugInfo("trame telecomande &m : %c (%d)", Character.valueOf(trame.charAt(4)), trame.length());
            boolean finAppui = false;
            switch (trame.charAt(2)) {
                case '0': {
                    finAppui = maintien;
                    maintien = false;
                    break;
                }
                case '1': 
                case '2': {
                    maintien = true;
                    break;
                }
                default: {
                    Utils.debugInfo("Erreur lecture t\u00e9l\u00e9commande");
                }
            }
            switch (trame.charAt(4)) {
                case 'A': {
                    Main.telecommandeStop();
                    break;
                }
                case 'B': {
                    if (!finAppui) break;
                    Main.telecommandePause();
                    break;
                }
                case 'E': {
                    Main.telecommandeAMoins();
                    break;
                }
                case 'F': {
                    Main.telecommandeAPlus();
                    break;
                }
                case 'K': {
                    Main.telecommandeAMoins();
                    Main.telecommandeBMoins();
                    break;
                }
                case 'G': {
                    Main.telecommandeAPlus();
                    Main.telecommandeBPlus();
                    break;
                }
                case 'L': {
                    Main.telecommandeBMoins();
                    break;
                }
                case 'H': {
                    Main.telecommandeBPlus();
                    break;
                }
                default: {
                    Utils.debugInfo("Touche telecommande inconnue");
                }
            }
        }
    }

    static void rs232SerialEvent(SerialPortEvent event) {
        try {
            if (event.getEventType() == 1) {
                int pos;
                byte[] bread = new byte[serialPort.bytesAvailable()];
                serialPort.readBytes(bread, bread.length);
                char[] cread = new char[bread.length];
                for (int i = 0; i < bread.length; ++i) {
                    cread[i] = bread[i] >= 0 ? (char)bread[i] : (char)(bread[i] + 256);
                }
                String buffer = new String(cread);
                trameTemp = trameTemp + buffer;
                while ((pos = UsbBiostim.posNextTrame()) > 0) {
                    String trame = trameTemp.substring(0, pos);
                    trameTemp = trameTemp.substring(pos);
                    UsbBiostim.decodeTrame(trame, false);
                }
                if (!trameTemp.isEmpty()) {
                    UsbBiostim.decodeTrame(trameTemp, true);
                }
            }
            UsbBiostim.nextMessageAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int posNextTrame() {
        if (trameTemp.startsWith("&g")) {
            if (trameTemp.length() >= 3) {
                int size = trameTemp.charAt(2) + 2;
                if (trameTemp.length() >= size) {
                    return size;
                }
                return -1;
            }
            return -1;
        }
        return trameTemp.indexOf(38, 1);
    }

    private static void setVoieBfbABrut(double voieBfbA) {
        if (System.currentTimeMillis() > invalidTimeA) {
            int nbVal = Main.getConfig().versionProtocole == 0 ? 255 : 4095;
            voieBfbABrut = voieBfbA / (double)nbVal * (double)UsbBiostim.getGainReel(UsbBiostim.getGainVoieA());
        }
    }

    private static void setVoieBfbBBrut(double voieBfbB) {
        if (System.currentTimeMillis() > invalidTimeB) {
            int nbVal = Main.getConfig().versionProtocole == 0 ? 255 : 4095;
            voieBfbBBrut = voieBfbB / (double)nbVal * (double)UsbBiostim.getGainReel(UsbBiostim.getGainVoieB());
        }
    }

    private static void setVoiePressionBrut(double voiePression) {
        voiePressionBrut = voiePression;
    }

    private static void setVoiePression2Brut(double voiePression2) {
        voiePression2Brut = voiePression2;
    }

    public static int getGainReel(Integer gain) {
        if (Main.getConfig().versionProtocole == 0) {
            switch (gain) {
                case 0: {
                    return 2000;
                }
                case 1: {
                    return 888;
                }
                case 2: {
                    return 444;
                }
                case 3: {
                    return 222;
                }
                case 4: {
                    return 111;
                }
                case 5: {
                    return 55;
                }
                case 6: {
                    return 28;
                }
                case 7: {
                    return 14;
                }
            }
        } else {
            switch (gain) {
                case 0: {
                    return 2000;
                }
                case 1: {
                    return 125;
                }
            }
        }
        return 2000;
    }

    private static Integer getGainVoieA() {
        return gainVoieA;
    }

    private static Integer getGainVoieB() {
        return gainVoieB;
    }

    public static boolean isEnableIncrStim() {
        return System.currentTimeMillis() > disableIncrStim;
    }

    public static boolean isEnableIncrStim2() {
        return System.currentTimeMillis() > disableIncrStim2;
    }

    private static void securiteVoieA() {
        try {
            Utils.debugInfo("secu voie A");
            if (Main.currentController instanceof Autotest) {
                ((Autotest)Main.currentController).secuA = true;
                return;
            }
            if (Main.progEnCours == null) {
                return;
            }
            double ampli = Main.progEnCours.getStimAmplitudeA();
            if (System.currentTimeMillis() > disableSecuStim) {
                int freq = Main.progEnCours.currentPageProgram.getFreq();
                Main.progEnCours.setStimAmplitudeA(ampli -= (double)(freq > 10 ? 2 : 20 / freq) * deltaStim);
                ampli = Main.progEnCours.getStimAmplitudeA();
                disableIncrStim = System.currentTimeMillis() + (long)(freq <= 3 ? 1200 : 500);
            }
            UsbBiostim.amplitudeVoie(0, ampli);
            Platform.runLater(Main.currentController::updateAffichageStim);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void securiteVoieB() {
        try {
            Utils.debugInfo("secu voie B");
            if (Main.currentController instanceof Autotest) {
                ((Autotest)Main.currentController).secuB = true;
                return;
            }
            if (Main.progEnCours == null || Main.progEnCours.currentPageProgram.getNbVoie() < 2) {
                return;
            }
            double ampli = Main.progEnCours.getStimAmplitudeB();
            if (System.currentTimeMillis() > disableSecuStim) {
                int freq = Main.progEnCours.currentPageProgram.getFreq2();
                Main.progEnCours.setStimAmplitudeB(ampli -= (double)(freq > 10 ? 2 : 20 / freq) * deltaStim);
                ampli = Main.progEnCours.getStimAmplitudeB();
                disableIncrStim2 = System.currentTimeMillis() + (long)(freq <= 3 ? 1200 : 500);
            }
            UsbBiostim.amplitudeVoie(1, ampli);
            Platform.runLater(Main.currentController::updateAffichageStim);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isConnexionBioStim() {
        return connexionBioStim >= 2;
    }

    public static int getEtatPoire() {
        return etatPoire;
    }

    public static int getNbStartStim() {
        return nbStartStim;
    }

    static {
        connexionBioStim = 0;
        isL1 = false;
        etatPoire = 0;
        trameTemp = "";
        deltaStim = 0.5;
        invalidTimeA = 0L;
        invalidTimeB = 0L;
        receptionTrameG = false;
        nbComErrors = 0;
        messagesEnAttente = new ArrayList();
        typeMsgEnAttente = new ArrayList();
        attenteReponse = false;
        mutexInit = new ReentrantLock();
    }
}

