/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Ref;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.StageStyle;

public abstract class AlertQueue {
    private static final BlockingQueue<Callable<Boolean>> alertQueue = new LinkedBlockingQueue<Callable<Boolean>>();

    public static Future<Boolean> showAlertAndWait(Supplier<Alert> alertSupplier) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        alertQueue.add(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            Ref result = new Ref();
            Platform.runLater(() -> AlertQueue.lambda$showAlertAndWait$1((Supplier)alertSupplier, result, latch));
            latch.await();
            Optional res = (Optional)result.get();
            boolean ok = res.isPresent() && res.get() == ButtonType.OK;
            future.complete(ok);
            return ok;
        });
        return future;
    }

    public static void addAlerte(Supplier<Alert> alertSupplier) {
        alertQueue.add(() -> {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> AlertQueue.lambda$addAlerte$1((Supplier)alertSupplier, latch));
            latch.await();
            return null;
        });
    }

    private static void processQueue() {
        while (true) {
            try {
                while (true) {
                    Callable<Boolean> task = alertQueue.take();
                    task.call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void lambda$addAlerte$1(Supplier alertSupplier, CountDownLatch latch) {
        Alert alert = (Alert)alertSupplier.get();
        alert.initStyle(StageStyle.UTILITY);
        alert.initOwner(Main.sceneMain.getWindow());
        alert.showAndWait();
        latch.countDown();
    }

    private static /* synthetic */ void lambda$showAlertAndWait$1(Supplier alertSupplier, Ref result, CountDownLatch latch) {
        Alert alert = (Alert)alertSupplier.get();
        alert.initStyle(StageStyle.UTILITY);
        alert.initOwner(Main.sceneMain.getWindow());
        result.set(alert.showAndWait());
        latch.countDown();
    }

    static {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(AlertQueue::processQueue);
    }
}

