/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.image.Image;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;

public abstract class Computer {
    public static final String pngProfilDir = "appData/profils/";
    private static final Map<String, MediaPlayer> songMap = new HashMap<String, MediaPlayer>();
    private static final ArrayList<String> sonInconnus = new ArrayList();
    public static String absolutePath;
    public static MediaPlayer player;
    private static boolean playing;

    public static ObservableList<String> getListFormulaires() {
        File repertoireBilan_modele = new File(absolutePath + "appData/bilan" + TransientConfig.langueSuffixe);
        repertoireBilan_modele.mkdirs();
        ObservableList modelesFormulaire = FXCollections.observableArrayList();
        String[] files = repertoireBilan_modele.list();
        assert (files != null);
        for (String s : files) {
            if (s.equalsIgnoreCase("thumbs.db")) continue;
            modelesFormulaire.add((Object)s);
        }
        return modelesFormulaire;
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac os x");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static String getBootTime() {
        try {
            if (Computer.isWindows()) {
                return Computer.readProcessOutput("powershell.exe -Command \"[Management.ManagementDateTimeConverter]::ToDateTime((Get-WmiObject -Class Win32_OperatingSystem).LastBootUpTime)\"");
            }
            if (Computer.isMac()) {
                return Computer.readProcessOutput("sysctl -n kern.boottime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "???";
    }

    public static String getProcName() {
        if (Computer.isWindows()) {
            return Computer.readProcessOutput("powershell.exe -Command \"(Get-WmiObject -Class Win32_Processor).Name\"");
        }
        if (Computer.isMac()) {
            return Computer.readProcessOutput("sysctl -n machdep.cpu.brand_string");
        }
        return "???";
    }

    public static String readProcessOutput(String commande) {
        StringBuilder output = new StringBuilder();
        try {
            Process process = Runtime.getRuntime().exec(commande);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    output.append(line).append("\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output.toString().trim();
    }

    public static void keepAwake() {
        if (Main.getConfig().mouseMove > 0) {
            try {
                Robot hal = new Robot();
                Point pObj = MouseInfo.getPointerInfo().getLocation();
                hal.mouseMove(pObj.x, pObj.y);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void startPlayer(MediaPlayer player) {
        if (Computer.player != null) {
            Computer.player.stop();
        }
        Computer.player = player;
        if (player != null) {
            player.setOnEndOfMedia(() -> {
                playing = false;
            });
            playing = true;
            player.play();
        }
    }

    public static void playSong(String link) {
        if (link == null) {
            return;
        }
        try {
            MediaPlayer player = songMap.get(link);
            if (player == null) {
                if (sonInconnus.contains(link)) {
                    return;
                }
                File file = new File(link);
                Media pick = new Media(file.toURI().toASCIIString());
                player = new MediaPlayer(pick);
                songMap.put(link, player);
            }
            Computer.startPlayer(player);
        }
        catch (Exception e) {
            Utils.debugInfo("son inconnu : " + link);
            sonInconnus.add(link);
        }
    }

    public static void playSongIfNotIntro(String link, String intro) {
        MediaPlayer playerIntro = songMap.get(intro);
        if (player != null && player == playerIntro && playing) {
            return;
        }
        Computer.playSong(link);
    }

    public static void loadSong(String link) {
        if (link == null) {
            return;
        }
        try {
            MediaPlayer player = songMap.get(link);
            if (player == null) {
                if (sonInconnus.contains(link)) {
                    return;
                }
                File file = new File(link);
                Media pick = new Media(file.toURI().toASCIIString());
                player = new MediaPlayer(pick);
                songMap.put(link, player);
            }
        }
        catch (Exception e) {
            Utils.debugInfo("impossible de pr\u00e9charger le son : " + link);
            sonInconnus.add(link);
        }
    }

    public static Image getImage(String img, String defaultImage, boolean custom) {
        try {
            Image res = custom ? new Image(Computer.newBiostimFile(img).toURI().toASCIIString()) : new Image(Computer.class.getResourceAsStream("/img/" + img));
            if (res.getHeight() > 5.0) {
                return res;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img != null) {
            System.out.format("pb avec l'image : %s (%s)%n", img, custom ? "custom" : "static");
        }
        if (defaultImage != null) {
            return new Image(Computer.class.getResourceAsStream("/img/" + defaultImage));
        }
        return null;
    }

    public static String tryRelative(String filename) {
        try {
            filename = Computer.newBiostimFile(filename).getAbsolutePath();
            if (filename.startsWith(absolutePath)) {
                return "./" + filename.substring(absolutePath.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filename;
    }

    public static String makeAbsolute(String filename) {
        if (filename.startsWith("./") || filename.startsWith(".\\")) {
            return absolutePath + filename.substring(2);
        }
        return filename;
    }

    public static File newBiostimFile(String filename) {
        File f = new File(filename);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(absolutePath, filename);
    }

    static {
        playing = false;
    }
}

