/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.mazet.biostim.Main;

public abstract class Maths {
    public static double filtreLight(int voie, double filtre, double inst) {
        try {
            if (filtre > 0.0 && Main.getConfig().lissage > 0) {
                boolean instNonNull;
                double delta = Math.abs(filtre - inst) / (filtre + 1.0);
                boolean bl = instNonNull = inst != 0.0;
                if (Main.progEnCours != null && voie != -1) {
                    double max = Main.progEnCours.getAffMax(voie);
                    boolean bl2 = instNonNull = inst > max * 0.05;
                    if (max > filtre) {
                        delta = Math.abs(filtre - inst) / (max + 1.0);
                    }
                }
                double lissage = (double)Main.getConfig().lissage / 5.0;
                if (instNonNull && delta < 0.15) {
                    lissage = Maths.interpolation(0.0, 0.15, lissage * 8.0, lissage, delta);
                }
                return (filtre * lissage + inst) / (1.0 + lissage);
            }
            return inst;
        }
        catch (Exception e) {
            return inst;
        }
    }

    public static double filtre(int voie, double filtre, double inst) {
        try {
            if (filtre > 0.0 && Main.getConfig().lissage > 0) {
                double max;
                double delta = Math.abs(filtre - inst) / (filtre + 1.0);
                if (Main.progEnCours != null && voie != -1 && (max = Main.progEnCours.getAffMax(voie)) > filtre) {
                    delta = Math.abs(filtre - inst) / (max + 1.0);
                }
                double lissage = Main.getConfig().lissage;
                if (delta < 0.15) {
                    lissage = Maths.interpolation(0.0, 0.15, lissage * 8.0, lissage, delta);
                }
                return (filtre * lissage + inst) / (1.0 + lissage);
            }
            return inst;
        }
        catch (Exception e) {
            return inst;
        }
    }

    public static double interpolation(double x1, double x2, double y1, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public static int readableDecOfHex(int i) {
        try {
            return Integer.parseInt(Integer.toHexString(i));
        }
        catch (Exception e) {
            return i;
        }
    }
}

