/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mazet.biostim.Main;
import com.mazet.biostim.utils.AlertQueue;
import com.mazet.biostim.utils.CloudManager;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utilsfx.FxUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;

public abstract class Utils {
    public static final SimpleDateFormat formatDateFormulaire = new SimpleDateFormat("dd-MM-yyyy-HH'h'-mm'm'-ss's'");
    public static final SimpleDateFormat formatDateFormulaire2 = new SimpleDateFormat("dd-MM-yyyy");
    public static final SimpleDateFormat debugDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    public static final SimpleDateFormat cloudDateFormat = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat cloudTimeFormat = new SimpleDateFormat("HHmm");
    public static final SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyy-MM-dd__HH-mm-ss");
    public static final SimpleDateFormat sqlDateFormat = new SimpleDateFormat("yyyyMMdd");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd").create();
    private static final Gson gsonCompat = new GsonBuilder().setPrettyPrinting().create();
    private static String lastmsg = "";
    private static int nbRepet = 0;
    private static int nbTrying = 0;
    static final Charset[] encodings = new Charset[]{StandardCharsets.UTF_8, Charset.forName("Windows-1252"), StandardCharsets.ISO_8859_1};

    public static boolean isInvalidEmail(String email) {
        String regex = "^[\\w]+([\\w._-]*[\\w])?@[\\w]+([\\w.-]*[\\w])?\\.[a-zA-Z]{2,}$";
        return !email.matches(regex);
    }

    public static String SQLformat(String s) {
        return s.replace("'", "''").replace("\"", "").replace("\\", "\\\\");
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Utils.debugLine(1, "urlEncode error (%s) : %s", s, e);
            return "";
        }
    }

    public static String UrlSqlEncode(String s) {
        return Utils.urlEncode(Utils.SQLformat(s));
    }

    public static void debugInfo(String msg) {
        if (msg.startsWith("Close connexion") || msg.startsWith("Trying Bio")) {
            if (++nbTrying == 50) {
                msg = "Arret des messages de debug sur les ouvertures / fermetures de ports";
            }
            if (nbTrying > 50) {
                return;
            }
        } else if (msg.startsWith("--------------- Connexion")) {
            nbTrying = 0;
        }
        if (lastmsg.equals(msg) && !TransientConfig.isDev()) {
            ++nbRepet;
        } else {
            String date = debugDateFormat.format(new Date());
            if (nbRepet > 0) {
                System.out.format("%s  %s (%d fois)%n%n", date, lastmsg, nbRepet);
            }
            System.out.println(date + "  " + msg);
            lastmsg = msg;
            nbRepet = 0;
        }
    }

    public static void debugInfo(String msg, Object ... args) {
        msg = String.format(msg, args);
        Utils.debugInfo(msg);
    }

    public static void debugLine(String msg, Object ... args) {
        msg = String.format(msg, args);
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String ste2 = ste[2].toString();
        int pos = ste2.indexOf("com.mazet.biostim.");
        if (pos != -1) {
            ste2 = ste2.substring(pos + 18);
        }
        Utils.debugInfo("%s : %s", ste2, msg);
    }

    public static void debugLine(int i, String msg, Object ... args) {
        msg = String.format(msg, args);
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        Utils.debugInfo("%s : %s", ste[2 + i].toString(), msg);
    }

    public static void debugLine(Exception e, int i, String msg, Object ... args) {
        msg = String.format(msg, args);
        StackTraceElement[] ste = e.getStackTrace();
        Utils.debugInfo("%s : %s", ste[i].toString(), msg);
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void makeToast(String msg, Object ... args) {
        String toastMsg = String.format(msg, args);
        Utils.debugInfo("toast : %s", toastMsg);
        if (Main.primaryStage == null || !Platform.isFxApplicationThread()) {
            Utils.debugLine("toast non affich\u00e9", new Object[0]);
            return;
        }
        Stage toastStage = new Stage();
        toastStage.initOwner((Window)Main.primaryStage);
        toastStage.setResizable(false);
        toastStage.initStyle(StageStyle.TRANSPARENT);
        Text text = new Text(toastMsg);
        text.setFont(Font.font((String)"Verdana", (double)40.0));
        text.setFill((Paint)Color.WHITE);
        StackPane root = new StackPane(new Node[]{text});
        root.setStyle("-fx-background-radius: 20; -fx-background-color: rgba(0,0,0,1); -fx-padding: 50px;");
        Scene scene = new Scene((Parent)root);
        scene.setFill((Paint)Color.TRANSPARENT);
        toastStage.setScene(scene);
        toastStage.show();
        new Thread(() -> {
            Utils.sleep(2000L);
            Timeline fadeOutTimeline = new Timeline();
            KeyFrame fadeOutKey1 = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{new KeyValue((WritableValue)toastStage.getScene().getRoot().opacityProperty(), (Object)0)});
            fadeOutTimeline.getKeyFrames().add((Object)fadeOutKey1);
            fadeOutTimeline.setOnFinished(actionEvent -> toastStage.close());
            fadeOutTimeline.play();
        }).start();
    }

    public static boolean popupAlertAndWaitAvecTitre(String titre, String s, String ok) {
        Future<Boolean> future = AlertQueue.showAlertAndWait(() -> {
            Button okButton;
            Utils.debugInfo("Popup Alerte : %s", titre != null ? titre : s);
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            FxUtils.setCssPopup((Parent)alert.getDialogPane());
            alert.setHeaderText(titre);
            alert.setContentText(s);
            if (ok != null && (okButton = (Button)alert.getDialogPane().lookupButton(ButtonType.OK)) != null) {
                okButton.setText(ok);
            }
            return alert;
        });
        try {
            return future.get();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static void popupAlertAndWait(String s, String ok) {
        Utils.popupAlertAndWaitAvecTitre(null, s, ok);
    }

    public static void popupAlertAvecTitre(String titre, String s, String ok) {
        AlertQueue.addAlerte(() -> {
            Button okButton;
            Utils.debugInfo("Popup Alerte : %s", titre != null ? titre : s);
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            FxUtils.setCssPopup((Parent)alert.getDialogPane());
            alert.setHeaderText(titre);
            alert.setContentText(s);
            if (ok != null && (okButton = (Button)alert.getDialogPane().lookupButton(ButtonType.OK)) != null) {
                okButton.setText(ok);
            }
            return alert;
        });
    }

    public static void popupAlert(String s) {
        Utils.popupAlertAvecTitre(null, s, null);
    }

    public static void popupAlert(String s, String ok) {
        Utils.popupAlertAvecTitre(null, s, ok);
    }

    public static boolean popupDialog(String s, boolean cancelByDefault) {
        Future<Boolean> future = AlertQueue.showAlertAndWait(() -> {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            FxUtils.setCssPopup((Parent)alert.getDialogPane());
            alert.setHeaderText(s);
            if (cancelByDefault) {
                ((Button)alert.getDialogPane().lookupButton(ButtonType.OK)).setDefaultButton(false);
                ((Button)alert.getDialogPane().lookupButton(ButtonType.CANCEL)).setDefaultButton(true);
            }
            return alert;
        });
        try {
            boolean res = future.get();
            Utils.debugInfo("Popup : %s => %b", s, res);
            return res;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean popupDialog(String s) {
        return Utils.popupDialog(s, true);
    }

    public static Optional<String> popupReadVal(String s, String input) {
        TextInputDialog dialog = new TextInputDialog(input);
        FxUtils.setCssPopup((Parent)dialog.getDialogPane());
        dialog.setHeaderText(null);
        dialog.setContentText(TransientConfig.translate(s));
        dialog.initStyle(StageStyle.UTILITY);
        dialog.initOwner(Main.sceneMain.getWindow());
        return dialog.showAndWait();
    }

    public static Optional<String> popupReadInt(String s, String input) {
        TextInputDialog dialog = new TextInputDialog(input);
        UnaryOperator filter = change -> {
            String text = change.getControlNewText();
            if (text.matches("\\d*")) {
                return change;
            }
            return null;
        };
        dialog.getEditor().setTextFormatter(new TextFormatter(filter));
        FxUtils.setCssPopup((Parent)dialog.getDialogPane());
        dialog.setHeaderText(null);
        dialog.setContentText(TransientConfig.translate(s));
        dialog.initStyle(StageStyle.UTILITY);
        dialog.initOwner(Main.sceneMain.getWindow());
        return dialog.showAndWait();
    }

    public static String popupReadMultiline(String s, String input) {
        TextInputDialog dialog = new TextInputDialog();
        FxUtils.setCssPopup((Parent)dialog.getDialogPane());
        dialog.setHeaderText(null);
        dialog.setTitle(TransientConfig.translate(s));
        dialog.initStyle(StageStyle.UTILITY);
        dialog.initOwner(Main.sceneMain.getWindow());
        TextArea textArea = new TextArea(input);
        textArea.setWrapText(true);
        dialog.getDialogPane().setContent((Node)textArea);
        Platform.runLater(() -> ((TextArea)textArea).requestFocus());
        if (dialog.showAndWait().isPresent()) {
            return textArea.getText();
        }
        return null;
    }

    public static void executeWithTimeout(Runnable action, long timeoutMs) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(action);
        try {
            future.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            future.cancel(true);
            Utils.debugLine(2, "executeWithTimeout : %s", e);
        }
    }

    public static void chooseFile(MouseEvent event, TextField background, boolean inRep) {
        try {
            File file;
            FileChooser fileChooser = new FileChooser();
            TextField textField = (TextField)event.getSource();
            if (!textField.getText().isEmpty()) {
                if (inRep) {
                    fileChooser.setInitialDirectory(new File(textField.getText()));
                } else {
                    fileChooser.setInitialDirectory(new File(textField.getText()).getParentFile());
                }
            } else if (background != null && !background.getText().isEmpty()) {
                fileChooser.setInitialDirectory(new File(background.getText()).getParentFile());
            }
            try {
                file = fileChooser.showOpenDialog(Main.sceneMain.getWindow());
            }
            catch (IllegalArgumentException e) {
                fileChooser.setInitialDirectory(null);
                file = fileChooser.showOpenDialog(Main.sceneMain.getWindow());
            }
            if (file != null) {
                textField.setText(file.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void chooseDir(MouseEvent event) {
        try {
            File dir;
            TextField temp = (TextField)event.getSource();
            DirectoryChooser directoryChooser = new DirectoryChooser();
            File initdir = new File(temp.getText());
            directoryChooser.setInitialDirectory(initdir);
            try {
                dir = directoryChooser.showDialog(Main.sceneMain.getWindow());
            }
            catch (IllegalArgumentException e) {
                directoryChooser.setInitialDirectory(null);
                dir = directoryChooser.showDialog(Main.sceneMain.getWindow());
            }
            if (dir != null) {
                temp.setText(dir.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String chooseDir(String title) {
        try {
            File dir;
            DirectoryChooser directoryChooser = new DirectoryChooser();
            File initdir = new File(Main.getConfig().getSauvegarde_auto());
            directoryChooser.setInitialDirectory(initdir);
            directoryChooser.setTitle(title);
            try {
                dir = directoryChooser.showDialog(Main.sceneMain.getWindow());
            }
            catch (IllegalArgumentException e) {
                directoryChooser.setInitialDirectory(null);
                dir = directoryChooser.showDialog(Main.sceneMain.getWindow());
            }
            return dir.getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void deleteOldFiles(String rep, String prefix) {
        try {
            File repsav = new File(rep);
            Object[] files = repsav.list();
            assert (files != null);
            Arrays.sort(files);
            int nbfichiers = 0;
            long purgeTime = System.currentTimeMillis() - 864000000L;
            for (int i = files.length - 1; i >= 0; --i) {
                File f;
                Object file = files[i];
                if (!((String)file).startsWith(prefix) || ++nbfichiers <= 10 || (f = new File(rep + "/" + (String)file)).lastModified() >= purgeTime) continue;
                Utils.debugInfo("deleting file " + (String)file);
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File findFileWhateverEncoded(String strRep, String form) {
        String filename = strRep + form;
        File f = Paths.get(filename, new String[0]).toFile();
        if (!f.exists()) {
            File rep = new File(strRep);
            Collator collator = Collator.getInstance(Locale.getDefault());
            for (String file : rep.list()) {
                if (collator.compare(file, form) != 0) continue;
                f = new File(rep, file);
                break;
            }
        }
        return f;
    }

    public static String readFileWithFallbackEncoding(Path filePath) throws IOException {
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new RuntimeException("File not found: " + String.valueOf(filePath));
        }
        for (Charset encoding : encodings) {
            try {
                return Files.readString(filePath, encoding);
            }
            catch (Exception e) {
                Utils.debugInfo("readFileWithFallbackEncoding failed (%s) : %s", encoding, filePath);
            }
        }
        return new String(Files.readAllBytes(filePath));
    }

    public static String readHtmlRes(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        return Utils.readFileInJar("/html" + TransientConfig.langueSuffixe + "/" + name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileInJar(String name) {
        try (InputStream is = Main.class.getResourceAsStream(name);){
            if (is == null) {
                String string2 = "";
                return string2;
            }
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void addToZipFile(String fileName, ZipOutputStream zos) {
        File file = new File(fileName);
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            ZipEntry zipEntry = new ZipEntry(file.getName());
            zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[16384];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            zos.closeEntry();
        }
        catch (Exception e) {
            Utils.debugInfo("Impossible d'ajouter le fichier %s dans le fichier de sauvegarde %s", fileName, e.toString());
        }
    }

    public static void addToZipFile(String fileName, String content, ZipOutputStream zos) {
        try {
            ZipEntry zipEntry = new ZipEntry(fileName);
            zos.putNextEntry(zipEntry);
            zos.write(content.getBytes());
            zos.closeEntry();
        }
        catch (Exception e) {
            Utils.debugInfo("Impossible d'ajouter le fichier %s dans le fichier de sauvegarde %s", fileName, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJson(Object o) {
        String res;
        Gson gson = Utils.gson;
        synchronized (gson) {
            try {
                res = Utils.gson.toJson(o);
                new JSONObject(res);
            }
            catch (Exception e) {
                e.printStackTrace();
                res = null;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveJson(Object o, String filename) {
        Gson gson = Utils.gson;
        synchronized (gson) {
            try {
                String str = Utils.gson.toJson(o);
                new JSONObject(str);
                try (OutputStreamWriter file = new OutputStreamWriter(Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                    file.write(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromJson(String s, Class<T> myclass) {
        Gson gson = Utils.gson;
        synchronized (gson) {
            return (T)Utils.gson.fromJson(s, myclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromJsonFile(String filename, Class<T> myclass) {
        Gson gson = Utils.gson;
        synchronized (gson) {
            if (new File(filename).exists()) {
                try {
                    String content = Files.readString(Paths.get(filename, new String[0]));
                    Object res = Utils.gson.fromJson(content, myclass);
                    if (res != null) {
                        return (T)res;
                    }
                }
                catch (Exception e) {
                    Utils.debugInfo("Lecture json from file %s : %s", filename, e.toString());
                    Utils.debugInfo("Essai avec gsonCompat");
                    try {
                        String content = Files.readString(Paths.get(filename, new String[0]));
                        Object res = gsonCompat.fromJson(content, myclass);
                        if (res != null) {
                            return (T)res;
                        }
                    }
                    catch (Exception ee) {
                        Utils.debugLine("Lecture json from file %s : %s", filename, ee.toString());
                    }
                }
            }
            try {
                return myclass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Utils.debugLine("Cr\u00e9ation json from file %s : %s", filename, e.toString());
                CloudManager.sendJdd("impossible de relire %s / type %s", filename, myclass.getSimpleName());
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T fromJsonFileWithException(String filename, Class<T> myclass) throws IOException {
        Gson gson = Utils.gson;
        synchronized (gson) {
            String content = Files.readString(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
            return (T)Utils.gson.fromJson(content, myclass);
        }
    }

    public static void copyToOut(InputStream src) {
        new Thread(() -> {
            Scanner sc = new Scanner(src);
            while (sc.hasNextLine()) {
                System.out.println(sc.nextLine());
            }
        }).start();
    }

    public static String getHttp(String url) throws Exception {
        String inputLine;
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            response.append('\n');
        }
        in.close();
        return response.toString();
    }

    public static int getIntDelta(int value) {
        if (value < 50) {
            return 1;
        }
        if (value < 100) {
            return 5;
        }
        if (value < 1000) {
            return 10;
        }
        if (value < 10000) {
            return 100;
        }
        return 1000;
    }

    public static double getDoubleDelta(double value) {
        if (value < 4.999) {
            return 0.1;
        }
        if (value < 19.999) {
            return 0.5;
        }
        if (value < 99.999) {
            return 1.0;
        }
        if (value < 499.999) {
            return 5.0;
        }
        return 50.0;
    }

    public static int getDeltaDuree(int duree) {
        if (duree < 20) {
            return 1;
        }
        if (duree < 60) {
            return 5;
        }
        return 15;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String stringOfTime(Integer time) {
        if (time != null) {
            int minute = time / 60;
            int seconde = time % 60;
            return String.format("%02d:%02d", minute, seconde);
        }
        return "";
    }

    public static String stringOfReglage(double reglage) {
        if (reglage < 20.0) {
            return String.format("%.1f", reglage);
        }
        return String.format("%.0f", reglage);
    }

    public static int intOfTime(String time) {
        int seconde = 0;
        try {
            time = time.replaceAll(" ", "");
            if (!time.isEmpty()) {
                String[] temp = time.split(":");
                int min = Integer.parseInt(temp[0]);
                int sec = Integer.parseInt(temp[1]);
                seconde = min * 60 + sec;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seconde;
    }

    public static double parseDoubleSuffix(String num) {
        int lastOK = num.length() - 1;
        while (!Character.isDigit(num.charAt(lastOK))) {
            --lastOK;
        }
        num = num.substring(0, lastOK + 1);
        return Double.parseDouble(num.replaceAll(",", "."));
    }

    public static int parseIntSuffix(String num) {
        int lastOK = num.length() - 1;
        while (!Character.isDigit(num.charAt(lastOK))) {
            --lastOK;
        }
        num = num.substring(0, lastOK + 1);
        return Integer.parseInt(num);
    }

    public record Tuple<T1, T2>(T1 first, T2 second) {
    }
}

