/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.utilsfx;

import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;

public class CircularProgress {
    AnchorPane parent;
    Arc complet;
    Arc intensite;
    Arc action;
    double valIntensite = 1.0E-4;
    double valAction = 0.0;
    private static final double start = 210.0;
    private static final double amplitude = -240.0;

    public CircularProgress(AnchorPane parent) {
        this.parent = parent;
        double width = parent.getWidth();
        double height = parent.getHeight();
        double radius = Math.min(width, height) * 0.4;
        this.complet = new Arc();
        this.complet.setStroke((Paint)Color.WHITE);
        this.complet.getStyleClass().add((Object)"arcStim");
        this.complet.setStartAngle(210.0);
        this.intensite = new Arc();
        this.intensite.setStroke((Paint)Color.GRAY);
        this.intensite.getStyleClass().add((Object)"arcStim");
        this.intensite.setStartAngle(210.0);
        this.action = new Arc();
        this.action.setStroke((Paint)Color.RED);
        this.action.getStyleClass().add((Object)"arcStim");
        this.action.setStartAngle(210.0);
        this.parentChanged();
        parent.getChildren().add(0, (Object)this.complet);
        parent.getChildren().add(1, (Object)this.intensite);
        parent.getChildren().add(2, (Object)this.action);
        parent.widthProperty().addListener((a, b, c) -> this.parentChanged());
        parent.heightProperty().addListener((a, b, c) -> this.parentChanged());
    }

    public void setIntensite(double value) {
        this.valIntensite = Math.min(Math.max(value, 0.01), 1.0);
        this.updateArc(this.intensite, this.valIntensite);
        this.updateArc(this.action, this.valIntensite * this.valAction);
    }

    public void setAction(double value) {
        if (this.valAction != value) {
            this.valAction = value;
            this.updateArc(this.action, this.valIntensite * this.valAction);
        }
    }

    private void parentChanged() {
        this.updateArc(this.complet, 1.0);
        this.updateArc(this.intensite, this.valIntensite);
        this.updateArc(this.action, this.valIntensite * this.valAction);
    }

    private void updateArc(Arc arc, double value) {
        double width = this.parent.getWidth();
        double height = this.parent.getHeight();
        arc.setCenterX(width / 2.0);
        arc.setCenterY(height / 2.0);
        double radius = Math.min(width, height) * 0.4;
        arc.setRadiusX(radius);
        arc.setRadiusY(radius);
        arc.setStrokeWidth(radius / 5.0);
        double len = -240.0 * value;
        arc.setLength(len);
    }
}

