/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.configuration;

import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utils.Utils;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;

public abstract class Upgrade {
    public static void recupereVieuxJson() {
        new File(Config.configJson).getParentFile().mkdirs();
        String oldJsonFile = Upgrade.findOldConfigJson();
        if (oldJsonFile != null) {
            Utils.debugInfo("Recup\u00e9ration d'un ancien config.json : %s", oldJsonFile);
            Config old = Utils.fromJsonFile(oldJsonFile, Config.class);
            Computer.absolutePath = new File(oldJsonFile).getParent() + File.separator;
            if (!old.repPatients.startsWith(".")) {
                old.setRepPatients(old.repPatients);
            }
            if (!old.sauvegarde_auto.startsWith(".")) {
                old.setSauvegarde_auto(old.sauvegarde_auto);
            }
            if (!old.sonDebutBfb.startsWith(".")) {
                old.setSonDebutBfb(old.sonDebutBfb);
            }
            if (!old.sonFinBfb.startsWith(".")) {
                old.setSonFinBfb(old.sonFinBfb);
            }
            if (!old.sonFinProgramme.startsWith(".")) {
                old.setSonFinProgramme(old.sonFinProgramme);
            }
            if (!old.sonPageBFB.startsWith(".")) {
                old.setSonPageBFB(old.sonPageBFB);
            }
            if (!old.sonPageStim.startsWith(".")) {
                old.setSonPageStim(old.sonPageStim);
            }
            Utils.saveJson(old, Config.configJson);
            Upgrade.copyDirectory(new File(oldJsonFile).getParentFile().toString(), new File(Config.configJson).getParentFile().toString());
        }
    }

    public static String findOldConfigJson() {
        try {
            Object file = System.getenv("ONEDRIVE") + "/Desktop/BiostimData/config.json";
            if (new File((String)file).exists()) {
                return file;
            }
            file = System.getenv("ONEDRIVE") + "/Bureau/BiostimData/config.json";
            if (new File((String)file).exists()) {
                return file;
            }
            file = System.getenv("USERPROFILE") + "/Desktop/BiostimData/config.json";
            if (new File((String)file).exists()) {
                return file;
            }
            file = System.getProperty("user.home") + "/Desktop/BiostimData/config.json";
            if (new File((String)file).exists()) {
                return file;
            }
            file = System.getenv("ONEDRIVE");
            if (new File((String)file).exists()) {
                for (String rep : Objects.requireNonNull(new File((String)file).list())) {
                    file = System.getenv("ONEDRIVE") + "/" + rep + "/BiostimData/config.json";
                    if (!new File((String)file).exists()) continue;
                    return file;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void copyDirectory(String sourceDir, String destDir) {
        try {
            Files.walk(Paths.get(sourceDir, new String[0]), new FileVisitOption[0]).forEach(source -> {
                String filename = source.toString().substring(sourceDir.length());
                if (new File(source.toString()).isDirectory()) {
                    new File(destDir + File.separatorChar + filename).mkdirs();
                } else {
                    try {
                        Files.copy(source, Paths.get(destDir, filename), new CopyOption[0]);
                        Utils.debugInfo("fichier %s/%s ==> copi\u00e9", sourceDir, filename);
                    }
                    catch (Exception e) {
                        Utils.debugInfo("fichier %s/%s ignor\u00e9", sourceDir, filename);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

