/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.patient;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.patient.PatientListViewCtrl;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;

public class PatientFile {
    private String firstName;
    private String lastName;
    private String fileName;
    int kine = -1;
    private boolean archive;

    public PatientFile() {
    }

    public PatientFile(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public static ArrayList<PatientFile> getPatientFiles(boolean withArchive) {
        ArrayList<PatientFile> res = new ArrayList<PatientFile>();
        String[] list = new File(Main.getConfig().getRepPatients() + "/db/").list();
        if (list == null) {
            return res;
        }
        for (String file : list) {
            if (!file.endsWith(".json") || !file.contains("_")) continue;
            try {
                int debut;
                PatientFile temp = new PatientFile();
                temp.fileName = file;
                temp.archive = file.charAt(0) == '@';
                int j = debut = temp.archive ? 1 : 0;
                while (file.charAt(j) != '_') {
                    ++j;
                }
                temp.firstName = file.substring(debut, j);
                temp.lastName = file.substring(j + 1, file.length() - 5);
                int posKine = temp.lastName.indexOf(46);
                if (posKine != -1) {
                    try {
                        temp.kine = Integer.parseInt(temp.lastName.substring(posKine + 1));
                        temp.lastName = temp.lastName.substring(0, posKine);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!withArchive && temp.isArchive()) continue;
                res.add(temp);
            }
            catch (Exception e) {
                Utils.debugLine("probleme lors de la lecture de %s : %s", file, e.toString());
            }
        }
        if (Main.getConfig().triPatients == 0) {
            res.sort(Comparator.comparing(PatientFile::getFirstName, String.CASE_INSENSITIVE_ORDER).thenComparing(PatientFile::getLastName, String.CASE_INSENSITIVE_ORDER));
        } else {
            res.sort(Comparator.comparing(PatientFile::getLastName, String.CASE_INSENSITIVE_ORDER).thenComparing(PatientFile::getFirstName, String.CASE_INSENSITIVE_ORDER));
        }
        return res;
    }

    boolean isArchive() {
        return this.archive;
    }

    String getFirstName() {
        return this.firstName;
    }

    String getLastName() {
        return this.lastName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getNomCache(boolean cacheNom) {
        if (this == PatientListViewCtrl.tempPatient) {
            cacheNom = false;
        }
        return this.cacheNom(this.getFirstName(), cacheNom) + " " + this.cacheNom(this.getLastName(), cacheNom);
    }

    private String cacheNom(String nom, boolean cacheNom) {
        if (!cacheNom || nom.isEmpty()) {
            return nom;
        }
        return nom.charAt(0) + "...";
    }

    public String toString() {
        return this.firstName + " " + this.lastName;
    }
}

