/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Config;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimationSkin;
import com.mazet.biostim.view.programme.bfb.BiofeedbackController;
import com.mazet.biostim.zdata.AnimationStyle;
import com.mazet.biostim.zdata.Profil;
import java.util.ArrayList;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;

public class AnimationStatic
extends BiofeedbackAnimationSkin {
    private double finPage = 0.0;
    private double debutPage = 0.0;
    private boolean singlePage = false;
    private final ArrayList<Node> objets = new ArrayList();
    private final ArrayList<Node> noScaleObj = new ArrayList();

    public AnimationStatic(AnimationStyle animationStyle, BiofeedbackController controller) {
        this.animationStyle = animationStyle;
        controller.checkVoie2.setSelected(false);
        FxUtils.setVisibility((Node)controller.checkVoie2, false);
        controller.checkHistorique.setSelected(false);
        FxUtils.setVisibility((Node)controller.checkHistorique, false);
    }

    @Override
    public void initGame() {
        super.initGame();
        try {
            this.finPage = 0.0;
            this.createGameRootObjects();
            this.controller.gameAnchor.getChildren().add((Object)this.gameRoot);
            this.nouvelEcran();
            if (Main.getConfig().isActivated) {
                this.gameRoot.setOnMouseClicked(this::clicEcran);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createGameRootObjects() {
        try {
            this.gameRoot = new Pane();
            this.initLines();
            this.gameRoot.setPrefSize(this.widthGame, this.anchorHeight);
            if (!this.animationStyle.background.startsWith("__")) {
                this.animationStyle.setBackground(this.gameRoot, false, 1, 1.0, 1.0);
            }
            boolean inverseCurseur = this.controller.voiesSeparees && !Main.progEnCours.currentProgram.voie1EnHaut;
            this.curseur1 = this.animationStyle.getShapeCurseur(inverseCurseur ? 2 : 1, this);
            if (this.controller.nbVoie == 2) {
                this.curseur2 = this.animationStyle.getShapeCurseur(inverseCurseur ? 1 : 2, this);
            }
            if (this.controller.voiesSeparees) {
                this.courbeSeparation = new Polyline();
                this.courbeSeparation.getStyleClass().add((Object)"courbeSeparation");
                this.courbeSeparation.getPoints().addAll((Object[])new Double[]{0.0, this.anchorHeight / 2.0, this.widthGame, this.anchorHeight / 2.0});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void updateSizeGame() {
        this.gameRoot.setPrefSize(this.widthGame, this.anchorHeight);
        if (this.courbeSeparation != null) {
            this.courbeSeparation.getPoints().setAll((Object[])new Double[]{0.0, this.anchorHeight / 2.0, this.widthGame, this.anchorHeight / 2.0});
        }
        if (this.marqueurVoie1.getPoints().size() > 2) {
            this.marqueurVoie1.getPoints().set(2, (Object)this.widthGame);
        }
        if (this.marqueurVoie2.getPoints().size() > 2) {
            this.marqueurVoie2.getPoints().set(2, (Object)this.widthGame);
        }
        this.animationStyle.updateShapeCurseur(this.curseur1, 1, this);
        this.animationStyle.updateShapeCurseur(this.curseur2, 2, this);
        this.updateProfil();
    }

    private void nouvelEcran() {
        int dureeProg;
        this.noScaleObj.clear();
        Profil profil = this.controller.profil.getProfilUnitaire(this.controller.dureeMilli + 0.1);
        this.debutPage = this.finPage;
        double duree = profil.getDuree();
        Integer dureePage = Main.progEnCours.currentPageProgram.getDuree();
        if (dureePage != null && duree > (double)dureePage.intValue()) {
            duree = dureePage.intValue();
            this.singlePage = true;
        }
        if (duree > (double)(dureeProg = Main.progEnCours.currentProgram.getDuree())) {
            duree = dureeProg;
            this.singlePage = true;
        }
        this.finPage = this.debutPage + duree;
        this.updateProfil();
    }

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        try {
            if (this.controller.dureeMilli > this.finPage) {
                this.nouvelEcran();
            }
            if (this.curseur1 != null) {
                this.gereCollision();
            }
            double posX = this.pixOfTime(this.controller.dureeMilli);
            double posY1 = this.pixOfNiv1(this.controller.niveauVoie1Aff);
            double posY2 = this.pixOfNiv2(this.controller.niveauVoie2Aff);
            if (this.controller.started) {
                this.courbe1.getPoints().addAll((Object[])new Double[]{posX, posY1});
                if (this.controller.nbVoie == 2) {
                    this.courbe2.getPoints().addAll((Object[])new Double[]{posX, posY2});
                }
            }
            if (this.curseur2 != null) {
                this.curseur2.setTranslateX(posX - FxUtils.getCursorWidth(this.curseur2, 2, this) / 2.0);
                this.curseur2.setTranslateY(posY2 - FxUtils.getCursorHeight(this.curseur2, 2, this) / 2.0);
                this.curseur2.toFront();
            }
            if (this.curseur1 != null) {
                this.curseur1.setTranslateX(posX - FxUtils.getCursorWidth(this.curseur1, 1, this) / 2.0);
                this.curseur1.setTranslateY(posY1 - FxUtils.getCursorHeight(this.curseur1, 1, this) / 2.0);
                this.curseur1.toFront();
            }
            this.marqueurPresent.getPoints().setAll((Object[])new Double[]{posX, this.anchorHeight * 0.04, posX, this.anchorHeight * 0.96});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateProfil() {
        this.controller.biofeedbackAnimation.setMarqueurBFBAssiste();
        this.gameRoot.getChildren().clear();
        Profil profil = this.controller.profil.getProfilUnitaire(this.controller.dureeMilli + 0.1);
        double duree = profil.getDuree();
        if (this.animationStyle.background.startsWith("__")) {
            this.animationStyle.setBackground(this.gameRoot, this.controller.voiesSeparees, (int)this.anchorHeight, 0.0, this.widthGame * 5.0 / duree);
        }
        double deb = this.debutPage - this.debutPage % this.controller.profil.getDuree();
        double d = this.controller.profil.getProfilUnitaire(deb + 0.1).getDuree();
        while (deb + d < this.controller.dureeMilli) {
            d = this.controller.profil.getProfilUnitaire((deb += d) + 0.1).getDuree();
        }
        Integer dureePage = Main.progEnCours.currentPageProgram.getDuree();
        if (dureePage != null && duree > (double)dureePage.intValue()) {
            duree = dureePage.intValue();
        }
        double fin = deb + duree;
        if (!(!(Math.abs(deb - this.debutPage) > 0.1) && !(Math.abs(fin - this.finPage) > 0.1) || fin >= this.finPage && this.singlePage)) {
            this.debutPage = deb;
            this.finPage = fin;
            this.singlePage = false;
            this.courbe1.getPoints().clear();
            if (this.courbe2 != null) {
                this.courbe2.getPoints().clear();
            }
        }
        this.dessineProfil(profil);
        this.nouvellesCourbes();
        this.objets.clear();
        this.ajouteObjets(profil);
        if (this.courbeSeparation != null) {
            this.gameRoot.getChildren().add((Object)this.courbeSeparation);
        }
        this.gameRoot.getChildren().addAll((Object[])new Node[]{this.marqueurVoie1, this.marqueurVoie2, this.zeroVoie1, this.zeroVoie2, this.marqueurBFBAssiste, this.marqueurPresent});
        if (this.curseur2 != null) {
            this.gameRoot.getChildren().add((Object)this.curseur2);
        }
        if (this.curseur1 != null) {
            this.gameRoot.getChildren().add((Object)this.curseur1);
        }
        this.gameRoot.getChildren().addAll(this.noScaleObj);
        for (Node n : this.noScaleObj) {
            if (!(n instanceof Rectangle)) continue;
            this.objets.add(n);
        }
        if (this.controller.nbVoie == 2) {
            this.courbe2.getPoints().clear();
        }
        ArrayList<Integer> temps = Main.progEnCours.historique.temps;
        ArrayList<Double> voie1 = Main.progEnCours.historique.niveauVoie1;
        ArrayList<Double> voie2 = Main.progEnCours.historique.niveauVoie2;
        double tempsDebut = (Main.progEnCours.revoir.startPageTime + Math.max(0.0, this.debutPage)) * 100.0;
        for (int j = 0; j < temps.size(); ++j) {
            if (!((double)temps.get(j).intValue() > tempsDebut)) continue;
            double posX = this.pixOfTime((double)temps.get(j).intValue() / 100.0 - Main.progEnCours.revoir.startPageTime);
            double posY1 = this.pixOfNiv1(this.niv1AffOfReel(voie1.get(j)));
            if (!this.controller.started) continue;
            this.courbe1.getPoints().addAll((Object[])new Double[]{posX, posY1});
            if (this.controller.nbVoie != 2) continue;
            double posY2 = this.pixOfNiv2(this.niv2AffOfReel(voie2.get(j)));
            this.courbe2.getPoints().addAll((Object[])new Double[]{posX, posY2});
        }
        this.redrawEvents();
    }

    private void dessineProfil(Profil profil) {
        this.updateLevelZero();
        if (this.controller.profil.typeProfil() == 2) {
            Polyline ruban = new Polyline();
            double profilWidth = 0.92 * this.anchorHeight * (double)Main.progEnCours.epaisseurProfil / 100.0 * (100.0 - this.profToAff(0.0)) / 100.0;
            if (this.controller.voiesSeparees) {
                profilWidth = profilWidth * 5.0 / 11.0;
            }
            ruban.setStrokeWidth(profilWidth);
            if (profil.hasStim()) {
                ruban.getStyleClass().add((Object)"rubanRouge");
            } else {
                ruban.getStyleClass().add((Object)this.animationStyle.getRubanStyle());
            }
            for (int indice = 0; indice < profil.size(); ++indice) {
                double posX = this.pixOfTime(profil.temps.get(indice) + this.debutPage);
                double posY = this.pixOfProfil(profil.val.get(indice) * 100.0);
                ruban.getPoints().addAll((Object[])new Double[]{posX, posY});
            }
            this.gameRoot.getChildren().add((Object)ruban);
            ruban.toBack();
        }
    }

    private void ajouteObjets(Profil profil) {
        block4: {
            block3: {
                if (Main.progEnCours.currentPageProgram.getType() != 10) break block3;
                for (int i = 0; i < Main.progEnCours.currentPageProgram.dessineT.size(); ++i) {
                    Integer pinceau = Main.progEnCours.currentPageProgram.progs.get(i);
                    ImagePattern[] imgs = pinceau == null ? (this.animationStyle.patternObjets != null ? this.animationStyle.patternObjets : new ImagePattern[]{AnimationStyle.simpleEtoile}) : new ImagePattern[]{Config.listImagesCatch.get(Config.decodePosObj(pinceau))};
                    double pos = Main.progEnCours.currentPageProgram.dessineT.get(i) * (double)Main.progEnCours.currentPageProgram.dureeTravail;
                    this.afficheObjet(imgs, this.debutPage + pos, Main.progEnCours.currentPageProgram.dessineY.get(i) * 100.0, this.anchorHeight / 10.0, 6);
                }
                break block4;
            }
            if (this.animationStyle.patternObjets == null || profil.typeProfil() != 2 || profil.hasStim()) break block4;
            for (double posObj = 0.05; posObj < profil.getDuree(); posObj += 0.08) {
                double prof = profil.getVal(posObj);
                this.afficheObjet(this.animationStyle.patternObjets, this.debutPage + posObj, prof, this.getSizeObj(), 0);
                double initFin = posObj;
                while (posObj < initFin + 0.99 && prof == profil.getVal(posObj)) {
                    posObj += 0.08;
                }
            }
        }
    }

    private void gereCollision() {
        try {
            Bounds bound = this.curseur1.getBoundsInParent();
            for (int i = 0; i < this.objets.size(); ++i) {
                if (!this.objets.get(i).getBoundsInParent().intersects(bound)) continue;
                this.gameRoot.getChildren().remove((Object)this.objets.get(i));
                this.noScaleObj.remove(this.objets.get(i));
                this.objets.remove(i);
                Main.progEnCours.points += 1.0;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void nouvellesCourbes() {
        if (this.controller.nbVoie == 2) {
            this.courbe2 = new Polyline();
            this.courbe2.getStyleClass().add((Object)"courbeVoie");
            this.courbe2.setStrokeWidth((double)Main.getConfig().epaisseurVoie * 0.7);
            this.courbe2.setStyle("-fx-stroke:" + this.animationStyle.getCouleurVoie2());
            this.courbe2.setVisible(!this.controller.checkModeAveugle.isSelected());
            this.gameRoot.getChildren().add((Object)this.courbe2);
        }
        this.courbe1 = new Polyline();
        this.courbe1.getStyleClass().add((Object)"courbeVoie");
        double widthRatio = this.controller.stateStimAssistee == 4 || this.controller.motifStimEnCours != 0 ? 1.4 : 1.0;
        this.courbe1.setStrokeWidth((double)Main.getConfig().epaisseurVoie * widthRatio);
        this.courbe1.setStyle("-fx-stroke:" + this.animationStyle.getCouleurVoie1());
        this.courbe1.setVisible(!this.controller.checkModeAveugle.isSelected());
        this.gameRoot.getChildren().add((Object)this.courbe1);
    }

    @Override
    public void addEvent(String s_event, double time) {
        super.addEvent(s_event, time);
        this.drawEvent(s_event, time);
    }

    void drawEvent(String s_event, double time) {
        double labelX = this.pixOfTime(time);
        Polyline p = new Polyline(new double[]{labelX, this.anchorHeight * 0.96, labelX, this.anchorHeight * 0.04});
        Label event = new Label(s_event);
        event.getStyleClass().add((Object)"event");
        this.gameRoot.getChildren().addAll((Object[])new Node[]{p, event});
        BiofeedbackAnimation.postPositionneEvent(event, labelX, this.anchorHeight);
    }

    void redrawEvents() {
        for (int i = 0; i < Main.progEnCours.historique.tempsEvt.size(); ++i) {
            double time = (double)Main.progEnCours.historique.tempsEvt.get(i).intValue() / 100.0 - Main.progEnCours.revoir.startPageTime;
            if (!(time > this.debutPage)) continue;
            this.drawEvent(Main.progEnCours.historique.events.get(i), time);
        }
    }

    @Override
    void addNode(Node n, double dateVal, int type) {
        this.objets.add(n);
        this.noScaleObj.add(n);
    }

    @Override
    void addNodeObj(Node n, double dateVal, double level, int type) {
        this.objets.add(n);
    }

    @Override
    double pixOfTime(double temps) {
        return this.widthGame * (temps - this.debutPage) / (this.finPage - this.debutPage);
    }

    @Override
    double timeOfPix(double pix) {
        return pix * (this.finPage - this.debutPage) / this.widthGame + this.debutPage;
    }
}

