/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bilan;

import com.mazet.biostim.Main;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utilsfx.FxUtils;
import com.mazet.biostim.view.programme.bilan.BilanAnorectal;
import com.mazet.biostim.view.programme.bilan.BilanController;
import com.mazet.biostim.view.programme.bilan.BilanVaginal;
import com.mazet.biostim.view.programme.bilan.EtapeBilan;
import com.mazet.biostim.view.programme.bilan.ProgBilan;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class TestContractionController
extends EtapeBilan {
    static final int typeRapides = 0;
    static final int typeLentes = 1;
    static final int typeLentesAnorectales = 2;
    static final int typeReflexe = 3;
    static final int typeReflexeNonStop = 4;
    static final int typeVerrouillage = 5;
    static final ArrayList<Double> profilPic = new ArrayList<Double>(Arrays.asList(0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
    static final ArrayList<Double> profilPlateau = new ArrayList<Double>(Arrays.asList(0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0));
    int type = 0;
    int nbContractions = 0;
    double level = 0.5;
    double levelHaut = 0.7;
    double levelBas = 0.3;
    String titreEtape;
    @FXML
    Label title;
    @FXML
    Label label0;
    @FXML
    Label label1;
    @FXML
    Label label2;
    @FXML
    HBox hboxCombo;
    @FXML
    Label labelCombo;
    @FXML
    ComboBox<String> combo;
    @FXML
    Region vboxComboVol;
    @FXML
    ComboBox<String> comboCV;
    @FXML
    TextField textCV;
    @FXML
    TextField textVol1;
    @FXML
    TextField textVolCste;
    @FXML
    TextField textVol;
    @FXML
    LineChart<Number, Number> graphique;
    @FXML
    NumberAxis xAxis;
    @FXML
    NumberAxis yAxis;
    XYChart.Series<Number, Number> series1;
    XYChart.Series<Number, Number> series2;
    private XYChart.Series<Number, Number> seriesP;
    private XYChart.Series<Number, Number> seriesB;
    boolean isContract;
    double startContract;
    int ymax;

    @Override
    void init(ProgBilan progBilan, int posAffichee) {
        Object typeGraph;
        super.init(progBilan, posAffichee);
        switch (this.type) {
            case 0: {
                this.titreEtape = "Fibres_rapides";
                this.level = 0.0;
                this.duree = 30;
                FxUtils.setVisibility((Node)this.label0, true);
                this.dessineCanvas(profilPic);
                this.label0.setText(TransientConfig.translate("contractions_rapides"));
                break;
            }
            case 1: {
                this.titreEtape = "Fibres_lentes";
                this.dessineCanvas(profilPlateau);
                this.levelHaut = 0.5;
                this.levelBas = 0.4;
                this.label1.setText(TransientConfig.translate("maintenir_contraction"));
                break;
            }
            case 2: {
                this.titreEtape = "Fibres_lentes";
                this.dessineCanvas(profilPlateau);
                this.level = 0.3;
                this.levelHaut = 0.3;
                this.levelBas = 0.25;
                this.label1.setText(TransientConfig.translate("maintenir_contraction"));
                break;
            }
            case 3: {
                this.titreEtape = "reflexe_toux";
                this.duree = 20;
                this.level = 0.0;
                this.levelHaut = 0.6;
                this.levelBas = 0.4;
                this.setCombo("presence_reflexe");
                break;
            }
            case 4: {
                this.setComboPlusVol();
                break;
            }
            case 5: {
                this.titreEtape = "verrouillage_effort";
                this.duree = 40;
                this.levelHaut = 0.5;
                this.levelBas = 0.4;
                this.setCombo("verrouillage_ok");
            }
        }
        this.title.setText(posAffichee + ". " + TransientConfig.translate(this.titreEtape));
        this.series1 = new XYChart.Series();
        this.series1.setName(Biostim.nomOfVoie(progBilan.voie1));
        this.graphique.getData().add(this.series1);
        Object object = typeGraph = progBilan.voie2 == -1 ? "historique1" : "historique2";
        if (this.level != 0.0) {
            typeGraph = (String)typeGraph + "p";
        }
        this.graphique.setId((String)typeGraph);
        if (progBilan.voie2 != -1) {
            this.series2 = new XYChart.Series();
            this.series2.setName(Biostim.nomOfVoie(progBilan.voie2));
            this.graphique.getData().add(this.series2);
        } else if (progBilan.bilanController instanceof BilanVaginal) {
            this.graphique.setLegendVisible(false);
        }
        this.seriesP = new XYChart.Series();
        if (this.level != 0.0) {
            this.seriesP.setName(TransientConfig.translate("Profil"));
            this.graphique.getData().add(this.seriesP);
        }
        this.seriesB = new XYChart.Series();
        if (progBilan.bilanController instanceof BilanAnorectal) {
            this.seriesB.setName(TransientConfig.translate("Base"));
            this.graphique.getData().add(this.seriesB);
        }
    }

    void setCombo(String comboTxt) {
        FxUtils.setVisibility((Node)this.label1, false);
        FxUtils.setVisibility((Node)this.label2, false);
        FxUtils.setVisibility((Node)this.hboxCombo, true);
        this.labelCombo.setText(TransientConfig.translate(comboTxt));
        this.combo.getItems().add((Object)" ");
        for (int i = 0; i <= 5; ++i) {
            this.combo.getItems().add((Object)Integer.toString(i));
        }
        this.combo.getSelectionModel().select(0);
    }

    void setComboPlusVol() {
        this.titreEtape = "reflexe_anal";
        this.duree = 90;
        this.level = 0.0;
        FxUtils.setVisibility((Node)this.label1, false);
        FxUtils.setVisibility((Node)this.label2, false);
        FxUtils.setVisibility((Node)this.hboxCombo, false);
        FxUtils.setVisibility((Node)this.vboxComboVol, true);
        this.comboCV.getItems().add((Object)" ");
        for (int i = 0; i <= 5; ++i) {
            this.comboCV.getItems().add((Object)Integer.toString(i));
        }
        this.comboCV.getSelectionModel().select(0);
    }

    @Override
    void enter() {
        super.enter();
        this.xAxis.setLowerBound(0.0);
        this.xAxis.setUpperBound((double)this.endIndex);
        this.xAxis.setTickUnit(60.0);
        this.label2.setText("");
        this.isContract = false;
        this.nbContractions = 0;
        if (this.type == 0) {
            this.label1.setText("");
            this.bilan.levelMax = 1.0;
            this.bilan.levelMin = 9999.0;
            this.bilan.levelMax2 = 1.0;
        } else if (this.type == 1 || this.type == 2) {
            this.bilan.maintien = 0.0;
        } else if (this.type == 3 || this.type == 5) {
            this.combo.getSelectionModel().select(0);
        } else if (this.type == 4) {
            this.comboCV.getSelectionModel().select(0);
        }
        this.updateMax();
        this.series1.getData().clear();
        if (this.progBilan.voie2 != -1) {
            this.series2.getData().clear();
        }
    }

    @Override
    void exit() {
        if (this.type == 0) {
            this.bilan.nbRapides = this.nbContractions;
            this.calculeStat();
        }
        if (this.combo.getSelectionModel().getSelectedIndex() == 0) {
            if (this.type == 3) {
                this.combo.getSelectionModel().select(this.nbContractions > 0 ? 6 : 1);
            } else if (this.type == 5) {
                if (this.nbContractions == 1) {
                    this.combo.getSelectionModel().select(6);
                }
                if (this.nbContractions > 1) {
                    this.combo.getSelectionModel().select(1);
                }
            }
        }
        if (this.comboCV.getSelectionModel().getSelectedIndex() == 0 && this.type == 4) {
            this.comboCV.getSelectionModel().select(this.nbContractions > 0 ? 6 : 1);
        }
    }

    private void calculeStat() {
        Double startInc = null;
        Double startDec = null;
        double seuilBas = this.bilan.levelMin + 0.2 * (this.bilan.levelMax - this.bilan.levelMin);
        double seuilHaut = this.bilan.levelMin + 0.8 * (this.bilan.levelMax - this.bilan.levelMin);
        this.bilan.vitesseRelachement = null;
        this.bilan.vitesseContraction = null;
        for (int i = 0; i < this.series1.getData().size(); ++i) {
            double tps;
            XYChart.Data data1 = (XYChart.Data)this.series1.getData().get(i);
            double index = ((Number)data1.getXValue()).doubleValue();
            double x = (Double)((Number)data1.getYValue());
            if (x < seuilBas) {
                startInc = index;
                if (startDec != null) {
                    tps = (index - startDec) / 60.0;
                    if (this.bilan.vitesseRelachement == null || this.bilan.vitesseRelachement > tps) {
                        this.bilan.vitesseRelachement = tps;
                    }
                    startDec = null;
                }
            }
            if (!(x > seuilHaut)) continue;
            startDec = index;
            if (startInc == null) continue;
            tps = (index - startInc) / 60.0;
            if (this.bilan.vitesseContraction == null || this.bilan.vitesseContraction > tps) {
                this.bilan.vitesseContraction = tps;
            }
            startInc = null;
        }
    }

    @Override
    boolean update(int currentIndex) {
        double duree;
        double level;
        double data1 = Biostim.getVoie(this.progBilan.voie1);
        this.series1.getData().add((Object)new XYChart.Data((Object)currentIndex, (Object)data1));
        if (data1 > this.bilan.levelMax) {
            if (this.progBilan.voie2 != -1 && this.bilan.levelMax != 0.0) {
                this.updateVoie2(data1 / this.bilan.levelMax);
            }
            this.bilan.levelMax = data1;
            if (this.type == 0) {
                this.label1.setText(TransientConfig.translate("contraction_maximale", data1));
            }
            this.updateMax();
        }
        if (data1 < this.bilan.levelMin) {
            this.bilan.levelMin = data1;
            if (this.type != 0) {
                this.updateBaseEtProfil();
            }
        }
        if (this.progBilan.voie2 != -1) {
            double data2 = Biostim.getVoie(this.progBilan.voie2);
            if (data2 > this.bilan.levelMax2) {
                this.updateVoie2(this.bilan.levelMax2 / data2);
                this.bilan.levelMax2 = data2;
            }
            this.series2.getData().add((Object)new XYChart.Data((Object)currentIndex, (Object)(data2 * this.bilan.levelMax / this.bilan.levelMax2)));
        }
        if (this.type == 4 && currentIndex >= this.endIndex) {
            this.xAxis.setLowerBound((double)(currentIndex - this.endIndex));
            this.xAxis.setUpperBound((double)currentIndex);
            while ((Integer)((Number)((XYChart.Data)this.series1.getData().getFirst()).getXValue()) < currentIndex - this.endIndex) {
                this.series1.getData().removeFirst();
                if (this.progBilan.voie2 == -1) continue;
                this.series2.getData().removeFirst();
            }
        }
        if ((level = this.levelOfValue(data1)) > this.levelHaut && data1 > this.bilan.levelMin + 5.0) {
            if (!this.isContract) {
                this.startContract = (double)System.currentTimeMillis() / 1000.0;
            }
            this.isContract = true;
        }
        if (level < this.levelBas) {
            if (this.isContract) {
                ++this.nbContractions;
                if (this.type == 0) {
                    this.label2.setText(TransientConfig.translate("nombre_contractions", this.nbContractions));
                }
            }
            this.isContract = false;
        }
        if ((this.type == 1 || this.type == 2) && this.isContract && (duree = (double)System.currentTimeMillis() / 1000.0 - this.startContract) > this.bilan.maintien) {
            this.bilan.maintien = duree;
            this.label2.setText(TransientConfig.translate("duree_maintien", duree));
        }
        return this.type != 4 && this.endIndex < currentIndex;
    }

    private void updateVoie2(double coef) {
        ArrayList old = new ArrayList(this.series2.getData());
        this.series2.getData().clear();
        for (XYChart.Data xy : old) {
            this.series2.getData().add((Object)new XYChart.Data((Object)((Number)xy.getXValue()), (Object)(((Number)xy.getYValue()).doubleValue() * coef)));
        }
    }

    double levelOfValue(double value) {
        if (this.bilan.pressionAnale != null && this.bilan.pressionAnale < this.bilan.levelMax) {
            return (value - this.bilan.pressionAnale) / (this.bilan.levelMax - this.bilan.pressionAnale);
        }
        return (value - this.bilan.levelMin) / (this.bilan.levelMax - this.bilan.levelMin);
    }

    void updateMax() {
        int newymax = (int)(10.0 * Math.ceil(this.bilan.levelMax * 0.1));
        if (this.ymax != newymax) {
            this.ymax = newymax;
            this.yAxis.setUpperBound((double)this.ymax);
            this.yAxis.setTickUnit(BilanController.getTickUnit(this.yAxis.getUpperBound()));
            this.seriesP.getData().clear();
            if (this.type == 0) {
                for (int i = 0; i < this.endIndex; i += 60) {
                    int j = i % 180;
                    double val = 0.0;
                    if (j < 60) {
                        val = (double)(j * this.ymax) / 60.0;
                    } else if (j < 120) {
                        val = (double)((120 - j) * this.ymax) / 60.0;
                    }
                    this.seriesP.getData().add((Object)new XYChart.Data((Object)i, (Object)val));
                }
            }
            this.updateBaseEtProfil();
        }
    }

    private void updateBaseEtProfil() {
        this.seriesB.getData().clear();
        double min = this.bilan.levelMin;
        if (this.bilan.pressionAnale != null && this.bilan.pressionAnale < this.bilan.levelMax * 0.9) {
            min = this.bilan.pressionAnale;
            this.seriesB.getData().add((Object)new XYChart.Data((Object)0, (Object)min));
            this.seriesB.getData().add((Object)new XYChart.Data((Object)this.endIndex, (Object)min));
        }
        if (this.level != 0.0) {
            this.seriesP.getData().clear();
            this.seriesP.getData().add((Object)new XYChart.Data((Object)0, (Object)(min + (this.bilan.levelMax - min) * this.level)));
            this.seriesP.getData().add((Object)new XYChart.Data((Object)this.endIndex, (Object)(min + (this.bilan.levelMax - min) * this.level)));
        }
    }

    double remplirHistorique(double startTime) {
        Main.progEnCours.historique.addEvent(TransientConfig.translate(this.titreEtape), startTime);
        for (int i = 0; i < this.series1.getData().size(); ++i) {
            XYChart.Data data1 = (XYChart.Data)this.series1.getData().get(i);
            double index = ((Number)data1.getXValue()).doubleValue();
            double x = (Double)((Number)data1.getYValue());
            if (this.series2 != null) {
                XYChart.Data data2 = (XYChart.Data)this.series2.getData().get(i);
                double y = ((Number)data2.getYValue()).doubleValue() * this.bilan.levelMax2 / this.bilan.levelMax;
                Main.progEnCours.historique.ajouteValeur(startTime + index / 60.0, x, y);
                continue;
            }
            Main.progEnCours.historique.ajouteValeur(startTime + index / 60.0, x);
        }
        return this.duree;
    }

    @Override
    boolean etapeFaite() {
        if (this.series1.getData().isEmpty()) {
            return false;
        }
        int maxIndex = (Integer)((Number)((XYChart.Data)this.series1.getData().getLast()).getXValue());
        return maxIndex > 300;
    }

    public void dessineCanvas(ArrayList<Double> values) {
        double width = this.anchorCanvas.getMinWidth();
        double height = this.anchorCanvas.getMinHeight();
        Canvas canvas = new Canvas(width, height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.setLineWidth(3.0);
        for (int i = 1; i < values.size(); ++i) {
            gc.strokeLine((double)(i - 1) * (width - 1.0) / (double)values.size(), (1.03 - values.get(i - 1)) * (height - 1.0) / 1.06, (double)i * (width - 1.0) / (double)values.size(), (1.03 - values.get(i)) * (height - 1.0) / 1.06);
        }
        gc.setStroke((Paint)Color.RED);
        FxUtils.setAnchorMargin((Node)canvas);
        this.anchorCanvas.getChildren().add((Object)canvas);
    }
}

