/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.ProgEnCours;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.zdata.Affichable;
import com.mazet.biostim.zdata.Profil;
import com.mazet.biostim.zdata.Programme;
import com.mazet.biostim.zdata.Session;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.XYChart;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class Seance
extends Affichable {
    private int id;
    public Programme prog;
    private String nom;
    private String date;
    private String duree;
    private Integer max;
    private Integer min;
    private Integer tonus;
    private Integer max2;
    private Integer min2;
    private Integer tonus2;
    private Integer pourcentage;
    private Integer points;
    private String courbeSauvee;
    private int stimAmplitude;
    private int stimAmplitudeB;
    private int maxAff;
    private int maxAff2;
    public ArrayList<Integer> tendanceMax = null;
    public ArrayList<Integer> tendanceMoy = null;
    public double contractionMoyenne = -1.0;
    public double reposMoyen = -1.0;
    public double deficitContraction = -1.0;
    public int deficitContractionPourMille = -1;
    public int nbContractionsCompletes = -1;

    public Seance() {
    }

    public Seance(ProgEnCours progEnCours) {
        boolean isBalance;
        progEnCours.currentProgram.supprimeTarrage();
        this.prog = progEnCours.currentProgram;
        this.nom = progEnCours.currentProgram.getNom();
        this.date = LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
        this.duree = Utils.stringOfTime(progEnCours.currentProgram.getDuree() - progEnCours.getProgDureeRestante());
        boolean bl = isBalance = progEnCours.currentPageProgram.getType() == 13;
        if (progEnCours.getMaxPower() >= 0 && !isBalance) {
            this.max = progEnCours.getMaxPower();
            this.min = progEnCours.getMinPower();
            this.tonus = (int)progEnCours.getBase(progEnCours.currentProgram.getVoieBFB1());
            this.maxAff = (int)progEnCours.getAffMax(progEnCours.currentProgram.getVoieBFB1());
            this.contractionMoyenne = progEnCours.getContractionMoyenne();
            this.reposMoyen = progEnCours.getReposMoyen();
            this.deficitContraction = progEnCours.getDeficitContraction();
            this.deficitContractionPourMille = progEnCours.getDeficitContractionPourMille();
            this.nbContractionsCompletes = progEnCours.nbContractionsCompletes;
        }
        if (progEnCours.getMaxPower2() >= 0) {
            this.max2 = progEnCours.getMaxPower2();
            this.min2 = progEnCours.getMinPower2();
            this.tonus2 = (int)progEnCours.getBase(progEnCours.currentProgram.getVoieBFB2());
            this.maxAff2 = (int)progEnCours.getAffMax(progEnCours.currentProgram.getVoieBFB2());
        }
        if (progEnCours.hasPourcentageReussite()) {
            Profil p = progEnCours.currentPageProgram.getProfil();
            if (p != null && p.typeProfil() == 2) {
                this.pourcentage = progEnCours.getPourcentageReussite();
                this.points = (int)progEnCours.points;
            }
        } else if (progEnCours.currentPageProgram.getType() == 10 || isBalance) {
            this.points = (int)progEnCours.points;
        }
        if (progEnCours.revoir != null && Main.getCurrentPatient() != null && !isBalance) {
            this.courbeSauvee = progEnCours.historique.saveHistory(this.max.intValue(), this.max2 == null ? 1.0 : (double)this.max2.intValue());
        }
        this.stimAmplitude = (int)progEnCours.getMaxStimAmplitudeA();
        this.stimAmplitudeB = (int)progEnCours.getMaxStimAmplitudeB();
        this.commentaire = progEnCours.commentaire;
        this.position = progEnCours.position;
        if (progEnCours.historique.tendanceTravail.getData().size() > 2 && !isBalance) {
            int pos;
            this.tendanceMax = new ArrayList();
            for (XYChart.Data data : progEnCours.historique.tendanceTravail.getData()) {
                pos = (Integer)data.getXValue();
                while (this.tendanceMax.size() < pos) {
                    this.tendanceMax.add(null);
                }
                this.tendanceMax.add((int)((Double)data.getYValue() / (double)this.max.intValue() * 1000.0));
            }
            this.tendanceMoy = new ArrayList();
            for (XYChart.Data data : progEnCours.historique.tendanceRepos.getData()) {
                pos = (Integer)data.getXValue();
                while (this.tendanceMoy.size() < pos) {
                    this.tendanceMoy.add(null);
                }
                this.tendanceMoy.add((int)((Double)data.getYValue() / (double)this.max.intValue() * 1000.0));
            }
        }
    }

    public Seance(String nom, String commentaire) {
        this.id = -1;
        this.nom = nom;
        this.date = LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
        this.commentaire = commentaire;
    }

    public void supprime(Session session) {
        session.getListSeances().remove(this);
    }

    @Override
    public Programme getProg() {
        if (this.prog != null) {
            return this.prog;
        }
        return Programme.getProgById(this.id);
    }

    public boolean isProgId(int id) {
        if (this.prog != null) {
            return this.prog.getId() == id;
        }
        return this.id == id;
    }

    public int getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDuree() {
        return this.duree;
    }

    public int getStimAmplitude() {
        return this.stimAmplitude;
    }

    public int getStimAmplitudeB() {
        return this.stimAmplitudeB;
    }

    public Integer getMax() {
        return this.max;
    }

    public int getMaxAff() {
        if (this.maxAff == 0 && this.max != null) {
            return this.max - this.getIntTonus();
        }
        return this.maxAff - this.getIntTonus();
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getTonus() {
        return this.tonus;
    }

    public int getIntTonus() {
        return !Main.getConfig().baseZeroPatient || this.tonus == null ? 0 : this.tonus;
    }

    public int getIntTonus2() {
        return !Main.getConfig().baseZeroPatient || this.tonus2 == null ? 0 : this.tonus2;
    }

    public Integer getMax2() {
        return this.max2;
    }

    public int getMaxAff2() {
        if (this.maxAff2 == 0 && this.max2 != null) {
            return this.max2 - this.getIntTonus2();
        }
        return this.maxAff2 - this.getIntTonus2();
    }

    public Integer getPoints() {
        return this.points;
    }

    public Integer getPourcentage() {
        return this.pourcentage;
    }

    @Override
    public String getCourbeSauvee() {
        return this.courbeSauvee;
    }

    public boolean hasTendance() {
        return this.tendanceMoy != null;
    }

    public Canvas getCanvasTendance(double width, double height) {
        Canvas res = new Canvas(width, height);
        GraphicsContext gc = res.getGraphicsContext2D();
        gc.setLineWidth(Math.max(1.0, height / 50.0));
        int max = Math.max(this.tendanceMoy.size(), this.tendanceMax.size()) - 1;
        this.dessineCourbe(gc, this.tendanceMoy, Color.ORANGE, max, width, height);
        this.dessineCourbe(gc, this.tendanceMax, Color.RED, max, width, height);
        return res;
    }

    private void dessineCourbe(GraphicsContext gc, ArrayList<Integer> tendance, Color color, int max, double width, double height) {
        if (tendance.size() >= 2) {
            gc.setStroke((Paint)color);
            int prev = 0;
            Integer prevVal = tendance.getFirst();
            for (int i = 1; i <= max; ++i) {
                if (tendance.size() <= i || tendance.get(i) == null) continue;
                if (prevVal != null) {
                    gc.strokeLine((double)prev * (width - 1.0) / (double)max, (double)(1070 - prevVal) * (height - 1.0) / 1070.0, (double)i * (width - 1.0) / (double)max, (double)(1070 - tendance.get(i)) * (height - 1.0) / 1070.0);
                }
                prev = i;
                prevVal = tendance.get(i);
            }
        }
    }
}

