/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.quantum.ViewPainter;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.stage.Window;
import javafx.util.Subscription;

final class ViewSceneOverlay {
    private final Scene scene;
    private final ViewPainter painter;
    private final Subscription subscriptions;
    private Parent root;
    private boolean rootDirty;
    private double width;
    private double height;

    ViewSceneOverlay(Scene scene, ViewPainter viewPainter) {
        this.scene = scene;
        this.painter = viewPainter;
        this.subscriptions = Subscription.combine((Subscription[])new Subscription[]{scene.rootProperty().subscribe(this::onSceneRootChanged), scene.effectiveNodeOrientationProperty().subscribe(this::onEffectiveNodeOrientationInvalidated)});
    }

    public void dispose() {
        this.subscriptions.unsubscribe();
    }

    public void reapplyCSS() {
        if (this.root != null) {
            NodeHelper.reapplyCSS(this.root);
        }
    }

    public void processCSS() {
        if (this.root != null) {
            NodeHelper.processCSS(this.root);
        }
    }

    public void resize(double d, double d2) {
        this.width = d;
        this.height = d2;
    }

    public void layout() {
        if (this.scene == null) {
            return;
        }
        Window window = this.scene.getWindow();
        if (this.root != null && window != null) {
            this.root.resize(this.width, this.height);
            this.root.layout();
            NodeHelper.updateBounds(this.root);
        }
    }

    public void setRoot(Parent parent) {
        if (this.root == parent) {
            return;
        }
        if (this.root != null) {
            NodeHelper.setParent(this.root, null);
            NodeHelper.setScenes(this.root, null, null);
            NodeHelper.setInheritOrientationFromScene(this.root, false);
        }
        this.root = parent;
        if (parent != null) {
            NodeHelper.setParent(parent, this.scene.getRoot());
            NodeHelper.setScenes(parent, this.scene, null);
            NodeHelper.setInheritOrientationFromScene(parent, true);
        }
        this.rootDirty = true;
    }

    public void synchronize() {
        if (this.rootDirty || this.root != null && !NodeHelper.isDirtyEmpty(this.root)) {
            this.rootDirty = false;
            if (this.root != null) {
                this.syncPeer(this.root);
                this.painter.setOverlayRoot((NGNode)NodeHelper.getPeer(this.root));
            } else {
                this.painter.setOverlayRoot(null);
                SceneHelper.getPeer(this.scene).entireSceneNeedsRepaint();
            }
        }
    }

    private void syncPeer(Node node) {
        NodeHelper.syncPeer(node);
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node node2 : parent.getChildrenUnmodifiable()) {
                this.syncPeer(node2);
            }
        } else if (node instanceof SubScene) {
            SubScene subScene = (SubScene)node;
            this.syncPeer(subScene.getRoot());
        }
        if (node.getClip() != null) {
            this.syncPeer(node.getClip());
        }
    }

    private void onSceneRootChanged(Parent parent) {
        if (this.root != null) {
            NodeHelper.setParent(this.root, parent);
        }
    }

    private void onEffectiveNodeOrientationInvalidated(NodeOrientation nodeOrientation) {
        if (this.root != null) {
            NodeHelper.nodeResolvedOrientationInvalidated(this.root);
        }
    }
}

