/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.patient;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.mazet.biostim.Main;
import com.mazet.biostim.ProgEnCours;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.Pdf;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.patient.RevoirBilan;
import com.mazet.biostim.view.patient.RevoirController;
import com.mazet.biostim.zdata.Affichable;
import com.mazet.biostim.zdata.Bilan;
import com.mazet.biostim.zdata.Kines;
import com.mazet.biostim.zdata.Patient;
import com.mazet.biostim.zdata.Programme;
import com.mazet.biostim.zdata.Seance;
import com.mazet.biostim.zdata.Session;
import java.awt.Desktop;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;

public class patientbilanViewController
extends Controller {
    private Patient patient;
    private Session sessionAffiche;
    @FXML
    private Label title;
    @FXML
    private ToggleButton boutonIdentite;
    @FXML
    private ToggleButton boutonSuiviSeances;
    @FXML
    private AnchorPane suiviId;
    @FXML
    private HBox printPatient;
    @FXML
    private VBox infosPatient;
    @FXML
    private VBox infosDoc;
    @FXML
    private VBox suiviVBox;
    @FXML
    private HBox listSessions;
    @FXML
    private Separator sepSessions;
    @FXML
    private ComboBox<Session> comboSession;
    private boolean comboSessionListenerActif = true;
    @FXML
    private GridPane listFormulaires;
    @FXML
    private HBox conteneurChoixForm;
    @FXML
    private ComboBox<String> comboForm;
    @FXML
    private VBox printSession;
    @FXML
    private Label titreBilans;
    @FXML
    private GridPane bilansVaginaux;
    @FXML
    private GridPane bilansAnorectaux;
    @FXML
    private Label titreSeances;
    @FXML
    private Button boutonBilan;
    @FXML
    ComboBox<String> typeComment;
    @FXML
    private TextArea textComment;
    @FXML
    private Button addComment;
    @FXML
    private Label historyComments;
    @FXML
    private LineChart<String, Number> graphSeances;
    @FXML
    CategoryAxis xAxis;
    @FXML
    private GridPane tableauSeances;
    private ComboBox<String> kineField;
    private Kines kines;
    private TextField lastNameField;
    private TextField firstNameField;
    private ComboBox<String> motifField;
    private TextField numSecuField;
    private TextField adresseField;
    private TextField phoneField;
    private TextField mailField;
    private ComboBox<String> sexeField;
    private DatePicker ddnField;
    private TextField tailleField;
    private TextField poidField;
    private TextField firstNameMedField;
    private TextField lastNameMedField;
    private TextField adresseMedField;
    private TextField telephoneMedField;
    private TextField mailMedField;
    private boolean hasTendance = false;
    private boolean hasPosition = false;
    private static final ArrayList<Bilan> vaginalCompar = new ArrayList();
    private static final ArrayList<Bilan> anorectalCompar = new ArrayList();
    private final ArrayList<Seance> seanceCompar = new ArrayList();

    @Override
    public void setMain() {
        this.patient = Main.getCurrentPatient();
        if (this.patient == null) {
            this.patient = Main.tempPatient;
        }
        this.title.setText(this.patient.getName());
        this.initFormPatient();
        vaginalCompar.clear();
        anorectalCompar.clear();
        this.typeComment.getItems().addAll((Object[])new String[]{TransientConfig.translate("Commentaire"), TransientConfig.translate("seance_manuelle"), TransientConfig.translate("hypopressif"), TransientConfig.translate("pilates"), TransientConfig.translate("respiration")});
        this.typeComment.getSelectionModel().select(0);
        this.comboSession.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (this.comboSessionListenerActif) {
                this.sessionAffiche = newVal;
                this.afficheDroite();
            }
        });
        this.updateComboSession();
        if (this.patient.isNewPatient()) {
            this.versId();
        }
    }

    @FXML
    void versId() {
        this.boutonIdentite.setSelected(true);
        this.boutonSuiviSeances.setSelected(false);
        FxUtils.setVisibility((Node)this.suiviId, true);
        FxUtils.setVisibility((Node)this.suiviVBox, false);
    }

    @FXML
    void versSuivi() {
        this.boutonIdentite.setSelected(false);
        this.boutonSuiviSeances.setSelected(true);
        FxUtils.setVisibility((Node)this.suiviId, false);
        FxUtils.setVisibility((Node)this.suiviVBox, true);
    }

    void updateComboSession() {
        FxUtils.setVisibility((Node)this.listSessions, this.patient.getSessions().size() != 1);
        FxUtils.setVisibility((Node)this.sepSessions, this.patient.getSessions().size() != 1);
        this.patient.getSessions().sort((o1, o2) -> Integer.compare(o2.getId(), o1.getId()));
        this.sessionAffiche = this.patient.getSessions().get(0);
        ObservableList temps = FXCollections.observableArrayList();
        temps.addAll(this.patient.getSessions());
        this.comboSessionListenerActif = false;
        this.comboSession.setItems(temps);
        this.comboSessionListenerActif = true;
        this.comboSession.getSelectionModel().select((Object)this.sessionAffiche);
    }

    @Override
    public void exitAction() {
        block6: {
            try {
                LocalDate localDate;
                if (Main.getCurrentPatient() == null) break block6;
                if (this.kineField != null) {
                    int pos = this.kineField.getSelectionModel().getSelectedIndex();
                    this.patient.kine = pos == -1 ? -1 : this.kines.nums.get(pos);
                }
                this.patient.setFirstName(this.firstNameField.getText());
                this.patient.setLastName(this.lastNameField.getText());
                this.patient.motif = this.motifField.getSelectionModel().getSelectedIndex();
                this.patient.setNumSecu(this.numSecuField.getText());
                try {
                    localDate = (LocalDate)this.ddnField.getConverter().fromString(this.ddnField.getEditor().getText());
                }
                catch (Exception ignored) {
                    localDate = (LocalDate)this.ddnField.getValue();
                }
                Date newDate = localDate == null ? null : Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                this.patient.setDateNaissance(newDate);
                this.patient.setAdresse(this.adresseField.getText());
                this.patient.setTaille(this.tailleField.getText());
                this.patient.setPoid(this.poidField.getText());
                this.patient.setGenre(this.sexeField.getSelectionModel().getSelectedIndex());
                this.patient.setTelephone(this.phoneField.getText());
                this.patient.setMail(this.mailField.getText());
                this.patient.setMedecinPrenom(this.firstNameMedField.getText());
                this.patient.setMedecinNom(this.lastNameMedField.getText());
                this.patient.setMedecinAdresse(this.adresseMedField.getText());
                this.patient.setMedecinMail(this.mailMedField.getText());
                this.patient.setMedecinTelephone(this.telephoneMedField.getText());
                if (this.patient.getFileName() != null) {
                    this.patient.delete();
                }
                this.patient.save(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initFormPatient() {
        try {
            if (Main.getConfig().multiKine) {
                this.kines = Utils.fromJsonFile(Main.getConfig().getKineJson(), Kines.class);
                this.kineField = new ComboBox(FXCollections.observableArrayList(this.kines.noms));
                this.kineField.getSelectionModel().select(this.kines.nums.indexOf(this.patient.kine));
                this.addLabelToPatient("suiviPar", (Node)this.kineField);
                this.infosPatient.getChildren().add((Object)new Label(" "));
            }
            this.lastNameField = new TextField(this.patient.getLastName());
            this.firstNameField = new TextField(this.patient.getFirstName());
            this.motifField = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{TransientConfig.translate("prepartum"), TransientConfig.translate("postpartum"), TransientConfig.translate("IUE"), TransientConfig.translate("hyperactivite"), TransientConfig.translate("prolapsus"), TransientConfig.translate("sexologie"), TransientConfig.translate("preop"), TransientConfig.translate("postop"), TransientConfig.translate("incontinenceanale"), TransientConfig.translate("constipation"), TransientConfig.translate("endometriose"), TransientConfig.translate("enuresie"), TransientConfig.translate("autre")}));
            if (this.patient.motif != -1) {
                this.motifField.getSelectionModel().select(this.patient.motif);
            }
            this.numSecuField = new TextField(this.patient.getNumSecu());
            this.adresseField = new TextField(this.patient.getAdresse());
            this.phoneField = new TextField(this.patient.getTelephone());
            this.mailField = new TextField(this.patient.getMail());
            this.sexeField = new ComboBox(FXCollections.observableArrayList((Object[])new String[]{TransientConfig.translate("sexFemale"), TransientConfig.translate("sexMale")}));
            if (this.patient.getGenre() != null) {
                this.sexeField.getSelectionModel().select(this.patient.getGenre().intValue());
            }
            this.ddnField = new DatePicker();
            if (this.patient.getDateNaissance() != null) {
                this.ddnField.setValue((Object)this.patient.getDateNaissance().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            this.tailleField = new TextField(this.patient.getTaille());
            this.poidField = new TextField(this.patient.getPoid());
            this.firstNameMedField = new TextField(this.patient.getMedecinNom());
            this.lastNameMedField = new TextField(this.patient.getMedecinPrenom());
            this.adresseMedField = new TextField(this.patient.getMedecinAdresse());
            this.telephoneMedField = new TextField(this.patient.getMedecinTelephone());
            this.mailMedField = new TextField(this.patient.getMedecinMail());
            this.addLabelToPatient("name", (Node)this.lastNameField);
            this.addLabelToPatient("firstName", (Node)this.firstNameField);
            this.addLabelToPatient("motif", (Node)this.motifField);
            this.infosPatient.getChildren().add((Object)new Label(" "));
            this.addLabelToPatient("numSecu", (Node)this.numSecuField);
            this.addLabelToPatient("address", (Node)this.adresseField);
            this.addLabelToPatient("phone", (Node)this.phoneField);
            this.addLabelToPatient("email", (Node)this.mailField);
            this.addLabelToPatient("sex", (Node)this.sexeField);
            this.addLabelToPatient("dateOfBirth", (Node)this.ddnField);
            this.addLabelToPatient("taille", (Node)this.tailleField);
            this.addLabelToPatient("poids", (Node)this.poidField);
            this.addLabelToDoc("name", (Node)this.lastNameMedField);
            this.addLabelToDoc("firstName", (Node)this.firstNameMedField);
            this.addLabelToDoc("address", (Node)this.adresseMedField);
            this.addLabelToDoc("phone", (Node)this.telephoneMedField);
            this.addLabelToDoc("email", (Node)this.mailMedField);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addLabelToPatient(String key, Node field) {
        Label label = new Label(TransientConfig.translate(key));
        label.setMinWidth(120.0);
        HBox hbox = new HBox(10.0, new Node[]{label, field});
        hbox.setMinWidth(450.0);
        HBox.setHgrow((Node)field, (Priority)Priority.ALWAYS);
        this.infosPatient.getChildren().add((Object)hbox);
    }

    private void addLabelToDoc(String key, Node field) {
        Label label = new Label(TransientConfig.translate(key));
        label.setMinWidth(120.0);
        HBox hbox = new HBox(10.0, new Node[]{label, field});
        hbox.setMinWidth(450.0);
        HBox.setHgrow((Node)field, (Priority)Priority.ALWAYS);
        this.infosDoc.getChildren().add((Object)hbox);
    }

    private void afficheDroite() {
        boolean isActive = this.sessionAffiche == this.patient.getSessions().get(0);
        this.listFormulaires.getChildren().clear();
        if (!this.sessionAffiche.getListForm().isEmpty()) {
            this.afficheTableauFormulaires();
        }
        FxUtils.setVisibility((Node)this.conteneurChoixForm, isActive);
        if (isActive) {
            ObservableList<String> modelesFormulaire = Computer.getListFormulaires();
            modelesFormulaire.add((Object)TransientConfig.translate("document_personnalise"));
            this.comboForm.setItems((ObservableList)modelesFormulaire);
            this.comboForm.setPromptText(TransientConfig.translate("select_formulaire"));
        }
        for (Node n : this.printSession.getChildren()) {
            FxUtils.setVisibility(n, false);
        }
        Programme progBilan = Programme.getProgById(Main.getConfig().progBilan);
        if (progBilan == null) {
            progBilan = Programme.getProgById(500);
        }
        this.boutonBilan.setText(progBilan.getNom());
        this.boutonBilan.setUserData((Object)progBilan);
        if (!this.sessionAffiche.getListBilans().isEmpty()) {
            FxUtils.setVisibility((Node)this.titreBilans, true);
            ArrayList<Bilan> vaginal = new ArrayList<Bilan>();
            ArrayList<Bilan> anorectal = new ArrayList<Bilan>();
            for (Bilan bilan : this.sessionAffiche.getListBilans()) {
                if (bilan.prog.getFirstPage().getType() == -2) {
                    vaginal.add(bilan);
                    continue;
                }
                anorectal.add(bilan);
            }
            if (Main.getConfig().triSeances) {
                Collections.reverse(vaginal);
                Collections.reverse(anorectal);
            }
            if (!vaginal.isEmpty()) {
                patientbilanViewController.afficheTableauBilanVaginal(this, this.bilansVaginaux, vaginal);
            }
            if (!anorectal.isEmpty()) {
                patientbilanViewController.afficheTableauBilanAnorectal(this, this.bilansAnorectaux, anorectal);
            }
        }
        if (!this.sessionAffiche.getListSeances().isEmpty()) {
            FxUtils.setVisibility((Node)this.titreSeances, true);
            FxUtils.setVisibility(this.graphSeances, Main.getConfig().afficheGraphiquePagePatient);
            FxUtils.setVisibility((Node)this.tableauSeances, true);
            this.initInfoSeance();
        }
        FxUtils.setVisibility((Node)this.textComment, isActive);
        FxUtils.setVisibility((Node)this.addComment, isActive);
        this.historyComments.setText(String.join((CharSequence)"\n", this.sessionAffiche.getComments()));
    }

    void afficheTableauFormulaires() {
        for (String fichier : this.sessionAffiche.getListForm()) {
            this.ajouteBoutonForm(fichier);
        }
    }

    private void ajouteBoutonForm(String fichierForm) {
        try {
            if (this.listFormulaires.getChildren().isEmpty()) {
                Region regionRow0 = new Region();
                regionRow0.getStyleClass().add((Object)"row0GridConfig");
                this.listFormulaires.add((Node)regionRow0, 0, 0, 2, 1);
                patientbilanViewController.addTitleTableau(this.listFormulaires, "date", 0);
                patientbilanViewController.addTitleTableau(this.listFormulaires, "formulaires", 1);
            }
            int pos = fichierForm.indexOf(95);
            String fichier = fichierForm.substring(pos + 1);
            pos = fichier.indexOf(95);
            int pos_point = fichier.lastIndexOf(46);
            String titre = fichier.substring(pos + 1, pos_point);
            Date date = Utils.formatDateFormulaire2.parse(fichier.substring(0, 10));
            LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            Label labelDate = new Label(localDate.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)));
            labelDate.getStyleClass().add((Object)"valtableauFin");
            Label label = new Label(titre);
            label.setOnMouseClicked(this::clicFormulaire);
            label.setUserData((Object)fichierForm);
            label.getStyleClass().add((Object)"nomSeanceTableauCliquable");
            label.setStyle("-fx-padding: 0 20 0 0;");
            int ligne = 1 + GridPane.getRowIndex((Node)((Node)this.listFormulaires.getChildren().get(this.listFormulaires.getChildren().size() - 1)));
            Region regionRow = new Region();
            regionRow.setMinHeight(45.0);
            regionRow.getStyleClass().add((Object)(ligne % 2 == 0 ? "grisclair" : "blanc"));
            this.listFormulaires.add((Node)regionRow, 0, ligne, 2, 1);
            this.listFormulaires.add((Node)labelDate, 0, ligne);
            this.listFormulaires.add((Node)label, 1, ligne);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void afficheTableauBilanVaginal(patientbilanViewController pbvc, GridPane bilansVaginaux, ArrayList<Bilan> bilans) {
        FxUtils.setVisibility((Node)bilansVaginaux, true);
        bilansVaginaux.getChildren().clear();
        Region regionRow0 = new Region();
        regionRow0.getStyleClass().add((Object)"row0GridConfig");
        bilansVaginaux.add((Node)regionRow0, 0, 0, 10, 1);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "date", 2);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "Min", 3);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "Max", 4);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "nb_rapides", 5);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "maintien", 6);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "tab_reflexe_toux", 7);
        patientbilanViewController.addTitleTableau(bilansVaginaux, "tab_verrouillage_effort", 8);
        if (pbvc != null && Main.getConfig().isActivated) {
            ColumnConstraints c = (ColumnConstraints)bilansVaginaux.getColumnConstraints().get(0);
            c.setMinWidth(50.0);
            c.setMaxWidth(50.0);
            Label revoir = new Label();
            revoir.getStyleClass().add((Object)"revoirButton");
            revoir.setOnMouseClicked(e -> patientbilanViewController.comparerBilan(vaginalCompar, false));
            FxUtils.setAnchorMargin((Node)revoir);
            bilansVaginaux.add((Node)new AnchorPane(new Node[]{revoir}), 0, 0);
        }
        int row = 1;
        int ligne = 0;
        for (Bilan bilan : bilans) {
            row += patientbilanViewController.createVaginalLine(pbvc, bilansVaginaux, ligne, row, bilan, bilans);
            ++ligne;
        }
    }

    private static int createVaginalLine(patientbilanViewController pbvc, GridPane bilansVaginaux, int ligne, int row, Bilan bilan, ArrayList<Bilan> bilans) {
        int nbRow = bilan.getCommentaire().isEmpty() ? 1 : 2;
        Region regionRow = new Region();
        regionRow.setMinHeight(45.0);
        regionRow.getStyleClass().add((Object)(ligne % 2 == 0 ? "grisclair" : "blanc"));
        bilansVaginaux.add((Node)regionRow, 0, row, 10, nbRow);
        Label date = new Label(bilan.getDate());
        if (pbvc != null) {
            date.setOnMouseClicked(e -> pbvc.clicBilan(bilan, false, (MouseEvent)e));
        }
        if (pbvc != null && Main.getConfig().isActivated && bilan.getCourbeSauvee() != null) {
            date.getStyleClass().add((Object)"nomSeanceTableauCliquable");
        } else {
            date.getStyleClass().add((Object)"nomSeanceTableau");
            if (pbvc == null && bilans.size() > 1) {
                date.setStyle("-fx-text-fill : " + RevoirController.couleurs.get(ligne));
            }
        }
        bilansVaginaux.add((Node)date, 2, row);
        bilansVaginaux.add((Node)new Label(String.format("%.0f", bilan.levelMin)), 3, row);
        bilansVaginaux.add((Node)new Label(String.format("%.0f", bilan.levelMax)), 4, row);
        if (bilan.nbRapides != null) {
            bilansVaginaux.add((Node)new Label(Integer.toString(bilan.nbRapides)), 5, row);
        }
        if (bilan.maintien != null) {
            bilansVaginaux.add((Node)new Label(String.format("%.1f", bilan.maintien)), 6, row);
        }
        if (bilan.reflexe > 0) {
            bilansVaginaux.add((Node)new Label(TransientConfig.translate(bilan.reflexe == 1 ? "oui" : "non")), 7, row);
        } else if (bilan.reflexe < 0) {
            bilansVaginaux.add((Node)new Label(Integer.toString(-1 - bilan.reflexe)), 7, row);
        }
        if (bilan.verrouillage > 0) {
            bilansVaginaux.add((Node)new Label(TransientConfig.translate(bilan.verrouillage == 1 ? "oui" : "non")), 8, row);
        } else if (bilan.verrouillage < 0) {
            bilansVaginaux.add((Node)new Label(Integer.toString(-1 - bilan.verrouillage)), 8, row);
        }
        if (pbvc != null) {
            pbvc.addBoutonsPicto(bilansVaginaux, 9, row, 1, bilan, vaginalCompar);
        }
        if (!bilan.getCommentaire().isEmpty()) {
            TextFlow comment = new TextFlow(new Node[]{new Text(bilan.getCommentaire())});
            bilansVaginaux.add((Node)comment, 2, row + 1, 7, 1);
        }
        if (pbvc != null) {
            Label changeComment = new Label();
            changeComment.getStyleClass().add((Object)"commentButton");
            changeComment.setOnMouseClicked(e -> pbvc.modifCommentaire(bilan));
            FxUtils.setAnchorMargin((Node)changeComment);
            bilansVaginaux.add((Node)new AnchorPane(new Node[]{changeComment}), 1, row, 1, 1);
        }
        return nbRow;
    }

    static void afficheTableauBilanAnorectal(patientbilanViewController pbvc, GridPane bilansAnorectaux, ArrayList<Bilan> bilans) {
        FxUtils.setVisibility((Node)bilansAnorectaux, true);
        bilansAnorectaux.getChildren().clear();
        Region regionRow0 = new Region();
        regionRow0.getStyleClass().add((Object)"row0GridConfig");
        bilansAnorectaux.add((Node)regionRow0, 0, 0, 13, 1);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "date", 2);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "repos", 3);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "Max", 4);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "nb_rapides", 5);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "maintien", 6);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "reflexe_anal", 7);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "volume_reflexe_court", 8);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "volume_premiere_sensation_court", 9);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "volume_sensation_constante_court", 10);
        patientbilanViewController.addTitleTableau(bilansAnorectaux, "volume_max_tolerable_court", 11);
        if (pbvc != null && Main.getConfig().isActivated) {
            ColumnConstraints c = (ColumnConstraints)bilansAnorectaux.getColumnConstraints().get(0);
            c.setMinWidth(50.0);
            c.setMaxWidth(50.0);
            Label revoir = new Label();
            revoir.getStyleClass().add((Object)"revoirButton");
            revoir.setOnMouseClicked(e -> patientbilanViewController.comparerBilan(anorectalCompar, true));
            FxUtils.setAnchorMargin((Node)revoir);
            bilansAnorectaux.add((Node)new AnchorPane(new Node[]{revoir}), 0, 0);
        }
        int row = 1;
        int ligne = 0;
        for (Bilan bilan : bilans) {
            row += patientbilanViewController.createAnorectalLine(pbvc, bilansAnorectaux, ligne, row, bilan, bilans);
            ++ligne;
        }
    }

    static int createAnorectalLine(patientbilanViewController pbvc, GridPane bilansAnorectaux, int ligne, int row, Bilan bilan, ArrayList<Bilan> bilans) {
        int nbRow = !bilan.getCommentaire().isEmpty() ? 2 : 1;
        Region regionRow = new Region();
        regionRow.setMinHeight(45.0);
        regionRow.getStyleClass().add((Object)(ligne % 2 == 0 ? "grisclair" : "blanc"));
        bilansAnorectaux.add((Node)regionRow, 0, row, 13, nbRow);
        Label titre = new Label(bilan.getDate());
        if (pbvc != null) {
            titre.setOnMouseClicked(e -> pbvc.clicBilan(bilan, true, (MouseEvent)e));
        }
        if (pbvc != null && Main.getConfig().isActivated && bilan.getCourbeSauvee() != null) {
            titre.getStyleClass().add((Object)"nomSeanceTableauCliquable");
        } else {
            titre.getStyleClass().add((Object)"nomSeanceTableau");
            if (pbvc == null && bilans.size() > 1) {
                titre.setStyle("-fx-text-fill : " + RevoirController.couleurs.get(ligne));
            }
        }
        bilansAnorectaux.add((Node)titre, 2, row);
        if (bilan.pressionAnale != null) {
            bilansAnorectaux.add((Node)new Label(String.format("%.0f", bilan.pressionAnale)), 3, row);
        }
        bilansAnorectaux.add((Node)new Label(String.format("%.0f", bilan.levelMax)), 4, row);
        if (bilan.nbRapides != null) {
            bilansAnorectaux.add((Node)new Label(Integer.toString(bilan.nbRapides)), 5, row);
        }
        if (bilan.maintien != null) {
            bilansAnorectaux.add((Node)new Label(String.format("%.1f", bilan.maintien)), 6, row);
        }
        if (bilan.reflexeAnal > 0) {
            bilansAnorectaux.add((Node)new Label(TransientConfig.translate(bilan.reflexeAnal == 1 ? "oui" : "non")), 7, row);
        } else if (bilan.reflexeAnal < 0) {
            bilansAnorectaux.add((Node)new Label(Integer.toString(-1 - bilan.reflexeAnal)), 7, row);
        }
        if (bilan.volReflexeAnal != 0) {
            bilansAnorectaux.add((Node)new Label(Integer.toString(bilan.volReflexeAnal)), 8, row);
        }
        if (bilan.volPremiereSensation != 0) {
            bilansAnorectaux.add((Node)new Label(Integer.toString(bilan.volPremiereSensation)), 9, row);
        }
        if (bilan.volSensationConstante != 0) {
            bilansAnorectaux.add((Node)new Label(Integer.toString(bilan.volSensationConstante)), 10, row);
        }
        if (bilan.volumeRectal != null) {
            bilansAnorectaux.add((Node)new Label(Integer.toString(bilan.volumeRectal)), 11, row);
        }
        if (pbvc != null) {
            pbvc.addBoutonsPicto(bilansAnorectaux, 12, row, 1, bilan, anorectalCompar);
        }
        if (!bilan.getCommentaire().isEmpty()) {
            TextFlow comment = new TextFlow(new Node[]{new Text(bilan.getCommentaire())});
            bilansAnorectaux.add((Node)comment, 2, row + 1, 8, 1);
        }
        if (pbvc != null) {
            Label changeComment = new Label();
            changeComment.getStyleClass().add((Object)"commentButton");
            changeComment.setOnMouseClicked(e -> pbvc.modifCommentaire(bilan));
            FxUtils.setAnchorMargin((Node)changeComment);
            bilansAnorectaux.add((Node)new AnchorPane(new Node[]{changeComment}), 1, row, 1, 1);
        }
        return nbRow;
    }

    private void addBoutonsPicto(GridPane tableau, int col, int row, int nbRow, Affichable aff, ArrayList listCompar) {
        Programme pplay = aff.getProg();
        if (pplay != null) {
            Label butGo = new Label();
            butGo.setUserData((Object)pplay);
            butGo.getStyleClass().add((Object)"playButtonTransp");
            butGo.setOnMouseClicked(this::startProg);
            FxUtils.setAnchorMargin((Node)butGo);
            AnchorPane anchorGo = new AnchorPane(new Node[]{butGo});
            tableau.add((Node)anchorGo, col, row, 1, nbRow);
        }
        if (Main.getConfig().isActivated && aff.getCourbeSauvee() != null) {
            CheckBox revoir = new CheckBox();
            revoir.setSelected(listCompar.contains(aff));
            revoir.selectedProperty().addListener((a, b, newval) -> this.clicRevoir(listCompar, (Boolean)newval, aff));
            tableau.add((Node)revoir, 0, row, 1, nbRow);
        }
    }

    private void initInfoSeance() {
        try {
            ColumnConstraints columnConstraintsVerySmall = (ColumnConstraints)this.tableauSeances.getColumnConstraints().get(0);
            ColumnConstraints columnConstraintsSmall = (ColumnConstraints)this.tableauSeances.getColumnConstraints().get(9);
            ColumnConstraints columnConstraintsGraph = (ColumnConstraints)this.tableauSeances.getColumnConstraints().get(8);
            if (Main.getConfig().typeScore == 0) {
                this.tableauSeances.getColumnConstraints().set(7, (Object)columnConstraintsVerySmall);
            }
            if (Main.getConfig().isActivated) {
                this.tableauSeances.getColumnConstraints().set(0, (Object)columnConstraintsSmall);
            }
            this.remplirTableauSeances(-1);
            if (this.hasTendance) {
                this.tableauSeances.getColumnConstraints().set(1, (Object)columnConstraintsGraph);
            }
            if (this.hasPosition) {
                this.tableauSeances.getColumnConstraints().set(2, (Object)columnConstraintsSmall);
            }
            ArrayList<String> etiquettes = new ArrayList<String>();
            if (Main.getConfig().afficheGraphiquePagePatient) {
                ArrayList<Seance> listSeances = this.sessionAffiche.getListSeances();
                String datePrec = null;
                String dateUnique = null;
                int maxmax = 1;
                for (Seance seance : listSeances) {
                    Integer max = seance.getMax();
                    if (max == null || max <= maxmax) continue;
                    maxmax = max;
                }
                XYChart.Series aSeries = new XYChart.Series();
                XYChart.Series bSeries = new XYChart.Series();
                for (Seance seance : listSeances) {
                    String date2 = seance.getDate();
                    dateUnique = date2.equals(datePrec) ? dateUnique + " " : date2;
                    etiquettes.add(dateUnique);
                    if (seance.getMax() != null) {
                        aSeries.getData().add((Object)new XYChart.Data((Object)dateUnique, (Object)(seance.getMax() * 100 / maxmax)));
                    }
                    if (seance.getPourcentage() != null && Main.getConfig().typeScore == 1) {
                        bSeries.getData().add((Object)new XYChart.Data((Object)dateUnique, (Object)seance.getPourcentage()));
                    }
                    if (seance.getPoints() != null && Main.getConfig().typeScore == 2) {
                        bSeries.getData().add((Object)new XYChart.Data((Object)dateUnique, (Object)seance.getPoints()));
                    }
                    datePrec = date2;
                }
                this.xAxis.setCategories(FXCollections.observableList(etiquettes));
                aSeries.setName(TransientConfig.translate("Max"));
                bSeries.setName(TransientConfig.translate("Reussite"));
                this.graphSeances.getData().setAll((Object[])new XYChart.Series[]{aSeries});
                if (Main.getConfig().typeScore != 0) {
                    this.graphSeances.getData().add((Object)bSeries);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void remplirTableauSeances(int progId) {
        this.tableauSeances.getChildren().clear();
        this.tableauSeances.getRowConstraints().setAll((Object[])new RowConstraints[]{(RowConstraints)this.tableauSeances.getRowConstraints().get(0)});
        Region regionRow0 = new Region();
        regionRow0.getStyleClass().add((Object)"row0GridConfig");
        this.tableauSeances.add((Node)regionRow0, 0, 0, 10, 1);
        patientbilanViewController.addTitleTableau(this.tableauSeances, "duree", 4);
        patientbilanViewController.addTitleTableau(this.tableauSeances, "niveauStim", 5);
        patientbilanViewController.addTitleTableau(this.tableauSeances, Main.getConfig().baseZeroPatient ? "AmplitudePatient" : "Amplitude", 6);
        if (Main.getConfig().typeScore != 0) {
            patientbilanViewController.addTitleTableau(this.tableauSeances, "Reussite", 7);
        }
        if (Main.getConfig().isActivated) {
            Label revoir = new Label();
            revoir.getStyleClass().add((Object)"revoirButton");
            revoir.setOnMouseClicked(e -> this.comparerSeance());
            FxUtils.setAnchorMargin((Node)revoir);
            this.tableauSeances.add((Node)new AnchorPane(new Node[]{revoir}), 0, 0);
        }
        int row = 1;
        int ligne = 0;
        ArrayList<Seance> listSeance = this.sessionAffiche.getListSeances();
        ArrayList<Seance> sorted = new ArrayList<Seance>(listSeance);
        if (Main.getConfig().triSeances) {
            Collections.reverse(sorted);
        }
        for (Seance seance : sorted) {
            if (progId != -1 && !seance.isProgId(progId)) continue;
            row += this.createSeanceLine(ligne, row, seance);
            ++ligne;
        }
    }

    static void addTitleTableau(GridPane tableau, String name, int col) {
        Label label = new Label(TransientConfig.translate(name));
        label.setWrapText(true);
        label.getStyleClass().add((Object)"timetableau");
        tableau.add((Node)label, col, 0);
    }

    private int createSeanceLine(int ligne, int row, Seance seance) {
        int nbRow = !seance.getCommentaire().isEmpty() && seance.getId() != -1 ? 3 : 2;
        Region regionRow = new Region();
        regionRow.getStyleClass().add((Object)(ligne % 2 == 0 ? "grisclair" : "blanc"));
        this.tableauSeances.add((Node)regionRow, 0, row, 10, nbRow);
        Label titre = new Label(seance.getDate() + " : " + seance.getNom().replaceAll("\n", ""));
        titre.setOnMouseClicked(e -> this.clicSeance(seance, (MouseEvent)e));
        if (Main.getConfig().isActivated && seance.getCourbeSauvee() != null) {
            titre.getStyleClass().add((Object)"nomSeanceTableauCliquable");
        } else {
            titre.getStyleClass().add((Object)"nomSeanceTableau");
        }
        this.tableauSeances.add((Node)titre, 3, row, 4, 1);
        this.tableauSeances.add((Node)new Label(seance.getDuree()), 4, row + 1);
        if (seance.getStimAmplitude() != 0) {
            this.tableauSeances.add((Node)new Label(seance.getStimAmplitude() + ""), 5, row + 1);
        }
        if (seance.getMax() != null) {
            int tonus = seance.getIntTonus();
            String amplitude = String.format("%d", seance.getMax() - tonus);
            if (!Main.getConfig().baseZeroPatient & seance.getTonus() != null) {
                amplitude = String.format("%s - %s", seance.getTonus(), amplitude);
            }
            if (seance.getMin() != null) {
                amplitude = String.format("%s - %s", seance.getMin() - tonus, amplitude);
            }
            this.tableauSeances.add((Node)new Label(amplitude), 6, row + 1);
        }
        if (seance.getPourcentage() != null && Main.getConfig().typeScore == 1) {
            this.tableauSeances.add((Node)new Label(seance.getPourcentage() + " %"), 7, row + 1);
        }
        if (seance.getPoints() != null && Main.getConfig().typeScore == 2) {
            this.tableauSeances.add((Node)new Label(seance.getPoints() + ""), 7, row + 1);
        }
        if (seance.prog != null && seance.prog.containBFB()) {
            this.tableauSeances.add((Node)this.getLabelVoies(seance.prog), 7, row);
        }
        if (seance.getProg() != null && seance.getProg().pngExist()) {
            Label profil = new Label();
            profil.setMinHeight(40.0);
            FxUtils.setBackGround((Region)profil, seance.getProg().getId() + ".png", 75.0, false);
            FxUtils.setAnchorMargin((Node)profil, 5.0, 5.0, 5.0, 5.0);
            AnchorPane anchorProfil = new AnchorPane(new Node[]{profil});
            this.tableauSeances.add((Node)anchorProfil, 8, row, 1, 2);
        }
        this.addBoutonsPicto(this.tableauSeances, 9, row, 2, seance, this.seanceCompar);
        if (!seance.getCommentaire().isEmpty()) {
            TextFlow comment = new TextFlow(new Node[]{new Text(seance.getCommentaire())});
            int rowCom = seance.getId() != -1 ? row + 2 : row + 1;
            this.tableauSeances.add((Node)comment, 4, rowCom, 5, 1);
        }
        this.addTendanceEtPosition(this.tableauSeances, row, seance);
        AnchorPane changeComment = new AnchorPane();
        changeComment.getStyleClass().add((Object)"commentButton");
        changeComment.setOnMouseClicked(e -> this.modifCommentaire(seance));
        this.tableauSeances.add((Node)changeComment, 3, row + nbRow - 1, 1, 1);
        return nbRow;
    }

    private void addTendanceEtPosition(GridPane tableau, int row, Seance seance) {
        if (Main.getConfig().isActivated && seance.hasTendance()) {
            this.hasTendance = true;
            Canvas canvas = seance.getCanvasTendance(85.0, 55.0);
            RowConstraints rc = new RowConstraints();
            rc.setMinHeight(canvas.getHeight() / 2.0);
            while (tableau.getRowConstraints().size() < row + 2) {
                tableau.getRowConstraints().add((Object)rc);
            }
            tableau.add((Node)canvas, 1, row, 1, 2);
        }
        if (seance.position != 0) {
            this.hasPosition = true;
            AnchorPane position = new AnchorPane();
            position.getStyleClass().add((Object)"positionPatient");
            if (seance.position == 1) {
                position.getStyleClass().add((Object)"patientAllongeBleu");
            }
            if (seance.position == 2) {
                position.getStyleClass().add((Object)"patientAssisBleu");
            }
            if (seance.position == 3) {
                position.getStyleClass().add((Object)"patientDeboutBleu");
            }
            position.setMinWidth(50.0);
            position.setMaxWidth(50.0);
            position.setMinHeight(55.0);
            position.setMaxHeight(55.0);
            this.tableauSeances.add((Node)position, 2, row, 1, 2);
        }
    }

    private void modifCommentaire(Affichable aff) {
        Optional<String> s = Utils.popupReadMultiline("modifier_commentaire", aff.getCommentaire());
        if (s.isPresent()) {
            aff.setCommentaire(s.get());
            this.afficheDroite();
        }
    }

    private Label getLabelVoies(Programme prog) {
        String voies = Biostim.nomOfVoie(prog.getVoieBFB1());
        if (prog.getVoieBFB2() != -1) {
            voies = voies + " / " + Biostim.nomOfVoie(prog.getVoieBFB2());
        }
        Label res = new Label(voies);
        if (Biostim.isBTforbidden(prog.getVoieBFB1()) || Biostim.isBTforbidden(prog.getVoieBFB2())) {
            res.getStyleClass().add((Object)"texteRouge");
        }
        return res;
    }

    private void clicFormulaire(MouseEvent event) {
        try {
            Region target = (Region)event.getSource();
            String form = (String)target.getUserData();
            if (event.getButton() == MouseButton.PRIMARY) {
                File f = Utils.findFileWhateverEncoded(Main.getConfig().getRepPatients() + "/bilan/", form);
                Desktop.getDesktop().open(f);
            } else if (this.sessionAffiche == this.patient.getSessions().get(0)) {
                ContextMenu contextMenuForm = new ContextMenu();
                MenuItem item = new MenuItem(TransientConfig.translate("delete"));
                item.setOnAction(e -> {
                    this.sessionAffiche.getListForm().remove(form);
                    this.afficheDroite();
                });
                contextMenuForm.getItems().add((Object)item);
                contextMenuForm.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @FXML
    private void placerFormulaire() {
        String fichierModele = (String)this.comboForm.getSelectionModel().getSelectedItem();
        if (fichierModele != null) {
            Path source;
            if (fichierModele.equals(TransientConfig.translate("document_personnalise"))) {
                FileChooser fileChooser = new FileChooser();
                File file = fileChooser.showOpenDialog(Main.sceneMain.getWindow());
                if (file == null) {
                    return;
                }
                source = file.toPath();
                fichierModele = source.getFileName().toString();
            } else {
                source = Paths.get(Computer.absolutePath + "appData/bilan" + TransientConfig.langueSuffixe + "/" + fichierModele, new String[0]);
            }
            Date aujourdhui = new Date();
            String tagDate = Utils.formatDateFormulaire.format(aujourdhui);
            String nomFichierDestination = this.firstNameField.getText() + "-" + this.lastNameField.getText() + "_" + tagDate + "_" + fichierModele;
            Path destination = Paths.get(Main.getConfig().getRepPatients() + "/bilan/" + nomFichierDestination, new String[0]);
            try {
                try {
                    String[] motifs;
                    PdfReader reader = new PdfReader(source.toString());
                    PdfStamper pdfout = new PdfStamper(reader, Files.newOutputStream(Paths.get(destination.toString(), new String[0]), new OpenOption[0]));
                    AcroFields form1 = pdfout.getAcroFields();
                    Map<String, AcroFields.Item> fields = form1.getFields();
                    if (fields.containsKey("Nom")) {
                        form1.setField("Nom", this.lastNameField.getText());
                    }
                    if (fields.containsKey("Prenom")) {
                        form1.setField("Prenom", this.firstNameField.getText());
                    }
                    if (!Main.getConfig().noPraticienInForm && fields.containsKey("Praticien")) {
                        String nomKine;
                        String string = nomKine = this.kineField == null ? null : (String)this.kineField.getSelectionModel().getSelectedItem();
                        if (Main.getConfig().multiKine && nomKine != null && !nomKine.isEmpty()) {
                            form1.setField("Praticien", nomKine);
                        } else {
                            form1.setField("Praticien", Main.getConfig().comptePrenom + " " + Main.getConfig().compteNom);
                        }
                    }
                    if (fields.containsKey("Date")) {
                        String date = DateFormat.getDateInstance(2, Locale.getDefault()).format(aujourdhui);
                        form1.setField("Date", date);
                    }
                    int nbMotif = this.motifField.getSelectionModel().getSelectedIndex();
                    if (fields.containsKey("Motif") && nbMotif != -1 && nbMotif < (motifs = form1.getListOptionExport("Motif")).length) {
                        form1.setField("Motif", motifs[nbMotif]);
                    }
                    if (fields.containsKey("NomComplet")) {
                        form1.setField("NomComplet", this.firstNameField.getText() + " " + this.lastNameField.getText());
                    }
                    if (fields.containsKey("nbSeances")) {
                        form1.setField("nbSeances", this.sessionAffiche.getListSeances().size() + "");
                    }
                    if (fields.containsKey("Techniques")) {
                        StringBuilder res = new StringBuilder();
                        for (Seance s : this.sessionAffiche.getListSeances()) {
                            if (s.getMax() != null && res.indexOf(TransientConfig.translate("biofeedback")) == -1) {
                                if (res.length() != 0) {
                                    res.append(", ");
                                }
                                res.append(TransientConfig.translate("biofeedback"));
                            }
                            if (s.getStimAmplitude() <= 0 || res.indexOf(TransientConfig.translate("stimulation")) != -1) continue;
                            if (res.length() != 0) {
                                res.append(", ");
                            }
                            res.append(TransientConfig.translate("stimulation"));
                        }
                        form1.setField("Techniques", res.toString());
                    }
                    pdfout.close();
                }
                catch (Exception ignored) {
                    Files.copy(source, destination, new CopyOption[0]);
                }
                this.sessionAffiche.getListForm().add(nomFichierDestination);
                this.ajouteBoutonForm(nomFichierDestination);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void sauverCommentaire() {
        try {
            Seance seance = new Seance((String)this.typeComment.getSelectionModel().getSelectedItem(), this.textComment.getText());
            this.sessionAffiche.getListSeances().add(seance);
            this.afficheDroite();
            this.textComment.setText("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void comparerSeance() {
        if (!this.seanceCompar.isEmpty()) {
            RevoirController.listSeances = this.seanceCompar;
            while (this.seanceCompar.size() > 4) {
                this.seanceCompar.remove(4);
            }
            Main.changeCenterView("patient", "revoir", Main.menu.patientButton);
        }
    }

    private static void comparerBilan(ArrayList<Bilan> bilanCompar, boolean isAnorectal) {
        if (!bilanCompar.isEmpty()) {
            RevoirBilan.listBilans = bilanCompar;
            RevoirBilan.isAnorectal = isAnorectal;
            while (bilanCompar.size() > 4) {
                bilanCompar.remove(4);
            }
            Main.changeCenterView("patient", "revoirBilan", Main.menu.patientButton);
        }
    }

    private void clicBilan(Bilan bilan, boolean isAnorectal, MouseEvent event) {
        if (event.getButton() == MouseButton.SECONDARY) {
            try {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem item1 = new MenuItem(TransientConfig.translate("suppression"));
                item1.setOnAction(e -> {
                    bilan.supprime(this.sessionAffiche);
                    this.afficheDroite();
                });
                contextMenu.getItems().addAll((Object[])new MenuItem[]{item1});
                contextMenu.show(Main.sceneMain.getWindow(), event.getScreenX(), event.getScreenY());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (Main.getConfig().isActivated && bilan.getCourbeSauvee() != null) {
            RevoirBilan.listBilans = new ArrayList<Bilan>(Collections.singletonList(bilan));
            RevoirBilan.isAnorectal = isAnorectal;
            Main.changeCenterView("patient", "revoirBilan", Main.menu.patientButton);
        }
    }

    private void clicSeance(Seance seance, MouseEvent event) {
        if (event.getButton() == MouseButton.SECONDARY) {
            try {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem item1 = new MenuItem(TransientConfig.translate("suppression"));
                item1.setOnAction(e -> {
                    seance.supprime(this.sessionAffiche);
                    this.afficheDroite();
                });
                contextMenu.getItems().addAll((Object[])new MenuItem[]{item1});
                contextMenu.show(Main.sceneMain.getWindow(), event.getScreenX(), event.getScreenY());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (Main.getConfig().isActivated && seance.getCourbeSauvee() != null) {
            RevoirController.listSeances = new ArrayList<Seance>(Collections.singletonList(seance));
            Main.changeCenterView("patient", "revoir", Main.menu.patientButton);
        }
    }

    private void clicRevoir(ArrayList listCompar, Boolean selected, Affichable affichable) {
        int prog = -2;
        if (selected.booleanValue()) {
            listCompar.add(affichable);
            if (listCompar.size() == 1) {
                prog = affichable.getProg().getId();
            }
        } else {
            listCompar.remove(affichable);
            if (listCompar.isEmpty()) {
                prog = -1;
            }
        }
        if (prog != -2 && listCompar == this.seanceCompar) {
            this.remplirTableauSeances(prog);
        }
    }

    @FXML
    private void startProg(MouseEvent event) {
        Node target = (Node)event.getSource();
        Programme pplay = (Programme)target.getUserData();
        Main.setCategorie("patient");
        new ProgEnCours(pplay.copy());
    }

    public void imprime() {
        Pdf.createPDF((Node)this.printPatient, (Node)this.printSession, this.patient.getName());
    }
}

