/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.planche;

import com.mazet.biostim.Main;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Computer;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.utils.Utils;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.planche.Planche;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.scene.web.WebView;

public class plancheMainViewController
extends Controller {
    @FXML
    private Label titre;
    @FXML
    private VBox listPlanches;
    @FXML
    private StackPane stackPlanche;
    @FXML
    private VBox newPlanche;
    @FXML
    private TextField nomPlanche;
    @FXML
    private TextField filePlanche;
    @FXML
    private TextField urlPlanche;
    private ImageView imageView;
    private MediaView mediaView;
    private WebView webView;

    @Override
    public void setMain() {
        Planche firstPlanche = null;
        if (!Main.getConfig().customPlancheList.isEmpty()) {
            Label titre = new Label(TransientConfig.translate("planchesUtilisateur"));
            titre.getStyleClass().add((Object)"titrePlanche");
            VBox.setMargin((Node)titre, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
            titre.setMaxWidth(Double.MAX_VALUE);
            this.listPlanches.getChildren().add((Object)titre);
            for (String s : Main.getConfig().customPlancheList) {
                Planche.PlancheUser plancheUser = new Planche.PlancheUser(s);
                if (firstPlanche == null) {
                    firstPlanche = plancheUser;
                }
                Label label = new Label(((Planche)plancheUser).getName());
                label.getStyleClass().add((Object)"planche");
                label.setOnMouseClicked(e -> this.clicPlanche((MouseEvent)e, planche));
                label.setUserData((Object)plancheUser);
                this.listPlanches.getChildren().add((Object)label);
            }
        }
        for (int i = 0; i < Planche.familles.size(); ++i) {
            Label titre = new Label(TransientConfig.translate(Planche.familles.get(i)));
            titre.getStyleClass().add((Object)"titrePlanche");
            VBox.setMargin((Node)titre, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
            this.listPlanches.getChildren().add((Object)titre);
            for (Planche planche : Planche.toutesLesPlanches.get(i)) {
                String name;
                if (firstPlanche == null) {
                    firstPlanche = planche;
                }
                if ((name = planche.getName()).equals("null")) continue;
                Label label = new Label(planche.getName());
                label.getStyleClass().add((Object)"planche");
                label.setOnMouseClicked(e -> this.clicPlanche((MouseEvent)e, planche));
                label.setUserData((Object)planche);
                this.listPlanches.getChildren().add((Object)label);
            }
        }
        this.start(firstPlanche);
    }

    private void start(Planche planche) {
        if (this.stackPlanche.getWidth() > 30.0) {
            this.clicPlanche(null, planche);
        } else {
            Platform.runLater(() -> this.start(planche));
        }
    }

    @Override
    public void exitAction() {
        if (this.mediaView != null) {
            this.mediaView.getMediaPlayer().stop();
            this.mediaView.getMediaPlayer().dispose();
        }
        if (this.webView != null) {
            this.webView.getEngine().load(null);
        }
        this.imageView = null;
        this.mediaView = null;
        this.webView = null;
    }

    private void chargeMedia(String mediaFile) {
        this.newPlanche.setVisible(false);
        this.stackPlanche.getChildren().clear();
        if (this.mediaView != null) {
            this.mediaView.getMediaPlayer().stop();
            this.mediaView.getMediaPlayer().dispose();
            this.mediaView = null;
        }
        this.exitAction();
        try {
            if (mediaFile.startsWith("/res")) {
                this.imageView = new ImageView();
                this.imageView.setImage(new Image(mediaFile));
                this.imageView.setPreserveRatio(true);
                this.imageView.setFitWidth(this.stackPlanche.getWidth());
                this.imageView.setFitHeight(this.stackPlanche.getHeight());
                FxUtils.setAnchorMargin((Node)this.imageView);
                StackPane.setAlignment((Node)this.imageView, (Pos)Pos.CENTER);
                this.stackPlanche.getChildren().add((Object)this.imageView);
            } else if (mediaFile.startsWith("http")) {
                this.webView = new WebView();
                this.webView.getEngine().load(mediaFile);
                this.webView.setPrefSize(this.stackPlanche.getWidth(), this.stackPlanche.getHeight());
                this.stackPlanche.getChildren().add((Object)this.webView);
                this.webView.getEngine().getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
                    if (newState == Worker.State.FAILED) {
                        this.webView.getEngine().loadContent("<h1>" + TransientConfig.translate("requireInternet") + "</h1>");
                        Utils.debugInfo("pas d'internet => pas de planche 3D (%s)", mediaFile);
                    }
                });
            } else if (mediaFile.endsWith(".jpg") || mediaFile.endsWith(".jpeg") || mediaFile.endsWith(".png") || mediaFile.endsWith(".gif") || mediaFile.endsWith(".bmp")) {
                this.imageView = new ImageView();
                File file = Computer.newBiostimFile(mediaFile);
                this.imageView.setImage(new Image(file.toURI().toASCIIString()));
                this.imageView.setPreserveRatio(true);
                this.imageView.setFitWidth(this.stackPlanche.getWidth());
                this.imageView.setFitHeight(this.stackPlanche.getHeight());
                this.stackPlanche.getChildren().add((Object)this.imageView);
            } else {
                File file = Computer.newBiostimFile(mediaFile);
                Media pick = new Media(file.toURI().toASCIIString());
                MediaPlayer player = new MediaPlayer(pick);
                player.setCycleCount(-1);
                this.mediaView = new MediaView();
                this.mediaView.setPreserveRatio(true);
                this.mediaView.setFitWidth(this.stackPlanche.getWidth());
                this.mediaView.setFitHeight(this.stackPlanche.getHeight());
                this.stackPlanche.getChildren().add((Object)this.mediaView);
                player.setOnReady(() -> {
                    this.mediaView.setMediaPlayer(player);
                    player.play();
                });
            }
        }
        catch (Exception e) {
            Utils.debugInfo("probl\u00e8me chargement de planche : " + Computer.absolutePath + mediaFile);
            Label noPlanche = new Label();
            noPlanche.getStyleClass().add((Object)"noPlanche");
            this.stackPlanche.getChildren().add((Object)noPlanche);
        }
    }

    private void clicPlanche(MouseEvent event, Planche planche) {
        try {
            if (planche instanceof Planche.PlancheUser && event != null && event.getButton() == MouseButton.SECONDARY) {
                ContextMenu contextMenu = new ContextMenu();
                MenuItem item = new MenuItem(TransientConfig.translate("delete"));
                item.setOnAction(e -> {
                    Main.getConfig().customPlancheList.remove(((Planche.PlancheUser)planche).initString);
                    Main.getConfig().saveConfig();
                    Main.changeCenterView("planche", "main", Main.menu.plancheButton);
                });
                contextMenu.getItems().add((Object)item);
                contextMenu.show((Node)event.getSource(), event.getScreenX(), event.getScreenY());
            } else {
                this.titre.setText(planche.getName());
                this.chargeMedia(planche.getUrlImg());
                for (Node node : this.listPlanches.getChildren()) {
                    node.getStyleClass().removeAll((Object[])new String[]{"plancheSelect"});
                    if (node.getUserData() != planche) continue;
                    node.getStyleClass().add((Object)"plancheSelect");
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @FXML
    private void addFiche() {
        this.stackPlanche.getChildren().clear();
        this.newPlanche.setVisible(true);
        this.exitAction();
    }

    @FXML
    private void chooseFile(MouseEvent event) {
        Utils.chooseFile(event, null, false);
    }

    @FXML
    private void addFile() {
        String name = this.nomPlanche.getText();
        if (name.isEmpty()) {
            Utils.popupAlert(TransientConfig.translate("giveName"));
            return;
        }
        File file = new File(this.filePlanche.getText());
        Path source = file.toPath();
        String fichierModele = source.getFileName().toString();
        String destination = "appData/img/" + fichierModele;
        try {
            Computer.newBiostimFile("appData/img").mkdirs();
            Files.copy(source, Paths.get(Computer.absolutePath + destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            Main.getConfig().customPlancheList.add(name + ">" + destination);
            Main.getConfig().saveConfig();
            Main.changeCenterView("planche", "main", Main.menu.plancheButton);
        }
        catch (IOException e) {
            e.printStackTrace();
            Utils.popupAlert(TransientConfig.translate("fichierIntrouvable"));
        }
    }

    @FXML
    private void addURL() {
        String name = this.nomPlanche.getText();
        if (name.isEmpty()) {
            Utils.popupAlert(TransientConfig.translate("giveName"));
            return;
        }
        if (this.urlPlanche.getText().startsWith("http://") || this.urlPlanche.getText().startsWith("https://")) {
            Main.getConfig().customPlancheList.add(name + ">" + this.urlPlanche.getText());
        } else {
            Main.getConfig().customPlancheList.add(name + ">http://" + this.urlPlanche.getText());
        }
        Main.getConfig().saveConfig();
        Main.changeCenterView("planche", "main", Main.menu.plancheButton);
    }
}

