/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bilan;

import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.view.programme.bilan.ProgBilan;
import com.mazet.biostim.zdata.Bilan;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public abstract class EtapeBilan {
    ProgBilan progBilan;
    Bilan bilan;
    int duree = 60;
    int endIndex;
    @FXML
    AnchorPane mainNode;
    @FXML
    HBox mainHbox;
    @FXML
    VBox mainVbox;
    @FXML
    AnchorPane partText;
    @FXML
    AnchorPane anchorCanvas;
    @FXML
    AnchorPane partGraph;

    void init(ProgBilan progBilan, int posAffichee) {
        this.progBilan = progBilan;
        this.bilan = progBilan.bilan;
    }

    void enter() {
        this.endIndex = this.duree * 60;
    }

    void exit() {
    }

    void setStyle(boolean isEnCours, boolean isPause, boolean isOver) {
        if (!isEnCours || isPause) {
            this.setMainHbox();
            FxUtils.setVisibility((Node)this.mainHbox, true);
            FxUtils.setVisibility((Node)this.mainVbox, false);
        } else {
            this.setMainVbox();
            FxUtils.setVisibility((Node)this.mainHbox, false);
            FxUtils.setVisibility((Node)this.mainVbox, true);
        }
        if (isEnCours && isPause) {
            this.mainHbox.getStyleClass().setAll((Object[])new String[]{"bilanActionEnCours"});
        } else {
            this.mainHbox.getStyleClass().clear();
        }
        FxUtils.setVisibility((Node)this.mainNode, isEnCours || isPause || isOver);
    }

    void setMainVbox() {
        this.mainVbox.getChildren().setAll((Object[])new Node[]{this.partText, this.partGraph});
    }

    void setMainHbox() {
        this.mainHbox.getChildren().setAll((Object[])new Node[]{this.partText, this.partGraph});
    }

    abstract boolean update(int var1);

    @FXML
    void start() {
        int etape = this.progBilan.bilanController.etapes.indexOf(this);
        if (etape != -1 && etape <= this.progBilan.etape + 1) {
            this.progBilan.changeEtape(etape, true);
        }
    }

    abstract boolean etapeFaite();
}

