/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bilan;

import com.mazet.biostim.Main;
import com.mazet.biostim.comm.SondeBT;
import com.mazet.biostim.comm.UsbBiostim;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.Biostim;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.view.Controller;
import com.mazet.biostim.view.programme.bilan.BilanController;
import com.mazet.biostim.view.programme.bilan.EtapeBilan;
import com.mazet.biostim.zdata.Bilan;
import javafx.animation.AnimationTimer;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;

public class ProgBilan
extends Controller {
    public int voie1;
    public int voie2;
    BilanController bilanController;
    public Bilan bilan;
    int etape = -1;
    long startTime;
    int lastIndex;
    private boolean pause = false;
    private AnimationTimer mainLoop;
    double max1 = 0.0;
    double max2 = 0.0;
    long debutPause = 0L;

    public ProgBilan() {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(TransientConfig.langue);
            if (Main.progEnCours.currentPageProgram.getType() == -1) {
                loader.setLocation(Main.class.getResource("view/programme/bilan/bilanAnorectal.fxml"));
            } else {
                loader.setLocation(Main.class.getResource("view/programme/bilan/bilanVaginal.fxml"));
            }
            Main.mainLayout.setCenter((Node)loader.load());
            this.bilanController = (BilanController)loader.getController();
            this.bilanController.title.setText(Main.progEnCours.currentProgram.getNom());
            this.bilanController.init();
            this.bilanController.changeCouleurVoies();
            Main.currentController = this;
            Main.mainLayout.setLeft(null);
            this.voie1 = Main.progEnCours.currentProgram.getVoieBFB1();
            this.voie2 = Main.progEnCours.currentProgram.getVoieBFB2();
            this.bilan = new Bilan(Main.progEnCours.currentProgram);
            this.bilanController.menuBasController.getLabelSuivant().setOnMouseClicked(event -> this.suivantAction());
            this.bilanController.menuBasController.getLabelPrecedent().setOnMouseClicked(event -> this.precedentAction());
            this.bilanController.menuBasController.getLabelStop().setOnMouseClicked(event -> this.stopAction());
            this.bilanController.menuBasController.getLabelPause().setOnMouseClicked(event -> this.pauseAction());
            this.bilanController.menuBasController.initLogo();
            for (int i = 0; i < this.bilanController.etapes.size(); ++i) {
                EtapeBilan etape = this.bilanController.etapes.get(i);
                etape.init(this, i + 1);
            }
            this.changeEtape(0, !Main.getConfig().pauseEtapesBilan);
            if (this.voie1 == 8 || this.voie2 == 8) {
                SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.debutAcquisition);
            }
            this.startMainLoop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startMainLoop() {
        this.startTime = -3L;
        this.mainLoop = new AnimationTimer(){

            public void handle(long unused) {
                long now = System.currentTimeMillis();
                if (!ProgBilan.this.pause && ProgBilan.this.etape < ProgBilan.this.bilanController.etapes.size()) {
                    if (ProgBilan.this.startTime < 0L) {
                        ++ProgBilan.this.startTime;
                    } else if (ProgBilan.this.startTime == 0L) {
                        ProgBilan.this.startTime = now;
                        ProgBilan.this.lastIndex = -10;
                    }
                    if (ProgBilan.this.startTime > 0L) {
                        int currentIndex;
                        double v2;
                        double v1 = Biostim.getVoie(ProgBilan.this.voie1);
                        if (v1 > ProgBilan.this.max1) {
                            ProgBilan.this.max1 = v1;
                            UsbBiostim.selectCalibre(ProgBilan.this.voie1, ProgBilan.this.max1);
                        }
                        if (ProgBilan.this.voie2 != -1 && (v2 = Biostim.getVoie(ProgBilan.this.voie2)) > ProgBilan.this.max2) {
                            ProgBilan.this.max2 = v2;
                            UsbBiostim.selectCalibre(ProgBilan.this.voie2, ProgBilan.this.max2);
                        }
                        if ((currentIndex = (int)((now - ProgBilan.this.startTime) * 60L / 1000L)) - ProgBilan.this.lastIndex >= 3) {
                            ProgBilan.this.lastIndex = currentIndex;
                            if (ProgBilan.this.bilanController.etapes.get(ProgBilan.this.etape).update(currentIndex)) {
                                ProgBilan.this.changeEtape(ProgBilan.this.etape + 1, !Main.getConfig().pauseEtapesBilan);
                            }
                        }
                    }
                }
            }
        };
        this.mainLoop.start();
    }

    void changeEtape(int newEtape, boolean autostart) {
        try {
            this.bilanController.etapes.get(this.etape).exit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.etape = newEtape;
        if (this.etape < this.bilanController.etapes.size()) {
            this.bilanController.etapes.get(this.etape).enter();
            if (!this.pause && !autostart || this.pause && autostart) {
                this.pauseAction();
                this.debutPause = 0L;
            }
        }
        this.afficheEtape();
        this.startTime = -3L;
    }

    void afficheEtape() {
        boolean isOver = this.etape >= this.bilanController.etapes.size();
        for (int i = 0; i < this.bilanController.etapes.size(); ++i) {
            this.bilanController.etapes.get(i).setStyle(i == this.etape, this.pause, isOver);
        }
        FxUtils.setVisibility((Node)this.bilanController.anchorCommentaire, this.pause || isOver);
    }

    public boolean isNonVide() {
        for (EtapeBilan etape : this.bilanController.etapes) {
            if (!etape.etapeFaite()) continue;
            return true;
        }
        return false;
    }

    private void suivantAction() {
        try {
            if (this.pause) {
                this.pauseAction();
            } else if (this.etape < this.bilanController.etapes.size()) {
                this.changeEtape(this.etape + 1, true);
            } else {
                this.stopAction();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopAction() {
        try {
            try {
                if (this.startTime > 0L) {
                    this.bilanController.etapes.get(this.etape).exit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.voie1 == 8 || this.voie2 == 8) {
                SondeBT.commandeBLEConnect(SondeBT.ActionBLEConnect.finAcquisition);
            }
            this.mainLoop.stop();
            this.bilanController.exit(this.bilan);
            this.bilan.commentaire = this.bilanController.commentaire.getText();
            Main.progEnCours.finBilan(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pauseAction() {
        if (this.pause) {
            this.pause = false;
            this.bilanController.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "pauseButton"});
            if (this.debutPause != 0L) {
                this.startTime += System.currentTimeMillis() - this.debutPause;
                this.debutPause = 0L;
            }
        } else {
            this.pause = true;
            this.bilanController.menuBasController.getLabelPause().getStyleClass().setAll((Object[])new String[]{"buttonNav", "restartButton"});
            this.debutPause = System.currentTimeMillis();
        }
        this.afficheEtape();
    }

    private void precedentAction() {
        try {
            if (this.etape > 0) {
                this.changeEtape(this.etape - 1, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

