/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.zdata;

import com.mazet.biostim.Main;
import com.mazet.biostim.view.configuration.CloudManager;
import com.mazet.biostim.zdata.Pageprogramme;
import com.mazet.biostim.zdata.Profil;
import java.util.ArrayList;
import java.util.Collections;

public class ProfilConcatSimple
extends Profil {
    private final ArrayList<Motif> motifs;
    private boolean hasStim = false;
    public ArrayList<Motif> stims = new ArrayList();

    ProfilConcatSimple(ArrayList<Motif> motifs) {
        this.motifs = motifs;
        double t_init = 0.0;
        for (Motif motif : motifs) {
            boolean reposAvant = Main.getConfig().reposAvantTravail && motif.nbPic != -1;
            for (int i = 0; i < motif.repet; ++i) {
                if (reposAvant) {
                    this.addPoint(t_init, 0.0, motif);
                    t_init += motif.repos;
                }
                t_init += motif.addProfil(this, t_init);
                if (reposAvant) continue;
                this.addPoint(t_init += motif.repos, 0.0, motif);
            }
        }
    }

    @Override
    public Profil getProfilUnitaire(double now) {
        now %= this.getDuree();
        double t = 0.0;
        for (Motif motif : this.motifs) {
            for (int i = 0; i < motif.repet; ++i) {
                if (!(now < (t += motif.getDureeTravail() + motif.repos))) continue;
                return new ProfilConcatSimple(new ArrayList<Motif>(Collections.singletonList(new Motif(motif))));
            }
        }
        CloudManager.sendJdd("Erreur getProfilUnitaire concat simple %d motifs, now=%.2f t=%.2f", this.motifs.size(), now, t);
        Thread.dumpStack();
        return this;
    }

    void addPoint(Double t, double y, Motif motif) {
        this.stims.add(motif);
        super.addPoint(t, y);
    }

    @Override
    public boolean hasStim() {
        return this.hasStim;
    }

    @Override
    public Motif getStimMotif(int i) {
        return this.stims.get(i);
    }

    @Override
    public boolean isStim(double t) {
        t %= ((Double)this.temps.get(this.temps.size() - 1)).doubleValue();
        int i = 1;
        while (t > (Double)this.temps.get(i)) {
            ++i;
        }
        return this.stims.get((int)(i - 1)).nbPic == -1;
    }

    @Override
    public Motif getStimMotif(double t) {
        t %= ((Double)this.temps.get(this.temps.size() - 1)).doubleValue();
        int i = 1;
        while (t > (Double)this.temps.get(i)) {
            ++i;
        }
        return this.stims.get((int)(i - 1)).nbPic == -1 ? this.stims.get(i - 1) : null;
    }

    @Override
    public Motif getStimMotifNext(double t) {
        t %= ((Double)this.temps.get(this.temps.size() - 1)).doubleValue();
        int i = 1;
        while (t > (Double)this.temps.get(i)) {
            ++i;
        }
        Motif motif = this.stims.get(i - 1);
        while (i < this.temps.size()) {
            if (this.stims.get(i) != motif || (Double)this.val.get(i) > 0.0) {
                return this.stims.get(i);
            }
            ++i;
        }
        return this.stims.get(0);
    }

    @Override
    public double dateFinStim(double t) {
        double initDate = t - t % (Double)this.temps.get(this.temps.size() - 1);
        t %= ((Double)this.temps.get(this.temps.size() - 1)).doubleValue();
        int i = 1;
        while (t > (Double)this.temps.get(i)) {
            ++i;
        }
        Motif motif = this.stims.get(i - 1);
        while (i < this.temps.size()) {
            if (this.stims.get(i) != motif || (Double)this.val.get(i) > 0.0) {
                return initDate + (Double)this.temps.get(i);
            }
            ++i;
        }
        return initDate + (Double)this.temps.get(this.temps.size() - 1);
    }

    public static class Motif {
        public double repos;
        public int repet;
        public int nbPic;
        public double niveau;
        public double dureePlateau;
        public int freq;
        public int largeur;

        public Motif(int repet, int nbPic, double niveau, double repos) {
            this.repet = repet;
            this.nbPic = nbPic;
            this.niveau = niveau;
            this.repos = repos;
        }

        public Motif(int repet, double niveau, double dureePlateau, double repos) {
            this.repet = repet;
            this.nbPic = 0;
            this.niveau = niveau;
            this.dureePlateau = dureePlateau;
            this.repos = repos;
        }

        public Motif(int repet, double dureePlateau, int freq, int largeur, double repos) {
            this.repet = repet;
            this.nbPic = -1;
            this.dureePlateau = dureePlateau;
            this.freq = freq;
            this.largeur = largeur;
            this.repos = repos;
        }

        public Motif(double repos) {
            this.repet = 1;
            this.nbPic = -2;
            this.repos = repos;
        }

        public Motif(Motif motif) {
            this.repet = 1;
            this.nbPic = motif.nbPic;
            this.niveau = motif.niveau;
            this.dureePlateau = motif.dureePlateau;
            this.freq = motif.freq;
            this.largeur = motif.largeur;
            this.repos = motif.repos;
        }

        public static Motif createMotif(Pageprogramme page, int nbRepet, int type, int nbPic, int hauteur, double duree, int freq, int largeur, double repos) {
            if (type == 0) {
                return new Motif(nbRepet, nbPic, (double)hauteur / 100.0, repos);
            }
            if (type == 1) {
                return new Motif(nbRepet, (double)hauteur / 100.0, duree, repos);
            }
            if (type == 2) {
                page.setFreq(freq);
                page.setLargeur(largeur);
                return new Motif(nbRepet, duree, freq, largeur, repos);
            }
            return new Motif(repos);
        }

        public double addProfil(ProfilConcatSimple pcs, double t_init) {
            if (this.nbPic > 0) {
                for (int i = 0; i < this.nbPic; ++i) {
                    pcs.addPoint(t_init + (double)i, 0.0, this);
                    pcs.addPoint(t_init + (double)i + 0.5, this.niveau, this);
                    pcs.addPoint(t_init + (double)i + 0.5, this.niveau, this);
                    pcs.addPoint(t_init + (double)i + 1.0, 0.0, this);
                }
                return this.nbPic;
            }
            if (this.nbPic == 0) {
                pcs.addPoint(t_init, 0.0, this);
                pcs.addPoint(t_init + 0.5, this.niveau, this);
                pcs.addPoint(t_init + this.dureePlateau + 0.5, this.niveau, this);
                pcs.addPoint(t_init + this.dureePlateau + 1.0, 0.0, this);
                return this.dureePlateau + 1.0;
            }
            if (this.nbPic == -1) {
                pcs.hasStim = true;
                pcs.addPoint(t_init, 0.0, this);
                pcs.addPoint(t_init + 0.5, 0.5, this);
                pcs.addPoint(t_init + this.dureePlateau + 0.5, 0.5, this);
                pcs.addPoint(t_init + this.dureePlateau + 1.0, 0.0, this);
                return this.dureePlateau + 1.0;
            }
            pcs.addPoint(t_init, 0.0, this);
            return 0.0;
        }

        public double getDureeTravail() {
            if (this.nbPic > 0) {
                return this.nbPic;
            }
            if (this.nbPic != -2) {
                return this.dureePlateau + 1.0;
            }
            return 0.0;
        }
    }
}

