/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NestHost
extends Attribute {
    private int hostClassIndex;

    public NestHost(NestHost c) {
        this(c.getNameIndex(), c.getLength(), c.getHostClassIndex(), c.getConstantPool());
    }

    public NestHost(int nameIndex, int length, int hostClassIndex, ConstantPool constantPool) {
        super((byte)26, nameIndex, length, constantPool);
        this.hostClassIndex = hostClassIndex;
    }

    NestHost(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, 0, constant_pool);
        this.hostClassIndex = input.readUnsignedShort();
    }

    @Override
    public void accept(Visitor v) {
        v.visitNestHost(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.hostClassIndex);
    }

    public int getHostClassIndex() {
        return this.hostClassIndex;
    }

    public void setHostClassIndex(int hostClassIndex) {
        this.hostClassIndex = hostClassIndex;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NestHost: ");
        String class_name = super.getConstantPool().getConstantString(this.hostClassIndex, (byte)7);
        buf.append(Utility.compactClassName(class_name, false));
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        NestHost c = (NestHost)this.clone();
        c.setConstantPool(_constant_pool);
        return c;
    }
}

