/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm;

public class ProfileDataVerifier {
    private static final int MAX_TAG_COUNT = 100;
    private static final int HEADER_SIZE = 128;
    private static final int TOC_OFFSET = 132;
    private static final int TOC_RECORD_SIZE = 12;
    private static final int PROFILE_FILE_SIGNATURE = 1633907568;

    public static void verify(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        if (byArray.length < 132) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        int n = ProfileDataVerifier.readInt32(byArray, 0);
        int n2 = ProfileDataVerifier.readInt32(byArray, 128);
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        if (n < 132 + n2 * 12 || n > byArray.length) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        int n3 = ProfileDataVerifier.readInt32(byArray, 36);
        if (1633907568 != n3) {
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = ProfileDataVerifier.getTagOffset(i, byArray);
            int n5 = ProfileDataVerifier.getTagSize(i, byArray);
            if (n4 < 132 || n4 > n) {
                throw new IllegalArgumentException("Invalid ICC Profile Data");
            }
            if (n5 >= 0 && n5 <= Integer.MAX_VALUE - n4 && n5 + n4 <= n) continue;
            throw new IllegalArgumentException("Invalid ICC Profile Data");
        }
    }

    private static int getTagOffset(int n, byte[] byArray) {
        int n2 = 132 + n * 12 + 4;
        return ProfileDataVerifier.readInt32(byArray, n2);
    }

    private static int getTagSize(int n, byte[] byArray) {
        int n2 = 132 + n * 12 + 8;
        return ProfileDataVerifier.readInt32(byArray, n2);
    }

    private static int readInt32(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            n2 <<= 8;
            n2 |= 0xFF & byArray[n++];
        }
        return n2;
    }
}

