/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.graph;

import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;

public class HeatChart {
    WritableImage image;
    PixelWriter pixelWriter;
    int pos = 0;
    double calibre = 0.0;

    public HeatChart(ImageView imageView, int width, int height) {
        this.image = new WritableImage(width, height);
        imageView.setImage((Image)this.image);
        this.pixelWriter = this.image.getPixelWriter();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.pixelWriter.setColor(x, y, Color.WHITE);
            }
        }
    }

    public void resetCalibre() {
        this.calibre = 0.0;
    }

    public void addLine(double[] values, int minv, int maxv) {
        int width = (int)this.image.getWidth();
        int height = (int)this.image.getHeight();
        int yv = minv;
        for (int y = 0; y < height; ++y) {
            int maxyv = minv + y * (maxv - minv) / height;
            int nb = 1;
            double sum = values[maxyv];
            while (yv < maxyv) {
                sum += values[yv];
                ++nb;
                ++yv;
            }
            double val = sum / (double)nb;
            if (val > this.calibre) {
                this.calibre = val;
            }
            int yscreen = height - 1 - y;
            this.pixelWriter.setColor(this.pos, yscreen, HeatChart.getColorFromIntensity(val / this.calibre));
            this.pixelWriter.setColor((this.pos + 3) % width, yscreen, Color.RED);
        }
        this.pos = (this.pos + 1) % width;
    }

    public static Color getColorFromIntensity(double intensity) {
        double blue;
        double green;
        double red;
        if ((intensity = Math.max(0.0, Math.min(1.0, intensity))) < 0.5) {
            red = 0.0;
            green = 2.0 * intensity;
            blue = 1.0 - 2.0 * intensity;
        } else {
            red = 2.0 * (intensity - 0.5);
            green = 1.0 - 2.0 * (intensity - 0.5);
            blue = 0.0;
        }
        return new Color(red, green, blue, 1.0);
    }
}

