/*
 * Decompiled with CFR 0.152.
 */
package com.mazet.biostim.view.programme.bfb;

import com.mazet.biostim.Main;
import com.mazet.biostim.graph.FxUtils;
import com.mazet.biostim.utils.TransientConfig;
import com.mazet.biostim.view.programme.bfb.BiofeedbackAnimation;
import com.mazet.biostim.zdata.AnimationStyle;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public abstract class BiofeedbackAnimationSkin
extends BiofeedbackAnimation {
    static final int typeObjProfil = 0;
    static final int typeProfil = 1;
    static final int typeEventLine = 2;
    static final int typeEventText = 3;
    static final int typeManualObj = 4;
    static final int typeCourbe = 5;
    static final int typeObjCatch = 6;
    private double lastAleatoire;
    Pane gameRoot = new Pane();
    public AnimationStyle animationStyle;
    Polyline courbe1;
    Polyline courbe2;
    Shape curseur1;
    Shape curseur2;
    Polyline courbeSeparation;
    Polyline marqueurVoie1 = new Polyline();
    Polyline marqueurVoie2 = new Polyline();
    Polyline zeroVoie1 = new Polyline();
    Polyline zeroVoie2 = new Polyline();
    Polyline marqueurBFBAssiste = new Polyline();
    Polyline marqueurPresent = new Polyline();

    @Override
    int getDefaultRelativeGameSize() {
        return 60;
    }

    @Override
    public void initGame() {
        if (Main.getConfig().isActivated) {
            FxUtils.setVisibility((Node)this.controller.checkModeAveugle, true);
        }
    }

    @Override
    public void updateSpecifique() {
        super.updateSpecifique();
        if (Main.progEnCours.aleatoire && this.controller.dureeMilli > this.lastAleatoire + 2.0 && Math.random() < (double)0.01f) {
            int type = (int)(Math.random() + 0.5);
            this.addManualObjet(type, this.pixOfTime(this.controller.dureeMilli + 1.0), this.pixOfNiv1(70 - 50 * type));
            this.lastAleatoire = this.controller.dureeMilli + 1.0;
        }
    }

    @Override
    public String getCouleurVoie1() {
        return this.animationStyle.getCouleurVoie1();
    }

    @Override
    public String getCouleurVoie2() {
        return this.animationStyle.getCouleurVoie2();
    }

    double getLargeurComplete() {
        return this.widthGame;
    }

    @Override
    void changeModeAveugle() {
        boolean visible = !this.controller.checkModeAveugle.isSelected();
        this.curseur1.setVisible(visible);
        if (this.curseur2 != null) {
            this.curseur2.setVisible(visible);
        }
        this.marqueurPresent.setVisible(!visible);
        for (Node n : this.gameRoot.getChildren()) {
            if (!n.getStyleClass().contains((Object)"courbeVoie")) continue;
            n.setVisible(visible);
        }
    }

    @Override
    boolean hasObjects() {
        return this.animationStyle.objets != null && !this.animationStyle.objets.isEmpty();
    }

    public double getSizeObj() {
        return this.anchorHeight / 20.0;
    }

    void addManualObjet(int type, double x, double y) {
        String name = "+";
        ImagePattern objet = AnimationStyle.patternPlus;
        switch (type) {
            case 1: {
                name = "-";
                objet = AnimationStyle.patternMoins;
                break;
            }
            case 2: {
                name = TransientConfig.translate("prefixeCustomProg").substring(0, 1);
                objet = AnimationStyle.simpleEtoile;
            }
        }
        if (this.hasObjects()) {
            int pos = (int)Math.floor((double)this.animationStyle.patternObjets.length * Math.random());
            objet = this.animationStyle.patternObjets[pos];
        }
        double tx = this.timeOfPix(x);
        Main.progEnCours.historique.addEvent(name, tx + Main.progEnCours.revoir.startPageTime);
        Rectangle rect = FxUtils.creationObjet(this.gameRoot, objet, 2.0 * this.getSizeObj());
        rect.setX(x - rect.getWidth() / 2.0);
        rect.setY(y - rect.getHeight() / 2.0);
        this.addNode((Node)rect, tx, 4);
    }

    void afficheObjet(ImagePattern[] objs, double valt, double valy, double size, int type) {
        int j = (int)Math.floor((double)objs.length * Math.random());
        Rectangle rect = FxUtils.creationObjet(this.gameRoot, objs[j], size);
        double posX = this.pixOfTime(valt) - rect.getWidth() / 2.0;
        double posY = this.pixOfObjet(valy == -1.0 ? this.controller.profil.getVal(valt) : valy, rect.getHeight());
        rect.setX(posX);
        rect.setY(posY);
        this.addNodeObj((Node)rect, valt, valy, type);
    }

    void addNode(Node n, double dateVal, int type) {
    }

    void addNodeObj(Node n, double dateVal, double level, int type) {
    }

    void initLines() {
        this.marqueurVoie1.getStyleClass().add((Object)"courbeSeuil");
        this.marqueurVoie2.getStyleClass().add((Object)"courbeSeuil");
        String courbeZero = this.animationStyle.typeRuban == 1 ? "courbeZeroBlanc" : "courbeZeroNoir";
        this.zeroVoie1.getStyleClass().add((Object)courbeZero);
        this.zeroVoie2.getStyleClass().add((Object)courbeZero);
        this.marqueurPresent.getStyleClass().add((Object)courbeZero);
        this.marqueurPresent.setVisible(false);
        this.marqueurBFBAssiste.getStyleClass().add((Object)"courbeSeuilBFBAssiste");
        this.gameRoot.getChildren().addAll((Object[])new Node[]{this.marqueurVoie1, this.marqueurVoie2, this.zeroVoie1, this.zeroVoie2, this.marqueurBFBAssiste, this.marqueurPresent});
    }

    void updateLevelZero() {
        boolean zeroLine2;
        boolean zeroLine1;
        this.zeroVoie1.getPoints().clear();
        this.zeroVoie2.getPoints().clear();
        boolean bl = zeroLine1 = this.controller.profil.typeProfil() != 2;
        if (zeroLine1) {
            double level = this.pixOfNiv1(this.baseToAff1());
            this.zeroVoie1.getPoints().addAll((Object[])new Double[]{0.0, level});
            this.zeroVoie1.getPoints().addAll((Object[])new Double[]{this.getLargeurComplete(), level});
        }
        boolean bl2 = zeroLine2 = this.controller.nbVoie == 2 && this.controller.voiesSeparees;
        if (zeroLine2) {
            this.zeroVoie2.getPoints().clear();
            double level = this.pixOfNiv2(this.baseToAff2());
            this.zeroVoie2.getPoints().addAll((Object[])new Double[]{0.0, level, this.getLargeurComplete(), level});
        }
    }

    void clicEcran(MouseEvent e) {
        if (e.getButton() == MouseButton.SECONDARY) {
            if (Main.getConfig().eventClicDroit) {
                this.addEvent(this.controller.event1.getText(), this.timeOfPix(e.getX()));
            } else {
                this.addManualObjet(2, e.getX(), e.getY());
            }
        } else if (this.controller.voiesSeparees && e.getY() > this.anchorHeight / 2.0) {
            this.updateLevel(Main.progEnCours.currentProgram.voie1EnHaut ? this.marqueurVoie2 : this.marqueurVoie1, e.getY());
        } else {
            this.updateLevel(this.marqueurVoie1, e.getY());
        }
    }

    private void updateLevel(Polyline marqueur, double level) {
        double old_level = 0.0;
        if (marqueur.getPoints().size() > 1) {
            old_level = (Double)marqueur.getPoints().get(1);
        }
        marqueur.getPoints().clear();
        if (old_level != level) {
            marqueur.getPoints().setAll((Object[])new Double[]{0.0, level, this.gameRoot.getWidth(), level});
        }
    }

    @Override
    void setMarqueurBFBAssiste() {
        if (Main.progEnCours.currentPageProgram.isBfbAssiste()) {
            double level = this.pixOfBasProfil((double)(Main.progEnCours.seuilBFBAssiste * Main.progEnCours.currentPageProgram.dynHaut) / 100.0);
            this.marqueurBFBAssiste.getPoints().setAll((Object[])new Double[]{0.0, level, this.gameRoot.getWidth(), level});
        }
    }

    double pixOfTime(double temps) {
        return 100.0;
    }

    double timeOfPix(double pix) {
        Thread.dumpStack();
        return 0.0;
    }

    double pixOfNiv1(double niv) {
        if (this.controller.voiesSeparees) {
            niv = Main.progEnCours.currentProgram.voie1EnHaut ? (600.0 + niv * 5.0) / 11.0 : niv * 5.0 / 11.0;
        }
        return this.anchorHeight * (0.96 - 0.92 * niv / 100.0);
    }

    double pixOfNiv2(double niv) {
        if (this.controller.voiesSeparees) {
            niv = Main.progEnCours.currentProgram.voie1EnHaut ? niv * 5.0 / 11.0 : (600.0 + niv * 5.0) / 11.0;
        }
        return this.anchorHeight * (0.96 - 0.92 * niv / 100.0);
    }

    double pixOfProfil(double niv) {
        niv = (double)Main.progEnCours.epaisseurProfil / 2.0 + niv * (double)(100 - Main.progEnCours.epaisseurProfil) / 100.0;
        return this.pixOfNiv1(this.profToAff(niv));
    }

    private double pixOfBasProfil(double niv) {
        niv = niv * (double)(100 - Main.progEnCours.epaisseurProfil) / 100.0;
        return this.pixOfNiv1(this.profToAff(niv));
    }

    double pixOfObjet(double niv, double hauteurObj) {
        double res2;
        double res = this.pixOfProfil(niv) - hauteurObj / 2.0;
        if (niv < 0.001 && (res2 = this.pixOfNiv1(this.profToAff(0.0)) - hauteurObj - this.getSizeObj() / 2.0) > res) {
            res = res2;
        }
        return res;
    }
}

