/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import com.sun.org.apache.bcel.internal.util.ClassQueue;
import com.sun.org.apache.bcel.internal.util.Repository;
import com.sun.org.apache.bcel.internal.util.SyntheticRepository;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node,
Comparable<JavaClass> {
    private String fileName;
    private String packageName;
    private String sourceFileName = "<Unknown>";
    private int classNameIndex;
    private int superclassNameIndex;
    private String className;
    private String superclassName;
    private int major;
    private int minor;
    private ConstantPool constantPool;
    private int[] interfaces;
    private String[] interfaceNames;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private AnnotationEntry[] annotations;
    private byte source = 1;
    private boolean isAnonymous = false;
    private boolean isNested = false;
    private boolean computedNestedTypeStatus = false;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    private static final boolean debug = false;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            JavaClass THIS = (JavaClass)o1;
            JavaClass THAT = (JavaClass)o2;
            return Objects.equals(THIS.getClassName(), THAT.getClassName());
        }

        @Override
        public int hashCode(Object o) {
            JavaClass THIS = (JavaClass)o;
            return THIS.getClassName().hashCode();
        }
    };
    private transient Repository repository = SyntheticRepository.getInstance();

    public JavaClass(int classNameIndex, int superclassNameIndex, String fileName, int major, int minor, int access_flags, ConstantPool constantPool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes, byte source) {
        super(access_flags);
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.classNameIndex = classNameIndex;
        this.superclassNameIndex = superclassNameIndex;
        this.fileName = fileName;
        this.major = major;
        this.minor = minor;
        this.constantPool = constantPool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.source = source;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof SourceFile)) continue;
            this.sourceFileName = ((SourceFile)attribute).getSourceFileName();
            break;
        }
        this.className = constantPool.getConstantString(classNameIndex, (byte)7);
        this.className = Utility.compactClassName(this.className, false);
        int index = this.className.lastIndexOf(46);
        this.packageName = index < 0 ? "" : this.className.substring(0, index);
        if (superclassNameIndex > 0) {
            this.superclassName = constantPool.getConstantString(superclassNameIndex, (byte)7);
            this.superclassName = Utility.compactClassName(this.superclassName, false);
        } else {
            this.superclassName = "java.lang.Object";
        }
        this.interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String str = constantPool.getConstantString(interfaces[i], (byte)7);
            this.interfaceNames[i] = Utility.compactClassName(str, false);
        }
    }

    public JavaClass(int classNameIndex, int superclassNameIndex, String fileName, int major, int minor, int access_flags, ConstantPool constantPool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes) {
        this(classNameIndex, superclassNameIndex, fileName, major, minor, access_flags, constantPool, interfaces, fields, methods, attributes, 1);
    }

    @Override
    public void accept(Visitor v) {
        v.visitJavaClass(this);
    }

    static void Debug(String str) {
    }

    public void dump(File file) throws IOException {
        File dir;
        String parent = file.getParent();
        if (parent != null && !(dir = new File(parent)).mkdirs() && !dir.isDirectory()) {
            throw new IOException("Could not create the directory " + dir);
        }
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
            this.dump(dos);
        }
    }

    public void dump(String _file_name) throws IOException {
        this.dump(new File(_file_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(s);
        try {
            this.dump(ds);
        }
        catch (IOException e) {
            System.err.println("Error dumping class: " + e.getMessage());
        }
        finally {
            try {
                ds.close();
            }
            catch (IOException e2) {
                System.err.println("Error dumping class: " + e2.getMessage());
            }
        }
        return s.toByteArray();
    }

    public void dump(OutputStream file) throws IOException {
        this.dump(new DataOutputStream(file));
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeInt(-889275714);
        file.writeShort(this.minor);
        file.writeShort(this.major);
        this.constantPool.dump(file);
        file.writeShort(super.getAccessFlags());
        file.writeShort(this.classNameIndex);
        file.writeShort(this.superclassNameIndex);
        file.writeShort(this.interfaces.length);
        for (int interface1 : this.interfaces) {
            file.writeShort(interface1);
        }
        file.writeShort(this.fields.length);
        for (Field field : this.fields) {
            field.dump(file);
        }
        file.writeShort(this.methods.length);
        for (Method method : this.methods) {
            method.dump(file);
        }
        if (this.attributes != null) {
            file.writeShort(this.attributes.length);
            for (Attribute attribute : this.attributes) {
                attribute.dump(file);
            }
        } else {
            file.writeShort(0);
        }
        file.flush();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotations == null) {
            this.annotations = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotations;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(java.lang.reflect.Method m) {
        for (Method method : this.methods) {
            if (!m.getName().equals(method.getName()) || m.getModifiers() != method.getModifiers() || !Type.getSignature(m).equals(method.getSignature())) continue;
            return method;
        }
        return null;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public int getSuperclassNameIndex() {
        return this.superclassNameIndex;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassNameIndex(int classNameIndex) {
        this.classNameIndex = classNameIndex;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setInterfaceNames(String[] interfaceNames) {
        this.interfaceNames = interfaceNames;
    }

    public void setInterfaces(int[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMethods(Method[] methods) {
        this.methods = methods;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public void setSuperclassName(String superclassName) {
        this.superclassName = superclassName;
    }

    public void setSuperclassNameIndex(int superclassNameIndex) {
        this.superclassNameIndex = superclassNameIndex;
    }

    public String toString() {
        AnnotationEntry[] annotations;
        String access = Utility.accessToString(super.getAccessFlags(), true);
        access = access.isEmpty() ? "" : access + " ";
        StringBuilder buf = new StringBuilder(128);
        buf.append(access).append(Utility.classOrInterface(super.getAccessFlags())).append(" ").append(this.className).append(" extends ").append(Utility.compactClassName(this.superclassName, false)).append('\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            for (int i = 0; i < size; ++i) {
                buf.append(this.interfaceNames[i]);
                if (i >= size - 1) continue;
                buf.append(", ");
            }
            buf.append('\n');
        }
        buf.append("file name\t\t").append(this.fileName).append('\n');
        buf.append("compiled from\t\t").append(this.sourceFileName).append('\n');
        buf.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        buf.append("access flags\t\t").append(super.getAccessFlags()).append('\n');
        buf.append("constant pool\t\t").append(this.constantPool.getLength()).append(" entries\n");
        buf.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            for (Attribute attribute : this.attributes) {
                buf.append(JavaClass.indent(attribute));
            }
        }
        if ((annotations = this.getAnnotationEntries()) != null && annotations.length > 0) {
            buf.append("\nAnnotation(s):\n");
            for (AnnotationEntry annotation : annotations) {
                buf.append(JavaClass.indent(annotation));
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n").append(this.fields.length).append(" fields:\n");
            for (Field field : this.fields) {
                buf.append("\t").append(field).append('\n');
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n").append(this.methods.length).append(" methods:\n");
            for (Method method : this.methods) {
                buf.append("\t").append(method).append('\n');
            }
        }
        return buf.toString();
    }

    private static String indent(Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuilder buf = new StringBuilder();
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken()).append("\n");
        }
        return buf.toString();
    }

    public JavaClass copy() {
        JavaClass c = null;
        try {
            int i;
            c = (JavaClass)this.clone();
            c.constantPool = this.constantPool.copy();
            c.interfaces = (int[])this.interfaces.clone();
            c.interfaceNames = (String[])this.interfaceNames.clone();
            c.fields = new Field[this.fields.length];
            for (i = 0; i < this.fields.length; ++i) {
                c.fields[i] = this.fields[i].copy(c.constantPool);
            }
            c.methods = new Method[this.methods.length];
            for (i = 0; i < this.methods.length; ++i) {
                c.methods[i] = this.methods[i].copy(c.constantPool);
            }
            c.attributes = new Attribute[this.attributes.length];
            for (i = 0; i < this.attributes.length; ++i) {
                c.attributes[i] = this.attributes[i].copy(c.constantPool);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    public final boolean isSuper() {
        return (super.getAccessFlags() & 0x20) != 0;
    }

    public final boolean isClass() {
        return (super.getAccessFlags() & 0x200) == 0;
    }

    public final boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    private void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        for (Attribute attribute : this.attributes) {
            InnerClass[] innerClasses;
            if (!(attribute instanceof InnerClasses)) continue;
            for (InnerClass innerClasse : innerClasses = ((InnerClasses)attribute).getInnerClasses()) {
                boolean innerClassAttributeRefersToMe = false;
                String inner_class_name = this.constantPool.getConstantString(innerClasse.getInnerClassIndex(), (byte)7);
                if ((inner_class_name = Utility.compactClassName(inner_class_name, false)).equals(this.getClassName())) {
                    innerClassAttributeRefersToMe = true;
                }
                if (!innerClassAttributeRefersToMe) continue;
                this.isNested = true;
                if (innerClasse.getInnerNameIndex() != 0) continue;
                this.isAnonymous = true;
            }
        }
        this.computedNestedTypeStatus = true;
    }

    public final byte getSource() {
        return this.source;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final boolean instanceOf(JavaClass super_class) throws ClassNotFoundException {
        JavaClass[] super_classes;
        if (this.equals(super_class)) {
            return true;
        }
        for (JavaClass super_classe : super_classes = this.getSuperClasses()) {
            if (!super_classe.equals(super_class)) continue;
            return true;
        }
        if (super_class.isInterface()) {
            return this.implementationOf(super_class);
        }
        return false;
    }

    public boolean implementationOf(JavaClass inter) throws ClassNotFoundException {
        JavaClass[] super_interfaces;
        if (!inter.isInterface()) {
            throw new IllegalArgumentException(inter.getClassName() + " is no interface");
        }
        if (this.equals(inter)) {
            return true;
        }
        for (JavaClass super_interface : super_interfaces = this.getAllInterfaces()) {
            if (!super_interface.equals(inter)) continue;
            return true;
        }
        return false;
    }

    public JavaClass getSuperClass() throws ClassNotFoundException {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        return this.repository.loadClass(this.getSuperclassName());
    }

    public JavaClass[] getSuperClasses() throws ClassNotFoundException {
        JavaClass clazz = this;
        ArrayList<JavaClass> allSuperClasses = new ArrayList<JavaClass>();
        for (clazz = clazz.getSuperClass(); clazz != null; clazz = clazz.getSuperClass()) {
            allSuperClasses.add(clazz);
        }
        return allSuperClasses.toArray(new JavaClass[allSuperClasses.size()]);
    }

    public JavaClass[] getInterfaces() throws ClassNotFoundException {
        String[] _interfaces = this.getInterfaceNames();
        JavaClass[] classes = new JavaClass[_interfaces.length];
        for (int i = 0; i < _interfaces.length; ++i) {
            classes[i] = this.repository.loadClass(_interfaces[i]);
        }
        return classes;
    }

    public JavaClass[] getAllInterfaces() throws ClassNotFoundException {
        ClassQueue queue = new ClassQueue();
        TreeSet<JavaClass> allInterfaces = new TreeSet<JavaClass>();
        queue.enqueue(this);
        while (!queue.empty()) {
            JavaClass clazz = queue.dequeue();
            JavaClass souper = clazz.getSuperClass();
            JavaClass[] _interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                allInterfaces.add(clazz);
            } else if (souper != null) {
                queue.enqueue(souper);
            }
            for (JavaClass _interface : _interfaces) {
                queue.enqueue(_interface);
            }
        }
        return allInterfaces.toArray(new JavaClass[allInterfaces.size()]);
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    @Override
    public int compareTo(JavaClass obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

