/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class PMGClass
extends Attribute {
    private int pmgClassIndex;
    private int pmgIndex;

    public PMGClass(PMGClass pgmClass) {
        this(pgmClass.getNameIndex(), pgmClass.getLength(), pgmClass.getPMGIndex(), pgmClass.getPMGClassIndex(), pgmClass.getConstantPool());
    }

    PMGClass(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, input.readUnsignedShort(), input.readUnsignedShort(), constant_pool);
    }

    public PMGClass(int name_index, int length, int pmgIndex, int pmgClassIndex, ConstantPool constantPool) {
        super((byte)9, name_index, length, constantPool);
        this.pmgIndex = pmgIndex;
        this.pmgClassIndex = pmgClassIndex;
    }

    @Override
    public void accept(Visitor v) {
        PMGClass.println("Visiting non-standard PMGClass object");
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.pmgIndex);
        file.writeShort(this.pmgClassIndex);
    }

    public int getPMGClassIndex() {
        return this.pmgClassIndex;
    }

    public void setPMGClassIndex(int pmgClassIndex) {
        this.pmgClassIndex = pmgClassIndex;
    }

    public int getPMGIndex() {
        return this.pmgIndex;
    }

    public void setPMGIndex(int pmgIndex) {
        this.pmgIndex = pmgIndex;
    }

    public String getPMGName() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.pmgIndex, (byte)1);
        return c.getBytes();
    }

    public String getPMGClassName() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.pmgClassIndex, (byte)1);
        return c.getBytes();
    }

    @Override
    public String toString() {
        return "PMGClass(" + this.getPMGName() + ", " + this.getPMGClassName() + ")";
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        return (Attribute)this.clone();
    }
}

