/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValuePair;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ElementValueGen;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePairGen {
    private int nameIdx;
    private final ElementValueGen value;
    private final ConstantPoolGen constantPoolGen;

    public ElementValuePairGen(ElementValuePair nvp, ConstantPoolGen cpool, boolean copyPoolEntries) {
        this.constantPoolGen = cpool;
        this.nameIdx = copyPoolEntries ? cpool.addUtf8(nvp.getNameString()) : nvp.getNameIndex();
        this.value = ElementValueGen.copy(nvp.getValue(), cpool, copyPoolEntries);
    }

    public ElementValuePair getElementNameValuePair() {
        ElementValue immutableValue = this.value.getElementValue();
        return new ElementValuePair(this.nameIdx, immutableValue, this.constantPoolGen.getConstantPool());
    }

    protected ElementValuePairGen(int idx, ElementValueGen value, ConstantPoolGen cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.constantPoolGen = cpool;
    }

    public ElementValuePairGen(String name, ElementValueGen value, ConstantPoolGen cpool) {
        this.nameIdx = cpool.addUtf8(name);
        this.value = value;
        this.constantPoolGen = cpool;
    }

    protected void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.nameIdx);
        this.value.dump(dos);
    }

    public int getNameIndex() {
        return this.nameIdx;
    }

    public final String getNameString() {
        return ((ConstantUtf8)this.constantPoolGen.getConstant(this.nameIdx)).getBytes();
    }

    public final ElementValueGen getValue() {
        return this.value;
    }

    public String toString() {
        return "ElementValuePair:[" + this.getNameString() + "=" + this.value.stringifyValue() + "]";
    }
}

